                                ;
                                ;       ROM addr 0000 - 7FFF
                                ;       RAM addr A000 - BFFF
                                ;       stack at C000 (going down) 
                                ;               
                                ;
                                ;       File:   208n.dat
                                ;       Date:   Mon Nov 15 22:12:52 1999
                                ;       CPU:    Intel 8085 
                                ;
                                ;
                                ;       ***** is an address to be converted to a label

;------------------------------------------------------------------------------------------------------
;RAM variables
;
;       A004 - A518     Channel data for 99 channels, 13 bytes each
;       structure:
;       offset  Usage                           new cmded       present
;       0       Freq BCD, LSD                   A54B            A559
;       1       Freq BCD                        A54C            A55A
;       2       Freq BCD                        A54D            A55B
;       3       Freq BCD, MSD                   A54E            A55C
;       4       BFO, lsb                        A54F            A55D
;       5       BFO, msb and sign               A550            A55E
;       6       Mode & IF filter                A551            A55F
;         | low 4 bits
;         |   val  Mode  (to user)
;         |    0   CW     3
;         |    2   AM     1
;         |    3   USB    7
;         |    4   LSB    6
;         |    5   2-ISB  5
;         |    6   4-ISB  9
;         |    8   FM     2
;         |    9   FSK    8
;         | high 4 bits
;         |   IF filter number (0 to 7)
;         |
;       7       AGC speed pointer               A552            A560
;       8                                       A553            A561
;       9       FSK center freq, msb & sign     A554            A562
;       A       FSK center freq, lsb            A555            A563
;       B       FSK shift & polarity (msb=pol, low 2 bits are shift)
;       C       checksum                        A557            A565
;
;       A525-A531       13 byte block for locally generated params going to commanded
;       A532-A53E       13 byte block for remotely generated params going to commanded
;       A543-A546       freq for ?
;       A549            locally generated channel number going to commanded
;       A54A            remotely generated channel number going to commanded
;       A54B-A557       13 byte block, new commanded receive parms
;       A558            Channel number displayed on front panel (=A0 if none)
;       A559-A565       13 byte block, present receive mode parms
;       A566            Channel
;       A567            Tuning wheel enabled flag (FF if enabled)
;       A568            Tune wheel sensitivity (reset value)
;       A569            Tune wheel sensitivity (variable, difference from $A568 counts)
;       A56A            Increments/decrements from 0 on tuning wheel up/down movement
;       A56B            Tune wheel movement internal control flag, $00 or $FF
;       A56C            Decimal movement of tuning wheel
;       A56D            Tuning wheel direction flag (FF means negative)
;       A574            D/A value for RF gain
;       A575            Actively scanning flag ($FF means actively scanning)
;       A576
;       A577            Flag, tuning wheel active for scan chan select
;       A578
;       A579            Holds group number
;       A57B            Channel or group scan.  43=channel, 47=group
;       A57C            Channel scanning lower bound
;       A57D            Channel scanning upper bound
;       A57E
;       A57F
;       A580            Scan Dwell pointer; $0B means external.
;       A581            Scan dwell (FF means external)
;       A582            Scan channel
;       A589-A59C       Group 0 channel storage area
;       A59D-A5B0       Group 1 channel storage area
;       A5B1-A5C4       Group 2 channel storage area
;       A5C5-A5D8       Group 3 channel storage area
;       A5D9-A5EC       Group 4 channel storage area
;       A5ED-A600       Group 5 channel storage area
;       A601-A614       Group 6 channel storage area
;       A615-A628       Group 7 channel storage area
;       A629-A63C       Group 8 channel storage area
;       A63D-A650       Group 9 channel storage area
;       A665-A666       Pointer for member of group
;       A667-A668       Pointer for member of group
;       A669-A66A       Pointer for member of group
;       A66F            Mode 0  CW      stored user filter choice
;       A670            Mode 1  -       stored user filter choice
;       A671            Mode 2  AM      stored user filter choice
;       A672            Mode 3  USB     stored user filter choice
;       A673            Mode 4  LSB     stored user filter choice
;       A674            Mode 5  2ISB    stored user filter choice
;       A675            Mode 6  4ISB    stored user filter choice
;       A676            Mode 7  -       stored user filter choice
;       A677            Mode 8  FM      stored user filter choice
;       A678            Mode 9  FSK     stored user filter choice
;       A679            Status bits
;               80      0=remote, 1=local operation
;               40
;       A67A            Radio state bits
;               04        Radio is in test state
;               02        Scan mode (0=channel, 1=group)
;               01        Radio is in scan state
;       A67B            RF atten
;       A67C            NB/mute status
;               10        unknown, set but not used?
;               08        Noise Blanker on/off
;               01        Mute on/off
;       A67E            Comm port has been initialized flag
;       A67F
;       A680            Remote 'programming channel' flag
;       A681
;       A682            Status bits
;               10        unlocked or 4ISB selected but not installed
;               02        BITE running
;       A683
;       A684
;       A687            Harris protocol action bits
;               40        Who Are You request
;               10        ACK message
;               08        report equipment type
;               04        request status report
;               02        data message/interpret message & respond
;               01        $FF received, waiting for $F5
;       A689-A          Harris protocol jump pointer
;       A68B            Harris protocol
;       A68C
;       A68D
;       A68E
;       A68F
;       A696-A6A3       Parameter block for HP difference status reporting
;       A6A4            Harris protocol byte count for urgent message
;       A6A5-A6AE       Harris protocol urgent message buffer
;       A6B1            Harris protocol non-urgent message byte count
;       A6B2-A6BB       Harris protocol non-urgent message buffer
;       A752            Harris protocol incoming message data and checksum total byte count
;       A753-4          Harris protocol pointer, received characters
;       A755-A784?      Harris protocol received message buffer
;               A755
;               A756
;               A757      send byte count/data/flag
;       A7A5            Harris protocol # chars left to transmit
;       A7A6            Harris protocol transmit buffer pointer
;       A7A8-A???       Harris protocol transmit buffer
;               A7A8      $FF
;               A7A9      $F5
;               A7AA      type
;               A7AB      ID (radio address)
;               A7AC      byte count/flag byte

;       A809-A815       13 byte block, new command?
;       A809-A          Pointer for RAM address of channel storage data (A004 - A518 or so)
;       A80C            Mirrors UART port bits
;       A80D            Harris protocol channel
;       A80E
;       A80F            RF gain via remote
;       A818            Flag for 4ISB option installed.
;       A819            No 4ISB fault flag
;       A81A            Harris protocol
;       A81B            Harris protocol
;       A81C            Harris protocol
;       A81D            Synthesizer flag, false if synth freq < 40.500 MHz
;       A81E            Synthesizer flag, internal to L3160 module, helps deal with change
;       A81F            Synthesizer flag, internal to L3160 module, helps deal with change
;       A821            RF590A/other; $FF for RF590A
;       A823
;       A825            Flag for FSK option installed.  Zero if not installed.
;       A82A            FSK variable
;       A82B-A82F       Programmable FSK option values
;       A831-5          Programmable FSK options, avail options flags
;       A837            FSK shift code (0-3)
;       A838            Active FSK option value
;       A839            2nd IF AGC A/D value
;       A83A            AGC A/D value
;       A83B
;       A83C
;       A83D            Flag, if FF then remeasure USB AGC Level
;       A83E            Flag, if FF then remeasure LSB AGC Level
;       A83F            Flag, if FF then remeasure USB Line Audio Level
;       A840            Flag, if FF then remeasure LSB Line Audio Level
;       A843            0=Harris Protocol, $FF=ASCII
;       A845            Radio addressed, respond to commands (FF=respond)
;       A846            Radio addressed uniquely, return status reports (FF=report)
;       A847-A945       Serial comm input buffer area
;       A946            Pointer for placing next char into input buffer ring
;       A947
;       A948            Receive buffer overflow counter.  Reaching FF indicates an overflow.
;       A949-AA47       Serial comm transmit buffer
;       AA48            Serial comm transmit buffer pointer
;
;       AA4A            UART # chars left to transmit
;       AA4B            Number of CR's in input buffer
;       AA4C-AB4A       Secondary receive buffer
;       AB4B            Pointer for parsing incoming command string
;       AB4D            Comm error flag (parity, etc)
;       AB4E            Receive buffer overflow flag (=FF)
;       AB4F            command parsing flag - (Invalid command or unable to comply flag)
;       AB50            command parsing flag - (Syntax error flag)
;       AB51-8          BCD radio, filter bw, or BFO frequency for outputting
;       AB67            0 or FF.  FF indicates sending serial port data.
;       AB72-AB81
;       AB85-AB8D
;       AB8E            set to FF to request BITE
;       AB90            Auto Stop Scan Threshold (FF=off)
;       AB91            Auto Stop Scan Threshold
;       AB92            Flag, scan stopped for received signal (=FF)
;
; Front panel display buffer addresses
;             "C" addr  Usage
;               ---     -----
;       AB95            Control byte; which char just sent; set to $20 to update display
;       AB96    $1D     agc
;       AB97    $1C     agc
;       AB98    $1B     agc
;       AB99    $1A
;       AB9A    $19     mode
;       AB9B    $18     mode
;       AB9C    $17     mode
;       AB9D    $16
;       AB9E    $15     bw
;       AB9F    $14     bw
;       ABA0    $13     bw
;       ABA1    $12
;       ABA2    $11     dwell
;       ABA3    $10     dwell
;       ABA4    $0F     dwell
;       ABA5    $0E
;       ABA6    $0D     bfo
;       ABA7    $0C     bfo
;       ABA8    $0B     bfo
;       ABA9    $0A     bfo
;       ABAA            10 MHz freq digit
;       ABAB            1 MHz freq digit
;       ABAC            100 KHz freq digit
;       ABAD            10 KHz freq digit
;       ABAE            1 KHz freq digit
;       ABAF            100 Hz freq digit
;       ABB0            10 Hz freq digit
;       ABB1            1 Hz freq digit
;       ABB2            10's channel digit
;       ABB3            1's channel digit
;       ABB4 LEDs
;               80      prog
;               40      recv
;               20      scan
;               10      test
;               8       remote
;               4       -
;               2       -
;               1       fault
;       ABB5 LEDs
;               80      freq
;               40      chan
;               20      BFO
;               10      tune
;               8       Noise Blanker
;               4       -
;               2       -
;               1       -
;
;       ABB6            Digit to tune
;       ABBB            Key pressed code
;       ABBD            Numerical keypad applicability
;       ABBE            tuning wheel...
;       ABBF
;       ABC1            only bit $20 used, helps detect meter bd LSB switch changes in L0B02
;       ABC4            Channel storage for use in group programming
;       ABC5            2ISB option installed flag (0=not installed, FF=installed)
;       ABC9            BITE fault code
;       ABCA            BITE fault subassembly
;       ABCB            
;       ABD1            Decrements every 1msec, but not below 0 (Used for every 31 msec PLL unlock check)
;       ABD2            Inc'd in main loop, controls sequencing
;       ABD4-ABD5
;       ABD7            reflects Scan step input from back panel (=0 or =1)
;       ABD8            reflects Scan Stop input from back panel (=0 or =2)
;       ABE8            var used in L332F
;       ABE9            var used in L332F
;       ABEA            var used in L332F
;       ABEB            in BITE mode if FF
;       ABEC            Display update control see L06FD
;       ABED            Radio setting control, see L2D5B
;       ABEF            PLL unlocked error flag
;       ABF0
;       ABF1-2
;       ABF3
;       ABF4            flag, 0 or FF
;       ABF5            flag used in L332F only
;
; IF filter data per DIP switch setting
;               filt1           filt2           filt3           filt4           filt5           filt6           filt7           filt8
; data          ABF8            ABF9            ABFA            ABFB            ABFC            ABFD            ABFE            ABFF    
;
; AC00  extra filter data
;
; ASCII         AC09            AC0D            AC11            AC15            AC19            AC1D            AC21            AC25
;               AC0A            AC0E            AC12            AC16            AC1A            AC1E            AC22            AC26
;               AC0B            AC0F            AC13            AC17            AC1B            AC1F            AC23            AC27
;               AC0C            AC10            AC14            AC18            AC1C            AC20            AC24            AC28
;
; First, second and third filter parameter bytes (1,2 are filt bw in hex, 10's of Hz)
;
;               AC29            AC2B            AC2D            AC2F            AC31            AC33            AC35            AC37
;               AC2A            AC2C            AC2E            AC30            AC32            AC34            AC36            AC38
;               AC01            AC02            AC03            AC04            AC05            AC06            AC07            AC08
;
;
;       AC39            Serial transmitter transmitting flag
;       AC3A            FSK UART present flag
;       AC3B            Radio ID
;       AC3C            Synthesizer VCO range select flag, used only as memory of last setting
;       AC3D            Synth offset ( 0 = USB, 1 = AM, 2 = LSB )

; Display Addressing for front panel controller
;       20      alph 1
;       21      alph 2
;       22      alph 3
;       23      alph 4
;       24      alph 5
;       25      alph 6
;       26      alph 7
;       27      alph 8
;       28      alph 9
;       29      alph 10
;       2A      alph 11
;       2B      alph 12
;       2C      alph 13
;       2D      alph 14
;       2E      alph 15
;       2F      alph 16
;       30      alph 17
;       31      alph 18
;       32      alph 19
;       33      alph 20
;       34      freq 1
;       35      freq 2
;       36      freq 3
;       37      freq 4
;       38      freq 5
;       39      freq 6
;       3A      freq 7
;       3B      freq 8
;       3C      freq 9
;       3D      freq 10
;       3E      LED port 1, 7=prog, 6=rcv, 5=scan, 4=test, 3=remote, 2=7seg en, 1=14seg en, 0=fault
;       3F      LED port 2, top 4 bits only, 7=freq, 6=chan, 5=BFO, 4=tune
;--------------------------------------------------------------------------------------------------
;       Subroutine overview
;
;
;       0000 - 003E     Vectors
;       003F - 009F     empty
;       00A0 - 03B5     Startup and main loop
;       03B6 - 0432     IF filter setup
;       0433 - 046F     FSK UART test, sets flag $AC3A to $FF if OK
;       0470 - 0486     4ISB detect
;       0487 - 04C5     FSK option detect
;       04C6 - 04D0     loads $32 and $76 to $F800 serially
;       04D1 - 050C     text messages
;       050D - 0570     1 msec Timer interrupt
;       0571 - 0594     Send display data to Front Panel
;       0595 - 05D2     Front panel keyboard, check for pressed key
;       05D3 - 061F     Front panel keypress detected, determine key
;       0620 - 0636     form key code
;       0637 - 0644     Send scan code C to front panel keyboard
;       0645 - 0665     Display text message to alphanumeric display
;       0666 - 0684     Display B chars from [HL] to disp loc C
;       0685 - 06EA     Place char A to display location C (not changing existing bit 7)
;       06EB - 06FC     Place BCD number in A in display positions C-1 and C
;       06FD - 0731     Display update based on bits set in $ABEC
;       0732 - 075E     Put BCD $A566 to disp pos 0,1
;       075F - 078A     Display frequency and digit to tune
;       078B - 0872     Display BFO freq (of FSK freq if in FSK mode)
;       0873 - 08D5     Display mode
;       08D6 - 0911     text messages
;       0912 - 0946     Display IF filter
;       0947 - 0991     Display AGC info (or FSK info when in FSK mode)
;       0992 - 09DF     Display Scan Dwell time
;       09E0 - 0A01     If not in BITE, make NB LED display NB status
;       0A02 - 0A27     Sets bit 7 of display data byte C
;       0A28 - 0A4D     Clears bit 7 of display data byte C
;       0A4E - 0A63     Set $AB95 to $1F and clr b7 of all 30 display data bytes
;       0A64 - 0A74     Clear bit 7 of display frequency digits
;       0A75 - 0A7E     Clear bit 7 of display data bytes $15 and $16
;       0A7F - 0B01     text messages
;       0B02 - 0B3A     High level operations
;       0B3B - 0CB1     Operations and commands processing
;       0CB2 - 0D37     Process function buttons
;       0D38 - 0D4F     process pressed key
;       0D50 - 0D7B     jump table for pressed keys
;       0D7C - 0EC6     Prog, Rcv, Scan, Test, Remote keys
;       0EC7 - 10D2     Chan, Freq, BFO keys
;       10D3 - 10F7     action jump for keypress
;       10F8 - 110D     jump table for L10D3 routine
;       110E - 118A     p/o numerical keypad mode 1 (BFO) processing
;       118B - 11B8     p/o numerical keypad frequency processing
;       11B9 - 11D9     p/o numerical keypad program processing
;       11DA - 1230     p/o numerical keypad channel # processing
;       1231 - 124D     p/o numerical keypad first/last channel processing
;       124E - 1261     p/o numerical keypad group processing
;       1262 - 127F     p/o numerical keypad stop threshold processing
;       1280 - 12F3     BW, Mode, AGC speed, Dwell, Tune Rate keys
;       12F4 - 1322     Enter, Load, Recall keys
;       1323 - 1338     Enter key jump table
;       1339 - 1402     Enter, Load, Recall keys
;       1403 - 140B     frequency channel #, and program Enter key code
;       140C - 1415     Clear bit 7 of display bytes 3 & 2
;       1416 - 145B     first channel enter key code
;       145C - 1493     last channel Enter key code
;       1494 - 14D7     group mode 7 Enter key code
;       14D8 - 1529     group mode 8 Enter key code
;       1529 - 15B8     AGC on/off key
;       15B9 - 161D     Group key
;       161E - 16A1     Stuck button & display radio ID, baud code
;       16A2 - 1713     Start receive mode
;       1714 - 17D8     Mode key
;       17D9 - 17FD     BW key
;       17FE - 1857     AGC Speed key
;       1858 - 186B     Store user filter choice for mode
;       186C - 18A6     Tuning wheel steering code
;       18A7 - 18E5     Dwell key
;       18E6 - 1900     Tune Enable key
;       1901 - 1921     Tune Rate key
;       1922 - 1943     Noise Blanker key
;       1944 - 1979     Noise Blanker = not(carry)
;       197A - 19CA     auto stop scan Enter key code
;       19CB - 19E3     Stop threshold Enter key code
;       19E4 - 1A33     Display Auto Stop Scan on/off status
;       1A34 - 1AB4     Find next filter supporting mode
;       1AB5 - 1ACA     data
;       1ACB - 1CBE     text messages
;       1CBF - 1CE5     Get channel memory RAM addr in HL given BCD channel # in B
;       1CE6 - 1CFA     Recall channel B to receiver and place B in $A566
;       1CFB - 1D0E     Store present receive params to channel memory loc spec in $A566
;       1D0F - 1D64     Set radio to BCD chan # in B
;       1D65 - 1D71     A = sum of 13 bytes from HL
;       1D72 - 1E04     Load default params to chan 0 if necessary
;       1E05 - 1F6A     Set radio where present <> new commanded params
;       1F6B - 1FA5     Part of setting up receiver, incl data from commanded to present block
;       1FA6 - 1FCD     Move created receiver params to commanded block
;       1FCE - 1FF6     Move commanded block to created area
;       1FF7 - 2033     13 bytes from $A54B to pointer HL
;       2034 - 2070     13 bytes from $A559 to pointer HL
;       2071 - 20AC     13 bytes from pointer HL to $A54B
;       20AD - 20E8     13 bytes from pointer HL to $A559
;       20E9 - 20FA     Calc address of beginning of group C memory area (returned in HL)
;       20FB - 2108     Test channel A in group C? carry clear if so, set if not
;       2109 - 213C     Utility setup code for group (called with group # in C)
;       213D - 21AD     Group (and maybe scan) logic
;       21AE - 21B6     Put channel A into spot with $EE in group C
;       21B7 - 21BD     Replace channel A in group C with $EE
;       21BE - 21D5     Scan channel code
;       21D6 - 22B0     Active scanning code
;       22B1 - 22E1     High level scan code
;       22E2 - 234F     Scan dwell setting code
;       2350 - 23B5     Active scanning logic for external Step, Stop inputs
;       23B6 - 23D9     Stopping scan, not due to received signal
;       23DA - 2420     Init & start scan
;       2421 - 2472     Tune Wheel interrupt routine
;       2473 - 24C4     Tuning wheel movement processing
;       24C5 - 25E3     Tuning wheel processing for numeric entry mode 1
;       25E4 - 268C     Tuning wheel processing for frequency control
;       268D - 26EC     Tuning wheel processing for Program control
;       26ED - 2724     Tuning wheel processing for Stop Threshold control
;       2725 - 2747     Disable Tuning wheel
;       2748 - 27D2     Enable Tuning wheel
;       27D3 - 27DB     Move C bytes @HL to @DE
;       27DC - 27FF     Converts C to tens & ones BCD (99=>10011001 and 255=>01010101) in A (B has hundreds)
;       2800 - 281B     Convert BCD B to number in A, carry set if B not good BCD
;       281C - 282E     Test A: C=1 if A>$99 or low 4 bits >9
;       282F - 2838     A=DAA($99-C+B) with carry complemented
;       2839 - 285A     Keypress modifies mem nybble offset C from HL, data A
;       285B - 2872     (HL)=daa[$99-(DE)+(HL)] for C locations
;       2873 - 2883     (HL)=daa[(HL)+(DE)] for C locations
;       2884 - 2894     Called from front Panel keypress routine; Sets bit C of A to 1
;       2895 - 28A2     p/o key detect code
;       28A3 - 28BF     Increment/decrement channel logic.  Carry=1 means dec, B=present chan, HL=valid range of chans
;       28C0 - 28D7     Not used (?) B=f(C,D)
;       28D8 - 28E5     XORs memory from HL to H=D, result in A,E & flags set
;       28E6 - 2A9C     IF filter data and text
;       2A9D - 2AB0     text messages
;       2AB1 - 2B27     Ant overload, PLL unlocked code
;       2B28 - 2BBD     PLL unlocked and 4ISB missing fault detection
;       2BBE - 2C6B     A/D read routine.  H is the channel number to read, A returns data.  Carry flag set if error.
;       2C6C - 2C80     RF gain setting code
;       2C81 - 2CBE     Set RF gain of receiver (not 590A)
;       2CBF - 2D32     Set RF gain of receiver (590A)
;       2D33 - 2D3C     Read 2nd IF AGC & store at $A839
;       2D3D - 2D46     Read AGC and store at $A83A
;       2D47 - 2D50     Read Line Audio & store at $A83B
;       2D51 - 2D5A     Read ISB Audio & store at $A83C
;       2D5B - 2D82     Set radio, section controlled by bits in $ABED
;       2D83 - 2E06     Set FSK parameters
;       2E07 - 2E19     data
;       2E1A - 2E69     Set AGC control lines
;       2E6A - 2EBC     Set IF filter
;       2EBD - 2F1B     Set audio path and mode
;       2F1C - 2FA8     Set synth, BFO by mode/filter
;       2FA9 - 3082     Set BFO
;       3083 - 3097     data
;       3098 - 3137     Set Synth; recv freq in $A54B-E, $AC3D determines offset (USB, AM, or LSB)
;       3138 - 3143     data (synth offsets)
;       3144 - 315F     Send rotated B, C, D to serial bus
;       3160 - 322B     Set 1st LO from B, C, D, E, H
;       322C - 3233     Send A to Serial Bus
;       3234 - 326C     Disconnect ant and mute audio if called with carry set
;       326D - 327B     Rotate HL register right 4 times, fill zeroes into upper bits
;       327C - 3313     Set preselector (use $A54D and E values)
;       3314 - 332E     set preselector after checking preselector filter ID between $66 and $9A
;       332F - 3471     Send data out rear panel serial bus
;       3472 - 352C     Protocol initialization code
;       352D - 35E3     Called from 1 msec timer intr routine if comm port has been initialized
;       35E4 - 369E     Remote comm code
;       369F - 36BB     Harris protocol Fault DID generator
;       36BC - 36F0     FSK option code, set A67F and A681 flags
;       36F1 - 375F     Initialize FSK hardware, init UART if no FSK installed
;       3760 - 37C1     Initialize UART
;       37C2 - 37D1     UART data table for setting speed
;       37D2 - 39CA     UART Interrupt routine
;       39CB - 3A74     FSK/UART initialization code
;       3A75 - 3A9A     FSK option code
;       3A9B - 3AC3     UART/FSK UART output port reset bits B
;       3AC4 - 3AF1     UART/FSK UART output port set bits B
;       3AF2 - 3B03     Get BAUD rate select switch data into low nybble of A
;       3B04 - 3B34     Put Radio ID from DIP switch into $AC3B
;       3B35 - 3B67     Sets A843=0 for Harris Protocol, $FF for ASCII
;       3B68 - 3C25     Harris Protocol command jump table
;       3C26 - 3C3E     Harris protocol, add bandwidth DID to response
;       3C3F - 3C5B     Harris protocol code; add non-urgent DID B data C to response
;       3C5C - 3C70     Harris protocol code; add Urgent DID B data C to response
;       3C71 - 3C92     P/O Harris protocol code; add DID B, data C to response
;       3C93 - 3CAA     Search for B at D locs from HL
;       3CAB - 3CC3     Harris protocol, if (HL)<>(BC) for A locs, send DID (DE) data (HL) for each nomatch
;       3CC4 - 3C52     Harris protocol, report differences in parameters since last subroutine run
;       3D53 - 3D61     Set flags to reacquire AGC and audio levels
;       3D62 - 3DB2     Reacquire AGC and audio levels based on flags
;       3DB3 - 3DD3     P/O Harris protocol code
;       3DD4 - 3DD8     data
;       3DD9 - 3E34     Harris protocol, add DIDs for channel data to response
;       3E35 - 3E3D     data
;       3E3E - 3EB1     Harris protocol, report status
;       3EB2 - 3EF0     Harris protocol - send urgent DID sequence for resuming scan
;       3EF1 - 3F0E     Harris protocol - send out state or suspend scan DID as urgent
;       3F0F - 3F4D     Harris protocol, Error DIDs
;       3F4E - 3F56     HL = $A809 + C
;       3F57 - 3F85     Remote programming channel code
;       3F86 - 3F96     Jump to location DE
;       3F97 - 3FA6     Harris protocol, generates Error DID 06, Scanning, cannot program channel, if scanning
;       3FA7 - 3FAB     Clear remote 'programming channel' flag
;       3FAC - 4074     Interpret Harris protocol commands and jump via table
;       4075 - 4075     Harris protocol NOP
;       4076 - 4084     Harris protocol Spare 1/2
;       4085 - 4090     Harris protocol Who Are You
;       4091 - 40C6     Harris protocol Program Channel Data
;       40C7 - 410C     Harris protocol Group Program/Unprogram
;       410D - 4133     Harris protocol Report Group
;       4134 - 414F     Harris protocol Receiver Command/Status
;       4150 - 415B     Harris protocol RF Gain
;       415C - 416A     Harris protocol Stop Scan Threshold
;       416B - 4192     Harris protocol BFO High
;       4193 - 41AD     Harris protocol BFO Low
;       41AE - 41F5     Harris protocol Tuning method/AGC speed
;       41F6 - 4206     Harris protocol 10/1 MHz Frequency
;       4207 - 420B     Harris protocol 100/10 KHz Frequency
;       420C - 4210     Harris protocol 1000/100 Hz Frequency
;       4211 - 422B     Harris protocol 10/1 Hz Frequency
;       422C - 427E     Harris protocol Mode
;       427F - 42A3     Harris protocol Self-test (BITE)
;       42A4 - 42C6     Harris protocol Dwell
;       42C7 - 42D2     data
;       42D3 - 42D9     Harris protocol reacquire USB AGC Level
;       42DA - 42E0     Harris protocol reacquire LSB AGC Level
;       42E1 - 42E7     Harris protocol reacquire USB Line Audio Level
;       42E8 - 42EE     Harris protocol reacquire LSB Line Audio Level
;       42EF - 4310     Harris protocol FSK Center Freq Low
;       4311 - 4336     Harris protocol FSK Center Freq High
;       4337 - 4354     Harris protocol FSK Shift & Shift Polarity
;       4355 - 4371     Harris protocol Options
;       4372 - 4386     Harris protocol Bandwidth Configuration
;       4387 - 43BE     Harris protocol Report Channel Data
;       43BF - 43F4     Harris protocol Channel
;       43F5 - 444E     Harris protocol Bandwidth
;       444F - 4458     data
;       4459 - 44B3     Harris protocol State
;       44B4 - 44BE     Harris protocol Report Complete Status
;       44BF - 4500     Harris protocol Increment Channel
;       4501 - 4550     Harris protocol Decrement Channel
;       4551 - 4556     Harris protocol Scan Start Bound
;       4557 - 4569     Harris protocol Scan End Bound
;       456A - 45D7     Harris protocol Resume Scan
;       45D8 - 45F3     Harris protocol Suspend Scan
;       45F4 - 462B     Harris protocol Lock/Unlock channel
;       462C - 4639     Reset Harris protocol state machine
;       463A - 4652     Harris protocol, keep track of incoming 4 byte messages
;       4653 - 466B     Harris protocol - place first char in buffer and set count to 1
;       466C - 468D     Detect Harris protocol header preamble FF F5, call L463A if so.
;       468E - 46BD     Harris protocol, receive next byte
;       46BE - 46D1     Harris protocol process HRRCP data messages
;       46D2 - 4728     Harris protocol message received, process it
;       4729 - 47A4     Harris protocol - decode message type
;       47A5 - 47E2     Harris protocol, check radio ID and message CRC
;       47E3 - 47EC     Returns checksum byte in A for HL, HL+1, HL+2
;       47ED - 481D     Harris protocol CRC generation.  HL points to header, CRC returned in DE
;       481E - 4881     Harris protocol, set up outgoing message
;       4882 - 48A6     Harris protocol - make flag byte
;       48A7 - 48AF     Set # chars to xmt at $A7AC + 8 for Harris protocol
;       48B0 - 491C     Harris protocol - process WRU rqst, xfer data to xmt buffer and append CRC
;       491D - 4924     Harris protocol CRC generation (alternate entry).  HL points to header, CRC returned in DE
;       4925 - 4967     Harris protocol - transfer long data to send buffer
;       4968 - 4AC7     BITE routine
;       4AC8 - 4AF9     text messages
;       4AFA - 4B08     Reset Front Panel Display
;       4B09 - 4B3D     ROM test routine
;       4B3E - 4B88     RAM test routine
;       4B89 - 4BFD     Test 8155 and 8255 Ports
;       4BFE - 4C72     Serial Data test
;       4C73 - 4C7D     Returns bits 1PA7, 1PA5, 1PA3, 2PC2 in A
;       4C7E - 4CA2     Reference generator test
;       4CA3 - 4CA9     Set carry and PLL unlocked flag
;       4CAA - 4CF7     PLL test
;       4CF8 - 4D28     BFO test
;       4D29 - 4D68     4ISB test
;       4D69 - 4D86     P/O BITE routine
;       4D87 - 4DAF     A/D Test.  returns with carry clear if OK, else A= 7, 8, or 9 indicating type of error.
;       4DB0 - 4E16     Input filter test (Tests 8.1, 8.2, 8.3)
;       4E17 - 4E3A     Test first and second converters
;       4E3B - 4F25     IF filter test
;       4F26 - 4F30     Read IF input level
;       4F31 - 51D5     IF audio test
;       51D6 - 51D9     data
;       51DA - 52A1     FSK test routine
;       52A2 - 52B1     Set Receiver to 100 KHz
;       52B2 - 52BA     Send 4 serial data strobes
;       52BB - 52C7     L52BB sends $00 to D/A and $A574, L52BD sends A to D/A and $A574
;       52C8 - 52DC     500 msec delay
;       52DD - 531E     FSK option code
;       531F - 532D     Returns sum of mem locs $A82B, C, D, E, F in Acc (FSK option values)
;       532E - 5339     Check FSK option data with checksum.  A=0 means was OK, A=FF means was reinitialized
;       533A - 537B     FSK option code
;       537C - 53A1     FSK option code
;       53A2 - 53CD     FSK option code, called from 542C
;       53CE - 53EE     FSK option code, called from 542C
;       53EF - 542B     Display FSK shift, more
;       542C - 5440     FSK option code, command steering
;       5441 - 5467     jump table for 542C
;       5469 - 5469     FSK option code, called from 542C
;       546A - 5472     FSK option code, called from 542C
;       5473 - 547D     FSK option code, called from 542C
;       547E - 54CC     FSK option code
;       54CD - 54F3     FSK option code
;       54F4 - 5505     FSK option code
;       5506 - 5515     Get into A from $55B0 lookup table the byte offset by val of $A82F
;       5516 - 5523     Set AGC control lines if FSK mode
;       5524 - 55AF     text messages
;       55B0 - 55D2     data
;       55D3 - 55F4     Process ASCII commands from serial port
;       55F5 - 56C1     ASCII command processing
;       56C2 - 571B     Enable/disable radio response based on Radio ID and incoming address
;       571C - 5799     Scan Dwell command (zD) processing
;       579A - 57A4     data
;       57A5 - 57DE     Open/close Path (mute) command (P) processing
;       57DF - 5818     Noise Blanker command (N) processing
;       5819 - 5840     Auto stop scan threshold command (E) processing
;       5841 - 585E     Report group command (X) processing
;       585F - 589A     Channel scanning bounds (U) command processing
;       589B - 58F3     Program options command (O) processing
;       58F4 - 5955     Program group (V) command processing
;       5956 - 59A6     Lock out chan(s) command (L) processing
;       59A7 - 59F7     Unlock channel(s) command (Q) processing
;       59F8 - 5A59     Unprogram group (W) command processing
;       5A5A - 5A8F     Program channel (J) command processing
;       5A90 - 5AC4     S command processing
;       5AC5 - 5AEA     S command jump table
;       5AEB - 5AEB     S command NOP processing
;       5AEC - 5B0D     S12 Halt Scan command
;       5B0E - 5B5C     S14 Increment Channel command
;       5B5D - 5BA8     S15 Decrement Channel command
;       5BA9 - 5BD5     S4 Goto Normal State command
;       5BD6 - 5C1A     S10 Prepare For Channel Scan command
;       5C1B - 5C5F     S11 Prepare for Group Scan command
;       5C60 - 5C6D     S3 Begin BITE command
;       5C6E - 5CA6     Start BITE
;       5CA7 - 5CCD     Report complete status command (G) processing
;       5CCE - 5D39     Request specific status command (T) processing
;       5D3A - 5D44     FSK Center freq report
;       5D45 - 5D4F     FSK shift report
;       5D50 - 5D95     RF attenuation command (A) processing 
;       5D96 - 5D9A     Start Scan at chan or grp command (K) processing
;       5D9B - 5E2E     S13 Resume Scan command
;       5E2F - 5E7B     Goto Channel command (C) processing
;       5E7C - 5E8B     Report Channel (H) command processing
;       5E8C - 5EF9     AGC command (M) processing
;       5EFA - 5F04     AGC speed mapping data
;       5F05 - 5F58     Mode command (D) processing
;       5F59 - 5F61     Mode mapping data
;       5F62 - 5F7F     IF filter bandwidth (I) command processing
;       5F80 - 6061     Remote code dealing with BW filters
;       6062 - 60A3     Compare AB85,AB86,AB89,AB8C to AB87,AB88,AB8A,AB8D and make 1st set=2nd set sometimes
;       60A4 - 60C6     HL=f(HL,DE) and set A to 0, 1, or 2
;       60C7 - 610F     Frequency command (F) processing
;       6110 - 6183     FSK Center freq command (R) processing
;       6184 - 61D6     FSK shift and polarity command (Y) processing
;       61D7 - 623B     BFO command (B) processing
;       623C - 6246     Adv parsing ptr to next cmd and set 'Unable or Invalid Command' flag
;       6247 - 6251     Adv parsing ptr to next cmd and set 'Syntax Error' flag
;       6252 - 6292     Move incoming ASCII into second buffer
;       6293 - 62A8     If actively scanning, if $A57E <> E, return with carry set
;       62A9 - 62B5     Convert ASCII char A into upper case
;       62B6 - 62C6     Returns with carry clear if A is ASCII number char
;       62C7 - 62E0     ASCII char in A, returns with cy set for letter; converts A to UC.
;       62E1 - 630B     ASCII at [HL] and [HL+1] converted to BCD in A, HL incr by 2
;       630C - 6316     A gets low nybble of B as top 4 bits, low nybble of C as low 4 bits
;       6317 - 633F     Convert nbr string to # in DE, A=# digits, HL points to next
;       6340 - 63C8     ASCII verify number B digits before dec pt, C digits after.  A=0 if OK, $FF if bad
;       63C9 - 63DA     returns with A=# of ASCII # chars from HL on and HL pointing to first non-#
;       63DB - 63F5     Advance $AB4B pointer to next valid cmd or EOL (CR)
;       63F6 - 6411     Send status report and Carriage return
;       6412 - 6474     CURRENT STATUS report - Appended to the end of all outgoing messages
;       6475 - 64A3     Report channels programmed into group specified in A
;       64A4 - 64C4     Channel scanning bounds report
;       64C5 - 64EC     Channel status report
;       64ED - 6538     Scan Dwell report
;       6539 - 6559     text messages
;       655A - 656D     Report channel (H) processing
;       656E - 6583     reports for 655A
;       6584 - 65F2     S17 Report Radio State command
;       65F3 - 6632     S18 Report Programmable Options command (for FSK only)
;       6633 - 6689     S19 Report AGC and Audio Levels command
;       668A - 66BC     S6 Report BITE Results command
;       66BD - 66E6     S16 Report Who You Are command
;       66E7 - 673D     S5 Report IF Filter Config command
;       673E - 6742     data
;       6743 - 6757     Send ASCII '#a[' where a is A
;       6758 - 675F     Send ASCII ']'
;       6760 - 6780     IF Filter Bandwidth report
;       6781 - 6807     Filter number, low 4 bits of A, BW ASCII out serial port
;       6808 - 6829     RF Atten status report
;       682A - 684D     Auto Stop Scan Threshold report
;       684E - 686D     Mute Status Report
;       686E - 688D     Noise Blanker Status Report
;       688E - 68D1     AGC report
;       68D2 - 68FD     Mode report
;       68FE - 6944     Frequency report, sends out freq of RAM channel data pointed to by $A809
;       6945 - 698D     BFO report
;       698E - 69E0     FSK Center freq report
;       69E1 - 6A15     FSK Shift and Polarity report
;       6A16 - 6A33     Put ASCII char A in serial comm output queue
;       6A34 - 6A60     Send value of A out as ASCII '000' to '255'
;       6A61 - 6A83     Convert H/L bytes of A into ASCII and send out serial port
;       6A84 - 6A96     Convert H/L nybbles of A to ASCII # chars in B/C
;       6A97 - 6AC1     Place C ASCII #'s from HL into output queue.  Suppress leading zeroes.
;       6AC2 - 6B46     Place ASCII # digits from HL into output queue, B before DP, C after DP.
;
;
;--------------------------------------------------------------------------------------------------
        .org    $0000                   ; RST 0
        di                              ;Disable Interrupts
        jmp     START

        .fill   $4

        .org    $0008                   ; RST 1
        pop     h
        rst     0

        .fill   $6

        .org    $0010                   ; RST 2
        pop     h
        rst     0

        .fill   $6

        .org    $0018                   ; RST 3
        pop     h
        rst     0

        .fill   $6

        .org    $0020                   ; RST 4
        pop     h
        rst     0

        .fill   $2

        .org    $0024                   ; TRAP
        rim
        pop     h
        push    psw
        rst     0

        .org    $0028                   ; RST 5
        pop     h
        rst     0

        .fill   $2

        .org    $002C                   ; RST 5.5
        jmp     L37D2                   ; UART Interrupt

        .fill   $1

        .org    $0030                   ; RST 6
        pop     h
        rst     0

        .fill   $2

        .org    $0034                   ; RST 6.5
        jmp     L2421                   ; Tune Wheel Interrupt

        .fill   $1

        .org    $0038                   ; RST 7
        pop     h
        rst     0

        .fill   $2

        .org    $003C                   ; RST 7.5
        jmp     L050D                   ; 1 msec interrupt


        .fill   START-$
;--------------------------------------------------------------------------------------------------
;
        .org    $00A0
START:
        lxi     sp,$C000                ;set stack (top) start at C000
        mvi     a,$4F
        sim
        mvi     a,$C0
        sim
        mvi     a,$4E                   
        out     $80                     ; 4E to 8155 Command Register
                                                        ;   Stop Timer; Port B & C as Output; Port A as Input
        mvi     a,$98
        out     $82                     ; 98 to 8155 Port B
                                                        ;   BFO on/off; Fast AGC; AGC Off
        mvi     a,$00
        out     $83                     ; 00 to 8155 Port C (IF filter select)
        mvi     a,$4B
        out     $85                     ; 4B to 8155 Timer
                                                        ;   Sq wave output; MSB=$B
        mvi     a,$B8
        out     $84                     ; B8 to 8155 Timer LSB, $B8
        mvi     a,$CE
        out     $80                     ; CE to 8155 Command Register
                                                        ;   Start Timer, count $BB8 to create 1 KHz for RST 7.5
                                                        ;   $BB8 = 3000 decimal, 3 MHz input clk => 1 KHz
        mvi     a,$8B
        out     $43                     ; 8B to 8255 Control Register
                                                        ;   Ports B & C as Input; Port A as Output
        mvi     a,$31
        out     $40                     ; 31 to 8255 Port A, Remote Out 2 set
        mvi     a,$7F
        out     $70                     ; 7F to (Serial bus data)
        nop
        nop
        nop
        nop
        nop
        nop
        nop
        out     $62                     ; Set Serial Data strobe to PLL III
        lxi     h,$AB95
        mvi     b,$00
        mvi     a,$A9
L00DD:
        mov     m,b                     ; Clear $A9 locs starting at $AB95
        inx     h
        dcr     a
        jnz     L00DD
        xra     a                       ; Clear A
        sta     $A575                   ; Actively scanning flag ($FF means actively scanning)
        sta     $A682                   ; Status bits
        sta     $A68E                   ; 00
        sta     $A67C                   ; 00 (NB/mute status)
        sta     $A579                   ; 00 (Holds group number)
        sta     $A823                   ; 00
        sta     $A824                   ; 00 Timer decrements this every 1 msec, but not below 0
        mvi     a,$43
        sta     $A57B                   ; Channel or group scan.  43=channel, 47=group
        mvi     a,$FF
        sta     $ABEE                   ; FF
        sta     $A576                   ; FF
        cma                             ; Clear A
        sta     $A577                   ; Flag, tuning wheel active for scan chan select
        sta     $A578                   ; 00
        sta     $A57A                   ; 00
        sta     $A579                   ; 00 (Holds group number)
        sta     $A839                   ; 00   (2nd IF AGC A/D value)
        sta     $A83A                   ; 00   (AGC A/D value)
        sta     $A83B                   ; 00   (Line Audio)
        sta     $A83C                   ; 00   (ISB Audio)
        mvi     a,$1E
        sta     $AB94                   ; 1E Timer decrements this every 1 msec, but not below 0
        mvi     a,$01
        sta     $A842                   ; 01
        sta     $A841                   ; 01
        mvi     a,$00
        sta     $ABF4                   ; 00
        sta     $AB92                   ; Flag, scan stopped for received signal (=FF)
        lda     $AB8F
        call    L281C                   ; Test A: C=1 if A>$99 or low 4 bits >9
        jnc     L014C
        mvi     a,$99
        sta     $AB8F                   ; 99
        mvi     a,$FF
        sta     $AB90                   ; Auto Stop Scan Threshold (FF=off)
        mvi     a,$FF
        sta     $AB91                   ; Auto Stop Scan Threshold (FF=off)
L014C:
        call    L2725                   ; Disable Tuning wheel
        call    L03B6                   ; Save IF filt config to RAM as per DIP sw setting
        mvi     a,$78
        sta     $ABD0                   ; 78
        call    L1D72                   ; Load default params to chan 0 if necessary
        jnz     L0192
        call    L532E                   ; Check FSK option data with checksum.  A=0 means was OK, A=FF means was reinitialized
        jnz     L0195
        lda     $A54A                   ; remotely generated channel number going to commanded
        mov     b,a
        call    L2800                   ; Convert BCD B to number in A, carry set if B not good BCD
        jnc     L0172
        mvi     a,$A0
        sta     $A54A                   ; remotely generated channel number going to commanded
L0172:
        lda     $A549                   ; locally generated channel number going to commanded
        mov     b,a
        call    L2800                   ; Convert BCD B to number in A, carry set if B not good BCD
        jnc     L0181
        mvi     a,$A0
        sta     $A549                   ; locally generated channel number going to commanded
L0181:
        lda     $A679                   ; Status bits
        ani     $3F
        jz      L01F0
        call    L0433                   ; FSK UART test, sets flag $AC3A to $FF if OK
        jz      L01DD
        jmp     L01D2
L0192:
        call    L533A   ;
L0195:
        mvi     a,$FF
        sta     $AB91                   ; Auto Stop Scan Threshold (FF=off)
        sta     $AB90                   ; Auto Stop Scan Threshold (FF=off)
        mvi     a,$99
        sta     $AB8F
        lxi     h,$A589                 ; Group channel storage area base address
        mvi     a,$EE
        mvi     b,$C8
L01A9:
        mov     m,a
        inx     h
        dcr     b
        jnz     L01A9
        mvi     a,$43
        sta     $A682                   ; Status bits
        lxi     h,$9900
        shld    $A57C                   ; Channel scanning lower bound
        mvi     a,$03
        sta     $A580                   ; Scan Dwell pointer; $0B means external.
        mvi     a,$05
        sta     $A581                   ; Scan dwell (FF means external)
        mvi     a,$A0
        sta     $A54A                   ; remotely generated channel number going to commanded
        sta     $A549                   ; locally generated channel number going to commanded
        call    L0433                   ; FSK UART test, sets flag $AC3A to $FF if OK
        jz      L01DD
L01D2:
        lda     $A679                   ; Status bits
        ori     $80
        sta     $A679                   ; Set to local control mode
        jmp     L01F0
L01DD:
        xra     a
        sta     $A574                   ; D/A value for RF gain
        cma
        sta     $A67B                   ; RF atten
        sta     $A80F                   ; RF gain via remote
        lda     $A679                   ; Status bits
        ani     $7F
        sta     $A679                   ; Set to remote control mode
L01F0:
        mvi     h,$5A                   ; AGC
        call    L2BBE                   ; A/D read routine.  Channel H, A has data, carry if error.
        mvi     h,$5A                   ; AGC
        call    L2BBE                   ; A/D read routine.  Channel H, A has data, carry if error.
        cpi     $CD
        jnc     L020B
        mvi     a,$FF
        sta     $ABC5                   ; 2ISB option installed flag (0=not installed, FF=installed)
        xra     a
        sta     $A674
        jmp     L0214
L020B:
        xra     a
        sta     $ABC5                   ; 2ISB option installed flag (0=not installed, FF=installed)
        mvi     a,$0F
        sta     $A674
L0214:
        call    L04C6                   ; loads 2 values to $F800 to see what happens
        lxi     h,$D800                 ; FSK option memory space
        mvi     m,$0F
        mvi     m,$00
        lxi     h,$C800                 ; FSK option memory space
        mvi     m,$77
        mvi     m,$01
        mvi     a,$14
        sta     $C200                   ; FSK option memory space
        sta     $A82A                   ; FSK variable
        call    L5354
        call    L0470                   ; 4ISB option detect
        call    L0487                   ; Test whether or not FSK option installed
        lda     $A679                   ; Status bits
        ani     $80
        jz      L024F                   ; jump if remote control mode
        lda     $AB90                   ; Auto Stop Scan Threshold (FF=off)
        sta     $A67D
        lda     $A574                   ; D/A value for RF gain
        cma
        sta     $A67B                   ; RF atten
        cma
        jmp     L025F
L024F:
        lda     $AB91                   ; Auto Stop Scan Threshold (FF=off)
        sta     $A67D
        lda     $A80F                   ; RF gain via remote
        sta     $A67B                   ; RF atten
        cma
        sta     $A574                   ; D/A value for RF gain
L025F:
        call    L322C                   ; Send A to Serial Bus
        out     $61                     ; Set Serial Data strobe to D/A
        mvi     b,$09
        lda     $A818                   ; 4ISB option flag, zero for no 4ISB
        push    psw
        mvi     a,$FF
        sta     $A818                   ; 4ISB option flag, zero for no 4ISB
L026F:
        mvi     c,$07
        call    L1A34                   ; Find next filter supporting mode, mode B, current filter C, returns with B
        lxi     h,$A56D
        mov     m,b
        call    L1858                   ; Store user filter choice for mode
        mov     b,c
        dcr     b
        jp      L026F
        pop     psw
        sta     $A818                   ; 4ISB option flag, zero for no 4ISB
        xra     a
        sta     $A821                   ; initially clear $A821 (RF590A/other select)
        in      $BD                     ; UART Input Port
        ani     $10                     ; Option select (RF590A/other) true=RF590A
        jnz     L0294
        mvi     a,$FF
        sta     $A821                   ; RF590A sets $A821 to $FF
L0294:
        xra     a
        sta     $A67E                   ; clear comm port initialized flag
        call    L0433                   ; FSK UART test, sets flag $AC3A to $FF if OK
        jz      L02A9
        lda     $A679                   ; Status bits
        ori     $80
        sta     $A679                   ; Set to local control mode
        jmp     L02AC
L02A9:
        call    L3472                   ; Protocol initialization code
L02AC:
        lda     $A682                   ; Status bits
        cpi     $43
        jnz     L02BB
        lxi     h,L04E5                 ; Channel memory fail message
        xra     a
        jmp     L02D0
L02BB:
        call    L4B09                   ; ROM test routine
        jnc     L02C7
        lxi     h,L04F9                 ; ROM failure message
        jmp     L02D0
L02C7:
        call    L4B3E                   ; RAM test routine
        jnc     L0306
        lxi     h,L04D1                 ; RAM failure message
L02D0:
        mvi     c,$1D
        mvi     b,$14
        call    L0645                   ; Display text message
        mvi     h,$14
        mov     l,a
        shld    $ABC9                   ; BITE fault code
        mvi     a,$04
        sta     $A682                   ; Status bits
        xra     a                       ; none
        sta     $ABED                   ; Radio setting control, see L2D5B
        sta     $ABB5                   ; Front panel LEDs
        mvi     a,$01
        sta     $ABB4                   ; Front panel LEDs
        mvi     a,$01                   ; update now
        sta     $ABEC                   ; Display update control see L06FD
        lda     $A679                   ; Status bits
        ani     $80
        jnz     L0311                   ; jump if local control mode
        lda     $ABB4
        ori     $08                     ; remote
        sta     $ABB4                   ; Front panel LEDs
        jmp     L0311
L0306:
        call    L16A2                   ; Start receive mode
        mvi     a,$03
        sta     $ABBE
        sta     $ABB6                   ; Digit to tune, start with 1 KHz
L0311:
        rim
        cma
        ori     $F4
        cma
        ori     $08
        sim
        lda     $A679                   ; Status bits
        ani     $C0
        sta     $A679                   ; Status bits
L0321:
        lda     $AB94                   ; Timer decrements this every 1 msec, but not below 0
        ora     a
        jnz     L0339
        mvi     a,$32
        sta     $AB94                   ; Timer decrements this every 1 msec, but not below 0
        call    L2D33                   ; Read 2nd IF AGC & store at $A839
        call    L2D3D                   ; Read AGC and store at $A83A
        call    L2D47                   ; Read Line Audio & store at $A83B
        call    L2D51                   ; Read ISB Audio & store at $A83C
L0339:
        lda     $A823
        cpi     $FF
        jnz     L0354
        lda     $A824                   ; Timer decrements this every 1 msec, but not below 0
        ora     a
        jnz     L0354
        xra     a
        sta     $A823
        lda     $ABED
        ori     $04                     ; AGC
        sta     $ABED                   ; Radio setting control, see L2D5B
L0354:
        lda     $ABCF                   ; increments every 1 msec
        cpi     $32
        jc      L0373
        xra     a
        sta     $ABCF                   ; increments every 1 msec
        lda     $ABD2                   ; Inc'd in main loop, controls sequencing
        inr     a
        sta     $ABD2
        call    L0B02                   ; High level operations
        call    L2C6C                   ; RF gain setting code
        call    L332F                   ; Send data out rear panel serial bus
        call    L2AB1
L0373:
        lda     $ABD2                   ; Inc'd in main loop, controls sequencing
        cpi     $14
        jc      L038F
        xra     a
        sta     $ABD2                   ; Inc'd in main loop, controls sequencing
        lda     $ABD0
        ora     a
        jz      L038A
        dcr     a
        sta     $ABD0
L038A:
        mvi     a,$20
        sta     $AB95                   ; update display
L038F:
        lda     $ABED
        ora     a
        cnz     L2D5B                   ; Set radio, section controlled by bits in $ABED
        lda     $ABD0
        ora     a
        jnz     L03A4
        lda     $ABD1                   ; Timer decrements this every 1 msec, but not below 0
        ora     a
        cz      L2B28                   ; PLL unlocked and 4ISB missing fault detection (checked every 31 msec)
L03A4:
        lda     $ABEC                   ; Display update control see L06FD
        ora     a
        cnz     L06FD                   ; Display update based on bits set in $ABEC
        call    L2350                   ; Active scanning logic for external Step, Stop inputs
        call    L0470                   ; 4ISB option detect
        ei                              ; Enable interrupts
        hlt                             ;   ...and wait
        jmp     L0321

;--------------------------------------------------------------------------------------------------
; IF filter routine
;
;       ABF8    Filter 1 data
;       ABF9    Filter 2 data
;       ABFA    Filter 3 data
;       ABFB    Filter 4 data
;       ABFC    Filter 5 data
;       ABFD    Filter 6 data
;       ABFE    Filter 7 data
;       ABFF    Filter 8 data
;       AC00    extra data
;
;
;       addr1           addr2           addr3           addr4           addr5           addr6           addr7           addr8
;       AC09            AC0D            AC11            AC15            AC19            AC1D            AC21            AC25
;       AC0A            AC0E            AC12            AC16            AC1A            AC1E            AC22            AC26
;       AC0B            AC0F            AC13            AC17            AC1B            AC1F            AC23            AC27
;       AC0C            AC10            AC14            AC18            AC1C            AC20            AC24            AC28
;
; First, second and third filter parameter bytes
;
;       AC29            AC2B            AC2D            AC2F            AC31            AC33            AC35            AC37
;       AC2A            AC2C            AC2E            AC30            AC32            AC34            AC36            AC38
;       AC01            AC02            AC03            AC04            AC05            AC06            AC07            AC08
;
L03B6:
;
; Set up ABF8-AC00 with filter config as per DIP switches
;
        in      $70                     ; BW filter config switch
        ani     $1F                     ; discard upper 3 bits, leaving config code
        add     a                       ; A = (0:62)
        lxi     h,L28E6                 ; HL=lookup table base addr
        mov     c,a
        mvi     b,$00
        dad     b                               ; add BC to the index HL
        mov     e,m                             ; read 1st entry from table, put into E
        inx     h
        mov     d,m                             ; read second entry from table, put into D
        xchg                                    ; Exchange HL & DE
        lxi     d,$ABF8
        mvi     c,$09
        call    L27D3                           ; Move 9 bytes @HL to @DE, filt config
        in      $70                             ; BW filter config switch
        rrc
        rrc
        rrc
        rrc
        rrc
        ani     $07                     ; 4=FL7, 2=FL6, 1=FL5 present
        lxi     h,$ABFC
        mvi     b,$00
        rrc
        jc      L03E1                           ; Is FL5 present?
        mov     m,b                             ; No, zero out its data at $ABFC
L03E1:
        inx     h
        rrc
        jc      L03E7                           ; Is FL6 present?
        mov     m,b                             ; No, zero out its data at $ABFD
L03E7:
        inx     h
        rrc
        jc      L03ED                   ; Is FL7 present?
        mov     m,b                     ; No, zero out its data at $ABFE
;
; For each of 8 filters,
;
L03ED:
        lxi     b,$0000
L03F0:
        push    b                               ; Push BC(0:7) onto stack
        lxi     h,$ABF8                 ; HL points to filter storage area 
        dad     b                               ; HL = loc of individual filter BC(0:7) data byte
        mov     l,m                             ; filter BC(0:7) data byte into L
        mvi     h,$00                           ; H=0, now HL has filter BC(0:7) data
        push    h                               ; Push filter BC(0:7) data byte (word, top bits=0) onto stack
        dad     h
        dad     h                               ; mult filter data by 3
        pop     d                               ; DE becomes filter BC(0:7) data
        dad     d                               ; HL = 4 times filter BC(0:7) data
        lxi     d,L2980                 ; DE = 2980
        dad     d                               ; HL = 4 x filt data + $2980
        mov     e,m                             ;
        inx     h
        mov     d,m                             ; DE has address of ASCII filter description
        inx     h
        push    h                               ; first filt data byte loc onto stack
        lxi     h,$AC09                 ; HL = $AC09, start of ASCII filt storage area
        dad     b
        dad     b
        dad     b
        dad     b                               ; HL = loc to store THIS filters ASCII at
        mvi     c,$04                           ; C = 04
L040F:
        ldax    d                               ; A=(DE), A=(DE+1), A=(DE+2), A=(DE+3)
        mov     m,a                             ; (HL)=A, (HL+1)=A, (HL+2)=A, (HL+3)=A 
        inx     d                       ;
        inx     h                       ; (Store ASCII filt desc to RAM)
        dcr     c
        jnz     L040F
        pop     d                               ; first filt data byte loc 
        pop     b                               ; filter # routine is working on (0:7)
        lxi     h,$AC29
        dad     b
        dad     b
        ldax    d                               ; A=first filt data byte 
        mov     m,a                             ; Store it to RAM
        inx     d
        inx     h
        ldax    d                               ; A= second filt data byte
        mov     m,a                             ; Store it to RAM
        inx     d                               ; DE now points to third file data byte
        lxi     h,$AC01
        dad     b                               ; HL now loc in RAM to store third parm byte
        ldax    d                               ; A=third filt parm byte
        mov     m,a                             ; Store it to RAM
        inx     b                               ; Inc BC(0:7) filter number to load to RAM
        mov     a,c
        cpi     $08                             ; BC=8 ?
        jnz     L03F0                           ; Loop if not
        ret
;--------------------------------------------------------------------------------------------------
;       FSK UART test, sets flag $AC3A to $FF if OK
L0433:
        push    h
        push    d
        push    b
        lxi     h,$E002                 ; FSK UART Command Register
        lxi     d,$E000                 ; FSK UART
        mvi     m,$10                   ; reser MR pointer
        ldax    d
        mov     c,a                     ; save $E000 value in C
        mvi     a,$55
        mvi     m,$10                   ; reser MR pointer
        stax    d                       ; put $55 into $E000
        mvi     m,$10                   ; reser MR pointer
        ldax    d
        cpi     $55                     ; is $E000 = $55?
        jnz     L045F                   ; jump if not
        mvi     a,$AA
        mvi     m,$10                   ; reser MR pointer
        stax    d                       ; put $AA into $E000
        mvi     m,$10                   ; reser MR pointer
        ldax    d                       ; get A from $E000
        cpi     $AA
        jnz     L045F                   ; jump if not
        mvi     a,$FF
        jmp     L0465           
L045F:
        in      $BD                     ; UART Input Port
        ani     $40                     ; Enable Remote Control if zero
        mvi     a,$00
L0465:
        sta     $AC3A                   ; FSK UART present flag
        mvi     m,$10                   ; reser MR pointer
        mov     a,c                     ; restore $E000 
        stax    d                       ;   to original value
        pop     b
        pop     d
        pop     h
        ret
;--------------------------------------------------------------------------------------------------
;       4ISB option detect
;
L0470:
        stc
        cmc
        mvi     h,$50                           ; 4ISB Detect
        call    L2BBE                           ; A/D read routine.  Channel H, A has data, carry if error.
        cpi     $C0
        jc      L0482
        mvi     a,$FF                           ; 4ISB installed, set $A818 to $FF
        sta     $A818                           ; 4ISB option flag
        ret
L0482:
        xra     a                               ; 4ISB not installed, set $A818 to zero
        sta     $A818                           ; 4ISB option flag
        ret
;--------------------------------------------------------------------------------------------------
;       Test whether or not FSK option installed
;
L0487:
        lda     $A82A                   ; FSK variable
        ani     $3F
        sta     $C200                   ; FSK option memory space
        sta     $A82A                   ; FSK variable
        lda     $C400                   ; FSK option memory space
        mvi     b,$C0
        ana     b
        jnz     L04C0
        lda     $A82A                   ; FSK variable
        ori     $C0
        sta     $C200                   ; FSK option memory space
        sta     $A82A                   ; FSK variable
        lda     $C400                   ; FSK option memory space
        ana     b
        jz      L04C0
        mvi     a,$FF
        sta     $A825                   ; Indicate FSK option installed
        mvi     a,$00
L04B4:
        push    psw
        call    L5365
        pop     psw
        inr     a
        cpi     $05
        jnz     L04B4
        ret
L04C0:
        mvi     a,$00
        sta     $A825                   ; Indicate FSK option not installed
        ret
;--------------------------------------------------------------------------------------------------
;       loads 2 values to $F800 to see what happens
L04C6:
        mvi     a,$32
        sta     $F800                   ; FSK option memory space
        mvi     a,$76
        sta     $F800                   ; FSK option memory space
        ret
;--------------------------------------------------------------------------------------------------
;
L04D1:  .db     "POWER-UP RAM FAILURE"
L04E5:  .db     "CHANNEL MEMORY FAIL "
L04F9:  .db     "POWER-UP ROM FAILURE"

;--------------------------------------------------------------------------------------------------
;       1 msec Timer interrupt
;
L050D:
        push    h
        push    d
        push    b
        push    psw
        lda     $ABCF
        inr     a
        sta     $ABCF                   ; Incr $ABCF
        lda     $A824
        ora     a
        jz      L0523
        dcr     a
        sta     $A824                   ; Decr $A824, but not below 0
L0523:
        lda     $AB94
        ora     a
        jz      L052E
        dcr     a
        sta     $AB94                   ; Decr $AB94, but not below 0
L052E:
        lda     $ABD3                   ; msec delay count for L52CA
        ora     a
        jz      L0539
        dcr     a
        sta     $ABD3                   ; Decr $ABD3, but not below 0
L0539:
        lda     $ABD1                   ; Decrements every 1msec, but not below 0
        ora     a
        jz      L0547
        lda     $ABD1                   ; Decrements every 1msec, but not below 0
        dcr     a
        sta     $ABD1                   ; Decr $ABD1, but not below 0
L0547:
        lda     $AB95
        ora     a
        cnz     L0571                   ; If $AB95 is not zero send data to front panel
        ei                              ; Enable interrupts
        lda     $A567                   ; Tuning wheel enabled flag (FF if enabled)
        ora     a
        jz      L055E                   ; jump if tuning disabled
        rim
        cma
        ori     $F2
        cma
        ori     $08
        sim                             ; If tuning enabled, mask = 00001x0x
L055E:
        mvi     a,$40
        sim                             ; SIM = $40
        mvi     a,$C0
        sim                             ; SIM = $C0
        lda     $A67E                   ; Comm port has been initialized flag
        cpi     $FF
        cz      L352D                   ; Call L352D if comm port initialized
        pop     psw
        pop     b
        pop     d
        pop     h
        ret

;--------------------------------------------------------------------------------------------------
;       Send display data to Front Panel
;        (called from timer interrupt routine)
;        Display address ($AB95), display data ($AB96 + $AB95)
;
L0571:
        lxi     h,$AB95                 ; HL = $AB95
        mov     a,m                     ; get A from $AB95
        dcr     a
        jp      L057B                   ; jump if $AB95 in range of $01 to $80
        mvi     a,$00
L057B:
        mov     m,a                     ; $AB95 dec'd if $01 to $80, else $00
        ani     $1F                     ; strip off upper 3 bits
        mov     c,a                     ; C has it now
        adi     $20                     ; add front panel controller offset
        di                              ; Disable Interrupts
        out     $70                     ; Output to serial bus
        lxi     h,$AB96                 ; HL = $AB96
        mvi     b,$00
        dad     b                       ; add low 5 bits of $AB95 to addr $AB96
        mov     a,m                     ; get data from there and
        out     $70                     ; send out on serial bus
        nop
        nop
        nop
        nop
        nop
        out     $66                     ; Set Serial Data strobe to frnt pnl Display Strobe
        ret
;--------------------------------------------------------------------------------------------------
;
;       Front panel keyboard, check for pressed key
;         Scan keyb, place key code in $ABBB
;
L0595:
        lxi     h,$ABBB                 ; $ABBB is key pressed code ($FF means no key pressed)
        mov     a,m
        cpi     $FF                             ; Is $ABBB = $FF?
        jnz     L05A7
        in      $42                             ; 8255 Port C
        cma
        ani     $0F                             ; A now has key code when scan input = $FF
        cnz     L05D3                           ; Call sub L05D3 if keypress detected
        ret

L05A7:                                          ; $ABBB not $FF, key pressed
        ani     $03                             ; A = row of pressed key
        mov     c,a
        call    L2884                           ; Sets bit C of A to 1
        mov     b,a
        in      $42                             ; 8255 Port C
        cma
        ani     $0F                             ; Read KB again
        ana     b                               ; agree with earlier detect?
        jz      L05BC                           ; If disagree, jump and reset scan logic
        mvi     a,$80
        ora     m
        mov     m,a                             ; If agree, set $80 bit of $ABBB to complete detection
        ret

L05BC:
        mvi     c,$FF
        call    L0637                           ; Send scan code $FF to front panel keyboard
        in      $42                             ; 8255 Port C
        cma
        ani     $0F
        jz      L05CD                           ; If no key pressed, reset scan to detect mode ?
        call    L05D3                           ; Call if keypress detected
        ret                                     ;

L05CD:
        mvi     a,$FF                           ; Reset scan to detect mode ?
        sta     $ABBB
        ret

;--------------------------------------------------------------------------------------------------
;       Front panel keypress detected
;
L05D3:
        mvi     c,$0F
        call    L0637                           ; Send scan code $0F to front panel keyboard
        in      $42                             ; 8255 Port C
        cma
        ani     $0F
        jnz     L05E6                           ; jmp if key detected on lower half of cols
        mov     a,c                             ; A=$0F
        add     a                               ; A=$1E
        add     a                               ; A=$3C                         
        add     a                               ; A=$78
        add     a                               ; A=$F0
        mov     c,a                             ; C=$F0
L05E6:
        mov     a,c                             ; A=$0F if key there or $F0 if key there
        ani     $33                             ; A=$03 if key there or $30 if key there
        mov     c,a
        call    L0637                           ; Send scan code $03 or $30 to front panel keyboard
        in      $42                             ; 8255 Port C
        cma
        ani     $0F
        jnz     L05F9                           ; jump if key detected
        mov     a,c                             ; A=$03 or $30
        add     a                               ; A=$06 or $60
        add     a                               ; A=$0C or $C0
        mov     c,a
L05F9:
        mov     a,c                             ; A=$03 or $0C or $30 or $C0
        ani     $55                             ; A=$01 or $04 or $10 or $40
        mov     c,a
        call    L0637                           ; Send scan code C to front panel keyboard
        in      $42                             ; 8255 Port C
        cma
        ani     $0F
        jnz     L0620                           ; jump if key detected
        mov     a,c
        add     a
        mov     c,a                             ; C=$02 or $08 or $20 or $80
        call    L0637                           ; Send scan code C to front panel keyboard
        in      $42                             ; 8255 Port C
        cma
        ani     $0F
        jnz     L0620                           ; jump if key detected
        mvi     a,$FF                           ; can't find key, must have been noise
        sta     $ABBB                           ; reset scan code to detect
        mov     c,a
        call    L0637                           ; Send scan code $FF to front panel keyboard
        ret

;--------------------------------------------------------------------------------------------------
;    form key code
L0620:                                          ; key detected with only one scan col active
        mov     b,c                             ; B has column (1 of 8 bits set)
        mov     c,a                             ; C has key code (1 of lower 4 bits set)
        call    L2895                           ; A has bit # of pressed key (encoded row)
        mov     c,b                             ; C has col (1 of 8 bits set)
        mov     b,a                             ; B has encoded row
        mov     a,c                             ; A has col (1 of 8 bits set)
        rlc
        rlc
        rlc
        rlc                                     ; 4 RLC's same as SWAB
        mov     c,a
        call    L2895                           ; A has col # of pressed key (encoded column)
        add     a                               ; * 2
        add     a                               ; * 4
        ora     b
        sta     $ABBB                           ; Store key as 000CCCRR here
        ret
;--------------------------------------------------------------------------------------------------
;
;       Send scan code C to front panel keyboard
;
L0637:
        di                                      ;Disable Interrupts
        mov     a,c
        cma
        out     $70                             ; (Serial bus data)
        nop
        nop
        nop
        nop
        nop
        out     $67                             ; Set Serial Data strobe to frnt pnl KBD Strobe
        ei                                      ; Enable interrupts
        ret
;--------------------------------------------------------------------------------------------------
;       Display text message to alphanumeric display
;         msg at HL, B number of chars, C = position on display, reduced by # chars outputted
;                                                     C = $1D for first pos, $0A for 20th (last) pos
;
L0645:
        push    b
        push    psw
L0647:
        mov     a,c
        cpi     $0A                     ; 
        jnc     L064E
        rst     2                       ; Reset processor if C < $0A
L064E:
        mov     a,m                     ; C >=$0A; get A from (HL)
        cpi     $2C
        jz      L0659
        cpi     $2E
        jnz     L065A
L0659:
        inr     c                       ; if char=$2C or $2E, incr C (backspace?)
L065A:
        call    L0685                   ; Place char A to display location C (not changing existing bit 7)
        dcr     c                       ; decr C after each char sent
        inx     h                       ; Incr message read pointer
        dcr     b                       ; decr B after each char sent
        jnz     L0647                   ; loop until B=0
        pop     psw
        pop     b
        ret
;--------------------------------------------------------------------------------------------------
;       Display B chars from [HL] to disp loc C
L0666:
        push    b
        push    psw
        mov     a,c
        cpi     $0A
        jc      L066F
        rst     2
L066F:
        mov     a,m
        cpi     $5F                     ; backspace
        jnz     L0676
        inr     c
L0676:
        call    L0685                   ; Place char A to display location C (not changing existing bit 7)
        dcr     c
        jm      L0682                   ; dec C until past zero, then exit
        inx     h
        dcr     b
        jnz     L066F
L0682:
        pop     psw
        pop     b
        ret
;--------------------------------------------------------------------------------------------------
;       Place char A to display location C (not changing existing bit 7)
;
L0685:
        push    psw
        push    b
        push    h
        mov     b,a                     ; B now has ASCII
        mov     a,c                     ; A has C
        cpi     $0A
        jnc     L06A8                   ; jump if C>=$A
        mov     a,b                     ; A has ASCII (numeric display address)
        cpi     $10                     ; 
        jc      L0697                   ; jump if ASCII < $10
        sui     $30                     ; convert ASCII to number
L0697:
        ani     $1F                     ; A has data (for numeric display)
        lxi     h,$ABAA                 ; base of numeric transfer area
        mvi     b,$00
        dad     b                       ; add offset C, now HL is location of number to be displayed
        mov     b,a                     ; B=char to be displayed
        mov     a,m                     ; A=char last there
        ani     $80                     ; get b7 from existing char
        ora     b                       ; add in new char
        mov     m,a                     ; and store to memory
        jmp     L06E2
L06A8:
        mov     a,b                     ; A has ASCII, C>=$0A (data for alphanumeric display)
        cpi     $5E
        jnc     L06E7                   ; exit if ASCII >= $5E
        cpi     $0A
        jnc     L06B8                   ; jump if ASCII >= $0A
        adi     $30                     ; ASCII is a pure number, need to add $30 to really get ASCII
        jmp     L06C7
L06B8:
        cpi     $10
        jnc     L06C2                   ; jump if ASCII >= $10
        adi     $37                     ; Hex to ASCII conversion
        jmp     L06C7
L06C2:
        cpi     $2E
        jz      L06D8
L06C7:
        sui     $20                     ; sub $20 from ASCII to get table value
        lxi     h,$AB8C         ; HL has pointer to data buffer for front panel xfer
        mvi     b,$00
        dad     b                       ; add BC to HL
        mov     b,a                     ; B has modified ASCII
        mov     a,m                     ; get present value at HL pointer
        ani     $80                     ; keep only bit 7
        ora     b                       ; then put in modified ASCII
        mov     m,a                     ; and store in RAM
        jmp     L06E2
L06D8:
        lxi     h,$AB8C
        mvi     b,$00
        dad     b
        mov     a,m
        ori     $40
        mov     m,a
L06E2:
        mvi     a,$20
        sta     $AB95                   ; update display
L06E7:
        pop     h
        pop     b
        pop     psw
        ret
;--------------------------------------------------------------------------------------------------
;       Place BCD number in A in display positions C-1 and C
L06EB:
        mov     e,a
        rrc
        rrc
        rrc
        rrc
        ani     $0F
        call    L0685                   ; Place char A to display location C (not changing existing bit 7)
        mov     a,e
        ani     $0F
        dcr     c
        call    L0685                   ; Place char A to display location C (not changing existing bit 7)
        ret
;--------------------------------------------------------------------------------------------------
;       Display update based on bits set in $ABEC
L06FD:
        mov     b,a
        xra     a
        sta     $ABEC
        mov     a,b
        ral                             ; call if bit 7 of $ABEC is set
        cc      L0732                   ; Put BCD $A566 to disp pos 0,1
        ora     a
        rz
        ral                             ; call if bit 6 of $ABEC is set
        cc      L075F                   ; Display frequency and digit to tune
        ora     a
        rz
        ral                             ; call if bit 5 of $ABEC is set
        cc      L078B                   ; Display BFO freq (of FSK freq if in FSK mode)
        ora     a
        rz
        ral                             ; call if bit 4 of $ABEC is set
        cc      L0873                   ; Display mode
        ora     a
        rz
        ral                             ; call if bit 3 of $ABEC is set
        cc      L0912                   ; Display IF filter
        ora     a
        rz
        ral                             ; call if bit 2 of $ABEC is set
        cc      L0947                   ; Display AGC info (or FSK info when in FSK mode)
        ora     a
        rz
        ral                             ; call if bit 1 of $ABEC is set
        cc      L0992                   ; Display Scan Dwell time
        ora     a
        rz
        ral                             ; call if bit 0 of $ABEC is set
        cc      L09E0                   ; If not in BITE, make NB LED display NB status
        ret
;--------------------------------------------------------------------------------------------------
;       Put BCD $A566 to disp pos 0,1
L0732:
        push    psw
        lda     $A566                   ; Channel
        cpi     $9A
        jc      L0750
        mvi     a,$20
        mvi     c,$01
        call    L0685                   ; Place char A to display location C (not changing existing bit 7)
        dcr     c
        call    L0685                   ; Place char A to display location C (not changing existing bit 7)
        lda     $A679                   ; Status bits
        ani     $BF
        sta     $A679                   ; Status bits
        pop     psw
        ret
L0750:
        mvi     c,$01
        call    L06EB                   ; Place BCD number in A in display positions C-1 and C
        lda     $A679                   ; Status bits
        ori     $40
        sta     $A679                   ; Status bits
        pop     psw
        ret
;--------------------------------------------------------------------------------------------------
;       Display frequency and digit to tune
L075F:
        push    psw
        lxi     h,$A55C                 ; MSB freq
        mvi     c,$09
L0765:
        mov     a,m
        call    L06EB                   ; Place BCD number in A in display positions C-1 and C
        dcx     h
        dcr     c
        mov     a,c
        cpi     $01
        jnz     L0765
        lda     $ABBD                   ; Numerical keypad applicability
        cpi     $02                     ; Frequency?
        jnz     L0789                   ; exit if not
        lda     $ABB6                   ; Digit to tune
        adi     $02
        lxi     h,$ABAA                 ; display buffer area
        mov     c,a                     ; C is 2 + digit to tune
        mvi     b,$00
        dad     b                       ; ABAA + (2 + digit to tune)
        mov     a,m
        ori     $40
        mov     m,a                     ; indicate digit to tune on display
L0789:
        pop     psw
        ret
;--------------------------------------------------------------------------------------------------
;       Display BFO freq (of FSK freq if in FSK mode)
L078B:
        push    psw
        lda     $ABBD                   ; Numerical keypad applicability
        cpi     $0A                     ; Stop Threshold
        jnz     L07BF
        lda     $AB8F
        mvi     c,$0B
        call    L06EB                   ; Place BCD number in A in display positions C-1 and C
        di                                      ;Disable Interrupts
        push    b
        lda     $AB8F
        mov     b,a
        call    L2800           ; Convert BCD B to number in A, carry set if B not good BCD
        sta     $AB90                   ; Auto Stop Scan Threshold (FF=off)
        sta     $A67D
        mov     c,a
        rrc
        ani     $7F
        add     c
        out     $70                             ; (Serial bus data)
        sta     $A574                   ; D/A value for RF gain
        nop
        nop
        nop
        nop
        out     $61                             ; Set Serial Data strobe to D/A
        pop     b
        pop     psw
        ei                                      ;Enable interrupts
        ret
L07BF:
        lda     $A55F                   ; mode & IF filter, present params
        ani     $0F
        cpi     $02                     ; AM?
        jz      L0847                   ; jump if AM
        cpi     $08
        jz      L0847                   ; jump if FM
        cpi     $09
        jz      L081B                   ; jump if FSK
        mvi     a,$20
        mvi     c,$0E
        call    L0685                   ; Place char A to display location C (not changing existing bit 7)
        lhld    $A55D                   ; BFO LSB
        mov     a,l
        ora     a
        jnz     L07F4
        ora     h
        jz      L07EF
        cpi     $F0
        jnz     L07F4
        xra     a
        sta     $A55E                   ; BFO MSB, sign
L07EF:
        mvi     a,$20
        jmp     L0801
L07F4:
        mov     a,h
        ani     $F0
        jz      L07FF
        mvi     a,$2D                   ; '-'
        jmp     L0801
L07FF:
        mvi     a,$2B                   ; '+'
L0801:
        mvi     c,$0D
        call    L0685                   ; Place char A to display location C (not changing existing bit 7)
        lda     $A55E
        ani     $0F
        dcr     c
        call    L0685                   ; Place char A to display location C (not changing existing bit 7)
        mvi     a,$2E
        call    L0685                   ; Place char A to display location C (not changing existing bit 7)
        mov     a,l
        dcr     c
        call    L06EB                   ; Place BCD number in A in display positions C-1 and C
        pop     psw
        ret
L081B:
        lhld    $A562                   ; FSK center freq, msb & sign
        mov     a,h
        ani     $80
        jnz     L0829
        mvi     a,$2B                   ; '+'
        jmp     L082B
L0829:
        mvi     a,$2D                   ; '-'
L082B:
        mvi     c,$0E
        call    L0685                   ; Place char A to display location C (not changing existing bit 7)
        mov     a,h
        ani     $3F
        mvi     c,$0D
        call    L06EB                   ; Place BCD number in A in display positions C-1 and C
        mvi     a,$2E
        mvi     c,$0D
        call    L0685                   ; Place char '.' to display location C (not changing existing bit 7)
        mov     a,l
        mvi     c,$0B
        call    L06EB                   ; Place BCD number in A in display positions C-1 and C
        pop     psw
        ret
L0847:
        lxi     h,L1B57                 ; blank spaces
        mvi     c,$0E
        mvi     b,$05
        call    L0645                   ; blank out bfo display
        lda     $ABBD                   ; Numerical keypad applicability
        cpi     $01                     ; BFO
        jnz     L0871
        xra     a
        sta     $ABBD                   ; clear Numerical keypad applicability
        lda     $ABB5
        ani     $DF                     ; BFO LED off
        sta     $ABB5                   ; Front panel LEDs
        xra     a
        sta     $ABF1
        lda     $ABEC
        ori     $21                     ; BFO, now
        sta     $ABEC                   ; Display update control see L06FD
L0871:
        pop     psw
        ret
;--------------------------------------------------------------------------------------------------
;       Display mode
L0873:
        push    psw
        lda     $A55F                   ; mode & IF filter, present params
        ani     $0F
        cpi     $09
        jnz     L088C                   ; jump if not in FSK mode
        mov     b,a
        lda     $A825                   ; FSK option installed flag. Zero if not installed
        ora     a
        jnz     L08BB
        lxi     h,L08FE                 ; No FSK message
        jmp     L08B1
L088C:
        cpi     $05
        jz      L08A5                   ; jump if in 2ISB mode
        cpi     $06
        jnz     L08BC                   ; jump if not in 4ISB mode
        mov     b,a
        lda     $A818                   ; 4ISB option flag, zero for no 4ISB
        cpi     $FF
        jz      L08BB
        lxi     h,L08EA                 ; No 4SB message
        jmp     L08B1
L08A5:
        mov     b,a
        lda     $ABC5                   ; 2ISB option installed flag (0=not installed, FF=installed)
        cpi     $FF
        jz      L08BB
        lxi     h,L08D6                 ; No ISB message
L08B1:
        mvi     c,$1D
        mvi     b,$14
        call    L0645                   ; Display text message
        pop     psw
        xra     a
        ret
L08BB:
        mov     a,b
L08BC:
        add     a
        add     a
        mov     c,a
        mvi     b,$00
        lxi     h,L0A7F                 ; Mode display text messages
        dad     b
        mvi     c,$19
        mvi     b,$04
        call    L0645                   ; Display mode
        lda     $ABEC
        ori     $2E                     ; BFO, mode, filt, AGC, dwell
        sta     $ABEC                   ; Display update control see L06FD
        pop     psw
        ret

L08D6:  .DB     "    NO ISB          "
L08EA:  .DB     "    NO 4SB          "
L08FE:  .DB     "    NO FSK          "

;--------------------------------------------------------------------------------------------------
;       Display IF filter
L0912:
        push    psw
        lda     $A55F                   ; mode & IF filter, present params
        ani     $0F
        cpi     $05                     ; 2ISB?
        jnz     L0925
        lda     $ABC5                   ; 2ISB option installed flag (0=not installed, FF=installed)
        cpi     $FF
        jnz     L0945
L0925:
        mvi     a,$20
        mvi     c,$16
        call    L0685                   ; Place char A to display location C (not changing existing bit 7)
        lda     $A55F                   ; mode & IF filter, present params
        rlc
        rlc
        rlc
        rlc
        ani     $0F
        add     a
        add     a
        mov     c,a
        mvi     b,$00
        lxi     h,$AC09                 ; IF filter text
        dad     b
        mvi     c,$15
        mvi     b,$04
        call    L0645                   ; Display bandwidth
L0945:
        pop     psw
        ret
;--------------------------------------------------------------------------------------------------
;       Display AGC info (or FSK info when in FSK mode)
L0947:
        push    psw
        lda     $A55F                   ; mode & IF filter, present params
        ani     $0F
        cpi     $09
        jz      L0967                   ; jump if FSK mode
        lda     $A560                   ; AGC speed pointer, present params
        add     a
        add     a
        mov     c,a
        mvi     b,$00
        lxi     h,L0AA7                 ; AGC mode/speed ASCII display messages
        dad     b
        mvi     c,$1D
        mvi     b,$04
        call    L0645                   ; Display agc
        pop     psw
        ret
L0967:
        lda     $A564
        mov     b,a
        ani     $80
        jnz     L0975
        mvi     a,$2B                   ; '+'
        jmp     L0977
L0975:
        mvi     a,$2D                   ; '-'
L0977:
        mvi     c,$1D
        call    L0685                   ; Place char A to display location C (not changing existing bit 7)
        mov     a,b
        ani     $03
        mov     b,a
        add     a
        add     b
        mov     c,a
        mvi     b,$00
        lxi     h,L0AF6                 ; FSK shift messages
        dad     b
        mvi     c,$1C
        mvi     b,$03
        call    L0645                   ; Display FSK param
        pop     psw
        ret
;--------------------------------------------------------------------------------------------------
;       Display Scan Dwell time
L0992:
        push    psw
        lda     $ABCB
        cpi     $0C
        jnz     L09A8                   ; jump if $ABCB not $0C
        lxi     h,L1B57                 ; all spaces, to blank area of display
        mvi     c,$12
        mvi     b,$03
        call    L0645                   ; blank dwell display
        jmp     L09BB
L09A8:
        lda     $A580                   ; Scan Dwell pointer; $0B means external.
        add     a
        add     a
        mov     c,a
        mvi     b,$00
        lxi     h,L0AC7                 ; Scan Dwell time ASCII display messages
        dad     b
        mvi     c,$12
        mvi     b,$04
        call    L0645                   ; Display scan dwell time
L09BB:
        mvi     c,$10
        mvi     a,$20
        call    L0685                   ; Place char A to display location C (not changing existing bit 7)
        dcr     c
        lda     $ABCB
        cpi     $0E
        jnz     L09D3
        lda     $A57B                   ; Channel or group scan.  43=channel, 47=group
        cpi     $47
        jz      L09D8
L09D3:
        mvi     a,$20
        jmp     L09DB
L09D8:
        lda     $A579                   ; Holds group number
L09DB:
        call    L0685                   ; Place char A to display location C (not changing existing bit 7)
        pop     psw
        ret

;--------------------------------------------------------------------------------------------------
;       If not in BITE, make NB LED display NB status
L09E0:
        lda     $ABEB                   ; in BITE mode if FF
        ora     a
        jnz     L09FC                   ; jump if $ABEB not zero
        lda     $A67C                   ; NB/mute status
        ani     $08
        lda     $ABB5                   ; Front panel LEDs
        jz      L09F7                   ; A has $ABB5 data, jump if b3 of $A67C clear
        ori     $08                     ; Set b3 of $ABB5
        jmp     L09F9
L09F7:
        ani     $F7
L09F9:
        sta     $ABB5                   ; Front panel LEDs
L09FC:
        mvi     a,$20
        sta     $AB95                   ; update display
        ret

;--------------------------------------------------------------------------------------------------
;       Sets bit 7 of display data byte C
;
L0A02:
        push    b
        push    h
        lxi     h,$AB96                 ;
        mvi     b,$00
        mov     a,c                     ;
        cpi     $0A                     ;
        jnc     L0A14                   ; jump if C >= $0A
        adi     $14
        jmp     L0A16
L0A14:
        sui     $0A
L0A16:                                  ;
        mov     c,a                     ; if C < $A, C=C+$14; else C=C-$A
        dad     b                       ; add BC to HL (B is zero)
        mvi     a,$80
        ora     m
        mov     m,a                     ; set bit 7 of ($AB96 + C)
        pop     h
        pop     b
        lda     $AB95
        cmp     c                       ; compare C with $AB95
        rnc                             ; return if $AB95 >= C
        mov     a,c
        sta     $AB95                   ; if $AB95 < C then $AB95 = C
        ret
;--------------------------------------------------------------------------------------------------
;       Clears bit 7 of display data byte C
;
L0A28:
        push    b
        push    h
        lxi     h,$AB96
        mvi     b,$00
        mov     a,c
        cpi     $0A
        jnc     L0A3A
        adi     $14
        jmp     L0A3C
L0A3A:
        sui     $0A
L0A3C:
        mov     c,a
        dad     b
        mvi     a,$7F
        ana     m
        mov     m,a
        pop     h
        pop     b
        lda     $AB95
        cmp     c
        rnc
        mov     a,c
        sta     $AB95
        ret
;--------------------------------------------------------------------------------------------------
;       Set $AB95 to $1F and clr b7 of all 30 display data bytes
;
L0A4E:
        push    h
        push    b
        lxi     h,$AB95         ;
        mvi     m,$1F                   ; set $AB95 to $1F
        inx     h                       ; HL = $AB96
        mvi     b,$1E
L0A58:
        mvi     a,$7F
        ana     m
        mov     m,a                     ; clear bit 7 of display data byte
        inx     h
        dcr     b
        jnz     L0A58                   ; do for 30 bytes from $AB96 to $ABB4
        pop     b
        pop     h
        ret
;--------------------------------------------------------------------------------------------------
;
;       Clear bit 7 of display frequency digits
L0A64:
        push    b
        mvi     b,$08
        lxi     h,$ABAC
L0A6A:
        mvi     a,$7F
        ana     m
        mov     m,a
        inx     h
        dcr     b
        jnz     L0A6A
        pop     b
        ret
;--------------------------------------------------------------------------------------------------
;       Clear bit 7 of display data bytes $15 and $16
L0A75:
        mvi     c,$01
        call    L0A28                   ; Clears bit 7 of display data byte $16
        dcr     c
        call    L0A28                   ; Clears bit 7 of display data byte $15
        ret
;--------------------------------------------------------------------------------------------------
;
L0A7F:  .DB     "CW  "
        .DB     "    "
        .DB     "AM  "
        .DB     "USB "
        .DB     "LSB "
        .DB     "ISB "
        .DB     "4SB "
        .DB     "    "
        .DB     "FM  "
        .DB     "FSK "

L0AA7:  .DB     "SLO "
        .DB     "FST "
        .DB     "MED "
        .DB     "EXT "
        .DB     "OFF "
        .DB     "DAT "
        .DB     "    "
        .DB     "OFF "

L0AC7:  .DB     "0.1 "
        .DB     "0.2 "
        .DB     "0.4 "
        .DB     "0.5 "
        .DB     "0.8 "
        .DB     "1.0 "
        .DB     "2.0 "
        .DB     "4.0 "
        .DB     "5.0 "
        .DB     "8.0 "
        .DB     "10. "
        .DB     "EX "

L0AF6:  .DB     "VN "
        .DB     " N "
        .DB     " M "
        .DB     " W "

;--------------------------------------------------------------------------------------------------
;       High level operations
L0B02:
        call    L0595                   ; Scan keyboard, place key code in $ABBB
        call    L0B3B                   ; Operations and commands processing
        lda     $A551                   ; mode & IF filter, new commanded rcv params
        ani     $0F
        cpi     $05
        jz      L0B17
        cpi     $06
        jnz     L0B2F
L0B17:
        in      $42                     ; 8255 Port C
        ani     $20                     ; meter board LSB switch
        mov     b,a
        lda     $ABC1                   ; only bit $20 used, helps detect meter bd LSB switch changes
        cmp     b                       ;
        jz      L0B2F
        mov     a,b
        sta     $ABC1                   ; only bit $20 used, helps detect meter bd LSB switch changes
        lda     $ABED
        ori     $10                     ; set Audio path and mode
        sta     $ABED                   ; Radio setting control, see L2D5B
L0B2F:
        lda     $ABD2                   ; Inc'd in main loop, controls sequencing
        rrc
        rc
        call    L2473                   ; Process tuning wheel movement
        call    L21D6                   ; Active scanning code
        ret
;--------------------------------------------------------------------------------------------------
;       Operations and commands processing
L0B3B:
        lda     $ABCB
        cpi     $0B
        jz      L52DD                   ; FSK option code
        lda     $ABBB                   ; Location of pressed key code
        cpi     $FF
        jz      L0BAF
        lda     $A56A                   ; tuning wheel movement output, 0=no movement
        cpi     $00
        jz      L0B5C
        lda     $ABBB                   ; Location of pressed key code
        cpi     $1E
        cz      L18E6                   ; Tune Enable key
        ret
L0B5C:
        lda     $A679                   ; Status bits
        ani     $80
        jnz     L0B9A                   ; jump if local control mode
        lda     $ABBB                   ; Location of pressed key code
        cpi     $10                     ; remote key?
        jnz     L0B8E
        sta     $ABBC
        lda     $ABB4
        ani     $F7                     ; remote off
        sta     $ABB4                   ; Front panel LEDs
        lda     $A679                   ; Status bits
        ori     $80
        sta     $A679                   ; Set to local control mode
        lda     $AB90                   ; Auto Stop Scan Threshold (FF=off)
        sta     $A67D
        call    L16A2                   ; Start receive mode
        stc
        cmc
        call    L3234                   ; Disconnect ant and mute audio if called with carry set
        ret
L0B8E:                                  ; not remote key
        ani     $7F
        cpi     $11
        rnz                             ; return if not enter key - this code shows radio ID and comm speed if enter key pressed
        sta     $ABBC                   ; ABBC gets $11
        call    L0CB2                   ; Process function buttons
        ret
L0B9A:
        lda     $ABBB                   ; Location of pressed key code
        rlc
        jc      L0BAB
        call    L0D38                   ; process pressed key
        lda     $ABBB                   ; Location of pressed key code
        sta     $ABBC
        ret
L0BAB:
        call    L0CB2                   ; Process function buttons
        ret
L0BAF:
        mvi     a,$64
        sta     $ABC2
        lda     $ABC6
        cpi     $FF
        jz      L0BC1
        lda     $ABBC
        ora     a
        rz
L0BC1:
        lda     $ABBC
        cpi     $1F
        jz      L0C86
        cpi     $18
        jc      L0C4F
        cpi     $1B
        jnc     L0C4F
        lda     $ABEB                   ; in BITE mode if FF
        cpi     $FF
        rz
        lda     $A575                   ; Actively scanning flag ($FF means actively scanning)
        cpi     $FF
        rz
        xra     a
        sta     $ABBC
        lda     $ABCB
        cpi     $0C
        jz      L0C07
        lxi     h,$A551                 ; mode & IF filter, new commanded rcv params
        lda     $A55F                   ; mode & IF filter, present params
        cmp     m
        jnz     L0C14
        inx     h
        lda     $A560                   ; AGC speed pointer, present params
        cmp     m
        jnz     L0C14
        lxi     h,$A556                 ; FSK shift & pol, new commanded rcv params
        lda     $A564                   ; FSK shift & pol, present params
        cmp     m
        jnz     L0C14
L0C07:
        mvi     b,$10
        mvi     c,$1D
L0C0B:
        call    L0A28                   ; Clears bit 7 of display data byte C
        dcr     c
        dcr     b
        jnz     L0C0B
        ret
L0C14:
        mvi     a,$FF
        sta     $ABF3
        lxi     h,$A55F                 ; mode & IF filter, present params
        call    L1858                   ; Store user filter choice for mode
        lda     $A551                   ; mode & IF filter, new commanded rcv params
        ani     $0F
        cmp     c
        jz      L0C48
        mov     a,c
        ora     a
        jz      L0C3D
        cpi     $07
        jnc     L0C48
        cpi     $03
        jc      L0C48
        lxi     h,$0000                 ; initial BFO setting for AM, USB, LSB, ISB
        jmp     L0C40
L0C3D:
        lxi     h,$0080                 ; CW BFO initial setting !
L0C40:
        shld    $A55D                   ; BFO settings, present params
        mvi     a,$FF
        sta     $ABF1
L0C48:
        call    L1E05                   ; Set radio where present <> new commanded params
        call    L186C                   ; Tuning wheel steering code
        ret
L0C4F:
        xra     a
        sta     $ABBC
        lxi     h,$ABC6
        cmp     m
        rz
        mvi     m,$00
        lda     $A679                   ; Status bits
        ani     $80
        jz      L0C72                   ; jump if remote control mode
        lda     $ABEB                   ; in BITE mode if FF
        cpi     $FF
        jz      L0C7B
        lda     $ABBD                   ; Numerical keypad applicability
        cpi     $04                     ; Channel #?
        jnc     L0C7B
L0C72:
        lda     $ABEC
        ori     $FE                     ; everything, but not now
        sta     $ABEC                   ; Display update control see L06FD
        ret
L0C7B:
        lxi     h,L1B57                 ; blanks
        mvi     b,$14
        mvi     c,$1D
        call    L0645                   ; clear display
        ret
L0C86:
        xra     a
        sta     $ABBC
        lda     $ABBD                   ; Numerical keypad applicability
        cpi     $04                     ; Channel #?
        rnc
        lda     $ABC3
        ora     a
        rnz
        lda     $ABEB                   ; in BITE mode if FF
        ora     a
        rnz
        mvi     c,$12
        call    L0A28                   ; Clears bit 7 of display data byte $8
        dcr     c
        call    L0A28                   ; Clears bit 7 of display data byte $7
        lda     $A580                   ; Scan Dwell pointer; $0B means external.
        mov     c,a
        mvi     b,$00
        lxi     h,L1ABF                 ; scan dwell values table
        dad     b
        mov     b,m                     ; put scan dwell value in B
        call    L22E2                   ; Scan dwell setting code
        ret
;--------------------------------------------------------------------------------------------------
;       Process function buttons
L0CB2:
        lda     $ABBB                   ; Location of pressed key code
        sui     $80
        mov     b,a
        cpi     $1F
        jz      L0CDD                   ; $1F is dwell button
        cpi     $1D
        jz      L0CD7                   ; $1D is tune rate button
        cpi     $18
        jc      L0CCC                   ; 
        cpi     $1B
        jc      L0CD7                   ; jump if BW, AGC speed, or mode button
L0CCC:
        lda     $ABC2
        dcr     a
        sta     $ABC2
        cz      L161E                   ; Stuck button & display radio ID, baud code
        ret
L0CD7:                                  ; tune rate, BW, AGC speed, or mode button pressed
        lda     $A575                   ; Actively scanning flag ($FF means actively scanning)
        cpi     $FF
        rz                              ; exit if actively scanning
L0CDD:
        lda     $ABC3
        ora     a
        rnz
        lda     $ABBD                   ; Numerical keypad applicability
        cpi     $04                     ;
        rnc                             ; return if 4 or above
        lda     $ABEB                   ; in BITE mode if FF
        ora     a
        rnz
        lxi     h,$ABBF
        dcr     m
        jz      L0D02
        mvi     a,$1F
        cmp     b
        rnz
        mvi     c,$12
        call    L0A02                   ; Sets bit 7 of display data byte $8
        dcr     c
        call    L0A02                   ; Sets bit 7 of display data byte $7
        ret
L0D02:
        mvi     m,$0C
        mov     a,b
        cpi     $19
        jnz     L0D0E
        call    L1714                   ; Mode key
        ret
L0D0E:
        cpi     $18
        jnz     L0D17
        call    L17D9                   ; BW key
        ret
L0D17:
        cpi     $1A
        jnz     L0D20
        call    L17FE                   ; AGC Speed key
        ret
L0D20:
        cpi     $1F
        jnz     L0D2F
        lda     $ABCB
        cpi     $0C
        rz
        call    L18A7                   ; Dwell key
        ret
L0D2F:
        cpi     $1D
        rnz
        mvi     m,$06
        call    L1901                   ; Tune Rate key
        ret

; key codes
;
;       00      0
;       01      1
;       02      2
;       03      3
;       04      4
;       05      5
;       06      6
;       07      7
;       08      8
;       09      9
;       0A
;       0B
;       0C      Prog
;       0D      Rcv
;       0E      Scan
;       0F      Test
;       10      Remote
;       11      Enter
;       12      Load
;       13      Recall
;       14      Chan
;       15      Frequency
;       16      BFO
;       17      Group
;       18      Bandwidth
;       19      Mode
;       1A      AGC speed
;       1B      AGC on/off
;       1C      Noise Blanker
;       1D      Tune Rate
;       1E      Tune Enable
;       1F      Dwell

;--------------------------------------------------------------------------------------------------
; process pressed key
L0D38:
        lda     $ABBB                           ; Location of pressed key code
        sui     $0A
        jc      L10D3                           ; jump if number key
        add     a
        mov     e,a
        mvi     d,$00
        lxi     h,L0D50
        dad     d
        mov     e,m
        inx     h
        mov     d,m
        rrc
        ani     $7F
        xchg
        pchl                    ;INFO: index jump  

;
L0D50:  .DW     L161C
        .DW     L161C
        .DW     L0D7C   ; Prog
        .DW     L0D7C   ; Rcv
        .DW     L0D7C   ; Scan
        .DW     L0D7C   ; Test
        .DW     L0D7C   ; Remote
        .DW     L12F4   ; Enter
        .DW     L12F4   ; Load
        .DW     L12F4   ; Recall
        .DW     L0EC7   ; Chan
        .DW     L0EC7   ; Freq
        .DW     L0EC7   ; BFO
        .DW     L15B9   ; Group
        .DW     L1280   ; BW
        .DW     L1280   ; Mode
        .DW     L1280   ; AGC speed
        .DW     L1529   ; AGC on/off
        .DW     L1922   ; Noise Blanker
        .DW     L1280   ; Tune Rate
        .DW     L18E6   ; Tune Enable
        .DW     L1280   ; Dwell

;--------------------------------------------------------------------------------------------------
;       Prog, Rcv, Scan, Test, Remote keys
;
L0D7C:
        lxi     h,$ABCB
        mov     a,m
        cpi     $0D
        jnz     L0D8C
        lda     $ABBB                   ; Location of pressed key code
        cmp     m
        cnz     L1FCE                   ; Move commanded block to created area
L0D8C:
        lda     $ABBB                   ; Location of pressed key code
        cpi     $10                     ; Remote key code
        jnz     L0DCB                   ; jump if not Remote command
;
;       Remote key
;
        lda     $A67E                   ; Comm port has been initialized flag
        cpi     $FF
        rnz                             ; return without action if comm port not initialized
        lda     $A679                   ; Status bits
        ani     $7F
        sta     $A679                   ; Set to remote control mode
        xra     a
        sta     $ABC3                   ; =0
        sta     $ABF4                   ; =0
        sta     $ABEB                   ; in BITE mode if FF
        cma
        sta     $ABBE                           ; =FF
        lda     $AB91                   ; Auto Stop Scan Threshold (FF=off)
        sta     $A67D
        call    L16A2                           ; Start receive mode
        lxi     h,$A80F                 ; RF gain via remote
        mov     a,m
        sta     $A67B                   ; RF atten
        di                              ; Disable Interrupts
        mov     m,a
        call    L2C6C                   ; RF gain setting code
        mvi     a,$FF
        sta     $ABEE                   ; =FF
        ret

;       Prog, Rcv, Scan, Test keys
;
L0DCB:
        mov     c,a
        lda     $ABCB
        cpi     $0C
        jnz     L0DD8
        cmp     c
        jz      L52DD                   ; FSK option code
L0DD8:
        mov     a,c
        mov     m,a
        cpi     $0E
        jz      L0DE7
        mvi     a,$FF
        sta     $ABEE
        call    L23B6                   ; Stopping scan, not due to received signal
L0DE7:
        call    L2725                   ; Disable Tuning wheel
        lda     $ABB4
        ani     $07
        sta     $ABB4                   ; Front panel LEDs
        lda     $ABB5
        ani     $0F                     ; Freq, chan, BFO, tune LEDs off
        sta     $ABB5                   ; Front panel LEDs
        xra     a
        sta     $ABEB                   ; in BITE mode if FF
        sta     $ABBD                   ; clear Numerical keypad applicability
        sta     $ABC3
        lxi     h,$0000
        shld    $ABF1
        shld    $ABF3
        mvi     a,$FF
        sta     $ABBE
        call    L0A4E                           ; Set $AB95 to $1F and clr b7 of all 30 display data bytes
        lda     $ABBB                           ; Location of pressed key code
        cpi     $0D                             ; Rcv key code
        jnz     L0E21                           ; jump if not Rcv command
;
;       Rcv key
;
        call    L16A2                           ; Start receive mode
        ret
;
;       Prog, Scan, Test keys
;
L0E21:
        cpi     $0C                             ; Prog key code
        jnz     L0E53                           ; jump if not Prog command
;
;       Prog key
;
        mvi     a,$03
        sta     $ABBD                   ; set Numerical keypad applicability to 'program'
        mvi     a,$01
        sta     $ABBE
        mvi     a,$FC
        sta     $A568                   ; Set tuning wheel sensitivity
        sta     $A569                   ; Set tuning wheel sensitivity
        mvi     a,$01
        sta     $A67A                   ; Radio state bits
        lda     $ABB4
        ori     $80                     ; prog
        sta     $ABB4                   ; Front panel LEDs
        lda     $ABB5
        ori     $40                     ; chan
        sta     $ABB5                   ; Front panel LEDs
        mvi     a,$FF                   ; everything
        sta     $ABEC                   ; Display update control see L06FD
        ret
;
;       Scan or Test keys
;
L0E53:
        cpi     $0E                     ; Scan key code
        jnz     L0E99                   ; jump if not Scan command
;
;       Scan key
;
        lda     $ABB4
        ori     $20
        sta     $ABB4                   ; scan
        lda     $ABEC
        ori     $01                     ; update now
        sta     $ABEC                   ; Display update control see L06FD
        lda     $ABEE
        ora     a
        jz      L0E87
        lxi     h,L1ACB                 ; 'GROUP OR CHAN SCAN ?'
        mvi     b,$14
        mvi     c,$1D
        call    L0645                   ; Display text message
        mvi     a,$FC
        sta     $A568                   ; Set tuning wheel sensitivity
        sta     $A569                   ; Set tuning wheel sensitivity
        mvi     a,$FF
        sta     $ABC3
        ret
L0E87:
        lda     $A575                   ; Actively scanning flag ($FF means actively scanning)
        ora     a
        jnz     L0E95
        call    L22B1                   ; High level scan code
        call    L23DA                   ; Init & start scan
        ret
L0E95:
        call    L23B6                   ; Stopping scan, not due to received signal
        ret

;--------------------------------------------------------------------------------------------------
;       Test key
;
L0E99:
        cpi     $0F
        cnz     L161C
        xra     a
        sta     $ABED                   ; Radio setting control, see L2D5B
        sta     $ABEC                   ; Display update control see L06FD
        mvi     a,$04
        sta     $A67A                   ; Radio state bits
        mvi     a,$FF
        sta     $ABEB                   ; in BITE mode if FF
        lda     $A682                   ; Status bits
        ori     $02
        ani     $FE
        sta     $A682                   ; Status bits
        call    L4968                   ; BITE routine
        lda     $A682                   ; Status bits
        ori     $04
        ani     $FD
        sta     $A682                   ; Status bits
        ret
;--------------------------------------------------------------------------------------------------
;
;       Chan, Freq, BFO keys
;
L0EC7:
        lda     $ABEB                   ; in BITE mode if FF
        ora     a
        rnz
        lda     $A575                           ; Actively scanning flag ($FF means actively scanning)
        cpi     $FF
        rz
        lda     $ABBD                   ; Numerical keypad applicability
        cpi     $09                     ; Auto Stop Scan
        jnz     L0EE3
        lda     $ABBB                           ; Location of pressed key code
        cpi     $16                             ; BFO key code
        rnz
        jmp     L19FE                   ; display Auto Stop threshold
L0EE3:
        cpi     $04
        rnc
        lda     $ABB5
        ani     $1F                     ; Freq, chan, BFO off
        sta     $ABB5                   ; Front panel LEDs
        lda     $ABEC
        ori     $01                     ; update now
        sta     $ABEC                   ; Display update control see L06FD
        xra     a
        sta     $A56A                           ; Reset tuning wheel movement output
        lxi     h,$ABBD                 ; Numerical keypad applicability
        lda     $ABBB                           ; Location of pressed key code
        cpi     $16                             ; BFO key code
        jnz     L101B                           ; jump if not BFO key
;
;       BFO key
;
        lda     $ABC3
        ora     a
        rnz
        lda     $A55F                   ; mode & IF filter, present params
        ani     $0F
        cpi     $08
        jz      L0F19
        cpi     $02
        jnz     L0F44
L0F19:
        mov     a,m
        cpi     $02
        jnz     L0F30
        lda     $ABB5
        ori     $80                     ; freq
        sta     $ABB5                   ; Front panel LEDs
        lda     $ABEC
        ori     $41                     ; freq, now
        sta     $ABEC                   ; Display update control see L06FD
        ret
L0F30:
        cpi     $03
        rnz
        lda     $ABB5
        ori     $40                     ; chan
        sta     $ABB5                   ; Front panel LEDs
        lda     $ABEC
        ori     $81                     ; chan, now
        sta     $ABEC                   ; Display update control see L06FD
        ret
L0F44:
        lda     $ABB5
        ori     $20                     ; BFO
        sta     $ABB5                   ; Front panel LEDs
        mvi     a,$01
        cmp     m
        jz      L0F74
        mov     m,a
        call    L186C                   ; Tuning wheel steering code
        mvi     a,$FF
        sta     $A568                   ; Set tuning wheel sensitivity
        sta     $A569                   ; Set tuning wheel sensitivity
        lda     $ABF1
        ora     a
        jnz     L0FCD
        mvi     c,$0E
        mvi     b,$05
L0F69:
        call    L0A28                   ; Clears bit 7 of display data byte C
        dcr     c
        dcr     b
        jnz     L0F69
        jmp     L0FCD
L0F74:
        lda     $A55F                   ; mode & IF filter, present params
        ani     $0F
        cpi     $09
        jz      L0FD6
        lhld    $A55D
        mov     a,h
        ora     l
        rz
        mov     a,h
        xri     $F0
        sta     $A55E
        ani     $F0
        mov     b,a
        lda     $ABBE
        ora     a
        jp      L0F99
        mvi     a,$02
        sta     $ABBE
L0F99:
        lda     $ABCB
        mov     e,a
        cpi     $0C
        jz      L0FC8
        lda     $ABF1
        ora     a
        jnz     L0FC8
        lda     $A55E
        sta     $A550                   ; BFO MSB & sign
        mvi     a,$0D
        cmp     e
        cz      L1FCE                   ; Move commanded block to created area
        mvi     a,$A0
        sta     $A566                   ; Channel
        sta     $A558                   ; Channel number displayed on front panel (=A0 if none)
        lda     $ABED
        ori     $20                     ; BFO
        sta     $ABED                   ; Radio setting control, see L2D5B
        jmp     L0FCD
L0FC8:
        mvi     c,$0D
        call    L0A02                   ; Sets bit 7 of display data byte $3
L0FCD:
        lda     $ABEC
        ori     $A1                     ; chan, BFO, now
        sta     $ABEC                   ; Display update control see L06FD
        ret
L0FD6:
        lda     $A563
        adi     $80
        sta     $A563
        lda     $ABCB
        mov     e,a
        cpi     $0C
        jz      L100D
        lda     $ABF1
        ora     a
        jnz     L100D
        lda     $A563
        sta     $A555                   ; FSK center freq
        mvi     a,$0D
        cmp     e
        cz      L1FCE                   ; Move commanded block to created area
        mvi     a,$A0
        sta     $A566                   ; Channel
        sta     $A558                   ; Channel number displayed on front panel (=A0 if none)
        lda     $ABED
        ori     $60                     ; Synth and BFO
        sta     $ABED                   ; Radio setting control, see L2D5B
        jmp     L1012
L100D:
        mvi     c,$0E
        call    L0A02                   ; Sets bit 7 of display data byte $4
L1012:
        lda     $ABEC
        ori     $A1                     ; chan, BFO, now
        sta     $ABEC                   ; Display update control see L06FD
        ret
;
;       Chan, Freq keys
;
L101B:
        cpi     $15                     ; Freq key code
        jnz     L1066                   ; jump if Chan key
;
;       Freq key
;
        lda     $ABC3
        ora     a
        rnz
        mvi     a,$02
        sta     $ABBD                   ; set Numerical keypad applicability to 'frequency'
        mvi     a,$07
        sta     $ABBE
        sta     $ABB6                   ; Digit to tune, Freq key sets to 10 MHz
        mvi     a,$FF
        sta     $A568                   ; Set tuning wheel sensitivity
        sta     $A569                   ; Set tuning wheel sensitivity
        lda     $ABB5
        ori     $80                     ; freq
        sta     $ABB5                   ; Front panel LEDs
        call    L0A64                   ; Clear bit 7 of display frequency digits
        lda     $ABCB
        cpi     $0C
        jz      L105D
        lhld    $A54B                   ; new commanded receiver params block beginning
        shld    $A559                   ; present receiver param block beginning
        lhld    $A54D
        shld    $A55B
        xra     a
        sta     $ABF2
L105D:
        lda     $ABEC
        ori     $41                     ; freq, now
        sta     $ABEC                   ; Display update control see L06FD
        ret
;
;       Chan key
;
L1066:
        cpi     $14
        cnz     L161C
        mvi     a,$FC
        sta     $A568                   ; Set tuning wheel sensitivity
        sta     $A569                   ; Set tuning wheel sensitivity
        lda     $ABC3
        ora     a
        jz      L10A3
        xra     a
        sta     $ABC3
        mvi     a,$02
        sta     $A67A                   ; Radio state bits
        lxi     h,L1ADF                 ; ' FIRST CHANNEL ?    '
        mvi     b,$14
        mvi     c,$1D
        call    L0645                   ; Display text message
        lda     $A57C                   ; Channel scanning lower bound
        sta     $ABC4                   ; Channel storage for use in group programming
        mvi     c,$0B
        call    L06EB                   ; Place BCD number in A in display positions C-1 and C
        mvi     a,$05
        sta     $ABBD                   ; set Numerical keypad applicability to 'first channel'
        mvi     a,$01
        sta     $ABBE
        ret
L10A3:
        mvi     a,$03
        sta     $ABBD                   ; set Numerical keypad applicability to 'program'
        mvi     a,$01
        sta     $ABBE
        lda     $ABB5
        ori     $40                     ; chan
        sta     $ABB5                   ; Front panel LEDs
        call    L0A75                   ; Clear bit 7 of display data bytes $15 and $16
        lda     $ABCB
        cpi     $0C
        jz      L10CA
        lda     $A558                   ; Channel number displayed on front panel (=A0 if none)
        sta     $A566                   ; Channel
        xra     a
        sta     $ABF4
L10CA:
        lda     $ABEC
        ori     $81                     ; chan, now
        sta     $ABEC                   ; Display update control see L06FD
        ret
;--------------------------------------------------------------------------------------------------
;       action jump for keypress
L10D3:
        lda     $ABEB                   ; in BITE mode if FF
        ora     a
        rnz
        lda     $ABC3
        ora     a
        rnz
        lda     $A575                           ; Actively scanning flag ($FF means actively scanning)
        ora     a
        rnz
        lda     $ABBE
        ora     a
        rm
        mov     c,a
        lda     $ABBD                   ; Numerical keypad applicability
        add     a
        mov     e,a
        mvi     d,$00
        lxi     h,L10F8                 ; *****
        dad     d
        mov     e,m
        inx     h
        mov     d,m
        xchg
        pchl                    ;lookup jump

L10F8:  .DW     L161C   ; 0       none            nop
        .DW     L110E   ; 1
        .DW     L118B   ; 2       Frequency
        .DW     L11B9   ; 3       Program
        .DW     L11DA   ; 4       Channel #
        .DW     L1231   ; 5       First Channel
        .DW     L1231   ; 6       Last Channel
        .DW     L124E   ; 7       Group
        .DW     L124E   ; 8       Group
        .DW     L161C   ; 9       Auto Stop Scan  nop
        .DW     L1262   ; A       Stop Threshold

;--------------------------------------------------------------------------------------------------
; p/o numerical keypad mode 1 processing (BFO?)
;
L110E:
        lda     $A55F                   ; mode & IF filter, present params
        ani     $0F
        cpi     $09
        jz      L1142
        lxi     h,$A55D
        lda     $ABBB                   ; Location of pressed key code
        call    L2839                   ; Keypress modifies mem nybble offset C from HL, data A
        mov     a,c
        adi     $0A
        mov     c,a
        call    L0A02                   ; Sets bit 7 of display data byte C
        lda     $ABBE
        dcr     a
        jp      L1131
        mvi     a,$02
L1131:
        sta     $ABBE
        lda     $ABEC
        ori     $20                     ; BFO
        sta     $ABEC                   ; Display update control see L06FD
        mvi     a,$FF
        sta     $ABF1
        ret
L1142:
        lxi     h,$A562
        lda     $ABBE
        cpi     $03
        jnz     L1164
        lda     $ABBB                   ; Location of pressed key code
        cpi     $04
        rnc
        mov     c,a
        lda     $A563
        ani     $80
        jz      L115E
        mvi     a,$08
L115E:
        ora     c
        mvi     c,$03
        jmp     L1167
L1164:
        lda     $ABBB                   ; Location of pressed key code
L1167:
        call    L2839                   ; Keypress modifies mem nybble offset C from HL, data A
        mov     a,c
        adi     $0A
        mov     c,a
        call    L0A02                   ; Sets bit 7 of display data byte C
        lda     $ABBE
        dcr     a
        jp      L117A
        mvi     a,$03
L117A:
        sta     $ABBE
        lda     $ABEC
        ori     $20                     ; BFO
        sta     $ABEC                   ; Display update control see L06FD
        mvi     a,$FF
        sta     $ABF1
        ret
;--------------------------------------------------------------------------------------------------
;       p/o numerical keypad frequency processing
L118B:
        mvi     a,$07
        cmp     c
        lda     $ABBB                           ; Location of pressed key code
        jnz     L1197
        cpi     $03
        rnc
L1197:
        lxi     h,$A559                 ; present receiver param block beginning
        call    L2839                   ; Keypress modifies mem nybble offset C from HL, data A
        mov     a,c
        adi     $02
        mov     c,a
        call    L0A02                   ; Sets bit 7 of display data byte C
        lda     $ABBE
        dcr     a
        sta     $ABBE
        lda     $ABEC
        ori     $40                     ; freq
        sta     $ABEC                   ; Display update control see L06FD
        mvi     a,$FF
        sta     $ABF2
        ret
;--------------------------------------------------------------------------------------------------
;       p/o numerical keypad program processing
L11B9:
        lxi     h,$A566                 ; Channel
        lda     $ABBB                   ; Location of pressed key code
        call    L2839                   ; Keypress modifies mem nybble offset C from HL, data A
        call    L0A02                   ; Sets bit 7 of display data byte C
        lda     $ABEC
        ori     $80                     ; chan
        sta     $ABEC                   ; Display update control see L06FD
        mvi     a,$FF
        sta     $ABF4
        lxi     h,$ABBE
        dcr     m
        rp
        mvi     m,$01
        ret
;--------------------------------------------------------------------------------------------------
;
L11DA:
        push    b
        lda     $A57A
        mov     c,a
        mvi     a,$EE
        call    L21AE                   ; Put channel A into spot with $EE in group C
        jnc     L1201
        lxi     h,L1B43                 ; '  GROUP   NOW FULL  '
        pop     b
        mvi     c,$1D
        mvi     b,$14
        call    L0645                   ; Display text message
        lxi     h,$A57A
        mvi     b,$01
        mvi     c,$15
        call    L0645                   ; Display text message
        xra     a
        sta     $ABBD                   ; clear Numerical keypad applicability
        ret
L1201:
        pop     b
        mvi     a,$01
        cmp     c
        jnz     L1214
        push    b
        lxi     h,L1B1B                 ; 'CHANNEL NUMBER?     '
        mvi     c,$1D
        mvi     b,$14
        call    L0645                   ; Display text message
        pop     b
L1214:
        lxi     h,$ABC4                 ; Channel storage for use in group programming
        lda     $ABBB                   ; Location of pressed key code
        call    L2839                   ; Keypress modifies mem nybble offset C from HL, data A
        mvi     c,$0D
        call    L06EB                   ; Place BCD number in A in display positions C-1 and C
        lxi     h,$ABBE
        mov     a,m
        adi     $0C
        mov     c,a
        call    L0A02                   ; Sets bit 7 of display data byte C
        dcr     m
        rp
        mvi     m,$01
        ret
;--------------------------------------------------------------------------------------------------
;       p/o numerical keypad first/last channel processing
L1231:
        lxi     h,$ABC4                 ; Channel storage for use in group programming
        lda     $ABBB                   ; Location of pressed key code
        call    L2839                   ; Keypress modifies mem nybble offset C from HL, data A
        mvi     c,$0B
        call    L06EB                   ; Place BCD number in A in display positions C-1 and C
        lxi     h,$ABBE
        mov     a,m
        adi     $0A
        mov     c,a
        call    L0A02                   ; Sets bit 7 of display data byte C
        dcr     m
        rp
        mvi     m,$01
        ret
;--------------------------------------------------------------------------------------------------
;       p/o numerical keypad group processing
L124E:
        lda     $ABBB                   ; Location of pressed key code
        lxi     h,$ABC4                 ; Channel storage for use in group programming
        mov     m,a
        mvi     b,$01
        mvi     c,$0B
        call    L0645                   ; Display text message
        mvi     c,$0B
        call    L0A02                   ; Sets bit 7 of display data byte 1
        ret
;--------------------------------------------------------------------------------------------------
;       p/o numerical keypad stop threshold processing
L1262:
        lxi     h,$AB8F
        lda     $ABBB                   ; Location of pressed key code
        call    L2839                   ; Keypress modifies mem nybble offset C from HL, data A
        lda     $ABBE
        dcr     a
        jp      L1274
        mvi     a,$01
L1274:
        sta     $ABBE
        lda     $ABEC
        ori     $20                     ; BFO
        sta     $ABEC                   ; Display update control see L06FD
        ret
;--------------------------------------------------------------------------------------------------
;
;       BW, Mode, AGC speed, Dwell, Tune Rate keys
;
L1280:
        lda     $ABC3
        ora     a
        rnz
        lda     $ABBD                   ; Numerical keypad applicability
        cpi     $04
        rnc                             ; return if 4 or above
        lda     $ABEB                   ; in BITE mode if FF
        ora     a
        rnz
        lda     $ABBB                           ; Location of pressed key code
        cpi     $1F                             ; Dwell key code
        jz      L129E
        lda     $A575                           ; Actively scanning flag ($FF means actively scanning)
        cpi     $FF
        rz
L129E:
        mvi     a,$18
        sta     $ABBF
        mvi     b,$0E
        mvi     c,$1D
L12A7:
        call    L0A28                   ; Clears bit 7 of display data byte C
        dcr     c
        dcr     b
        jnz     L12A7
        lda     $ABBB                   ; Location of pressed key code
        cpi     $19                     ; Mode key code
        jnz     L12BB
;
;       Mode key
;
        call    L1714                   ; Mode key
        ret
;
;       BW, AGC speed, Dwell, Tune Rate keys
;
L12BB:
        cpi     $18                     ; BW key code
        jnz     L12C4
;
;       BW key
;
        call    L17D9                   ; BW key
        ret
;
;       AGC speed, Dwell, Tune Rate keys
;
L12C4:
        cpi     $1A                     ; AGC Speed key code
        jnz     L12D9
;
;       AGC Speed key
;
        mvi     c,$1D
        mvi     b,$03
L12CD:
        call    L0A02                   ; Sets bit 7 of display data byte C
        dcr     c
        dcr     b
        jnz     L12CD
        call    L17FE                   ; AGC Speed key
        ret
;
;       Dwell, Tune Rate keys
;
L12D9:
        cpi     $1F                     ; Dwell key code
        jnz     L12E8
;
;       Dwell key
;
        lda     $ABCB
        cpi     $0C
        rz
        call    L18A7                   ; Dwell key
        ret
;
;       Tune Rate key
;
L12E8:
        cpi     $1D
        rnz
        mvi     a,$0C
        sta     $ABBF
        call    L1901                   ; Tune Rate key
        ret
;--------------------------------------------------------------------------------------------------
;
;       Enter, Load, Recall keys
;
L12F4:
        lda     $A575                           ; Actively scanning flag ($FF means actively scanning)
        ora     a
        rnz                     ; A575 must be 0
        lda     $ABEB                   ; in BITE mode if FF
        ora     a
        rnz                     ; ABEB must be 0
        lda     $ABC3
        ora     a
        rnz                     ; ABC3 must be 0
        call    L0A4E           ; Set $AB95 to $1F and clr b7 of all 30 display data bytes
        lda     $ABBD                   ; Numerical keypad applicability
        mov     b,a
        call    L186C                   ; Tuning wheel steering code
        lda     $ABBB           ; Location of pressed key code
        cpi     $11             ; 'Enter' key code
        jnz     L1339
;
;       Enter key
;
        mov     a,b
        add     a
        mov     e,a
        mvi     d,$00
        lxi     h,L1323                 ; *****
        dad     d
        mov     e,m
        inx     h
        mov     d,m
        xchg
        pchl                     ;lookup jump based on value from $ABBD
;
L1323:  .DW     L161C   ; 0       none
        .DW     L1403   ; 1       
        .DW     L1403   ; 2       Frequency
        .DW     L1403   ; 3       Program
        .DW     L140C   ; 4       Channel #
        .DW     L1416   ; 5       First Channel
        .DW     L145C   ; 6       Last Channel
        .DW     L1494   ; 7       Group
        .DW     L14D8   ; 8       Group
        .DW     L197A   ; 9       Auto Stop Scan
        .DW     L19CB   ; A       Stop Threshold
;--------------------------------------------------------------------------------------------------
;
;       Load, Recall keys
;
L1339:
        cpi     $12                     ; Load key code
        jnz     L13D2
;
;       Load key
;
        mov     a,b
        cpi     $05
        rnc
        lda     $ABCB
        cpi     $0D
        jz      L134F
        cpi     $0E
        jnz     L1368
L134F:
        call    L1F6B                   ; Part of setting up receiver, incl data from commanded to present block
        lxi     d,$A566                 ; Channel
        ldax    d
        mov     c,a
        mvi     a,$A0
        stax    d
        call    L1CFB                   ; Store present receive params to channel memory loc spec in $A566
        mov     a,c
        stax    d
        lda     $ABEC
        ori     $80                     ; chan
        sta     $ABEC                   ; Display update control see L06FD
        ret
L1368:
        mov     a,b
        cpi     $04
        jz      L1392
        call    L1CFB                   ; Store present receive params to channel memory loc spec in $A566
        jz      L1389
        lda     $A566                   ; Channel
        lxi     h,$A549                 ; locally generated channel number going to commanded
        cmp     m
        jnz     L1380
        mvi     m,$A0
L1380:
        lxi     h,$A54A                 ; remotely generated channel number going to commanded
        cmp     m
        jnz     L1389
        mvi     m,$A0
L1389:
        lda     $ABEC
        ori     $80                     ; chan
        sta     $ABEC                   ; Display update control see L06FD
        ret
L1392:
        lda     $A57A
        mov     c,a
        lda     $ABC4                   ; Channel storage for use in group programming
        mov     e,a
        ani     $F0
        cpi     $A0
        rnc
        mov     a,e
        call    L21AE                   ; Put channel A into spot with $EE in group C
        jnc     L13BF
        lxi     h,L1B43                 ; '  GROUP   NOW FULL  '
        mvi     c,$1D
        mvi     b,$14
        call    L0645                           ; Display text message
        lxi     h,$A57A
        mvi     b,$01
        mvi     c,$15
        call    L0645                           ; Display text message
        xra     a
        sta     $ABBD                   ; clear Numerical keypad applicability
        ret
L13BF:
        mvi     c,$0D
        call    L0A28                   ; Clears bit 7 of display data byte 3
        dcr     c
        call    L0A28                   ; Clears bit 7 of display data byte 2
        dcr     c
        lxi     h,L1B6B                 ; "OK"
        mvi     b,$02
        call    L0645                           ; Display text message
        ret
;--------------------------------------------------------------------------------------------------
;
;       Recall key
;
L13D2:
        cpi     $13
        cnz     L161C
        mov     a,b
        cpi     $04
        rnc
        lda     $ABCB
        cpi     $0C
        jnz     L13EB
        lda     $A566                   ; Channel
        mov     b,a
        call    L1CE6                   ; Recall channel B to receiver and place B in $A566
        ret
L13EB:
        cpi     $0D
        jz      L13F5
        cpi     $0E
        cnz     L161C
L13F5:
        mvi     b,$A0
        call    L1D0F                   ; Set radio to BCD chan # in B
        lda     $ABCB
        cpi     $0D
        call    L1FCE                   ; Move commanded block to created area
        ret
;--------------------------------------------------------------------------------------------------
;       frequency channel #, and program Enter key code
L1403:
        lda     $ABCB
        cpi     $0C
        cnz     L1E05                   ; Set radio where present <> new commanded params
        ret
;--------------------------------------------------------------------------------------------------
;       Clear bit 7 of display bytes 3 & 2
L140C:
        mvi     c,$0D
        call    L0A28                   ; Clears bit 7 of display data byte 3
        dcr     c
        call    L0A28                   ; Clears bit 7 of display data byte 2
        ret
;--------------------------------------------------------------------------------------------------
;       first channel enter key code
L1416:
        lda     $ABC4                   ; Channel storage for use in group programming
        cpi     $99
        jnz     L1429
        lxi     h,L1ADF                 ; ' FIRST CHANNEL ?    '
        mvi     b,$14
        mvi     c,$1D
        call    L0645                           ; Display text message
        ret
L1429:
        sta     $A57C                   ; Channel scanning lower bound
        push    psw
        lxi     h,L1AF3                 ; ' LAST CHANNEL  ?    '
        mvi     b,$14
        mvi     c,$1D
        call    L0645                           ; Display text message
        lda     $A57D                   ; Channel scanning upper bound
        mov     b,a
        pop     psw
        cmp     b
        jc      L144D
        inr     a
        mov     b,a
        ani     $0F
        cpi     $0A
        jnz     L144D
        mov     a,b
        adi     $06
        mov     b,a
L144D:
        mov     a,b
        sta     $ABC4                   ; Channel storage for use in group programming
        mvi     c,$0B
        call    L06EB                   ; Place BCD number in A in display positions C-1 and C
        mvi     a,$06
        sta     $ABBD                   ; set Numerical keypad applicability to 'last channel'
        ret
;--------------------------------------------------------------------------------------------------
;       last channel Enter key code
L145C:
        lda     $A57C                   ; Channel scanning lower bound
        mov     b,a
        lda     $ABC4                   ; Channel storage for use in group programming
        cmp     b
        jc      L146A
        jnz     L1485
L146A:
        lxi     h,L1ADF                 ; ' FIRST CHANNEL ?    '
        mvi     b,$14
        mvi     c,$1D
        call    L0645                           ; Display text message
        lda     $A57C                   ; Channel scanning lower bound
        sta     $ABC4                   ; Channel storage for use in group programming
        mvi     c,$0B
        call    L06EB                   ; Place BCD number in A in display positions C-1 and C
        mvi     a,$05
        sta     $ABBD                   ; set Numerical keypad applicability to 'first channel'
        ret
L1485:
        sta     $A57D                   ; Channel scanning upper bound
        mov     a,b
        sta     $A582                   ; Scan channel
        mvi     a,$43
        sta     $A57B                   ; Channel or group scan.  43=channel, 47=group
        jmp     L19E4                   ; Display Auto Stop Scan on/off status
;--------------------------------------------------------------------------------------------------
;       group mode 7 Enter key code
L1494:
        lda     $ABCB
        cpi     $0C
        rnz
        lda     $ABC4                   ; Channel storage for use in group programming
        cpi     $0A
        jc      L14B2
        lxi     h,L1B07                 ; ' GROUP NUMBER ?     '
        mvi     c,$1D
        mvi     b,$14
        call    L0645                           ; Display text message
        mvi     a,$00
        sta     $ABBE
        ret
L14B2:
        sta     $A57A
        mov     c,a
        call    L20E9                   ; Calc address of beginning of group C memory area (returned in HL)
        mvi     a,$EE
        mvi     c,$14
L14BD:
        mov     m,a
        inx     h
        dcr     c
        jnz     L14BD
        lxi     h,L1B1B                 ; 'CHANNEL NUMBER?     '
        mvi     c,$1D
        mvi     b,$14
        call    L0645                           ; Display text message
        mvi     a,$F0
        sta     $ABC4                   ; Channel storage for use in group programming
        mvi     a,$04
        sta     $ABBD                   ; set Numerical keypad applicability to 'channel #'
        ret
;--------------------------------------------------------------------------------------------------
;       group mode 8 Enter key code
L14D8:
        lda     $ABCB
        cpi     $0E
        rnz
        lda     $ABC4                   ; Channel storage for use in group programming
        mov     c,a
        call    L2109                   ; Utility setup code for group (called with group # in C)
        jnc     L1507
        lxi     h,L1B2F                 ; '  ANOTHER GROUP ?   '
        mvi     c,$1D
        mvi     b,$14
        call    L0645                           ; Display text message
        lxi     h,$ABC4                 ; Channel storage for use in group programming
        mvi     b,$01
        mvi     c,$0B
        call    L0645                           ; Display text message
        mvi     a,$08
        sta     $ABBD                   ; set Numerical keypad applicability to 'Group'
        mvi     a,$00
        sta     $ABBE
        ret
L1507:
        lda     $ABC4                   ; Channel storage for use in group programming
        sta     $A579                   ; Holds group number
        xra     a
        sta     $ABEE
        lhld    $A665                   ; Pointer for member of group
        mvi     a,$99
L1516:
        mov     b,m
        cmp     b
        jnc     L151F
        inx     h
        jmp     L1516
L151F:
        shld    $A665                   ; Pointer for member of group
        mov     a,b
        sta     $A582                   ; Scan channel
        jmp     L19E4                   ; Display Auto Stop Scan on/off status
;--------------------------------------------------------------------------------------------------
;       AGC on/off key
;
L1529:
        lda     $ABC3
        ora     a
        rnz
        lda     $A575                           ; Actively scanning flag ($FF means actively scanning)
        ora     a
        rnz
        lda     $ABBD                   ; Numerical keypad applicability
        cpi     $04
        rnc                             ; return if 4 or higher
        lda     $ABEB                   ; in BITE mode if FF
        ora     a
        rnz

        lda     $A55F                   ; mode & IF filter, present params
        ani     $0F
        cpi     $09
        jz      L1594
        lxi     h,$A560                 ; AGC speed pointer, present params
        mov     a,m
        cpi     $07
        jnz     L1571
        lda     $ABCC
        cpi     $05
        jnz     L156D
        lda     $A55F                   ; mode & IF filter, present params
        ani     $0F
        cpi     $03
        jc      L156B
        cpi     $07
        lda     $ABCC
        jc      L156D
L156B:
        mvi     a,$01
L156D:
        mov     m,a
        jmp     L1577
L1571:
        mov     a,m
        sta     $ABCC
        mvi     m,$07
L1577:
        lda     $ABCB
        cpi     $0C
        jz      L1588
        mvi     a,$FF
        sta     $ABF3
        call    L1E05                   ; Set radio where present <> new commanded params
        ret
L1588:
        lda     $ABEC
        ori     $04                     ; AGC
        sta     $ABEC                   ; Display update control see L06FD
        call    L186C                   ; Tuning wheel steering code
        ret
L1594:
        lda     $A564
        adi     $80
        sta     $A564
        lda     $ABCB
        cpi     $0C
        jz      L15AD
        mvi     a,$FF
        sta     $ABF3
        call    L1E05                   ; Set radio where present <> new commanded params
        ret
L15AD:
        lda     $ABEC
        ori     $04                     ; AGC
        sta     $ABEC                   ; Display update control see L06FD
        call    L186C                   ; Tuning wheel steering code
        ret
;--------------------------------------------------------------------------------------------------
;
;       Group key
;
L15B9:
        lda     $ABEB                   ; in BITE mode if FF
        ora     a
        rnz
        lda     $ABCB
        cpi     $0E
        jnz     L15E0
        lda     $A575                           ; Actively scanning flag ($FF means actively scanning)
        ora     a
        rnz
        lxi     h,$ABC3
        mov     a,m
        ora     a
        rz
        mvi     m,$00
        mvi     a,$03
        sta     $A67A                   ; Radio state bits
        mvi     a,$08
        sta     $ABBD                   ; set Numerical keypad applicability to 'group'
        jmp     L15F0
L15E0:
        lda     $ABCB
        cpi     $0C
        rnz
        mvi     a,$07
        sta     $ABBD                   ; set Numerical keypad applicability to 'group'
        mvi     a,$FF
        sta     $ABC4                   ; Channel storage for use in group programming
L15F0:
        lda     $ABB5
        ani     $1F                     ; freq, chan, BFO off
        sta     $ABB5                   ; Front panel LEDs
        lxi     h,L1B07                 ; ' GROUP NUMBER ?     '
        mvi     c,$1D
        mvi     b,$14
        call    L0645                           ; Display text message
        mvi     a,$00
        sta     $ABBE
        lda     $ABCB
        cpi     $0E
        rnz
        lxi     h,$A579                 ; Holds group number
        mov     a,m
        sta     $ABC4                   ; Channel storage for use in group programming
        mvi     b,$01
        mvi     c,$0B
        call    L0645                           ; Display text message
        ret
;
L161C:
        pop     h
        ret
;--------------------------------------------------------------------------------------------------                                
;       Stuck button & display radio ID, baud code
L161E:
        mvi     a,$FF
        sta     $ABC6
        lxi     h,L1B96                 ; '        BUTTON STUCK'
        mvi     b,$14
        mvi     c,$1D
        call    L0645                           ; Display text message
        lda     $ABBB                           ; Location of pressed key code
        ani     $7F
        mov     c,a
        lda     $A679                   ; Status bits
        ani     $80
        jnz     L1641                   ; jump if local control mode
        mvi     a,$11
        cmp     c
        jz      L1658
L1641:
        mov     a,c
        add     a
        add     a
        mov     c,a
        rrc
        ani     $7F
        add     c
        mov     c,a
        mvi     b,$00
        lxi     h,L1BAA                 ; Start of key names
        dad     b
        mvi     b,$06
        mvi     c,$1D
        call    L0645                           ; Display text message
        ret
L1658:
        mvi     b,$14
        mvi     c,$1D
        lxi     h,L1C6A                 ; Remote chan and link speed message
        call    L0645                           ; Display text message
        lda     $AC3B                   ; Radio ID
        mov     c,a
        call    L27DC                   ; Converts C to tens & ones BCD (99=>10011001 and 255=>01010101) in A (B has hundreds)
        mov     c,a
        ani     $0F
        adi     $10
        sta     $AB9F
        mov     a,c
        rlc
        rlc
        rlc
        rlc
        ani     $0F
        adi     $10
        sta     $ABA0
        mov     a,b
        ani     $0F
        jz      L1688
        adi     $10
        sta     $ABA1
L1688:
        call    L3AF2                   ; Get BAUD rate select switch data into low nybble of A
        add     a
        add     a
        mov     c,a
        mvi     b,$00
        lxi     h,L1C7E
        dad     b
        mvi     b,$04
        mvi     c,$11
        cpi     $3C
        jnz     L169E
        inr     b
L169E:
        call    L0645                           ; Display text message
        ret
;--------------------------------------------------------------------------------------------------
;       Start receive mode
;
L16A2:
        ora     a
        call    L3234                   ; Disconnect ant and mute audio if called with carry set
        mvi     a,$0D
        sta     $ABCB           ; $ABCB = $0D
        mvi     a,$01
        sta     $A67A                   ; Radio state bits
        mvi     a,$02
        sta     $ABBD           ; set Numerical keypad applicability to 'frequency'
        mvi     a,$07
        sta     $ABBE
        sta     $ABB6                   ; Digit to tune, set here to 10 MHz
        mvi     a,$FF
        sta     $A568                   ; Set tuning wheel sensitivity
        sta     $A569                   ; Set tuning wheel sensitivity
        call    L23B6                   ; Stopping scan, not due to received signal
        xra     a
        sta     $ABEB                   ; in BITE mode if FF
        call    L1FA6                   ; Move created receiver params to commanded block
        lda     $ABB4
        ani     $01                     ; fault
        sta     $ABB4                   ; Front panel LEDs
        lda     $ABB5
        ani     $08                     ; All except NB off
        sta     $ABB5                   ; Front panel LEDs
        lda     $A679                   ; Status bits
        ani     $80
        jz      L1703                   ; jump if remote control mode
        lda     $ABB4
        ori     $40                     ; receive
        sta     $ABB4                   ; Front panel LEDs
        lda     $ABB5
        ori     $80                     ; freq
        sta     $ABB5                   ; Front panel LEDs
        lda     $ABEC
        ori     $01                     ; update now
        sta     $ABEC                   ; Display update control see L06FD
        call    L2748                   ; Enable Tuning wheel
        ret
L1703:
        lda     $ABB4
        ori     $48                     ; receive, remote
        sta     $ABB4                   ; Front panel LEDs
        lda     $ABEC
        ori     $01                     ; update now
        sta     $ABEC                   ; Display update control see L06FD
        ret
;--------------------------------------------------------------------------------------------------
;
;       Mode key
;
L1714:
        push    b
        mvi     c,$19
        mvi     b,$06
L1719:
        call    L0A02                   ; Sets bit 7 of display data byte C
        dcr     c
        dcr     b
        jnz     L1719
L1721:
        lxi     h,$A55F                 ; mode in low 4 bits
        mov     a,m
        ani     $0F
        inr     a                       ; incr it
        mov     b,a
        cpi     $06                     ; 4ISB?
        jnz     L1741
        lda     $A818                   ; 4ISB option flag, zero for no 4ISB
        cpi     $FF
        jnz     L1763
        lda     $ABC5                   ; 2ISB option installed flag (0=not installed, FF=installed)
        cpi     $FF
        jz      L1764
        jnz     L1763
L1741:
        cpi     $09                     ; FSK?
        jnz     L1764
        lda     $A825                   ; FSK option installed flag. Zero if not installed
        ora     a
        jz      L1763
        lda     $A560                   ; AGC speed pointer, present params
        sta     $A841
        mvi     a,$06
        sta     $A560                   ; AGC speed pointer, present params
        lda     $ABEC
        ori     $04                     ; AGC
        sta     $ABEC                   ; Display update control see L06FD
        jmp     L1764
L1763:
        inr     b                       ; if, after incr, mode is not supported, incr it again
L1764:
        mov     a,b
        cpi     $0A
        jc      L176B
        xra     a                       ; loop around to 0 again if it gets above 9
L176B:
        mov     b,a                     ; B is new mode number
        mvi     a,$F0                   ; high 4 bits are filter number
        ana     m
        ora     b
        mov     m,a                     ; write new mode/filter byte back to memory
        mov     c,b
        mvi     b,$00
        lxi     h,$A66F                 ; stored user filter choice area
        dad     b                       ; HL = HL + BC (BC is the new mode)
        mov     a,m                     ; get whatever this is from RAM
        cpi     $0F
        jnc     L1721                   ;
        lxi     h,$A55F                 ; points to mode/filter byte
        add     a
        add     a
        add     a
        add     a
        mov     b,a
        mov     a,m
        ani     $0F
        ora     b
        mov     m,a                     ; write new mode/filter byte back to memory
        lda     $ABEC
        ori     $18                     ; mode, filt
        sta     $ABEC                   ; Display update control see L06FD
        lda     $A560                   ; AGC speed pointer, present params
        cpi     $06
        jnz     L17B3
        lda     $A55F                   ; mode & IF filter, present params
        ani     $0F
        cpi     $09
        jz      L17D7
        lda     $A841
        sta     $A560                   ; AGC speed pointer, present params
        lda     $ABEC
        ori     $04                     ; AGC
        sta     $ABEC                   ; Display update control see L06FD
L17B3:
        lda     $A560                   ; AGC speed pointer, present params
        cpi     $05
        jnz     L17D7
        lda     $A55F                   ; mode & IF filter, present params
        ani     $0F
        cpi     $03
        jc      L17CA
        cpi     $07
        jc      L17D7
L17CA:
        mvi     a,$01
        sta     $A560                   ; AGC speed pointer, present params
        lda     $ABEC
        ori     $04                     ; AGC
        sta     $ABEC                   ; Display update control see L06FD
L17D7:
        pop     b
        ret
;--------------------------------------------------------------------------------------------------
;
;       BW key
;
L17D9:
        mvi     c,$15
        mvi     b,$03
L17DD:
        call    L0A02                   ; Sets bit 7 of display data byte C
        dcr     c
        dcr     b
        jnz     L17DD
        lxi     h,$A55F                 ; mode & IF filter, present params
        mov     a,m
        rrc
        rrc
        rrc
        rrc
        ani     $0F
        mov     c,a
        mov     b,m
        call    L1A34                   ; Find next filter supporting mode, mode B, current filter C, returns with B
        mov     m,b
        lda     $ABEC
        ori     $08                     ; filt
        sta     $ABEC                   ; Display update control see L06FD
        ret
;--------------------------------------------------------------------------------------------------
;       AGC Speed key
;
L17FE:
        lda     $A55F                   ; mode & IF filter, present params
        ani     $0F
        cpi     $09
        jnz     L181C
        push    b
        lxi     h,$A564
        mov     a,m
        mov     b,a
        ani     $03
        inr     a
        ani     $03
        mov     c,a
        mov     a,b
        ani     $FC
        ora     c
        pop     b
        jmp     L184E
L181C:
        lxi     h,$A560                 ; AGC speed pointer, present params
        mov     a,m
        cpi     $07
        jnz     L1830
        lda     $ABCC
        cpi     $05
        jz      L1839
        jmp     L184E
L1830:
        inr     a
        cpi     $03
        jc      L184E
        jnz     L184D
L1839:
        lda     $A55F                   ; mode & IF filter, present params
        ani     $0F
        cpi     $03
        jc      L184D
        cpi     $07
        jnc     L184D
        mvi     a,$05
        jmp     L184E
L184D:
        xra     a
L184E:
        mov     m,a
        lda     $ABEC
        ori     $04                     ; AGC
        sta     $ABEC                   ; Display update control see L06FD
        ret
;--------------------------------------------------------------------------------------------------
;       Store user filter choice for mode
;
;       Place high nybble of [HL] into low nybble of ($A66F + low nybble of [HL])
L1858:
        mov     e,m
        mvi     a,$0F
        ana     e
        mov     c,a
        mvi     b,$00
        lxi     h,$A66F                 ; stored user filter choice area
        dad     b
        mvi     a,$F0
        ana     e
        rlc
        rlc
        rlc
        rlc
        mov     m,a
        ret
;--------------------------------------------------------------------------------------------------
;       Tuning wheel steering code
L186C:
        lda     $ABBD                   ; Numerical keypad applicability
        ora     a
        rz                              ; return if none
        cpi     $01
        jnz     L188A
        lda     $A55F                   ; mode & IF filter, present params
        ani     $0F
        cpi     $09
        jnz     L1885
        mvi     a,$03
        jmp     L18A3
L1885:
        mvi     a,$02
        jmp     L18A3
L188A:
        cpi     $02
        jnz     L1895
        lda     $ABB6                   ; Digit to tune
        jmp     L18A3
L1895:
        cpi     $0A
        jnz     L189F
        mvi     a,$01
        jmp     L18A3
L189F:
        cpi     $03
        mvi     a,$01
L18A3:
        sta     $ABBE
        ret
;--------------------------------------------------------------------------------------------------
;       Dwell key
;
L18A7:
        mvi     c,$12
        call    L0A02                   ; Sets bit 7 of display data byte $8
        dcr     c
        call    L0A02                   ; Sets bit 7 of display data byte $7
        lxi     h,$ABC0
        mov     a,m
        ora     a
        lda     $A580                   ; Scan Dwell pointer; $0B means external.
        jz      L18CD
        dcr     a
        jm      L18C6
        jnz     L18DA
        mov     m,a
        jmp     L18DA
L18C6:
        mvi     m,$00
        mvi     a,$01
        jmp     L18DA
L18CD:
        inr     a
        cpi     $0B
        jz      L18D8
        jc      L18DA
        mvi     a,$0A
L18D8:
        mvi     m,$FF
L18DA:
        sta     $A580                   ; Scan Dwell pointer; $0B means external.
        lda     $ABEC
        ori     $02                     ; dwell
        sta     $ABEC                   ; Display update control see L06FD
        ret
;--------------------------------------------------------------------------------------------------
;       Tune Enable key
;
L18E6:
        lda     $ABEB                   ; in BITE mode if FF
        ora     a
        rnz                             ; exit if in BITE mode
        lda     $ABC3
        ora     a
        rnz
        lda     $ABBD                   ; Numerical keypad applicability
        cpi     $04
        rnc                             ; return if 4 or above
        lda     $A567                   ; Tuning wheel enabled flag (FF if enabled)
        ora     a
        cz      L2748                   ; if disabled, go enable
        cnz     L2725                   ; if enabled, go disable
        ret
;--------------------------------------------------------------------------------------------------
;       Tune Rate key
;
L1901:
        lda     $ABBD                   ; Numerical keypad applicability
        cpi     $02                     ; frequency
        rnz
        lda     $ABB6                   ; Digit to tune
        dcr     a
        sta     $ABB6                   ; Digit to tune
        jp      L1916
        mvi     a,$07
        sta     $ABB6                   ; Digit to tune
L1916:
        sta     $ABBE
        lda     $ABEC
        ori     $40                     ; freq
        sta     $ABEC                   ; Display update control see L06FD
        ret
;--------------------------------------------------------------------------------------------------
;       Noise Blanker key
;
L1922:
        lda     $ABC3
        ora     a
        rnz
        lda     $ABEB                   ; in BITE mode if FF
        ora     a
        rnz                             ; $ABC3, $ABEB must be zero to proceed 
        lda     $ABBD                   ; Numerical keypad applicability
        cpi     $04
        rnc                             ; return if 4 or higher
        lda     $ABCB
        cpi     $0C
        rz                              ; $ABCB must not be $0C
        lda     $A67C                   ; NB/mute status
        rrc
        rrc
        rrc
        rrc
        cmc                             ; SWAB, carry = not bit 3
        call    L1944                   ; Noise Blanker = not(carry)
        ret
;--------------------------------------------------------------------------------------------------
;       Noise Blanker = not(carry)
;
L1944:
        lda     $A67C                   ; NB/mute status
        jc      L195E                   ; jump if bit 3 clear
        ani     $F7
        sta     $A67C                   ; clear bit 3 and save back
        lda     $ABB5
        ani     $F7                     ; NB off
        sta     $ABB5                   ; Front panel LEDs
        in      $40                     ; 8255 Port A
        ani     $7F                     ; bit 8 is Noise Blank line, clear it
        jmp     L196F
L195E:
        ori     $08                     ; set bit 3
        sta     $A67C                   ; save byte back
        lda     $ABB5
        ori     $08                     ; NB on
        sta     $ABB5                   ; Front panel LEDs
        in      $40                     ; 8255 Port A
        ori     $80                     ; Set Noise Blank signal line
L196F:
        out     $40                     ; 8255 Port A
        lda     $ABEC
        ori     $01                     ; update now
        sta     $ABEC                   ; Display update control see L06FD
        ret
;--------------------------------------------------------------------------------------------------
;       auto stop scan Enter key code
L197A:
        lda     $AB90                   ; Auto Stop Scan Threshold (FF=off)
        cpi     $FF
        jnz     L1997
        xra     a
        sta     $ABEE
        sta     $ABBD                   ; clear Numerical keypad applicability
        call    L2725                   ; Disable Tuning wheel
        lda     $A582                   ; Scan channel
        mov     b,a
        call    L1D0F                   ; Set radio to BCD chan # in B
        call    L23DA                   ; Init & start scan
        ret
L1997:
        mvi     a,$0A
        sta     $ABBD                   ; set Numerical keypad applicability to 'stop threshold'
        lxi     h,L1B84                 ; '  STOP THRESHOLD  '
        mvi     c,$1D
        mvi     b,$11
        call    L0645                   ; Display text message
        lda     $ABEC
        ori     $20                     ; BFO (used here for stop threshold indication)
        sta     $ABEC                   ; Display update control see L06FD
        mvi     a,$00
        sta     $AB92                   ; Flag, scan stopped for received signal (=FF)
        stc
        call    L3234                   ; Disconnect ant and mute audio if called with carry set
        mvi     a,$04
        sta     $A552
        call    L2E1A                   ; Set AGC control lines
        mvi     a,$FC
        sta     $A568                   ; Set tuning wheel sensitivity
        sta     $A569                   ; Set tuning wheel sensitivity
        call    L2748                   ; Enable Tuning wheel
        ret
;--------------------------------------------------------------------------------------------------
;       Stop threshold Enter key code
L19CB:
        ora     a
        call    L3234                   ; Disconnect ant and mute audio if called with carry set
        xra     a
        sta     $ABEE
        sta     $ABBD                   ; clear Numerical keypad applicability
        call    L2725                   ; Disable Tuning wheel
        lda     $A582                   ; Scan channel
        mov     b,a
        call    L1D0F                   ; Set radio to BCD chan # in B
        call    L23DA                   ; Init & start scan
        ret
;--------------------------------------------------------------------------------------------------
;       Display Auto Stop Scan on/off status
L19E4:
        mvi     a,$09
        sta     $ABBD                   ; set Numerical keypad applicability to 'auto stop scan'
        lxi     h,L1B6D                 ; ' AUTO STOP SCAN   '
        mvi     c,$1D
        mvi     b,$11
        call    L0645                   ; Display text message
        lda     $AB90                   ; Auto Stop Scan Threshold (FF=off)
        cpi     $FF
        jnz     L1A16
        jmp     L1A29
L19FE:                                  ; display Auto Stop threshold
        lda     $AB90                   ; Auto Stop Scan Threshold (FF=off)
        cpi     $FF
        jz      L1A09
        jmp     L1A21
L1A09:
        lda     $AB8F
        mov     b,a
        call    L2800                   ; Convert BCD B to number in A, carry set if B not good BCD
        sta     $AB90                   ; Auto Stop Scan Threshold (FF=off)
        sta     $A67D
L1A16:
        lxi     h,L1B7E                 ; ' ON'
        mvi     c,$0C
        mvi     b,$03
        call    L0645                   ; Display text message
        ret
L1A21:
        mvi     a,$FF
        sta     $AB90                   ; Auto Stop Scan Threshold (FF=off)
        sta     $A67D
L1A29:
        lxi     h,L1B81                 ; 'OFF'
        mvi     c,$0C
        mvi     b,$03
        call    L0645                   ; Display text message
        ret
;--------------------------------------------------------------------------------------------------
; Find next filter supporting mode
;
L1A34:
        mov     a,b
        ani     $0F             ; and B with $0F
        cpi     $04
        jnz     L1A3E           ; if B = $04, return
        mov     b,a
        ret
L1A3E:
        cpi     $03
        jnz     L1A47           ; if B = $03, or B with $10 and return
        ori     $10
        mov     b,a
        ret
L1A47:
        cpi     $05
        jnz     L1A5A                   ; if B = $05, then (if $ABC5 = $FF, B=$05 and return; else B=$F5 and return)
        lda     $ABC5                   ; 2ISB option installed flag (0=not installed, FF=installed)
        cpi     $FF
        jnz     L1A57
        mvi     b,$05
        ret
L1A57:
        mvi     b,$F5
        ret
L1A5A:
        cpi     $06
        jnz     L1A75                   ; if B = $06, then (if $ABC5 = $FF, if 4ISB installed B=$06 and return; else B=$F6 and return)
        lda     $ABC5                   ; 2ISB option installed flag (0=not installed, FF=installed)
        cpi     $FF
        jnz     L1A72
        lda     $A818                   ; 4ISB option flag, zero for no 4ISB
        cpi     $FF
        jnz     L1A72
        mvi     b,$06
        ret
L1A72:
        mvi     b,$F6
        ret
L1A75:
        cpi     $09
        jnz     L1A87                   ; if B = $09, then if FSK installed B=$F9 and return
        push    psw
        lda     $A825                   ; FSK option installed flag. Zero if not installed
        ora     a
        jnz     L1A86
        mvi     b,$F9
        pop     psw
        ret
L1A86:
        pop     psw
L1A87:
        push    h                       ; A has what B was when called, anded with $0F.  Not 3, 4, 5, 6, or 9 though. (arg)
        push    psw
        mov     d,c                     ; D gets C
        mvi     b,$00
        mov     c,a                     ; C gets arg
        lxi     h,L1AB5
        dad     b                       ; use arg in lookup table
        mov     e,m                     ; val from table
        mov     c,d                     ; C gets D
        mvi     d,$07
L1A95:
        lxi     h,$AC01                 ; filter mode list
        dcr     c
        jnz     L1A9E
        mvi     c,$07                   ; C = 0 to 7, 8 filters to check out
L1A9E:
        dad     b                       ; make HL address of selected filter mode byte
        mov     a,m
        ana     e                       ; test mode byte with table value
        jnz     L1AAA                   ; jump if mode supported
        dcr     d
        jnz     L1A95
        mvi     c,$0F                   ;  tried searching all filters
L1AAA:
        pop     psw
        mov     b,a             ; B has low nybble of called with B
        mov     a,c             ; A is new filter number
        rlc
        rlc
        rlc
        rlc                     ; move data to high byte
        ora     b               ; put orig data in there also
        mov     b,a             ; and out back in B
        pop     h
        ret
;--------------------------------------------------------------------------------------------------
;
L1AB5:  .db     $02, $00, $04, $00, $00, $00
        .db     $00, $00, $08, $10 

;       scan dwell values
L1ABF:  .db     $01, $02, $04, $05, $08, $10 
        .db     $20, $40, $50, $80, $99, $FF 

L1ACB:  .DB     "GROUP OR CHAN SCAN ?"
L1ADF:  .DB     " FIRST CHANNEL ?    "
L1AF3:  .DB     " LAST CHANNEL  ?    "
L1B07:  .DB     " GROUP NUMBER ?     "
L1B1B:  .DB     "CHANNEL NUMBER?     "
L1B2F:  .DB     "  ANOTHER GROUP ?   "
L1B43:  .DB     "  GROUP   NOW FULL  "
L1B57:  .db     "                    "

L1B6B:  .DB     "OK"

L1B6D:  .DB     " AUTO STOP SCAN  "

L1B7E:  .DB     " ON"
L1B81:  .DB     "OFF"

L1B84:  .DB     "  STOP THRESHOLD  "

L1B96:  .DB     "        BUTTON STUCK"

L1BAA:  .DB     " ZERO "
L1BB0:  .DB     "  ONE "
L1BB6:  .DB     "  TWO "
L1BBC:  .DB     " THREE"
L1BC2:  .DB     " FOUR "
L1BC8:  .DB     " FIVE "
L1BCE:  .DB     "  SIX "
L1BD4:  .DB     " SEVEN"
L1BDA:  .DB     " EIGHT"
L1BE0:  .DB     " NINE "
L1BE6:  .DB     "      "
L1BEC:  .DB     "      "
L1BF2:  .DB     " PROG "
L1BF8:  .DB     " RECV "
L1BFE:  .DB     " SCAN "
L1C04:  .DB     " TEST "
L1C0A:  .DB     "REMOTE"
L1C10:  .DB     " ENTER"
L1C16:  .DB     " LOAD "
L1C1C:  .DB     "RECALL"
L1C22:  .DB     " CHAN "
L1C28:  .DB     " FREQ "
L1C2E:  .DB     "  BFO "
L1C34:  .DB     " GROUP"
L1C3A:  .DB     "BANDWT"
L1C40:  .DB     " MODE "
L1C46:  .DB     "  AGC "
L1C4C:  .DB     "MANRFG"
L1C52:  .DB     "  NB  "
L1C58:  .DB     "TUNRAT"
L1C5E:  .DB     " TUNE "
L1C64:  .DB     " DWELL"

L1C6A:  .DB     "REMOTE #         BPS"

L1C7E:  .DB     "  50"
        .DB     "  75"
        .DB     " 110"
        .DB     " 134"
        .DB     " 150"
        .DB     " 300"
        .DB     " 600"
        .DB     "1200"
        .DB     "1800"
        .DB     "2000"
        .DB     "2400"
        .DB     "3600"
        .DB     "4800"
        .DB     "7200"
        .DB     "9600"
        .DB     "19.2K"

;--------------------------------------------------------------------------------------------------
;
;       Get channel memory RAM addr in HL given BCD channel # in B
;
L1CBF:
        push    psw
        call    L2800           ; Convert BCD B to number in A, carry set if B not good BCD
        jnc     L1CCD
        mvi     a,$A0
        cmp     b
        jz      L1CE1
        rst     0
L1CCD:
        push    b
          mvi     h,$00
          mov     l,a
          push    h             ; HL = # from B
          dad     h
          dad     h
          push    h             ; HL = 4 * # from B
          dad     h             ; HL = 8 * # from B
          pop     b             ; BC = 4 * # from B
          dad     b             ; HL = 12 * # from B
          pop     b             ; BC = # from B
          dad     b             ; HL = 13 * # from B
          lxi     b,$A004
          dad     b             ; HL = $A004 + (13 * # from B)
        pop     b
        pop     psw
        ret
L1CE1:
        lxi     h,$A518
        pop     psw
        ret
;--------------------------------------------------------------------------------------------------
;       Recall channel B to receiver and place B in $A566
L1CE6:
        push    d
        call    L1CBF                   ; Get channel memory RAM addr in HL given BCD channel # in B
        call    L20AD                   ; move 13 bytes from pointer HL to $A559
        mov     a,b
        sta     $A566                   ; Channel
        lda     $ABEC
        ori     $FE                     ; everything, but not now
        sta     $ABEC                   ; Display update control see L06FD
        pop     d
        ret
;--------------------------------------------------------------------------------------------------
;       Store present receive params to channel memory loc spec in $A566
L1CFB:
        push    d
        lda     $A566                   ; Channel
        mov     b,a
        call    L1CBF                   ; Get channel memory RAM addr in HL given BCD channel # in B
        push    h
        call    L2034                   ; move 13 bytes from $A559 to pointer HL
        pop     h
        call    L1D65                   ; A = sum of 13 bytes from HL
        cmp     m
        mov     m,a
        pop     d
        ret
;--------------------------------------------------------------------------------------------------
;       Set radio to BCD chan # in B
L1D0F:
        mvi     a,$FF
        sta     $A823
        call    L1CBF                   ; Get channel memory RAM addr in HL given BCD channel # in B
        lda     $A679                   ; Status bits
        ani     $80
        jnz     L1D39                   ; jump if local control mode
        lda     $A575                   ; Actively scanning flag ($FF means actively scanning)
        ora     a
        jz      L1D39
        lda     $A67A                   ; Radio state bits
        cpi     $02
        jnz     L1D39
        push    h
        lxi     d,$0007
        dad     d
        mvi     a,$80
        ana     m
        pop     h
        stc
        rnz
L1D39:
        push    d
        call    L2071                   ; 13 bytes from pointer HL to $A54B (desired radio state)
        mov     a,b
        sta     $A558                   ; Channel number displayed on front panel (=A0 if none)
        mvi     a,$7C
        sta     $ABED                   ; Radio setting control, see L2D5B - set everything
        call    L1F6B                   ; Part of setting up receiver, incl data from commanded to present block
        lda     $ABCB
        cpi     $0D
        jnz     L1D5A
        call    L1FCE                   ; Move commanded block to created area
        lxi     h,$A551                 ; mode & IF filter, new commanded rcv params
        call    L1858                   ; Store user filter choice for mode
L1D5A:
        lxi     h,$0000
        shld    $ABF1
        shld    $ABF3
        pop     d
        ret
;--------------------------------------------------------------------------------------------------
;       A = sum of 13 bytes from HL
;
L1D65:
        push    b
        mvi     b,$0C
        xra     a
L1D69:
        adc     m
        inx     h
        dcr     b
        jnz     L1D69
        adc     l
        pop     b
        ret
;--------------------------------------------------------------------------------------------------
;       Load default params to chan 0 if necessary
;       Called on power-up (only)
;
L1D72:
        lxi     h,$A004
        mvi     c,$67
        mvi     d,$00
L1D79:
        mvi     a,$40
        sim                             ; Set intr mask = $40
        mvi     a,$C0
        sim                             ; Set intr mask = $C0
        push    h                       ; HL = $A004
        inx     h
        inx     h
        inx     h                       ; HL = $A007
        mvi     a,$29
        cmp     m
        jc      L1DD7                   ; jump if $A007 > $29
        pop     h                       ; HL = $A004
        push    h
        mvi     b,$0D
        xra     a                       ; A=0
        push    psw
L1D8F:
        pop     psw
        dcr     b
        jnz     L1DA2
        adc     l
        cmp     m
        jnz     L1DD7
        pop     psw
        inx     h
        dcr     c
        jnz     L1D79
        mov     a,d
        ora     a
        ret
L1DA2:
        adc     m
        push    psw
        mvi     a,$0F
        ana     m
        cpi     $0A
        jc      L1DB2
        mvi     a,$04
        cmp     b
        jnz     L1DD6
L1DB2:
        mvi     a,$F0
        ana     m
        cpi     $91
        jc      L1DD2
        mvi     a,$05
        cmp     b
        jz      L1DD2
        mvi     a,$07
        cmp     b
        jz      L1DD2
        mvi     a,$02
        cmp     b
        jz      L1DD2
        mvi     a,$01
        cmp     b
        jnz     L1DD6
L1DD2:
        inx     h
        jmp     L1D8F
L1DD6:
        pop     psw
L1DD7:
        pop     h
        xra     a
        mov     m,a                             ; (HL)=0
        inx     h
        mov     m,a                             ; (HL+1)=0
        inx     h
        mov     m,a                             ; (HL+2)=0
        inx     h
        mvi     m,$10                           ; (HL+3)=10
        inx     h
        mov     m,a                             ; (HL+4)=0
        inx     h
        mov     m,a                             ; (HL+5)=0
        inx     h
        mvi     m,$13                           ; (HL+6)=13
        inx     h
        mvi     m,$01                           ; (HL+7)=1
        inx     h
        mov     m,a                             ; (HL+8)=0
        inx     h
        xra     a
        mov     m,a                             ; (HL+9)=0
        inx     h
        mov     m,a                             ; (HL+A)=0
        inx     h
        mvi     m,$02                           ; (HL+B)=2
        inx     h
        mvi     a,$25                           ; A=25
        adi     $01                             ; A=26
        adc     l                               ; 
        mov     m,a                             ; (HL+C)=A + L
        inx     h                               ; 
        inr     d
        dcr     c
        jnz     L1D79
        mov     a,d
        ora     a
        ret
;--------------------------------------------------------------------------------------------------
;       Set radio where present <> new commanded params
L1E05:
        lxi     d,$A68F
        ldax    d
        mov     b,a
        lda     $A68E
        cmp     b
        jz      L1E1A                   ; set synth if $A68E and $A68F are different
        stax    d
        lda     $ABED
        ori     $40                     ; set synth
        sta     $ABED                   ; Radio setting control, see L2D5B
L1E1A:
        lda     $ABF4
        ora     a
        jz      L1E29
        lda     $A566                   ; Channel
        mov     b,a
        call    L1D0F                   ; Set radio to BCD chan # in B
        ret
L1E29:
        push    h
        lhld    $ABF1
        mov     a,l
        ora     a
        jz      L1E88
        push    h
        lxi     h,$A54F                 ; BFO LSB, new commanded
        lxi     d,$A55D                 ; BFO LSB, present
        mvi     b,$02
L1E3B:
        ldax    d
        cmp     m
        jnz     L1E4C
        inx     h
        inx     d
        dcr     b
        jnz     L1E3B
        pop     h
        mvi     l,$00
        jmp     L1E5D
L1E4C:                                  ; if present <> new cmd'd BFO params, set BFO & update BFO disp
        pop     h
        lda     $ABED
        ori     $20                     ; BFO
        sta     $ABED                   ; Radio setting control, see L2D5B
        lda     $ABEC
        ori     $20                     ; BFO
        sta     $ABEC                   ; Display update control see L06FD
L1E5D:
        push    h
        lxi     h,$A554                 ; FSK center freq MSB & sign, new commanded
        lxi     d,$A562                 ; FSK center freq MSB & sign, present
        mvi     b,$02
L1E66:
        ldax    d
        cmp     m
        jnz     L1E75
        inx     h
        inx     d
        dcr     b
        jnz     L1E66
        pop     h
        jmp     L1E88
L1E75:                                  ; if present <> new cmd'd FSK params, set synth & BFO, update BFO disp
        lda     $ABED
        ori     $60                     ; synth and BFO
        sta     $ABED                   ; Radio setting control, see L2D5B
        lda     $ABEC
        ori     $20                     ; BFO
        sta     $ABEC                   ; Display update control see L06FD
        pop     h
        mvi     l,$FF
L1E88:
        mov     a,h
        ora     a
        jz      L1EB8
        push    h
        lxi     h,$A559                 ; present receiver param block beginning
        lxi     d,$A54B                 ; new commanded receiver params block beginning
        mvi     b,$04
L1E96:
        ldax    d
        cmp     m
        jnz     L1EA7
        inx     d
        inx     h
        dcr     b
        jnz     L1E96
        pop     h
        mvi     h,$00
        jmp     L1EB8
L1EA7:
        pop     h
        lda     $ABED
        ori     $40                     ; synth
        sta     $ABED                   ; Radio setting control, see L2D5B
        lda     $ABEC
        ori     $40                     ; freq
        sta     $ABEC                   ; Display update control see L06FD
L1EB8:
        lda     $ABF3
        ora     a
        jz      L1F2D
        lda     $A818                   ; 4ISB option flag, zero for no 4ISB
        cpi     $FF
        jnz     L1EE0
        lda     $A55F                   ; mode & IF filter, present params
        ani     $0F
        cpi     $06                     ; 4ISB mode?
        jnz     L1EDA
        in      $40                     ; 8255 Port A
        ani     $EF                     ; set 4ISB enable to 0
        out     $40                     ; 8255 Port A
        jmp     L1EE0
L1EDA:
        in      $40                     ; 8255 Port A
        ori     $10                     ; set 4ISB enable to 1
        out     $40                     ; 8255 Port A
L1EE0:
        lda     $A551                   ; mode & IF filter, new commanded rcv params
        mov     b,a
        lda     $A55F                   ; mode & IF filter, present params
        cmp     b
        jnz     L1EF8
        lda     $A552                   ; AGC speed pointer, new commanded params
        mov     b,a
        lda     $A560                   ; AGC speed pointer, present params
        cmp     b
        mvi     a,$00
        jz      L1F0A
L1EF8:
        lda     $ABED
        ori     $7C                     ; everything
        sta     $ABED                   ; Radio setting control, see L2D5B
        lda     $ABEC
        ori     $3C                     ; BFO, mode, filt, AGC
        sta     $ABEC                   ; Display update control see L06FD
        mvi     a,$FF
L1F0A:
        push    psw
        lda     $A556                   ; FSK shift & polarity, new commanded
        mov     b,a
        lda     $A564                   ; FSK shift & polarity, present
        cmp     b
        jnz     L1F1A
        pop     psw
        jmp     L1F2D
L1F1A:
        lda     $ABED
        ori     $20                     ; BFO
        sta     $ABED                   ; Radio setting control, see L2D5B
        lda     $ABEC
        ori     $04                     ; AGC
        sta     $ABEC                   ; Display update control see L06FD
        pop     psw
        mvi     a,$FF
L1F2D:
        push    psw
        push    h
        lxi     h,$A559                 ; present receiver param block beginning
        call    L2071                   ; copy present params to new commanded params
        lda     $A566                   ; Channel
        sta     $A558                   ; Channel number displayed on front panel (=A0 if none)
        pop     h
        pop     psw
        ora     h
        jnz     L1F45
        ora     l
        jz      L1F69
L1F45:
        mvi     a,$A0
        sta     $A566                   ; Channel
        sta     $A558                   ; Channel number displayed on front panel (=A0 if none)
        lda     $ABEC
        ori     $80                     ; chan
        sta     $ABEC                   ; Display update control see L06FD
        lda     $ABCB
        cpi     $0D
        cz      L1FCE                   ; Move commanded block to created area
        lxi     h,$0000
        shld    $ABF1
        shld    $ABF2
        call    L0A4E                   ; Set $AB95 to $1F and clr b7 of all 30 display data bytes
L1F69:
        pop     h
        ret
;--------------------------------------------------------------------------------------------------
;       Part of setting up receiver, incl data from commanded to present block
L1F6B:
        push    h
        lxi     h,$A559                 ; present receiver param block beginning
        call    L1FF7                   ; 13 bytes from $A54B to pointer HL (move commanded to present block)
        lda     $A558                   ; Channel number displayed on front panel (=A0 if none)
        sta     $A566                   ; Channel
        lda     $A818                   ; 4ISB option flag, zero for no 4ISB
        cpi     $FF
        jnz     L1F99
        lda     $A551                   ; mode & IF filter, new commanded rcv params
        ani     $0F
        cpi     $06                     ; 4ISB mode?
        jnz     L1F93
        in      $40                     ; 8255 Port A
        ani     $EF                     ; enable 4ISB
        out     $40                     ; 8255 Port A
        jmp     L1F99
L1F93:
        in      $40                     ; 8255 Port A
        ori     $10                     ; disable 4ISB
        out     $40                     ; 8255 Port A
L1F99:
        call    L0A4E                   ; Set $AB95 to $1F and clr b7 of all 30 display data bytes
        lda     $ABEC
        ori     $FE                     ; everything, but not now
        sta     $ABEC                   ; Display update control see L06FD
        pop     h
        ret
;--------------------------------------------------------------------------------------------------
;       Move created receiver params to commanded block
L1FA6:
        push    h
        lda     $A679                   ; Status bits
        ani     $80
        jz      L1FB8                   ; jump if remote control mode
        lxi     h,$A525                 ; 13 byte block for locally generated params going to commanded
        lda     $A549                   ; locally generated channel number going to commanded
        jmp     L1FBE
L1FB8:
        lxi     h,$A532                 ; 13 byte block for remotely generated params going to commanded
        lda     $A54A                   ; remotely generated channel number going to commanded
L1FBE:
        call    L2071                   ; 13 bytes from pointer HL to $A54B
        sta     $A558                   ; Channel number displayed on front panel (=A0 if none)
        mvi     a,$7C                   ; set everything
        sta     $ABED                   ; Radio setting control, see L2D5B
        call    L1F6B                   ; Part of setting up receiver, incl data from commanded to present block
        pop     h
        ret
;--------------------------------------------------------------------------------------------------
;       Move commanded block to created area
L1FCE:
        push    h
        lda     $A679                   ; Status bits
        ani     $80
        jz      L1FE3                   ; jump if remote control mode
        lxi     h,$A525                 ; 13 byte block for locally generated params going to commanded
        lda     $A558                   ; Channel number displayed on front panel (=A0 if none)
        sta     $A549                   ; locally generated channel number going to commanded
        jmp     L1FEC
L1FE3:
        lxi     h,$A532                 ; 13 byte block for remotely generated params going to commanded
        lda     $A558                   ; Channel number displayed on front panel (=A0 if none)
        sta     $A54A                   ; remotely generated channel number going to commanded
L1FEC:
        push    h
        call    L1FF7                   ; 13 bytes from $A54B to pointer HL
        pop     h
        call    L1D65                   ; A = sum of 13 bytes from HL
        mov     m,a
        pop     h
        ret
;--------------------------------------------------------------------------------------------------
;       13 bytes from $A54B to pointer HL
L1FF7:
        xchg
        lhld    $A54B                   ; new commanded receiver params block beginning
        xchg
        mov     m,e
        inx     h
        mov     m,d
        inx     h
        xchg
        lhld    $A54D
        xchg
        mov     m,e
        inx     h
        mov     m,d
        inx     h
        xchg
        lhld    $A54F                   ; BFO LSB
        xchg
        mov     m,e
        inx     h
        mov     m,d
        inx     h
        xchg
        lhld    $A551                   ; mode & IF filter, new commanded rcv params
        xchg
        mov     m,e
        inx     h
        mov     m,d
        inx     h
        xchg
        lhld    $A553
        xchg
        mov     m,e
        inx     h
        mov     m,d
        inx     h
        xchg
        lhld    $A555                   ; FSK center freq
        xchg
        mov     m,e
        inx     h
        mov     m,d
        inx     h
        xchg
        lhld    $A557
        xchg
        mov     m,e
        ret
;--------------------------------------------------------------------------------------------------
; 13 bytes from $A559 to pointer HL
L2034:
        xchg
        lhld    $A559                   ; present receiver param block beginning
        xchg
        mov     m,e
        inx     h
        mov     m,d
        inx     h
        xchg
        lhld    $A55B
        xchg
        mov     m,e
        inx     h
        mov     m,d
        inx     h
        xchg
        lhld    $A55D
        xchg
        mov     m,e
        inx     h
        mov     m,d
        inx     h
        xchg
        lhld    $A55F                   ; mode & IF filter, present params
        xchg
        mov     m,e
        inx     h
        mov     m,d
        inx     h
        xchg
        lhld    $A561
        xchg
        mov     m,e
        inx     h
        mov     m,d
        inx     h
        xchg
        lhld    $A563
        xchg
        mov     m,e
        inx     h
        mov     m,d
        inx     h
        xchg
        lhld    $A565
        xchg
        mov     m,e
        ret
;--------------------------------------------------------------------------------------------------
; 13 bytes from pointer HL to $A54B
L2071:
        mov     e,m
        inx     h
        mov     d,m
        inx     h
        xchg
        shld    $A54B           ; move [HL] to $A54B
        xchg
        mov     e,m
        inx     h
        mov     d,m
        inx     h
        xchg
        shld    $A54D
        xchg
        mov     e,m
        inx     h
        mov     d,m
        inx     h
        xchg
        shld    $A54F                   ; BFO LSB
        xchg
        mov     e,m
        inx     h
        mov     d,m
        inx     h
        xchg
        shld    $A551                   ; mode & IF filter, new commanded rcv params
        xchg
        mov     e,m
        inx     h
        mov     d,m
        inx     h
        xchg
        shld    $A553
        xchg
        mov     e,m
        inx     h
        mov     d,m
        inx     h
        xchg
        shld    $A555                   ; FSK center freq
        xchg
        mov     e,m
        lxi     h,$A557
        mov     m,e
        ret
;--------------------------------------------------------------------------------------------------
; 13 bytes from pointer HL to $A559
L20AD:
        mov     e,m
        inx     h
        mov     d,m
        inx     h
        xchg
        shld    $A559                   ; present receiver param block beginning
        xchg
        mov     e,m
        inx     h
        mov     d,m
        inx     h
        xchg
        shld    $A55B
        xchg
        mov     e,m
        inx     h
        mov     d,m
        inx     h
        xchg
        shld    $A55D
        xchg
        mov     e,m
        inx     h
        mov     d,m
        inx     h
        xchg
        shld    $A55F                   ; mode & IF filter, present params
        xchg
        mov     e,m
        inx     h
        mov     d,m
        inx     h
        xchg
        shld    $A561
        xchg
        mov     e,m
        inx     h
        mov     d,m
        inx     h
        xchg
        shld    $A563
        xchg
        mov     e,m
        lxi     h,$A565
        mov     m,e
        ret
;--------------------------------------------------------------------------------------------------
;       Calc address of beginning of group C memory area (returned in HL)
L20E9:
        push    b
          mvi     b,$00
          mov     h,b
          mov     l,c
          dad     h
          dad     h
          push    h
          dad     h
          dad     h
          pop     b
          dad     b
          lxi     b,$A589                 ; Group channel storage area base address
          dad     b
        pop     b
        ret
;--------------------------------------------------------------------------------------------------
;       Test channel A in group C? carry clear if so, set if not
L20FB:
        call    L20E9                   ; Calc address of beginning of group C memory area (returned in HL)
        mvi     b,$14
L2100:
        cmp     m
        rz
        inx     h
        dcr     b
        jnz     L2100
        stc
        ret
;--------------------------------------------------------------------------------------------------
;       Utility setup code for group (called with group # in C)
;
;       Called with group C,
;       counts # of good channels in group.  If 0, D=0 and carry is set.  If >0,
;       D=# good chanels
;       A665=beginning address of group
;       A667=beginning address of group
;       A669=ending address of group
;       A579=group #
;       A57B=$47
L2109:
        call    L20E9                   ; Calc address of beginning of group C memory area (returned in HL)
        push    h
        mvi     d,$00
        mvi     b,$14
L2111:
        mov     a,m
        cpi     $9A                     ; $9A is blank channel
        jnc     L2118                   ; jump if blank channel
        inr     d
L2118:
        inx     h
        dcr     b
        jnz     L2111
        pop     h
        mov     a,d
        ora     a
        stc
        rz
        shld    $A665                   ; Pointer for member of group
        shld    $A667                   ; Pointer for member of group
        push    d
        lxi     d,$0013
        dad     d
        pop     d
        shld    $A669                   ; Pointer for member of group
        mvi     a,$47
        sta     $A57B                   ; Channel or group scan.  43=channel, 47=group
        mov     a,c
        sta     $A579                   ; Holds group number
        stc
        cmc
        ret
;------------------------------------------------------------------------------------------------
;       Group (and maybe scan) logic
L213D:
        push    b
        mvi     b,$19
        lhld    $A665                   ; Pointer for member of group
        xchg                            ; HL=DE, DE=[$A665]
        jc      L2180
        lda     $A577                   ; Flag, tuning wheel active for scan chan select
        ora     a
        jz      L2155
        lda     $A56C                   ; Decimal movement of tuning wheel
        ora     a
        jnz     L2180
L2155:
        lhld    $A669                   ; Pointer for member of group
L2158:
        inx     d
        dcr     b
        jz      L21AB
        mov     a,d
        cmp     h
        jnz     L216A
        mov     a,e
        cmp     l
        jc      L216A
        jnz     L2172
L216A:
        mov     a,d
        cmp     h
        jc      L2177
        jz      L2177
L2172:
        xchg
        lhld    $A667                   ; Pointer for member of group
        xchg
L2177:
        ldax    d
        cpi     $9A
        jc      L21A2
        jmp     L2158
L2180:
        lhld    $A667                   ; Pointer for member of group
L2183:
        dcx     d
        dcr     b
        jz      L21AB
        mov     a,d
        cmp     h
        jnz     L2192
        mov     a,e
        cmp     l
        jc      L2197
L2192:
        mov     a,d
        cmp     h
        jnc     L219C
L2197:
        xchg
        lhld    $A669                   ; Pointer for member of group
        xchg
L219C:
        ldax    d
        cpi     $9A
        jnc     L2183
L21A2:
        xchg
        shld    $A665                   ; Pointer for member of group
        mov     a,m
        stc
        cmc
        pop     b
        ret
L21AB:
        stc
        pop     b
        ret
;--------------------------------------------------------------------------------------------------
;       Put channel A into spot with $EE in group C
L21AE:
        mov     d,a
        mvi     a,$EE
        call    L20FB                   ; Test channel A in group C? carry clear if so, set if not
        rc
        mov     m,d
        ret
;--------------------------------------------------------------------------------------------------
;       Replace channel A in group C with $EE
L21B7:
        call    L20FB                   ; Test channel A in group C? carry clear if so, set if not
        rc
        mvi     m,$EE
        ret
;--------------------------------------------------------------------------------------------------
;       Scan channel code
L21BE:
        push    b
        mov     b,a
        lda     $A577                   ; Flag, tuning wheel active for scan chan select
        ora     a
        jz      L21CF
        lda     $A56C                   ; Decimal movement of tuning wheel
        ora     a
        jz      L21CF
        stc
L21CF:
        mvi     a,$01
        call    L28A3                   ; Increment/decrement channel logic.  Carry=1 means dec, B=present chan, HL=valid range of chans
        pop     b
        ret
;--------------------------------------------------------------------------------------------------
;       Active scanning code
L21D6:
        lda     $A575                   ; Actively scanning flag ($FF means actively scanning)
        ora     a
        rz                              ; return if not actively scanning
        lda     $A578
        ora     a
        rnz
        lxi     h,$A57E
        lda     $A576
        ora     a
        jz      L21EB
        dcr     m
L21EB:
        mov     a,m
        cpi     $FE
        jnz     L21F4
        mvi     m,$FF
        ret
L21F4:
        lda     $A679                   ; Status bits
        ani     $80
        jnz     L2202                   ; jump if local control mode
        lda     $AB91                   ; Auto Stop Scan Threshold (FF=off)
        jmp     L2205
L2202:
        lda     $AB90                   ; Auto Stop Scan Threshold (FF=off)
L2205:
        cpi     $FF
        jnz     L2210
        lda     $AB92                   ; Flag, scan stopped for received signal (=FF)
        jmp     L2286
L2210:
        mov     c,a
        lda     $ABC5                   ; 2ISB option installed flag (0=not installed, FF=installed)
        ora     a
        jz      L2246
        lda     $A551                   ; mode & IF filter, new commanded rcv params
        ani     $0F
        cpi     $04
        jz      L223C
        cpi     $05
        jnz     L2246
        mvi     h,$5C                           ; 2nd IF AGC
        call    L2BBE                           ; A/D read routine.  Channel H, A has data, carry if error.
        rc
        mov     b,a
        mvi     h,$5A                           ; AGC
        call    L2BBE                           ; A/D read routine.  Channel H, A has data, carry if error.
        rc
        cmp     b
        jc      L224D
        mov     b,a
        jmp     L224D
L223C:
        mvi     h,$5A                           ; AGC
        call    L2BBE                           ; A/D read routine.  Channel H, A has data, carry if error.
        rc
        mov     b,a
        jmp     L224D
L2246:
        mvi     h,$5C                           ; 2nd IF AGC
        call    L2BBE                           ; A/D read routine.  Channel H, A has data, carry if error.
        rc
        mov     b,a
L224D:
        mov     a,b
        cmp     c
        lda     $AB92                   ; Flag, scan stopped for received signal (=FF)
        jc      L2286
        ora     a
        jnz     L2264
        mvi     a,$FF
        sta     $AB92                   ; Flag, scan stopped for received signal (=FF)
        call    L3EF1                   ; Harris protocol - send out state or suspend scan DID as urgent
        jmp     L226E
L2264:
        lda     $AB93
        dcr     a
        sta     $AB93
        jnz     L22AA
L226E:
        mvi     a,$01
        sta     $AB93
        lda     $ABB4
        xri     $20                     ; scan
        sta     $ABB4                   ; Front panel LEDs
        lda     $ABEC
        ori     $01                     ; update now
        sta     $ABEC                   ; Display update control see L06FD
        jmp     L22AA
L2286:
        ora     a
        jz      L2292
        mvi     a,$00
        sta     $AB92                   ; Flag, scan stopped for received signal (=FF)
        call    L3EB2                   ; Harris protocol - send urgent DID sequence for resuming scan
L2292:
        lda     $ABB4
        ori     $20                     ; scan
        sta     $ABB4                   ; Front panel LEDs
        lda     $ABEC
        ori     $01                     ; update now
        sta     $ABEC                   ; Display update control see L06FD
        lda     $A57E
        ora     a
        rnz
        call    L22B1                   ; High level scan code
L22AA:
        lda     $A57F
        sta     $A57E
        ret
;--------------------------------------------------------------------------------------------------
;       High level scan code
L22B1:
        push    b
        mvi     c,$63
        lda     $A57B                   ; Channel or group scan.  43=channel, 47=group
        cpi     $47
        jnz     L22C5
        call    L213D                   ; Group (and maybe scan) logic
        jc      L22E0
        jmp     L22CE
L22C5:
        lda     $A582                   ; Scan channel
        lhld    $A57C                   ; Channel scanning lower bound
        call    L21BE                   ; Scan channel code
L22CE:
        mov     b,a
        call    L1D0F                   ; Set radio to BCD chan # in B
        mov     a,b
        sta     $A582                   ; Scan channel
        jc      L22DB
        pop     b
        ret
L22DB:
        dcr     c
        jnz     L22C5
        stc
L22E0:
        pop     b
        ret
;--------------------------------------------------------------------------------------------------
;       Scan dwell setting code
L22E2:
        mvi     a,$FF
        cmp     b
        cnz     L2800                   ; Convert BCD B to number in A, carry set if B not good BCD
        mov     b,a
        sta     $A581                   ; Scan dwell (FF means external)
        lda     $A575                   ; Actively scanning flag ($FF means actively scanning)
        ora     a
        jz      L2347
        mvi     a,$FF
        cmp     b
        jz      L232A
        lda     $A578
        ora     a
        jz      L2309
        mvi     a,$FF
        sta     $A576
        cma
        sta     $A578
L2309:
        lda     $A57F
        mov     c,a
        mov     a,b
        sta     $A57F
        sub     c
        mov     c,a
        lda     $A57E
        cpi     $FF
        jz      L2347
        add     c
        jm      L2322
        jnz     L2324
L2322:
        mvi     a,$01
L2324:
        sta     $A57E
        jmp     L2347
L232A:
        xra     a
        sta     $A576
        cma
        sta     $A578
        in      $81                     ; 8155 Port A
        ani     $01                     ; read scan step input
        sta     $ABD7                   ; reflects Scan step input from back panel (=0 or =1)
        in      $81                     ; 8155 Port A
        ani     $02                     ; read scan stop input
        sta     $ABD8                   ; reflects Scan Stop input from back panel (=0 or =2)
        xra     a
        sta     $A57F
        sta     $A57E
L2347:
        lda     $ABEC
        ori     $02                     ; dwell
        sta     $ABEC                   ; Display update control see L06FD
        ret
;--------------------------------------------------------------------------------------------------
;       Active scanning logic for external Step, Stop inputs
L2350:
        lda     $A575                   ; Actively scanning flag ($FF means actively scanning)
        ora     a
        rz
        lda     $AB92                   ; Flag, scan stopped for received signal (=FF)
        ora     a
        rnz
        lda     $A576
        ora     a
        jz      L2389
        in      $81                     ; 8155 Port A
        ani     $02                     ; read Scan Stop input from rear panel
        mov     b,a
        jz      L2378
        mvi     a,$FF
        sta     $A57E
        xra     a
        sta     $ABD5
        call    L3314                   ; set preselector after checking preselector filter ID between $66 and $9A
        jmp     L23B1
L2378:
        lda     $ABD8                   ; reflects Scan Stop input from back panel (=0 or =2)
        cmp     b
        rz
        call    L22B1                   ; High level scan code
        lda     $A57F
        sta     $A57E
        jmp     L23B1
L2389:
        lda     $A578
        ora     a
        rz
        in      $81                     ; 8155 Port A
        mov     d,a
        ani     $01
        mov     c,a                     ; C = Scan Step input
        mvi     a,$02
        ana     d
        mov     b,a                     ; B = Scan Stop input
        jz      L23A1
        call    L3314                   ; set preselector after checking preselector filter ID between $66 and $9A
        jmp     L23AD
L23A1:
        mov     a,c
        ora     a
        jz      L23AD
        lda     $ABD7                   ; reflects Scan step input from back panel (=0 or =1)
        cmp     c
        cnz     L22B1                   ; High level scan code
L23AD:
        mov     a,c
        sta     $ABD7                   ; reflects Scan step input from back panel (=0 or =1)
L23B1:
        mov     a,b
        sta     $ABD8                   ; reflects Scan Stop input from back panel (=0 or =2)
        ret
;--------------------------------------------------------------------------------------------------
;       Stopping scan, not due to received signal
L23B6:
        lda     $A575                   ; Actively scanning flag ($FF means actively scanning)
        ora     a
        rz                              ; return if not actively scanning
        lda     $ABB4
        ori     $20                     ; scan
        sta     $ABB4                   ; Front panel LEDs
        lda     $ABEC
        ori     $01                     ; update now
        sta     $ABEC                   ; Display update control see L06FD
        xra     a
        sta     $AB92                   ; clear: Flag, scan stopped for received signal (=FF)
        xra     a
        sta     $A575                   ; clear: Actively scanning flag ($FF means actively scanning)
        sta     $ABD5
        call    L3314                   ; set preselector after checking preselector filter ID between $66 and $9A
        ret
;--------------------------------------------------------------------------------------------------
;       Init & start scan
L23DA:
        push    psw
        xra     a
        sta     $A577                   ; Flag, tuning wheel active for scan chan select
        lda     $A581                   ; Scan dwell (FF means external)
        cpi     $FF
        jnz     L2400
        in      $81                     ; 8155 Port A
        ani     $01                     ; read scan step input
        sta     $ABD7                   ; reflects Scan step input from back panel (=0 or =1)
        in      $81                     ; 8155 Port A
        ani     $02                     ; read stop scan input
        sta     $ABD8                   ; reflects Scan Stop input from back panel (=0 or =2)
        xra     a
        sta     $A576
        cma
        sta     $A578
        jmp     L240E
L2400:
        sta     $A57E
        sta     $A57F
        xra     a
        sta     $A578
        cma
        sta     $A576
L240E:
        xra     a
        sta     $ABD5
        sta     $ABBD                   ; clear Numerical keypad applicability
        sta     $AB92                   ; Flag, scan stopped for received signal (=FF)
        cma
        sta     $ABBE
        sta     $A575                   ; Actively scanning flag ($FF means actively scanning)
        pop     psw
        ret

;----------------------------------------------------------------------------------------
;
;       Tune Wheel interrupt routine
;
; $A568  sensitivity (reset value)
; $A569  sensitivity (variable, difference from $A568 counts)
; $A56A  Increments/decrements from 0 on tuning wheel up/down movement
; $A56B  movement internal control flag, $00 or $FF
;
L2421:
        push    h                       ;
        push    d                       ;
        push    b                       ;
        push    psw                     ;
        rim
        ani     $07
        ori     $0A
        sim                             ; Clr bits 4-7, set bits 1,3 leave bits 0,2
        out     $6A                     ; Set Serial Data strobe to frnt pnl TWHL reset
        lxi     h,$A568
        mov     b,m                             ; B=($A568)
        inx     h                               ; HL=$A569
        lxi     d,$A56B                 ; D=($A56B)
        in      $42                     ; 8255 Port C
        ani     $10
        jz      L2456                   ; Jmp if 10 bit not set (tuning wheel direction) 1=decr
        ldax    d                       ; load A from loc specified by DE
        ora     a
        jnz     L244C
        cma                             ; if A=$00, make A=$FF
        stax    d                       ; (DE)=A
        mov     a,b
        sub     m                       ; subtract $A569 from B
        jz      L244D
        mov     m,a                     ; if not zero, put back into $A569
        jmp     L244D
L244C:
        inr     m                       ; increment $A569
L244D:
        jnz     L246D
        mov     m,b
        inx     h
        dcr     m
        jmp     L246D
L2456:
        ldax    d                       ; load A from loc specified by DE
        ora     a
        jz      L2466
        cma
        stax    d
        mov     a,b
        sub     m
        jz      L2467
        mov     m,a
        jmp     L2467
L2466:
        inr     m
L2467:
        jnz     L246D
        mov     m,b
        inx     h
        inr     m
L246D:
        pop     psw                     ;
        pop     b                       ;
        pop     d                       ;
        pop     h                       ;
        ei                              ; Enable interrupts
        ret
;----------------------------------------------------------------------------------------
;       Tuning wheel movement processing
;
L2473:
        lda     $A567                   ; Tuning wheel enabled flag (FF if enabled)
        cpi     $FF
        rnz                             ; exit if tuning wheel disabled
        rim
        ani     $07
        ori     $0A
        sim
        lda     $A56A                   ; tuning wheel movement output, 0=no movement
        ora     a
        rz
        mvi     l,$00
        jp      L248C
        cma
        inr     a
        dcr     l
L248C:
        mov     c,a
        call    L27DC                   ; Converts C to tens & ones BCD (99=>10011001 and 255=>01010101) in A (B has hundreds)
        mov     h,a
        shld    $A56C                   ; $A56C=decimal movement, $A56D=0 if +, $FF if -
        mov     b,a
        xra     a
        sta     $A56A                   ; Reset tuning wheel movement output
        sta     $A56E
        lda     $A575                           ; Actively scanning flag ($FF means actively scanning)
        ora     a
        rnz
        lda     $ABBD                   ; Numerical keypad applicability
        cpi     $03
        jnz     L24AD                   ; jump if not 'program'
        call    L268D
        ret
L24AD:
        cpi     $02
        jnz     L24B6                   ; jump if not 'frequency'
        call    L25E4
        ret
L24B6:
        cpi     $01
        jnz     L24BF                   ; jump if not 1
        cz      L24C5
        ret
L24BF:
        cpi     $0A
        cz      L26ED                   ; call if 'Stop Threshold'
        ret
;--------------------------------------------------------------------------------------------------
;       Tuning wheel processing for BFO
;
L24C5:
        lda     $A55F                   ; mode & IF filter, present params
        ani     $0F
        cpi     $09
        jz      L256C
        lhld    $A55D
        lxi     d,$A55E
        xchg
        mov     a,d
        ora     e
        jnz     L24E6
        lda     $A56C                   ; Decimal movement of tuning wheel
        ani     $F0
        mov     m,a
        dcx     h
        mov     m,b
        jmp     L2539
L24E6:
        lxi     d,$A56C                   ; Decimal movement of tuning wheel
        mvi     a,$F0
        ana     m
        mov     b,a
        jz      L24F6
        mvi     b,$FF
        mvi     a,$0F
        ana     m
        mov     m,a
L24F6:
        dcx     h
        ldax    d
        cmp     b
        jnz     L2525
        mov     a,m
        cpi     $99
        jnz     L2511
        lda     $A55E
        cpi     $09
        jnz     L2511
        inx     h
        mvi     a,$F0
        ana     b
        ora     m
        mov     m,a
        ret
L2511:
        inx     d
        mvi     c,$02
        call    L2873                           ; (HL)=daa[(HL)+(DE)] for C locations
        cpi     $0A
        jc      L2534
        mvi     m,$09
        dcx     h
        mvi     m,$99
        inx     h
        jmp     L2534
L2525:
        inx     d
        mvi     c,$02
        call    L285B                   ; (HL)=daa[$99-(DE)+(HL)] for C locations
        jnc     L2534
        xra     a
        mov     b,a
        mov     m,a
        dcx     h
        mov     m,a
        inx     h
L2534:
        mvi     a,$F0
        ana     b
        ora     m
        mov     m,a
L2539:
        lda     $A55E
        ani     $0F
        mov     c,a
        lda     $A55D
        ora     c
        jnz     L254A
        xra     a
        sta     $A55E
L254A:
        mvi     a,$02
        sta     $ABBE
        lda     $ABCB
        cpi     $0C
        jz      L2560
        mvi     a,$FF
        sta     $ABF1
        call    L1E05                   ; Set radio where present <> new commanded params
        ret
L2560:
        call    L0A4E                           ; Set $AB95 to $1F and clr b7 of all 30 display data bytes
        lda     $ABEC
        ori     $20                     ; BFO
        sta     $ABEC                   ; Display update control see L06FD
        ret
L256C:
        lhld    $A562
        lxi     d,$A563
        xchg
        mov     a,m
        mov     b,a
        ani     $3F
        mov     m,a
        mov     a,b
        ani     $C0
        mov     b,a
        lda     $A56C                   ; Decimal movement of tuning wheel
        ora     a
        jnz     L259C
        lxi     d,$A56D                 ; Tuning wheel direction flag (FF means negative)
        lxi     h,$A562
        mvi     c,$02
        call    L2873                           ; (HL)=daa[(HL)+(DE)] for C locations
        cpi     $3A
        jc      L25AF
        mvi     m,$39
        dcx     h
        mvi     m,$99
        inx     h
        jmp     L25AF
L259C:
        lxi     d,$A56D                 ; Tuning wheel direction flag (FF means negative)
        lxi     h,$A562
        mvi     c,$02
        call    L285B                   ; (HL)=daa[$99-(DE)+(HL)] for C locations
        jnc     L25AF
        xra     a
        mov     m,a
        dcx     h
        mov     m,a
        inx     h
L25AF:
        mov     a,m
        ora     b
        mov     m,a
        mvi     a,$03
        sta     $ABBE
        lda     $ABCB
        cpi     $0C
        jz      L25D8
        lhld    $A554                   ; FSK center freq
        lda     $A562
        cmp     l
        jnz     L25D0
        lda     $A563
        cmp     h
        jz      L25E3
L25D0:
        mvi     a,$FF
        sta     $ABF1
        call    L1E05                   ; Set radio where present <> new commanded params
L25D8:
        call    L0A4E                           ; Set $AB95 to $1F and clr b7 of all 30 display data bytes
        lda     $ABEC
        ori     $20                     ; BFO
        sta     $ABEC                   ; Display update control see L06FD
L25E3:
        ret
;--------------------------------------------------------------------------------------------------
;       Tuning wheel processing for frequency control
;
L25E4:
        lda     $ABB6                   ; Digit to tune
        stc
        cmc
        rar
        mov     c,a
        jnc     L25FE
        cpi     $03
        jnz     L25F4
        ret                             ; exit if 10 MHz digit, don't tune that!
L25F4:
        mvi     h,$00                   ; tune digit 1,3,5 gets here
        mov     l,b
        dad     h
        dad     h
        dad     h
        dad     h
        shld    $A56D                   ; store HL at $A56D/E
L25FE:                                  ; tune digit 0,2,4,6 gets here
        lxi     h,$A559                 ; present receiver param block beginning
        mvi     b,$00
        dad     b
        lxi     d,$A56D                 ; Tuning wheel direction flag (FF means negative)
        mvi     a,$04
        sub     c
        mov     c,a
        lda     $A56C                   ; Decimal movement of tuning wheel
        cpi     $FF
        jnz     L2636
        call    L285B                   ; (HL)=daa[$99-(DE)+(HL)] for C locations
        jnc     L2661
        lda     $ABB6                   ; Digit to tune
        mov     c,a
        mvi     a,$08
        sub     c
        mov     c,a
L2621:
        jz      L2661
        dcr     c
        jnz     L262F
        mvi     a,$0F
        ana     m
        inr     c
        jmp     L2630
L262F:
        xra     a
L2630:
        mov     m,a
        dcx     h
        dcr     c
        jmp     L2621
L2636:
        call    L2873                           ; (HL)=daa[(HL)+(DE)] for C locations
        cpi     $2A
        jc      L2661
        lda     $ABB6                   ; Digit to tune
        mov     c,a
        mvi     a,$07
        sub     c
        mov     c,a
        mvi     m,$29
        dcr     c
L2649:
        jz      L2661
        dcx     h
        dcr     c
        jnz     L265A
        mvi     a,$0F
        ana     m
        ori     $90
        inr     c
        jmp     L265C
L265A:
        mvi     a,$99
L265C:
        mov     m,a
        dcr    c
        jmp     L2649
L2661:
        lxi     h,$0000
        shld    $A56D                 ; Tuning wheel direction flag (FF means negative)
        shld    $A56F
        lda     $ABB6                   ; Digit to tune
        sta     $ABBE
        lda     $ABCB
        cpi     $0C
        jz      L2681
        mvi     a,$FF
        sta     $ABF2
        call    L1E05                   ; Set radio where present <> new commanded params
        ret
L2681:
        call    L0A4E                           ; Set $AB95 to $1F and clr b7 of all 30 display data bytes
        lda     $ABEC
        ori     $40                     ; freq
        sta     $ABEC                   ; Display update control see L06FD
        ret
;--------------------------------------------------------------------------------------------------
;       Tuning wheel processing for Program control
;
L268D:
        mvi     a,$01
        sta     $ABBE
        lda     $ABCB
        cpi     $0E
        jz      L26C5
        lxi     d,$A566                   ; Channel
        lda     $A56C                   ; Decimal movement of tuning wheel
        rar
        ldax    d
        mov     b,a
        mov     a,h
        lxi     h,$9900
        call    L28A3                   ; Increment/decrement channel logic.  Carry=1 means dec, B=present chan, HL=valid range of chans
        mov     b,a
        lda     $ABCB
        cpi     $0C
        jz      L26B7
        call    L1D0F                   ; Set radio to BCD chan # in B
        ret
L26B7:
        mov     a,b
        stax    d
        lda     $ABEC
        ori     $80                     ; chan
        sta     $ABEC                   ; Display update control see L06FD
        call    L0A4E                           ; Set $AB95 to $1F and clr b7 of all 30 display data bytes
        ret
L26C5:
        mvi     a,$FF
        sta     $A577                   ; Flag, tuning wheel active for scan chan select
        cma
        sta     $A576
        sta     $A578
        lda     $A57B                   ; Channel or group scan.  43=channel, 47=group
        cpi     $47
        jnz     L26DF
        call    L213D                   ; Group (and maybe scan) logic
        jmp     L26E8
L26DF:
        lhld    $A57C                   ; Channel scanning lower bound
        lda     $A558                   ; Channel number displayed on front panel (=A0 if none)
        call    L21BE                   ; Scan channel code
L26E8:
        mov     b,a
        call    L1D0F                   ; Set radio to BCD chan # in B
        ret
;--------------------------------------------------------------------------------------------------
;       Tuning wheel processing for Stop Threshold control
;
L26ED:
        lda     $A56C                   ; Decimal movement of tuning wheel
        ora     a
        jnz     L2707
        lxi     d,$A56D                 ; Tuning wheel direction flag (FF means negative)
        lxi     h,$AB8F
        mvi     c,$01
        call    L2873                           ; (HL)=daa[(HL)+(DE)] for C locations
        jnc     L2717
        mvi     m,$99
        jmp     L2717
L2707:
        lxi     d,$A56D                 ; Tuning wheel direction flag (FF means negative)
        lxi     h,$AB8F
        mvi     c,$01
        call    L285B                   ; (HL)=daa[$99-(DE)+(HL)] for C locations
        jnc     L2717
        mvi     m,$00
L2717:
        mvi     a,$01
        sta     $ABBE
        lda     $ABEC
        ori     $20                     ; BFO
        sta     $ABEC                   ; Display update control see L06FD
        ret
;--------------------------------------------------------------------------------------------------
;       Disable Tuning wheel
L2725:
        push    psw
        xra     a
        sta     $A567                   ; set tuning wheel enabled flag to disabled
        sta     $A56A                   ; Reset tuning wheel movement output
        sta     $A56C                   ; Decimal movement of tuning wheel
        rim
        ani     $07
        ori     $0A
        sim
        lda     $ABB5
        ani     $EF                     ; tune off
        sta     $ABB5                   ; Front panel LEDs
        lda     $ABEC
        ori     $01                     ; update now
        sta     $ABEC                   ; Display update control see L06FD
        pop     psw
        ret
;--------------------------------------------------------------------------------------------------
;       Enable Tuning wheel
L2748:
        push    psw
        xra     a
        sta     $A56B                           ; Reset tuning wheel movement flag
        sta     $A56C                   ; Decimal movement of tuning wheel
        sta     $A56A                           ; Reset tuning wheel movement output
        lda     $ABB5
        ori     $10                     ; tune
        sta     $ABB5                   ; Front panel LEDs
        out     $6A                     ; Set Serial Data strobe to frnt pnl TWHL reset
        mvi     a,$FF
        sta     $A567                   ; Set tuning wheel enabled flag to enabled
        lda     $A575                           ; Actively scanning flag ($FF means actively scanning)
        mov     b,a
        call    L23B6                   ; Stopping scan, not due to received signal
        mov     a,b
        ora     a
        jnz     L277E
        lda     $ABBD                   ; Numerical keypad applicability
        cpi     $03                     ; Program
        jnz     L279F
        lda     $ABCB
        cpi     $0E
        jnz     L27BB
L277E:
        mvi     a,$FF
        sta     $A577                   ; Flag, tuning wheel active for scan chan select
        cma
        sta     $A576
        sta     $A578
        mvi     a,$03
        sta     $ABBD                   ; set Numerical keypad applicability to 'program'
        mvi     a,$01
        sta     $ABBE
        lda     $ABB5
        ori     $50                     ; chan, tune
        sta     $ABB5                   ; Front panel LEDs
        jmp     L27BB
L279F:
        cpi     $02
        jnz     L27BB
        lxi     h,$ABB6                 ; Digit to tune
        mov     a,m
        cpi     $07
        jnz     L27BB
        mvi     a,$03
        mov     m,a
        sta     $ABBE
        lda     $ABEC
        ori     $40                     ; freq
        sta     $ABEC                   ; Display update control see L06FD
L27BB:
        lda     $A568
        sta     $A569                   ; reset tuning wheel motion detector
        lda     $ABEC
        ori     $01                     ; update now
        sta     $ABEC                   ; Display update control see L06FD
        rim
        cma
        ori     $F2
        cma
        ori     $08
        sim
        pop     psw
        ret
;--------------------------------------------------------------------------------------------------
;
; Move C bytes @HL to @DE
;
L27D3:
        mov     a,m                     ; load A from loc pointed to by HL
        stax    d                       ; store A to loc pointed to by DE
        inx     h                       
        inx     d
        dcr     c
        jnz     L27D3
        ret

;--------------------------------------------------------------------------------------------------
;       Converts C to tens & ones BCD (99=>10011001 and 255=>01010101) in A (B has hundreds)
;
L27DC:
        push    d
        mvi     b,$00
        mov     e,b
        mov     a,c
L27E1:
        sui     $64
        jc      L27EA
        inr     b
        jmp     L27E1
L27EA:                                  ; B is # of decimal 100's in C
        adi     $64                     ; A=0 to 63 for C=0-63 and C=64-C7, A=0 to 37 for C=C8-FF
L27EC:
        sui     $0A
        jc      L27F5
        inr     e
        jmp     L27EC
L27F5:                                  ; E is # of decimal 10's in C
        adi     $0A
        mov     d,a                     ; D is # of decimal 1's in C
        mov     a,e
        add     a
        add     a
        add     a
        add     a
        add     d
        pop     d
        ret
;--------------------------------------------------------------------------------------------------
;       Convert BCD B to number in A, carry set if B not good BCD
;
L2800:
        mvi     a,$99
        cmp     b
        rc                              ; return if B > $99 with carry set
        push    d
        mvi     a,$0F                   ; A=$0F
        ana     b                       ; A gets low 4 bits of B
        mov     e,a                     ; move to E
        mvi     a,$09                   ; A=$09
        cmp     e
        jc      L281A                   ; return if low nybble of B > 9 with carry set
        mov     a,b
        rrc
        rrc
        rrc
        ani     $1E
        mov     d,a
        rlc
        rlc                     ; A = high nybble of B * 8
        add     d               ; D = high nybble of B * 2
        add     e               ; E = low nybble of B
L281A:
        pop     d
        ret

;--------------------------------------------------------------------------------------------------
;
;       Test A: C=1 if A>$99 or low 4 bits >9
L281C:
        cpi     $9A                     ; A-$9A
        cmc                             ; compl carry flag
        rc                              ; return if carry (A >= 9A)
        push    psw
        ani     $0F                     ; clear top 4 bits
        cpi     $0A                     ; A-$0A
        jc      L282B
        pop     psw
        stc                             ; set carry flag
        ret
L282B:
        pop     psw                     ; A not
        stc
        cmc                             ; clear carry flag
        ret
;--------------------------------------------------------------------------------------------------
;       A=DAA($99-C+B) with carry complemented
L282F:
        cmc
        mvi     a,$99
        aci     $00
        sub     c
        add     b
        daa
        cmc
        ret
;--------------------------------------------------------------------------------------------------
;       Keypress modifies mem nybble offset C from HL, data A
L2839:
        push    b
        mov     b,a
        mov     a,c
        ora     a
        rar
        mov     c,a
        mov     a,b
        mvi     b,$00
        jnc     L2852
        dad     b
        rlc
        rlc
        rlc
        rlc
        mov     b,a
        mov     a,m
        ani     $0F
        ora     b
        mov     m,a
        pop     b
        ret
L2852:
        dad     b
        mov     b,a
        mov     a,m
        ani     $F0
        ora     b
        mov     m,a
        pop     b
        ret
;--------------------------------------------------------------------------------------------------
;       (HL)=daa[$99-(DE)+(HL)] for C locations
L285B:
        push    b
        stc
L285D:
        mvi     a,$99
        aci     $00                     ; add with carry immediate
        xchg                            ; HL and DE
        sub     m
        xchg                            ; HL and DE
        add     m
        daa
        mov     m,a
        dcr     c
        jz      L2870
        inx     h
        inx     d
        jmp     L285D
L2870:
        cmc
        pop     b
        ret
;--------------------------------------------------------------------------------------------------
;       (HL)=daa[(HL)+(DE)] for C locations
;
L2873:
        push    b                       ;
        ora     a
L2875:
        ldax    d                       ; Load A from DE
        adc     m                       ; Add loc HL
        daa                             ; make BCD
        mov     m,a                     ; HL gets A
        dcr     c
        jz      L2882                   ; jump if done (do operation C times)
        inx     h
        inx     d
        jmp     L2875                   ; advance both DE and HL and do operation again
L2882:
        pop     b                       ;
        ret                             ;
;--------------------------------------------------------------------------------------------------
;
;       Called from front Panel keypress routine
;         Sets bit C of A to 1
;
L2884:
        mov     a,c
        cpi     $08                     ; Is C < 8?
        jc      L288C
        mvi     c,$08                   ; C >=8, make C=8
L288C:                                  ; C < 8
        xra     a                       ; A=0
        stc                             ; set carry flag
        inr     c                       ; C=C+1
L288F:
        ral                             ; Rotate A left C times then return
        dcr     c
        jnz     L288F
        ret
;--------------------------------------------------------------------------------------------------
;
;       Called from front Panel keypress routine when col has been detected.  C=key code (0:F)
;         Returns: A & C have bit # of pressed key
;
L2895:
        mov     a,c                     ; A gets key code
        mvi     c,$FF                   ; C=$FF
        ora     a
        jz      L28A1                   ; If key code=0, A&C=$FF and return
L289C:
        rar                             ; else, C incremented by # RARs to get bit in C to cy, A=C
        inr     c
        jnc     L289C
L28A1:
        mov     a,c
        ret
;--------------------------------------------------------------------------------------------------
;       Increment/decrement channel logic.  Carry=1 means dec, B=present chan, HL=valid range of chans
L28A3:
        jc      L28B0
        add     b
        daa
        jc      L28AE
        cmp     h
        rc
        rz
L28AE:
        mov     a,l
        ret
L28B0:
        push    b
        mov     c,a
        cmc
        call    L282F                   ; A=DAA($99-C+B) with carry complemented
        jc      L28BD
        cmp     l
        jnc     L28BE
L28BD:
        mov     a,h
L28BE:
        pop     b
        ret
;--------------------------------------------------------------------------------------------------
;       Not used (?) B=f(C,D)
L28C0:
        push    d
        mvi     b,$00
        mvi     e,$09
L28C5:
        mov     a,c
        rar
        mov     c,a
        dcr     e
        jz      L28D6
        mov     a,b
        jnc     L28D1
        add     d
L28D1:
        rar
        mov     b,a
        jmp     L28C5
L28D6:
        pop     d
        ret
;--------------------------------------------------------------------------------------------------
;  XORs memory from HL to H=D, result in A,E & flags set
;       Called from L4B09 ROM checksum routine
;
L28D8:
        mvi     e,$00
L28DA:
        mov     a,e
        xra     m
        mov     e,a
        inx     h
        mov     a,d
        cmp     h
        jnz     L28DA                   ;
        mov     a,e
        ora     a
        ret

;--------------------------------------------------------------------------------------------------
; BW filter DIP switch to config map
;
L28E6:  .DW     L296E                   ; config 00
        .DW     L2926                   ; config 01 
        .DW     L2926                   ; config 02 
        .DW     L2926                   ; config 03
        .DW     L2953                   ; config 04 
        .DW     L2926                   ; config 05 
        .DW     L2926                   ; config 06 
        .DW     L2926                   ; config 07
        .DW     L295C                   ; config 08
        .DW     L294A                   ; config 09
        .DW     L2926                   ; config 0A
        .DW     L2926                   ; config 0B
        .DW     L2926                   ; config 0C 
        .DW     L2926                   ; config 0D 
        .DW     L2926                   ; config 0E
        .DW     L2926                   ; config 0F
        .DW     L2926                   ; config 10
        .DW     L2926                   ; config 11        DIP switch selects 1 of 10 IF filter descriptions
        .DW     L2941                   ; config 12
        .DW     L2965                   ; config 13
        .DW     L2926                   ; config 14 
        .DW     L2926                   ; config 15 
        .DW     L2926                   ; config 16 
        .DW     L2926                   ; config 17
        .DW     L2938                   ; config 18
        .DW     L2977                   ; config 19
        .DW     L2926                   ; config 1A
        .DW     L2926                   ; config 1B
        .DW     L2926                   ; config 1C
        .DW     L2926                   ; config 1D
        .DW     L292F                   ; config 1E
        .DW     L2926                   ; config 1F
 
; IF filter descriptions
;
;filt             1    2    3    4    5    6    7    8
;                --   --   --   --   --   --   --   --
L2926:  .DB     $1C, $1C, $05, $0A, $0D, $10, $1D, $14, $00
L292F:  .DB     $1C, $1C, $05, $0A, $0D, $12, $1D, $14, $FF 
L2938:  .DB     $1C, $1C, $05, $0A, $0D, $10, $1D, $14, $FF 
L2941:  .DB     $0C, $0C, $05, $00, $0A, $10, $0D, $14, $FF 
L294A:  .DB     $0E, $0E, $05, $0A, $0D, $12, $00, $14, $FF 
L2953:  .DB     $1E, $1E, $01, $05, $0A, $20, $1F, $14, $FF 
L295C:  .DB     $1C, $1C, $00, $12, $00, $00, $1D, $14, $FF 
L2965:  .DB     $0C, $0C, $05, $01, $0A, $10, $0D, $14, $FF
L296E:  .DB     $0E, $0E, $05, $0A, $0D, $10, $14, $15, $00 
L2977:  .DB     $21, $21, $05, $0A, $22, $10, $1D, $14, $FF 

;
; IF filter text and parameters
;
;                text     bw      
;                modes (3rd parm byte, bit0=7, 1=3, 2=1, 3=2, 4=8)
;
L2980:  .DW     L2A39, $0000            ;
        .DB     $00
L2985:  .DW     L2A3D, $000F            ; 3, 8     0.15    CW, FSK
        .DB     $12
L298A:  .DW     L2A3D, $000F            ; 8        0.15    FSK
        .DB     $10
L298F:  .DW     L2A41, $0011            ; 3        0.17    CW
        .DB     $02
L2994:  .DW     L2A45, $0019            ; 3        0.25    CW
        .DB     $02
L2999:  .DW     L2A49, $001E            ; 3, 8     0.30    CW, FSK
        .DB     $12
L299E:  .DW     L2A4D, $0028            ; 3        0.40    CW
        .DB     $02
L29A3:  .DW     L2A51, $0032            ; 3        0.50    CW
        .DB     $02
L29A8:  .DW     L2A55, $004B            ; 3        0.75    CW
        .DB     $02
L29AD:  .DW     L2A59, $0055            ; 8        0.85    FSK
        .DB     $10
L29B2:  .DW     L2A5D, $0064            ; 3, 8     1.00    CW, FSK
        .DB     $12
L29B7:  .DW     L2A61, $00C8            ; 1, 2     2.00    AM, FM
        .DB     $0C
L29BC:  .DW     L2A65, $010E            ; 7, 8     2.70    USB, FSK
        .DB     $11
L29C1:  .DW     L2A6D, $0140            ; 1        3.20    AM
        .DB     $04
L29C6:  .DW     L2A6D, $0140            ; 7, 8     3.20    USB, FSK
        .DB     $11
L29CB:  .DW     L2A71, $0190            ; 1        4.00    AM
        .DB     $04
L29D0:  .DW     L2A79, $0258            ; 1        6.00    AM
        .DB     $04
L29D5:  .DW     L2A79, $0258            ; 7        6.00    USB
        .DB     $01
L29DA:  .DW     L2A7D, $02A8            ; 1        6.80    AM
        .DB     $04
L29DF:  .DW     L2A81, $0320            ; 1        8.00    AM
        .DB     $04
L29E4:  .DW     L2A89, $0640            ; 1, 2    16.00    AM, FM
        .DB     $0C
L29E9:  .DW     L2A8D, $07D0            ; 1, 2    20.00    AM, FM
        .DB     $0C
L29EE:  .DW     L2A91, $0000            ; 1                AM
        .DB     $04
L29F3:  .DW     L2A91, $0000            ; 3                CW
        .DB     $02
L29F8:  .DW     L2A95, $0000            ; 1                AM
        .DB     $04
L29FD:  .DW     L2A95, $0000            ; 3                CW
        .DB     $02
L2A02:  .DW     L2A99, $0000            ; 1                AM
        .DB     $04
L2A07:  .DW     L2A99, $0000            ; 3                CW
        .DB     $02
L2A0C:  .DW     L2A69, $0118            ; 7, 8     2.80    USB, FSK
        .DB     $11
L2A11:  .DW     L2A85, $03E8            ; 1       10.00    AM
        .DB     $04
L2A16:  .DW     L2A65, $010E            ; 7, 3, 8  2.70    USB, CW, FSK
        .DB     $13
L2A1B:  .DW     L2A85, $03E8            ; 3, 1, 8 10.00    CW, AM, FSK
        .DB     $16
L2A20:  .DW     L2A79, $0258            ; 3, 1, 8  6.00    CW, AM, FSK
        .DB     $16
L2A25:  .DW     L2A75, $01F4            ; 7        5.00    USB
        .DB     $01
L2A2A:  .DW     L2A6D, $0140            ; 1, 8     3.20    AM, FSK
        .DB     $14
 
L2A2F:  .DB     $02, $00, $04, $00, $00, $00, $00, $00, $08, $10

;
; IF filter ASCII descriptions
;                                                       config codes     Used
L2A39:  .DB     "    "  ; 00                    Y
L2A3D:  .DB     ".15 "  ; 01, 02                Y
L2A41:  .DB     ".17 "  ; 03
L2A45:  .DB     ".25 "  ; 04
L2A49:  .DB     ".30 "  ; 05                    Y
L2A4D:  .DB     ".40 "  ; 06
L2A51:  .DB     ".50 "  ; 07
L2A55:  .DB     ".75 "  ; 08
L2A59:  .DB     ".85 "  ; 09
L2A5D:  .DB     "1.0 "  ; 0A                    Y
L2A61:  .DB     "2.0 "  ; 0B
L2A65:  .DB     "2.7 "  ; 0C, 1E                Y
L2A69:  .DB     "2.8 "  ; 1C                    Y
L2A6D:  .DB     "3.2 "  ; 0D, 0E, 22    Y
L2A71:  .DB     "4.0 "  ; 0F
L2A75:  .DB     "5.0 "  ; 21
L2A79:  .DB     "6.0 "  ; 10, 11, 20    Y
L2A7D:  .DB     "6.8 "  ; 12                    Y
L2A81:  .DB     "8.0 "  ; 13
L2A85:  .DB     "10. "  ; 1D, 1F
L2A89:  .DB     "16. "  ; 14                    Y
L2A8D:  .DB     "20. "  ; 15
L2A91:  .DB     "B.1 "  ; 16, 17
L2A95:  .DB     "B.2 "  ; 18, 19
L2A99:  .DB     "B.3 "  ; 1A, 1B

L2A9D:  .DB     "  ANTENNA OVERLOAD  "

;--------------------------------------------------------------------------------------------------
;       Ant overload, PLL unlocked code
L2AB1:
        lda     $ABEB                   ; in BITE mode if FF
        ora     a
        rnz
        in      $41                     ; 8255 Port B
        ani     $01
        jz      L2AF9                   ; jump if not antenna overload
        mvi     a,$FF
        sta     $ABF0
        lxi     h,$0101
        shld    $ABC9                   ; BITE fault code
        lda     $A682                   ; Status bits
        ani     $FE
        sta     $A682                   ; Status bits
        lda     $A682                   ; Status bits
        ori     $04
        sta     $A682                   ; Status bits
        call    L23B6                   ; Stopping scan, not due to received signal
        lxi     h,L2A9D                 ; '  ANTENNA OVERLOAD  '
        lxi     b,$141D
        call    L0645                   ; Display text message
        lxi     h,L4AF0                 ; dashes
        lxi     b,$0A09
        call    L0666                   ; Display B chars from [HL] to disp loc C
        lda     $ABB4
        ori     $01                     ; fault
        sta     $ABB4                   ; Front panel LEDs
        call    L09E0                   ; If not in BITE, make NB LED display NB status
        ret
L2AF9:
        lda     $ABF0
        ora     a
        rz
        xra     a
        sta     $ABF0
        lda     $ABEF                   ; PLL unlocked error flag
        ora     a
        jnz     L2B14
        lda     $ABB4
        ani     $FE                     ; clear fault
        sta     $ABB4                   ; Front panel LEDs
        call    L09E0                   ; If not in BITE, make NB LED display NB status
L2B14:
        lxi     h,$0000
        shld    $ABC9                   ; BITE fault code
        lda     $A682                   ; Status bits
        ori     $04
        sta     $A682                   ; Status bits
        mvi     a,$FF                   ; everything
        sta     $ABEC                   ; Display update control see L06FD
        ret
;--------------------------------------------------------------------------------------------------
;       PLL unlocked and 4ISB missing fault detection
L2B28:
        lda     $ABEB                   ; in BITE mode if FF
        ora     a
        rnz
        in      $41                     ; 8255 Port B
        ani     $10                     ; A12 ref gen PLL lock detect (0=locked)
        jnz     L2B64
        in      $81                     ; 8155 Port A
        mov     b,a                     ;                               !
        in      $82                     ; 8155 Port B                   !
        ani     $80                     ; BFO on/off                    !
        jz      L2B44                   ;                               !
        mvi     a,$14                   ; this code here is superfluous !
        ana     b                       ;                               !
        jmp     L2B45                   ;                               !
L2B44:                                  ;                               !
        mov     a,b                     ;                               !
L2B45:                                  ;                               !
        ani     $10
        jz      L2B64
        lda     $A55F                   ; mode & IF filter, present params
        ani     $0F
        cpi     $06                     ; is present mode 4ISB?
        jnz     L2B88
        lda     $A818                   ; 4ISB option flag, zero for no 4ISB
        cpi     $FF
        jz      L2B88
        mvi     a,$FF
        sta     $A819                   ; No 4ISB fault flag
        jmp     L2B69
L2B64:
        mvi     a,$FF
        sta     $ABEF                   ; PLL unlocked error flag
L2B69:
        lda     $A682                   ; Status bits
        ori     $10
        sta     $A682                   ; Status bits
        mvi     a,$FF
        lda     $ABB4                   ; Front panel LEDs
        mov     b,a
        ani     $01
        jnz     L2B85                   ; jump if fault LED set
        mvi     a,$01
        ora     b
        sta     $ABB4                   ; set fault LED (Front panel LEDs)
        call    L09E0                   ; If not in BITE, make NB LED display NB status
L2B85:                                  ; !
        jmp     L2BB8                   ; !
L2B88:                                  ; !
        lda     $ABF0
        ora     a
        jnz     L2BB8
        lda     $ABEF                   ; PLL unlocked error flag
        ora     a
        jnz     L2B9D
        lda     $A819                   ; No 4ISB fault flag
        ora     a
        jz      L2BB8
L2B9D:
        xra     a
        sta     $A819                   ; No 4ISB fault flag
        xra     a
        sta     $ABEF                   ; PLL unlocked error flag
        lda     $A682                   ; Status bits
        ani     $EF                     ; clear error condition
        sta     $A682                   ; Status bits
        lda     $ABB4
        ani     $FE                     ; clear fault
        sta     $ABB4                   ; Front panel LEDs
        call    L09E0                   ; If not in BITE, make NB LED display NB status
L2BB8:
        mvi     a,$1E
        sta     $ABD1                   ; Timer decrements this every 1 msec, but not below 0
        ret
;--------------------------------------------------------------------------------------------------
;
;       A/D read routine.  H is the channel number to read, A returns data.  Carry flag set if error.
;
L2BBE:
        push    h
        push    b
        mov     a,h                     ; A gets channel number
        ral
        ral
        ral
        ani     $78                     ; Multiply by 8
        mov     l,a
        mvi     h,$00                   ; HL is jump offset
        lxi     d,L2BCE
        dad     d                       ; Add jump offset to base
        pchl                            ; index jump
;
L2BCE:
        out     $50                     ; A/D Channel 0, 4ISB Detect
        out     $50
        jmp     L2C4E
        nop
;
        out     $51                     ; A/D Channel 1, 
        out     $51
        jmp     L2C4E
        nop
;
        out     $52                     ; A/D Channel 2, RF Gain (D/A feedback)
        out     $52
        jmp     L2C4E
        nop
;
        out     $53                     ; A/D Channel 3, Test Monitor (A3 Det)
        out     $53
        jmp     L2C4E
        nop
;
        out     $54                     ; A/D Channel 4, 
        out     $54
        jmp     L2C4E
        nop
;
        out     $55                     ; A/D Channel 5, Det IF Input
        out     $55
        jmp     L2C4E
        nop
;
        out     $56                     ; A/D Channel 6, Test Monitor (A1 BITE Det Out)
        out     $56
        jmp     L2C4E
        nop
;
        out     $57                     ; A/D Channel 7, Test Monitor (A2 Detect)
        out     $57
        jmp     L2C4E
        nop
;
        out     $58                     ; A/D Channel 8, RF Gain
        out     $58
        jmp     L2C4E
        nop
;
        out     $59                     ; A/D Channel 9, Preselector Filter ID
        out     $59
        jmp     L2C4E
        nop
;
        out     $5A                     ; A/D Channel A, AGC
        out     $5A
        jmp     L2C4E
        nop
;
        out     $5B                     ; A/D Channel B,
        out     $5B
        jmp     L2C4E
        nop
;
        out     $5C                     ; A/D Channel C, 2nd IF AGC
        out     $5C
        jmp     L2C4E
        nop
;
        out     $5D                     ; A/D Channel D, IF Input Detect
        out     $5D
        jmp     L2C4E
        nop
;
        out     $5E                     ; A/D Channel E, Line Audio Detect Out
        out     $5E
        jmp     L2C4E
        nop
;
        out     $5F                     ; A/D Channel F, ISB Line Audio Detect
        out     $5F
        jmp     L2C4E
        nop
;
L2C4E:
        mvi     a,$05                   ; Count for...
L2C50:
        dcr     a
        jnz     L2C50                   ; ...short delay loop
        mvi     b,$50
L2C56:
        in      $41                     ; Look at EOC line, 8255 Port B
        ani     $80
        jnz     L2C65                   ; If true, get A/D result
        dcr     b
        jnz     L2C56                   ; If false, try again (80 loops max)
        stc                                     ; Set carry flag if A/D fault
        pop     b
        pop     h
        ret
L2C65:
        in      $50                     ; A/D read
        stc
        cmc                             ; Clear carry flag if successful
        pop     b
        pop     h
        ret
;--------------------------------------------------------------------------------------------------
;       RF gain setting code
L2C6C:
        lda     $ABBD                   ; Numerical keypad applicability
        cpi     $0A
        rz                              ; return if 'stop threshold'
        lda     $A821                   ; =$FF if RF590A
        ora     a
        jnz     L2C7D
        call    L2C81                   ; Set RF gain of receiver (not 590A)
        ret
L2C7D:
        call    L2CBF                   ; Set RF gain of receiver (590A)
        ret
;--------------------------------------------------------------------------------------------------
;       Set RF gain of receiver (not 590A)
L2C81:
        lda     $A679                   ; Status bits
        ani     $80
        jnz     L2C99                   ; jump if local control mode
        lda     $A80F                   ; RF gain via remote
        mov     b,a
        lda     $A67B                   ; RF atten
        cmp     b
        rz
        sta     $A80F                   ; RF gain via remote
        cma
        jmp     L2CAD
L2C99:
        mvi     h,$58                   ; RF Gain pot
        call    L2BBE                   ; A/D read routine.  Channel H, A has data, carry if error.
        rc
        mov     b,a
        lxi     h,$A574                 ; D/A value for RF gain
        sub     m
        jnc     L2CA9
        cma
        inr     a
L2CA9:
        sui     $02
        rc
        mov     a,b
L2CAD:
        di                              ; Disable Interrupts
        out     $70                     ; (Serial bus data)
        sta     $A574                   ; D/A value for RF gain
        cma
        sta     $A67B                   ; RF atten
        nop
        nop
        nop
        nop
        out     $61                     ; Set Serial Data strobe to D/A
        ei                              ; Enable interrupts
        ret
;--------------------------------------------------------------------------------------------------
;       Set RF gain of receiver (590A)
L2CBF:
        lda     $A552                   ; new cmded AGC speed pointer
        ani     $0F
        cpi     $07
        jz      L2CE4
        cpi     $04
        jz      L2CE4
        cpi     $06
        jnz     L2CDB
        call    L5506                   ; Get into A from $55B0 lookup table the byte offset by val of $A82F
        cpi     $04
        jz      L2CE4
L2CDB:
        mvi     a,$FF
        sta     $A820
        cma
        jmp     L2D25
L2CE4:
        lda     $A679                   ; Status bits
        ani     $80
        jnz     L2D0C                   ; jump if local control mode
        lda     $A80F                   ; RF gain via remote
        mov     b,a
        lda     $A820
        ora     a
        jz      L2CFF
        xra     a
        sta     $A820
        mov     a,b
        jmp     L2D06
L2CFF:
        lda     $A67B                   ; RF atten
        cmp     b
        jz      L2D21
L2D06:
        sta     $A80F                   ; RF gain via remote
        jmp     L2D21
L2D0C:
        mvi     h,$58                   ; RF Gain
        call    L2BBE                   ; A/D read routine.  Channel H, A has data, carry if error.
        rc
        mov     b,a
        lxi     h,$A574                 ; D/A value for RF gain
        sub     m
        jnc     L2D1C
        cma
        inr     a
L2D1C:
        sui     $02
        rc
        mov     a,b
        cma
L2D21:
        sta     $A67B                   ; RF atten
        cma
L2D25:
        di                              ; Disable Interrupts
        out     $70                     ; (Serial bus data)
        sta     $A574                   ; D/A value for RF gain
        nop
        nop
        nop
        nop
        out     $61                     ; Set Serial Data strobe to D/A
        ei                              ; Enable interrupts
        ret
;--------------------------------------------------------------------------------------------------
;
;       Read 2nd IF AGC & store at $A839
;
L2D33:
        mvi     h,$5C                           ; 2nd IF AGC
        call    L2BBE                           ; A/D read routine.  Channel H, A has data, carry if error.
        rc
        sta     $A839
        ret
;--------------------------------------------------------------------------------------------------
;
;       Read AGC and store at $A83A
;
L2D3D:
        mvi     h,$5A                           ; AGC
        call    L2BBE                           ; A/D read routine.  Channel H, A has data, carry if error.
        rc
        sta     $A83A
        ret
;--------------------------------------------------------------------------------------------------
;
;       Read Line Audio & store at $A83B
;
L2D47:
        mvi     h,$5E                           ; Line Audio Detect
        call    L2BBE                           ; A/D read routine.  Channel H, A has data, carry if error.
        rc
        sta     $A83B
        ret
;--------------------------------------------------------------------------------------------------
;
;       Read ISB Audio & store at $A83C
;
L2D51:
        mvi     h,$5F                           ; ISB Audio detect
        call    L2BBE                           ; A/D read routine.  Channel H, A has data, carry if error.
        rc
        sta     $A83C
        ret
;--------------------------------------------------------------------------------------------------
;       Set radio, section controlled by bits in $ABED
L2D5B:
        mvi     a,$1E
        sta     $AB94                   ; Timer decrements this every 1 msec, but not below 0
        call    L2D83                   ; Set FSK parameters
        lda     $ABED
        mov     b,a
        xra     a
        sta     $ABED                   ; clear radio update flags
        mov     a,b
        rrc
        rrc
        rrc                             ; if $04 bit set,
        cc      L2E1A                   ; Set AGC control lines
        rrc                             ; if $08 bit set,
        cc      L2E6A                   ; Set IF filter
        rrc                             ; if $10 bit set,
        cc      L2EBD                   ; Set audio path and mode
        rrc                             ; if $20 bit set,
        cc      L2FA9                   ; Set BFO
        rrc                             ; if $40 bit set,
        cc      L3098                   ; Set Synth; recv freq in $A54B-E, $AC3D determines offset (USB, AM, or LSB)
        ret
;--------------------------------------------------------------------------------------------------
;       Set FSK parameters
L2D83:
        push    psw
        push    b
        lda     $A82A                   ; FSK variable
        mov     b,a
        lda     $A551                   ; mode & IF filter, new commanded rcv params
        ani     $0F
        cpi     $09
        jz      L2D99                   ; jump if mode is FSK
        mov     a,b
        ani     $EF
        jmp     L2DFE
L2D99:
        lda     $ABEB                   ; in BITE mode if FF
        ora     a
        mov     a,b
        jnz     L2DA6
        ori     $10
        jmp     L2DA8
L2DA6:
        ani     $EF
L2DA8:
        mov     b,a
        lda     $A556                   ; FSK shift & pol
        ani     $03
        mov     c,a
        add     a
        mov     e,a
        mvi     d,$00
        lxi     h,L2E07
        dad     d
        mov     a,m
        sta     $D800                   ; FSK option memory space
        inx     h
        mov     a,m
        sta     $D800                   ; FSK option memory space
        lxi     h,L2E0F
        dad     d
        mov     a,m
        sta     $C800                   ; FSK option memory space
        inx     h
        mov     a,m
        sta     $C800                   ; FSK option memory space
        lda     $A556                   ; FSK shift & pol
        ani     $80
        mov     a,b
        jz      L2DDB
        ani     $F7
        jmp     L2DDD
L2DDB:
        ori     $08
L2DDD:
        mov     b,a
        mov     a,c
        cpi     $03
        jz      L2DEA
        mvi     a,$20
        ora     b
        jmp     L2DED
L2DEA:
        mvi     a,$DF
        ana     b
L2DED:
        ani     $F8
        mov     b,a
        mov     e,c
        mvi     d,$00
        lxi     h,$A82B                 ; FSK option values
        dad     d
        mov     e,m
        lxi     h,L2E17
        dad     d
        mov     a,m
        ora     b
L2DFE:
        sta     $C200                   ; FSK option memory space
        sta     $A82A                   ; FSK variable
        pop     b
        pop     psw
        ret

L2E07:  .DB     $64, $00, $3C, $00
        .DB     $1E, $00, $0F, $00
L2E0F:  .DB     $C4, $09, $DC, $05
        .DB     $EE, $02, $77, $01
L2E17:  .DB     $06, $05, $03

;--------------------------------------------------------------------------------------------------
;       Set AGC control lines
L2E1A:
        push    psw
        lda     $A823
        cpi     $FF
        jnz     L2E2D
        mvi     a,$1E
        sta     $A824                   ; Timer decrements this every 1 msec, but not below 0
        mvi     a,$01
        jmp     L2E3A
L2E2D:
        lda     $A552                   ; AGC speed pointer
        ani     $0F
        cpi     $06
        jnz     L2E3A                   ; jump if not 6
        call    L5506                   ;  (if 6) Get into A from $55B0 lookup table the byte offset by val of $A82F
L2E3A:
        mvi     c,$10
        mvi     d,$00
        cpi     $05                     ; 5?
        jz      L2E5A                   ; jump if 5
        mvi     d,$10
        cpi     $00
        mvi     c,$00
        jz      L2E5A                   ; jump if 0
        dcr     a
        mvi     c,$10
        jz      L2E5A                   ; jump if 1
        dcr     a
        mvi     c,$20
        jz      L2E5A                   ; jump if 2
        mvi     c,$08
L2E5A:
        in      $82                     ; 8155 Port B
        ani     $C7
        ora     c
        out     $82                     ; 8155 Port B, set 3 AGC control lines
        in      $83                     ; 8155 Port C
        ani     $EF
        ora     d
        out     $83                     ; 8155 Port C, set data AGC control line
        pop     psw
        ret
;--------------------------------------------------------------------------------------------------
;       Set IF filter
L2E6A:
        push    psw
        lda     $A551                   ; mode & IF filter, new commanded rcv params
        mov     c,a
        ani     $F0
        rlc
        rlc
        rlc
        rlc
        ora     a
        jnz     L2E99                   ; jump if not filter 0 (LSB, ISB)
        mov     a,c
        ani     $0F
        mvi     b,$01
        cpi     $05                     ; 2ISB ?
        jz      L2EA0                   ; jump if 2ISB
        cpi     $06                     ; 4ISB ?
        jz      L2EA0                   ; jump if 4ISB
        lda     $ABC5                   ; 2ISB option installed flag (0=not installed, FF=installed)
        ora     a
        jz      L2E94
        mvi     b,$09
        jmp     L2EA0
L2E94:
        mvi     b,$02
        jmp     L2EA0
L2E99:
        dcr     a
        mov     b,a
        jz      L2EA0
        inr     b
        inr     b
L2EA0:
        call    L2F1C                   ; Set synth, BFO by mode/filter
        mov     a,b
        cpi     $04
        jnz     L2EB4
        in      $70                             ; BW filter config switch
        ani     $1F
        cpi     $12
        jnz     L2EB4
        mvi     b,$03
L2EB4:
        in      $83                             ; 8155 Port C
        ani     $F0
        ora     b
        out     $83                             ; 8155 Port C (set IF filter)
        pop     psw
        ret
;--------------------------------------------------------------------------------------------------
;       Set audio path and mode
L2EBD:
        push    psw
        lda     $A551                   ; mode & IF filter, new commanded rcv params
        ani     $0F
        mov     b,a                     ; mode to B
        lda     $ABC5                   ; 2ISB option installed flag (0=not installed, FF=installed)
        ora     a
        mov     a,b
        jz      L2EEE                   ; jump if 2ISB not installed
        cpi     $05
        jz      L2ED6                   ; jump if desired mode is 2ISB
        cpi     $06
        jnz     L2EE0                   ; jump if desired mode is not 4ISB
L2ED6:
        in      $42                     ; 8255 Port C
        ani     $20                     ; LSB select from meter board
        jz      L2F0A
        jmp     L2EE5
L2EE0:
        cpi     $04
        jnz     L2EEE                   ; jump if desired mode not LSB
L2EE5:
        mvi     b,$05
        pop     psw
        ori     $01
        push    psw
        jmp     L2F10
L2EEE:
        cpi     $02
        jnz     L2EFC                   ; jump if desired mode not AM
        mvi     b,$80
        pop     psw
        ani     $FE
        push    psw
        jmp     L2F10
L2EFC:
        cpi     $08
        jnz     L2F0A                   ; jump if desired mode not FM
        mvi     b,$82
        pop     psw
        ani     $FE
        push    psw
        jmp     L2F10
L2F0A:
        mvi     b,$04
        pop     psw
        ori     $01
        push    psw
L2F10:
        in      $82                     ; 8155 Port B
        ani     $78
        ora     b
        out     $82                     ; 8155 Port B
        call    L2F1C                   ; Set synth, BFO by mode/filter
        pop     psw
        ret
;--------------------------------------------------------------------------------------------------
;       Set synth, BFO by mode/filter
L2F1C:
        lda     $A551                   ; mode & IF filter, new commanded rcv params
        ani     $0F
        cpi     $04
        jz      L2F84                   ; jump if desired mode is LSB
        lda     $A551                   ; mode & IF filter, new commanded rcv params
        ani     $F0
        cpi     $10
        jz      L2F4F                   ; jump if desired filter is 2
        cpi     $40
        jz      L2F5C                   ; jump if desired filter is 5
L2F35:                      ; USB
        lda     $AC3D                   ; Synth offset ( 0 = USB, 1 = AM, 2 = LSB )
        ora     a
        jz      L2F4E
        xra     a
        sta     $AC3D                   ; set Synth offset for USB
        push    h
        push    d
        push    b
        push    psw
        call    L3098                   ; Set Synth; recv freq in $A54B-E, $AC3D determines offset (USB, AM, or LSB)
        call    L2FA9                   ; Set BFO
        pop     psw
        pop     b
        pop     d
        pop     h
L2F4E:
        ret
L2F4F:
        lda     $A551                   ; mode & IF filter, new commanded rcv params
        ani     $0F
        cpi     $03
        jnz     L2F66                   ; jump if desired mode not USB
        jmp     L2F35
L2F5C:
        lda     $AC00                   ; extra filter data
        ora     a
        jnz     L2F35                   ; do USB if not zero
        jmp     L2F66
L2F66:                      ; AM
        mvi     b,$00
        lda     $AC3D                   ; Synth offset ( 0 = USB, 1 = AM, 2 = LSB )
        cpi     $01
        jz      L2F83                   ; jump if AM synth offset
        mvi     a,$01
        sta     $AC3D                   ; Synth offset for AM
        push    h
        push    d
        push    b
        push    psw
        call    L3098                   ; Set Synth; recv freq in $A54B-E, $AC3D determines offset (USB, AM, or LSB)
        call    L2FA9                   ; Set BFO
        pop     psw
        pop     b
        pop     d
        pop     h
L2F83:
        ret
L2F84:
        lda     $ABC5                   ; 2ISB option installed flag (0=not installed, FF=installed)
        ora     a
        jnz     L2F35
        mvi     b,$00
        lda     $AC3D                   ; Synth offset ( 0 = USB, 1 = AM, 2 = LSB )
        cpi     $02
        jz      L2FA8
        mvi     a,$02
        sta     $AC3D                   ; set Synth offset for LSB
        push    h
        push    d
        push    b
        push    psw
        call    L3098                   ; Set Synth; recv freq in $A54B-E, $AC3D determines offset (USB, AM, or LSB)
        call    L2FA9                   ; Set BFO
        pop     psw
        pop     b
        pop     d
        pop     h
L2FA8:
        ret
;--------------------------------------------------------------------------------------------------
;       Set BFO
;
L2FA9:
        push    psw
        lda     $A551                   ; mode & IF filter, new commanded rcv params
        ani     $0F
        cpi     $02                     ; AM? exit if so
        jz      L3081
        cpi     $08                     ; FM? exit if so
        jz      L3081
        lda     $AC3D                   ; Synth offset ( 0 = USB, 1 = AM, 2 = LSB )
        cpi     $01                     ; AM
        jnz     L2FD4
        lxi     h,L3086                 ; 30 53 04
        lxi     d,$ABE4
        mvi     b,$03
L2FC9:
        mov     a,m
        stax    d                       ; $ABE4=30 $ABE5=53 $ABE6=04    453 KHz
        inx     h
        inx     d
        dcr     b
        jnz     L2FC9
        jmp     L2FFC
L2FD4:
        cpi     $02                     ; LSB
        jnz     L2FEC
        lxi     h,L3089                 ; 60 51 04
        lxi     d,$ABE4
        mvi     b,$03
L2FE1:
        mov     a,m
        stax    d                       ; $ABE4=60 $ABE5=51 $ABE6=04    451 KHz
        inx     h
        inx     d
        dcr     b
        jnz     L2FE1
        jmp     L2FFC
L2FEC:                                  ; USB
        lxi     h,L3083                 ; 00 55 04
        lxi     d,$ABE4
        mvi     b,$03
L2FF4:
        mov     a,m
        stax    d                       ; $ABE4=00 $ABE5=55 $ABE6=04    455 KHz
        inx     h
        inx     d
        dcr     b
        jnz     L2FF4
L2FFC:
        lda     $A551                   ; mode & IF filter, new commanded rcv params
        ani     $0F
        cpi     $09
        jnz     L302F                   ; jump if not FSK mode
        lda     $A556                   ; FSK shift & pol
        ani     $03     ; A=0 to 3
        mov     c,a     ; C=A
        add     a       ; A=2A
        add     c       ; A=3A
        mov     l,a
        mvi     h,$00
        lxi     d,L308C
        dad     d
        lxi     d,$ABE4
        xchg
        mvi     c,$03
        lda     $A555                   ; FSK center freq
        ani     $80
        jnz     L3029
        call    L2873                   ; (HL)=daa[(HL)+(DE)] for C locations
        jmp     L305A
L3029:
        call    L285B                   ; (HL)=daa[$99-(DE)+(HL)] for C locations
        jmp     L305A
L302F:
        lhld    $A54F                   ; BFO LSB
        mov     a,h
        ani     $F0
        mov     b,a                     ; B=BFO sign
        mov     a,h
        ani     $0F
        mov     d,a                     ; D=BFO MSB
        mov     e,l                     ; E=BFO LSBs
        lxi     h,$ABE3
        mvi     m,$00                   ; $ABE3=0
        dcx     h
        mov     m,d                     ; $ABE2=BFO MSB
        dcx     h                       
        mov     m,e                     ; $ABE1=BFO LSBs
        lxi     d,$ABE1
        lxi     h,$ABE4
        mvi     c,$03
        mov     a,b
        ora     a
        jz      L3057
        call    L2873                   ; (HL)=daa[(HL)+(DE)] for C locations
        jmp     L305A
L3057:
        call    L285B                   ; (HL)=daa[$99-(DE)+(HL)] for C locations
L305A:
        lxi     h,$ABE4
        mov     b,m                     ; B=$ABE4
        call    L2800                   ; Convert BCD B to number in A, carry set if B not good BCD
        sta     $ABE7                   ; 
        inx     h
        mov     b,m                     ; B=$ABE5
        call    L2800                   ; Convert BCD B to number in A, carry set if B not good BCD
        mov     e,a     
        mvi     d,$00
        lxi     h,$0190
        dad     d
        mov     b,h
        mov     c,l
        lda     $ABE7
        mov     d,a
        call    L3144                   ; Send rotated B, C, D to serial bus
        out     $68                     ; Set Serial Data strobe to BFO
        ei                              ; Enable interrupts
        mvi     a,$1E
        sta     $ABD1                   ; Timer decrements this every 1 msec, but not below 0
L3081:
        pop     psw
        ret


L3083:  .DB     $00, $55, $04
L3086:  .DB     $30, $53, $04
L3089:  .DB     $60, $51, $04


L308C:  .DB     $30, $00, $00, $50, $00, $00
        .DB     $00, $01, $00, $00, $02, $00

;--------------------------------------------------------------------------------------------------
;
;       Set Synth; recv freq in $A54B-E, $AC3D determines offset (USB, AM, or LSB)
;
L3098:
        push    psw
        lhld    $A54B                   ; new commanded receiver params block beginning
        shld    $ABE1                   ; $ABE1=$A54B, $ABE2=$A54C
        lhld    $A54D
        shld    $ABE3                   ; $ABE3=$A54D, $ABE4=$A54E
        lxi     h,$ABE1                 ; HL=$ABE1
        lda     $AC3D                   ; Synth offset ( 0 = USB, 1 = AM, 2 = LSB )
        lxi     d,L3140                 ; DE = 00 16 45 40 (if $AC3D = 2); add 40.4516000 MHz for LSB
        cpi     $02
        jz      L30BE
        lxi     d,L313C                 ; DE = 00 33 45 40 (if $AC3D = 1); add 40.4533000 MHz for AM
        cpi     $01
        jz      L30BE
        lxi     d,L3138                 ; DE = 00 50 45 40 (if $AC3D neither 1 or 2); add 40.455000 MHz for USB
L30BE:
        mvi     c,$04
        call    L2873                   ; ($ABE1)=daa[($ABE1)+(DE)] for 4 locations
        lda     $A551                   ; mode & IF filter, new commanded rcv params
        ani     $0F
        cpi     $09
        jnz     L30F9                   ; jump if low 4 bits of $A551 are not 9 (jump if not FSK mode)
        ;
        ; the following (up to L30F9) is for FSK mode only
        ;
        lhld    $A554                   ; L=$A554, H=$A555      ; FSK center freq
        lxi     d,$A826                 ; DE='A826'
        xchg                            ; HL='A826' D=($A554) E=($A555)
        mov     m,e                     ; $A826=($A555)
        mov     a,d                     ; A=($A554)
        ani     $3F
        inx     h                       ; HL='A827'
        mov     m,a                     ; $A827=($A554) and $3F
        inx     h                       ; HL='A828'
        xra     a                       ; A=0
        mov     m,a                     ; $A828=0
        inx     h                       ; HL='A829'
        mov     m,a                     ; $A829=0
        mov     a,d                     ; A=($A554)
        ani     $80
        mov     b,a                     ; B=($A554) and $80
        lxi     h,$ABE1                 ; HL='ABE1'
        lxi     d,$A826                 ; DE='A826'
        mvi     c,$04
        mov     a,b             
        ora     a
        jnz     L30F6                   ; jump if bit 80 of $A554 is set
        call    L2873                   ; (HL)=daa[(HL)+(DE)] for C locations
        jmp     L30F9
L30F6:
        call    L285B                   ; (HL)=daa[$99-(DE)+(HL)] for C locations
L30F9:
        lhld    $ABE3
        call    L326D                   ; Rotate HL register right 4 times, fill zeroes into upper bits
        mov     b,h                     ; 10 MHz digit
        mov     c,l                     ; 1 MHz and 100 KHz digits
        push    b
        lhld    $ABE2
        call    L326D                   ; Rotate HL register right 4 times, fill zeroes into upper bits
        mov     d,l                     ; 10 KHz and 1 KHz digits
        lhld    $ABE1
        call    L326D                   ; Rotate HL register right 4 times, fill zeroes into upper bits
        mov     e,l                     ; 100 Hz and 10 Hz digits
        pop     b
        lda     $ABE1
        ani     $0F
        rlc
        rlc
        rlc
        rlc
        mov     h,a
        call    L3160                   ; Set 1st LO from B, C, D, E, H
        ei                              ; Enable interrupts
        mvi     h,$59                   ; Presel filter ID
        call    L2BBE                   ; A/D read routine.  Channel H, A has data, carry if error.
        cpi     $66
        jc      L3131
        cpi     $9A
        jnc     L3131
        call    L327C                   ; Set preselector (use $A54D and E values)
L3131:
        mvi     a,$1E
        sta     $ABD1                   ; Timer decrements this every 1 msec, but not below 0
        pop     psw                     ; 2B28 called when this hits 0 (31 msec)
        ret

; VCO offsets for USB, AM, LSB
L3138:  .DB     $00, $50, $45, $40      ; 40.455000 MHz
L313C:  .DB     $00, $33, $45, $40      ; 40.453300 MHz
L3140:  .DB     $00, $16, $45, $40      ; 40.451600 MHz

;--------------------------------------------------------------------------------------------------
;       Send rotated B, C, D to serial bus
;
L3144:
        mov     a,d
        rlc
        mov     d,a                     ; RLC D
        stc
        cmc
        mov     a,b
        rar
        mov     b,a                     ; RAR B, bit 7 = 0
        mov     a,c
        rar
        mov     c,a                     ; bit 7 of C gets old bit 0 of B
        mov     a,d
        rar
        mov     d,a                     ; bit 7 of D gets old bit 0 of C
        mov     a,b
        di                                      ; Disable Interrupts
        call    L322C                           ; Send B to Serial Bus
        mov     a,c
        call    L322C                           ; Send C to Serial Bus
        mov     a,d
        call    L322C                           ; Send D to Serial Bus
        ret
;--------------------------------------------------------------------------------------------------
;       Set 1st LO from B, C, D, E, H
;
;       If $AC3C = 0, VCO range switch at 55.5 MHz, else VCO range shift occurs at 55.3 MHz
;
;       B 7     unused
;         6     unused
;         5     unused (becomes loop filter control bit)
;         4     unused (becomes VCO range control bit)
;         3     10 MHz 8 bit (always 0)
;         2     10 MHz 4 bit
;         1     10 MHz 2 bit
;         0     10 MHz 1 bit
;
;       C 7     1 MHz 8 bit
;         6     1 MHz 4 bit
;         5     1 MHz 2 bit
;         4     1 MHz 1 bit
;         3     100 KHz 8 bit
;         2     100 KHz 4 bit
;         1     100 KHz 2 bit
;         0     100 KHz 1 bit
;
;       D 7     10 KHz 8 bit
;         6     10 KHz 4 bit
;         5     10 KHz 2 bit
;         4     10 KHz 1 bit
;         3     1 KHz 8 bit
;         2     1 KHz 4 bit
;         1     1 KHz 2 bit
;         0     1 KHz 1 bit
;
;       E 7     100 Hz 8 bit
;         6     100 Hz 4 bit
;         5     100 Hz 2 bit
;         4     100 Hz 1 bit
;         3     10 Hz 8 bit
;         2     10 Hz 4 bit
;         1     10 Hz 2 bit
;         0     10 Hz 1 bit
;
;       H 7     1 Hz 8 bit
;         6     1 Hz 4 bit
;         5     1 Hz 2 bit
;         4     1 Hz 1 bit
;         3     unused
;         2     unused
;         1     unused
;         0     unused
;
L3160:
        lda     $AC3C
        cpi     $00
        jnz     L3174
        mov     a,b
        cpi     $05
        jz      L3189
        jc      L319A
        jnc     L318F
L3174:
        mov     a,b
        cpi     $05
        jz      L3180
        jc      L319A
        jnc     L318F
L3180:
        mov     a,c
        cpi     $53
        jc      L319A
        jnc     L318F
L3189:
        mov     a,c
        cpi     $55
        jc      L319A
L318F:
        mvi     a,$FF
        sta     $AC3C
        mov     a,b
        ori     $10
        jmp     L31A0
L319A:
        mvi     a,$00
        sta     $AC3C
        mov     a,b
L31A0:
        push    psw
        mov     a,b
        cpi     $04
        jnz     L31B3
        mov     a,c
        cpi     $05
        jnz     L31B3
        mov     a,d
        cpi     $05
        jz      L31B6
L31B3:
        jnc     L31BE
L31B6:
        xra     a
        sta     $A81D
        pop     psw
        jmp     L31C6
L31BE:
        mvi     a,$FF
        sta     $A81D
        pop     psw
        ori     $20
L31C6:
        push    psw
        lda     $A81F
        mov     l,a
        lda     $AC3C
        cmp     l
        jz      L31D8
        sta     $A81F
        jmp     L31E6
L31D8:
        lda     $A81E
        mov     l,a
        lda     $A81D
        cmp     l
        jz      L31FD
        sta     $A81E
L31E6:
        lda     $ABEB                   ; in BITE mode if FF
        ora     a
        jnz     L31FD
        mvi     l,$FF
        in      $83                             ; 8155 Port C
        sta     $A822
        ani     $F0
        ori     $07
        out     $83                             ; 8155 Port C (set IF filter)
        jmp     L31FF
L31FD:
        mvi     l,$00
L31FF:
        pop     psw
        di                                      ; Disable Interrupts
        call    L322C                           ; Send A to Serial Bus
        mov     a,c
        call    L322C                           ; Send C to Serial Bus
        mov     a,d
        call    L322C                           ; Send D to Serial Bus
        mov     a,e
        call    L322C                           ; Send E to Serial Bus
        mov     a,h
        ani     $F0
        call    L322C                           ; Send H (with low 4 bits cleared) to Serial Bus
        out     $60                             ; Set Serial Data strobe to Synthesizer
        ei                                      ; Enable interrupts
        mov     a,l
        cpi     $FF
        jnz     L322B
        push    d
        mvi     d,$02
        call    L52CA                           ; 20 msec delay
        pop     d
        lda     $A822
        out     $83                             ; 8155 Port C (set IF filter)
L322B:
        ret
;--------------------------------------------------------------------------------------------------
;
;       Send A to Serial Bus
;
L322C:
        out     $70                             ; (Serial bus data)
        nop
        nop
        nop
        nop
        nop
        ret
;--------------------------------------------------------------------------------------------------
;       Disconnect ant and mute audio if called with carry set
;
L3234:                          ;
        push    h               ;
        push    d               ;
        push    b               ;
        push    psw             ;
        mvi     d,$00
        mvi     b,$00
        jc      L3247                           ; jmp if called w carry set
        lda     $A67C                   ; NB/mute status
        ani     $FE                     ; clear mute bit
        jmp     L3250
L3247:
        mvi     b,$40
        mvi     d,$08
        lda     $A67C                   ; NB/mute status
        ori     $01                     ; set mute bit
L3250:                          ;cy=0: clr MSB of $A67C, B=0, D=0; cy=1: set MSB of $A67C, B=40, D=8 
        sta     $A67C
        in      $82                             ; 8155 Port B
        ani     $BF                             ; MUTE control bit to IF
        ora     b
        out     $82                             ; 8155 Port B
        lda     $ABEB                   ; in BITE mode if FF
        ora     a
        jnz     L3268
        in      $40                             ; 8255 Port A
        ani     $F7                             ; A1 relay control
        ora     d
        out     $40                             ; 8255 Port A
L3268:
        pop     psw             ;
        pop     b               ;
        pop     d               ;
        pop     h               ;
        ret                     ;
;--------------------------------------------------------------------------------------------------
;       Rotate HL register right 4 times, fill zeroes into upper bits
;
L326D:
        mvi     c,$04
L326F:
        stc
        cmc
        mov     a,h
        rar
        mov     h,a
        mov     a,l
        rar
        mov     l,a
        dcr     c
        jnz     L326F
        ret
;--------------------------------------------------------------------------------------------------
;       Set preselector (use $A54D and E values)
;
L327C:
        lda     $A679                   ; Status bits
        ani     $80
        jnz     L328B                   ; jump if local control mode
        lda     $A68E
        ora     a
        jnz     L32B1
L328B:
        lda     $ABCB
        cpi     $0E
        jnz     L32CD
        lda     $A577                   ; Flag, tuning wheel active for scan chan select
        ora     a
        jnz     L32CD
        lda     $A575                   ; Actively scanning flag ($FF means actively scanning)
        ora     a
        jz      L32CD
        lda     $A57E
        cpi     $FF
        jz      L32CD
        lda     $ABD8                   ; reflects Scan Stop input from back panel (=0 or =2)
        ani     $02
        jnz     L32CD
L32B1:
        lda     $A821                   ; =$FF if RF590A
        ora     a
        jz      L32BE
        lxi     h,$C200                 ; FSK option memory space
        jmp     L32C1
L32BE:
        lxi     h,$0596
L32C1:
        lda     $A67C                   ; NB/mute status
        ori     $10
        sta     $A67C                   ; NB/mute status
        mov     a,h
        jmp     L3308
L32CD:
        lda     $A67C                   ; NB/mute status
        ani     $EF
        sta     $A67C                   ; NB/mute status
        lda     $A54D
        mov     b,a
        call    L2800           ; Convert BCD B to number in A, carry set if B not good BCD
        mov     c,a
        lda     $A54E
        push    psw
        ani     $0F
        mov     b,a
        lxi     d,$0064
        lxi     h,$0000
        ora     a
        jz      L32F3
L32EE:
        dad     d
        dcr     b
        jnz     L32EE
L32F3:
        dad     b
        stc
        cmc
        mvi     b,$04
L32F8:
        mov     a,l
        ral                     ; bit 0 = carry
        mov     l,a
        mov     a,h
        ral
        mov     h,a
        dcr     b
        jnz     L32F8
        pop     psw
        ani     $30
        ral
        ral
        ora     h
L3308:
        di                                      ; Disable Interrupts
        call    L322C                           ; Send A to Serial Bus
        mov     a,l
        call    L322C                           ; Send A to Serial Bus
        out     $69                             ; Set Serial Data strobe to Preselector
        ei                                      ; Enable interrupts
        ret
;--------------------------------------------------------------------------------------------------
; set preselector after checking preselector filter ID between $66 and $9A
L3314:
        push    h
        push    d
        push    b
        push    psw
        mvi     h,$59                   ; Preselector Filter ID
        call    L2BBE                   ; A/D read routine.  Channel H, A has data, carry if error.
        cpi     $66
        jc      L332A                   ; exit if < $66 or > $9A
        cpi     $9A
        jnc     L332A
        call    L327C                   ; Set preselector (use $A54D and E values)
L332A:
        pop     psw
        pop     b
        pop     d
        pop     h
        ret
;--------------------------------------------------------------------------------------------------
;       Send data out rear panel serial bus
L332F:
        lda     $ABEB                   ; in BITE mode if FF
        ora     a
        rnz                             ; exit if in BITE
        lda     $A551                   ; mode & IF filter, new commanded rcv params
        ani     $0F
        cpi     $08
        jnz     L3340                   ; jump if not FM
        mvi     a,$06
L3340:
        rrc
        rrc
        rrc
        mov     b,a
        lda     $A550                   ; BFO MSB & sign
        mov     c,a
        ani     $0F
        mov     d,a
        mov     a,c
        ani     $F0
        jz      L3353
        mvi     a,$10
L3353:
        ora     d
        ora     b
        sta     $ABE8
        mvi     b,$00
        lda     $ABCB
        cpi     $0E
        jnz     L3393
        lda     $A576
        ora     a
        jz      L337C
        inr     b
        lda     $A575                   ; Actively scanning flag ($FF means actively scanning)
        ora     a
        jz      L3378
        lda     $AB92                   ; Flag, scan stopped for received signal (=FF)
        ora     a
        jz      L3393
L3378:
        inr     b
        jmp     L3393
L337C:
        lda     $A575                   ; Actively scanning flag ($FF means actively scanning)
        ora     a
        jz      L3388
        mvi     b,$04
        jmp     L3393
L3388:
        mvi     b,$03
        lda     $A577                   ; Flag, tuning wheel active for scan chan select
        ora     a
        jnz     L3393
        mvi     b,$00
L3393:
        mvi     c,$00
        lda     $A581                   ; Scan dwell (FF means external)
        cpi     $14
        jc      L33AA
        inr     c
        cpi     $32
        jc      L33AA
        inr     c
        cpi     $FF
        jnz     L33AA
        inr     c
L33AA:
        mov     a,c
        ral
        ral
        ral
        ani     $18
        ora     b
        mov     b,a
        lda     $A679                   ; Status bits
        rrc
        rrc
        ani     $20
        ora     b
        sta     $ABE9
        lda     $ABCB
        cpi     $0E
        mvi     a,$80
        jz      L33FB
        lda     $A54E
        ani     $FE
        jz      L33E5
        lda     $ABE9
        ora     a
        jnz     L33F2
        lda     $A68E
        mov     b,a
        lda     $A68F
        cmp     b
        jnz     L33F2
        ora     a
        jz      L33F2
L33E5:
        lda     $A67C                   ; NB/mute status
        ori     $10
        sta     $A67C                   ; NB/mute status
        mvi     a,$80
        jmp     L33FB
L33F2:
        lda     $A67C                   ; NB/mute status
        ani     $EF
        sta     $A67C                   ; NB/mute status
        xra     a
L33FB:
        mov     b,a
        lda     $ABEF                   ; PLL unlocked error flag
        ora     a
        jnz     L340A
        lda     $ABF0
        ora     a
        jz      L340E
L340A:
        mvi     a,$40
        ora     b
        mov     b,a
L340E:
        lda     $A54E
        ora     b
        sta     $ABEA
        lda     $A558                   ; Channel number displayed on front panel (=A0 if none)
        cma
        di                              ; Disable Interrupts
        call    L322C                   ; Send A to Serial Bus
        lda     $A54F                   ; BFO LSB
        cma
        call    L322C                   ; Send A to Serial Bus
        lda     $ABE8
        cma
        call    L322C                   ; Send A to Serial Bus
        lda     $ABE9
        cma
        call    L322C                   ; Send A to Serial Bus
        mvi     b,$03
        lxi     h,$A54B                 ; new commanded receiver params block beginning
L3437:
        mov     a,m
        cma
        call    L322C                   ; Send A to Serial Bus
        inx     h
        dcr     b
        jnz     L3437
        lda     $ABEA
        cma
        call    L322C                   ; Send A to Serial Bus
        out     $64                     ; Set Serial Data strobe to rear pnl Strobe 1
        ei                              ; Enable interrupts
        xra     a
        sta     $ABF5
        mvi     b,$04
        lxi     h,$A54B                 ; new commanded receiver params block beginning
        lxi     d,$A543
L3457:
        mov     a,m
        xchg
        cmp     m
        jz      L3463
        mov     m,a
        mvi     a,$FF
        sta     $ABF5
L3463:
        xchg
        inx     h
        inx     d
        dcr     b
        jnz     L3457
        lda     $ABF5
        ora     a
        rz
        out     $65                     ; Set Serial Data strobe to rear panel Strobe 2
        ret
;--------------------------------------------------------------------------------------------------
;       Protocol initialization code
L3472:
        lda     $A67E                   ; Comm port has been initialized flag
        ora     a
        jnz     L3512
        mvi     a,$B4
        sta     $A80C                   ; Mirrors UART port bits
        out     $F0
        lda     $AC3A                   ; FSK UART present flag
        ora     a
        jnz     L34B6
        mvi     a,$FF
        sta     $A843                   ; 0=Harris Protocol, $FF=ASCII
        xra     a
        sta     $A844
        sta     $A845                   ; Radio addressed, respond to commands (FF=respond)
        sta     $A846                   ; Radio addressed uniquely, return status reports (FF=report)
        sta     $A946                   ; Pointer for placing next char into input buffer ring
        sta     $A947
        sta     $A948                   ; Receive unread counter.  Hitting FF means overflow
        sta     $AA4A                   ; # chars left to transmit
        sta     $AA4B                   ; Number of CR's in input buffer
        sta     $AB4D                   ; Comm error flag (parity, etc)
        sta     $AB4E                   ; FF = receive buffer overflow
        lxi     h,$A949                 ; Serial comm transmit buffer
        shld    $AA48                   ; Serial comm transmit buffer pointer
        in      $BD                     ; UART Input Port
        jmp     L34B9
L34B6:
        lda     $D000                   ; FSK option memory space
L34B9:
        mov     c,a
        mvi     b,$00
        ani     $40
        jz      L34C3                   ; jump if remote control enable switch is set to enabled
        mvi     b,$40
L34C3:
        mov     a,c
        ani     $20
        jz      L34CB
        mvi     a,$10
L34CB:
        ora     b
        mov     b,a
        call    L3A9B                   ; UART/FSK UART output port reset bits B
        mvi     a,$FF
        sta     $A67E                   ; Comm port has been initialized flag, set it
        sta     $A67F
        sta     $A68C
        cma
        sta     $A687                   ; Harris protocol action bits
        sta     $A688
        sta     $A68B
        sta     $A6A4                   ; Harris protocol byte count for urgent message
        sta     $A6B1                   ; Harris protocol non-urgent message byte count
        sta     $A7A5                   ; Harris protocol # chars left to transmit
        sta     $A683
        sta     $A684
        sta     $A80E
        sta     $A68D
        sta     $A819                   ; No 4ISB fault flag
        sta     $A83D                   ; Flag, if FF then remeasure USB AGC Level
        sta     $A83E                   ; Flag, if FF then remeasure LSB AGC Level
        sta     $A83F                   ; Flag, if FF then remeasure USB Line Audio Level
        sta     $A840                   ; Flag, if FF then remeasure LSB Line Audio Level
        lxi     h,$1388
        shld    $ABD4
        call    L36F1                   ; Initialize FSK hardware, init UART if no FSK installed
L3512:
        call    L3E3E                   ; Harris protocol, report status
        mvi     b,$04
        call    L3AC4                   ; UART/FSK UART output port set bits B
        call    L462C                   ; Reset Harris protocol state machine
        xra     a
        sta     $A681
        sta     $A67F
        rim
        cma
        ori     $F1
        cma
        ori     $08
        sim
        ret
;--------------------------------------------------------------------------------------------------
;
;       Called from 1 msec timer intr routine if comm port initialized
;
L352D:
        lda     $A681
        ora     a
        jnz     L353C
        rim
        cma
        ori     $F1
        cma
        ori     $08
        sim
L353C:
        lxi     h,$A67F
        mov     a,m
        ora     a
        rnz
        mvi     m,$FF
        mvi     b,$04
        call    L3A9B                   ; UART/FSK UART output port reset bits B
        call    L35E4                   ; Remote comm code
        lda     $A843                   ; 0=Harris Protocol, $FF=ASCII
        ora     a
        jz      L3559
        call    L55D3                   ; Process ASCII commands from serial port
        jmp     L35DA
L3559:
        lhld    $A81A
        mov     a,h
        ora     l
        jz      L3576
        dcx     h
        shld    $A81A
        mov     a,h
        ora     l
        jnz     L3576
        lda     $A81C
        cpi     $FF
        cz      L38E0
        xra     a
        sta     $A81C
L3576:
        lda     $A687                   ; Harris protocol action bits
        ani     $02
        jz      L3584
        call    L3FAC                   ; Interpret Harris protocol commands and jump via table

        jmp     L35DA
L3584:
        lda     $A68B
        ora     a
        jz      L35DA
        cpi     $05
        jnz     L35D7
        lda     $A687                   ; Harris protocol action bits
        ani     $04                     ;  (request status report bit)
        jnz     L35CD
        lda     $A757                   ; send byte count/data/flag
        rrc
        rrc
        jnc     L35D7
        lda     $ABEB                   ; in BITE mode if FF
        ora     a
        jz      L35BA
        lxi     h,$A692
        mvi     a,$04
        cmp     m
        jz      L35D7
        mov     m,a
        mov     c,a
        mvi     b,$CF                   ; DID - State
        call    L3C5C                   ; Harris protocol code; add Urgent DID B data C to response
        jmp     L35D7
L35BA:
        lda     $A68D
        ora     a
        jnz     L35D3
        call    L3DB3                   ; P/O Harris protocol code
        call    L3CC4                   ; Harris protocol, report differences in parameters since last subroutine run
        call    L3D62                   ; Reacquire AGC and audio levels based on flags
        jmp     L35D7
L35CD:
        call    L3E3E                   ; Harris protocol, report status
        call    L369F                   ; Harris protocol Fault DID generator
L35D3:
        xra     a
        sta     $A68D
L35D7:
        call    L481E                   ; Harris protocol, set up outgoing message
L35DA:
        mvi     b,$04
        call    L3AC4                   ; UART/FSK UART output port set bits B
        xra     a
        sta     $A67F
        ret
;--------------------------------------------------------------------------------------------------
;       Remote comm code
L35E4:
        lhld    $ABD4
        dcx     h
        shld    $ABD4                   ; dec (ABD4-5)
        mov     a,h
        ora     l
        rnz                             ; return if not zero now
        lxi     h,$03E8
        shld    $ABD4
        lda     $A682                   ; Status bits
        mov     e,a
        ani     $02
        jnz     L367A
        mov     a,e
        ani     $04
        jnz     L361A
        mov     a,e
        ani     $01
        jz      L365B
        mvi     a,$02
        sta     $A682                   ; Status bits
        xra     a
        sta     $A67F
        mvi     b,$04
        call    L3AC4                   ; UART/FSK UART output port set bits B
        call    L4968
L361A:
        lda     $A682                   ; Status bits
        ori     $04
        ani     $FC
        sta     $A682                   ; Status bits
        lda     $A843                   ; 0=Harris Protocol, $FF=ASCII
        ora     a
        jnz     L367A
        xra     a
        sta     $A682                   ; Status bits
        mov     e,a
        cma
        sta     $A67F
        mvi     b,$04
        call    L3A9B                   ; UART/FSK UART output port reset bits B
        lxi     h,$ABC9                 ; BITE fault code
        mvi     a,$07
        ana     m
        cmp     m
        jz      L3645
        mvi     a,$00
L3645:
        mov     c,a
        inx     h
        mov     b,m
        call    L2800                   ; Convert BCD B to number in A, carry set if B not good BCD
        add     a
        add     a
        add     a
        ora     c
        mov     c,a
        mvi     b,$D3                   ; DID - Self-test (BITE)
        call    L3C5C                   ; Harris protocol code; add Urgent DID B data C to response
        lxi     h,$0000
        shld    $ABC9                   ; BITE fault code
L365B:
        mov     a,e
        ani     $10
        jz      L366A
        call    L369F                   ; Harris protocol Fault DID generator
        mov     a,e
        xri     $30
        jmp     L3677
L366A:
        mov     a,e
        ani     $20
        mov     a,e
        jz      L3677
        call    L369F                   ; Harris protocol Fault DID generator
        mov     a,e
        ani     $DF
L3677:
        sta     $A682                   ; Status bits
L367A:
        lxi     h,$A80E
        lda     $A575                   ; Actively scanning flag ($FF means actively scanning)
        ora     a
        jz      L3688
        lda     $AB92                   ; Flag, scan stopped for received signal (=FF)
        cma
L3688:
        cmp     m
        jnz     L3696
        ora     a
        rz
        dcx     h
        lda     $A558                   ; Channel number displayed on front panel (=A0 if none)
        cmp     m
        jmp     L369B
L3696:
        mov     m,a
        ora     a
        cz      L3EF1                   ; Harris protocol - send out state or suspend scan DID as urgent
L369B:
        cnz     L3EB2                   ; Harris protocol - send urgent DID sequence for resuming scan
        ret
;--------------------------------------------------------------------------------------------------
;       Harris protocol Fault DID generator
L369F:
        mvi     c,$00
        lda     $ABEF                   ; PLL unlocked error flag
        ora     a
        jz      L36AD
        mvi     c,$01
        jmp     L36B6
L36AD:
        lda     $A819                   ; No 4ISB fault flag
        ora     a
        jz      L36B6
        mvi     c,$04
L36B6:
        mvi     b,$A1                   ; DID - Fault
        call    L3C5C                   ; Harris protocol code; add Urgent DID B data C to response
        ret
;--------------------------------------------------------------------------------------------------
;       FSK option code, set A67F and A681 flags
L36BC:
        mvi     a,$FF
        sta     $A681
        sta     $A67F
        cma
        mov     c,a
        call    L39CB                   ; FSK/UART initialization code
        jz      L36DF
        lda     $AC3A                   ; FSK UART present flag
        cpi     $FF
        jz      L36D9
        mvi     c,$10
        jmp     L36DB
L36D9:
        mvi     c,$02
L36DB:
        stc
        jmp     L36E7
L36DF:
        call    L3A75                   ; FSK option code
        jnc     L36E7
        mvi     c,$03
L36E7:
        mvi     a,$00
        sta     $A681
        sta     $A67F
        mov     a,c
        ret
;--------------------------------------------------------------------------------------------------
;       Initialize FSK hardware, init UART if no FSK installed
L36F1:
        call    L3AF2                   ; Get BAUD rate select switch data into low nybble of A
        cpi     $0B
        rz
        lda     $AC3A                   ; FSK UART present flag
        ora     a
        jz      L3760                   ; Initialize UART
        mvi     a,$30
        sta     $E002                   ; FSK UART Command Register
        sta     $E00A                   ; FSK option memory space
        mvi     a,$20
        sta     $E002                   ; FSK UART Command Register
        sta     $E00A                   ; FSK option memory space
        mvi     a,$40
        sta     $E002                   ; FSK UART Command Register
        mvi     a,$10
        sta     $E002                   ; FSK UART Command Register
        mvi     a,$07
        sta     $E000                   ; FSK UART
        mvi     a,$2F
        sta     $E000                   ; FSK UART
        call    L3AF2                   ; Get BAUD rate select switch data into low nybble of A
        mov     e,a
        mvi     d,$00
        lxi     h,L37C2                 ; BAUD rate table
        dad     d
        mov     a,m
        push    psw
        ani     $80
        sta     $E004                   ; FSK option memory space
        pop     psw
        ani     $0F
        mov     b,a
        add     a
        add     a
        add     a
        add     a
        ora     b
        sta     $E001                   ; FSK UART Command/Status Register
        mvi     a,$00
        sta     $E00D                   ; FSK option hardware
        mvi     a,$FF
        sta     $E00F                   ; FSK option hardware
        xra     a
        sta     $AC39                   ; Serial transmitter transmitting flag
        mvi     a,$03
        sta     $E005                   ; FSK option hardware
        mvi     a,$01
        sta     $E002                   ; FSK UART Command Register
        mvi     a,$40
        sta     $E002                   ; FSK UART Command Register
        call    L3B04                   ; Put Radio ID from DIP switch into $AC3B
        ret
;--------------------------------------------------------------------------------------------------
;       Initialize UART
;
L3760:
        mvi     a,$30
        out     $B2             ; UART CRA - Reset Transmitter A
        out     $BA             ; UART CRB - Reset Transmitter B
        mvi     a,$20
        out     $B2             ; UART CRA - Reset Receiver A
        out     $BA             ; UART CRB - Reset Receiver B
        mvi     a,$40
        out     $B2             ; UART CRA - Reset Error Status
        mvi     a,$10
        out     $B2             ; UART CRA - Reset MR Pointer
        mvi     a,$00
        out     $BD             ; UART Output Port Config Register - Set to all outputs
        mvi     a,$FF
        out     $BF             ; UART Reset Output Port Bits Command - Reset all bits
        call    L3B35           ; Sets A843=0 for Harris Protocol, $FF for ASCII
        lda     $A843
        ora     a
        jz      L378B
        mvi     a,$06
        jmp     L378D
L378B:
        mvi     a,$07           ; A=6 for ASCII, A=7 for Harris Protocol
L378D:
        out     $B0             ; UART MR1A - Odd parity 7 bits/char (8 bits/char for Harris)
        mvi     a,$2F
        out     $B0             ; UART MR2A - TxRTS=yes, Stop bit length=2.000
        call    L3AF2           ; Get BAUD rate select switch data into low nybble of A
        mov     e,a
        mvi     d,$00
        lxi     h,L37C2
        dad     d
        mov     a,m             ; translate baud switch data to UART control info
        push    psw
        ani     $80
        out     $B4             ; UART ACR - Select Baud Rate Gen set 0 or 1 based on $80 bit
        pop     psw
        ani     $0F
        mov     b,a
        add     a
        add     a               ; this dups the baud data for Rcv and Xmt
        add     a
        add     a
        ora     b
        out     $B1             ; UART CSRA - Set Baud Rate
        xra     a
        sta     $AC39           ; clear Serial transmitter transmitting flag
        mvi     a,$03
        out     $B5             ; UART IMR - which conditions cause interrupts
        mvi     a,$01
        out     $B2             ; UART CRA - Enable receiver
        mvi     a,$40
        out     $B2             ; UART CRA - Reset error status
        call    L3B04           ; Put Radio ID from DIP switch into $AC3B
        ret

;
L37C2:  .DB     $00       ; Baud set 0 Baud Rate 50
        .DB     $80       ; Baud set 1 Baud Rate 75
        .DB     $01       ; Baud set 0 Baud Rate 110
        .DB     $02       ; Baud set 0 Baud Rate 134.5
        .DB     $83       ; Baud set 1 Baud Rate 150
        .DB     $04       ; Baud set 0 Baud Rate 300
        .DB     $05       ; Baud set 0 Baud Rate 600
        .DB     $06       ; Baud set 0 Baud Rate 1200
        .DB     $8A       ; Baud set 1 Baud Rate 1800
        .DB     $87       ; Baud set 1 Baud Rate 2000
        .DB     $88       ; Baud set 1 Baud Rate 2400
        .DB     $00       ; Baud set 0 Baud Rate 50
        .DB     $09       ; Baud set 0 Baud Rate 4800
        .DB     $0A       ; Baud set 0 Baud Rate 7200
        .DB     $0B       ; Baud set 0 Baud Rate 9600
        .DB     $8C       ; Baud set 1 Baud Rate 19200

;--------------------------------------------------------------------------------------------------
;
;       UART Interrupt routine
;
L37D2:
        push    h
        push    d
        push    b
        push    psw
        lxi     h,$380D
        push    h
        lda     $A843                   ; 0=Harris Protocol, $FF=ASCII
        ora     a
        jnz     L3813
        lda     $AC3A                   ; FSK UART present flag
        ora     a
        jz      L37FC
        lda     $E005                   ; FSK option memory space
        ani     $03
        mov     b,a
        ani     $02
        jnz     L3826
        mov     a,b
        ani     $01
        jnz     L38E7
        jmp     L380C
L37FC:                                  ; Harris Protocol
        in      $B5                     ; UART Interrupt Status Register
        ani     $03                     ; Char rec'd or char xmt'd
        mov     b,a
        ani     $02
        jnz     L3846                   ; Character was received
        mov     a,b
        ani     $01
        jnz     L393A                   ; Character sent
L380C:
        pop     h
        pop     psw
        pop     b
        pop     d
        pop     h
        ei                              ; Enable interrupts
        ret
L3813:                                  ; ASCII Protocol
        in      $B5                     ; UART ISR - what caused interrupt?
        ani     $03
        mov     b,a
        ani     $02
        jnz     L3863                   ; Character was received
        mov     a,b
        ani     $01
        jnz     L3988                   ; Character sent
        jmp     L380C                   ; Other interrupt, ignore, return.
L3826:
        lda     $E001                   ; FSK UART Command/Status Register
        mov     c,a
        lda     $E003                   ; FSK UART Rx/Tx Holding Register
        mov     b,a
        lda     $AC39                   ; Serial transmitter transmitting flag
        ora     a
        jnz     L38DF
        mov     a,c
        ani     $70
        jz      L38C6
        mvi     a,$40
        sta     $E002                   ; FSK UART Command Register
        call    L462C                   ; Reset Harris protocol state machine
        jmp     L38DF
L3846:                                  ; Harris Protocol - Character received
        in      $B1                     ; UART Status Register A
        mov     c,a
        in      $B3                     ; UART Rx Holding Register A
        mov     b,a
        lda     $AC39                   ; Serial transmitter transmitting flag
        ora     a
        jnz     L38DF
        mov     a,c
        ani     $70                     ; mask for error bits
        jz      L38C6                   ; jump if no error
        mvi     a,$40
        out     $B2                     ; UART CRA - Reset error status
        call    L462C                   ; Reset Harris protocol state machine
        jmp     L38DF
L3863:                                  ; ASCII Protocol - Character received
        in      $B1                     ; UART Status Register A
        mov     c,a
        in      $B3                     ; UART Rx Holding Register A
        mov     b,a
        mov     a,c
        ani     $70                     ; mask for error bits
        jz      L387B                   ; jump if not error
        mvi     a,$40
        out     $B2                     ; UART CRA - Reset error status
        mvi     a,$FF
        sta     $AB4D                   ; $AB4D = $FF and exit - Comm error flag (parity, etc)
        jmp     L38C5
L387B:
        mov     a,b
        cpi     $0D                     ; is character a CR?
        jnz     L3893                   ; jump if not
        lda     $A948                   ; Receive unread counter.  Hitting FF means overflow
        cpi     $FF
        jz      L38C0
        lda     $AA4B                   ; Number of CR's in input buffer
        inr     a
        sta     $AA4B                   ; $AA4B gets incremented if char received is a CR
        jmp     L38A0
L3893:
        cpi     $21                     ; is character a control char?  Exit if so.
        jc      L38C5
        lda     $A948                   ; Receive unread counter.  Hitting FF means overflow
        cpi     $FE
        jnc     L38C0
L38A0:
        lda     $A948                   ; Receive unread counter.  Hitting FF means overflow
        inr     a
        sta     $A948                   ; Receive unread counter.  Hitting FF means overflow
        lxi     h,$A847
        lda     $A946                   ; Pointer for placing next char into input buffer ring
        mov     e,a
        inr     a
        cpi     $FF
        jnz     L38B6
        mvi     a,$00
L38B6:
        sta     $A946                   ; Pointer for placing next char into input buffer ring
        mvi     d,$00
        dad     d
        mov     m,b                     ; put received char to loc $A847 + pointer $A946
        jmp     L38C5
L38C0:
        mvi     a,$FF
        sta     $AB4E                   ; FF = receive buffer overflow
L38C5:
        ret
L38C6:                                  ; Harris Protocol - Character received
        lxi     h,$0000
        call    L3AF2                   ; Get BAUD rate select switch data into low nybble of A
        cpi     $07
        jnz     L38D4
        lxi     h,$01F4
L38D4:
        shld    $A81A
        lxi     h,L38DF
        push    h
        lhld    $A689
        pchl                            ; Jump to loc stored in $A689
L38DF:
        ret
L38E0:
        lda     $AC3A                   ; FSK UART present flag
        ora     a
        jz      L393A
L38E7:
        lda     $A7A5                   ; Harris protocol # chars left to transmit
        ora     a
        jnz     L38FA
        mvi     a,$08
        sta     $E002                   ; FSK UART Command Register
        xra     a
        sta     $AC39                   ; Serial transmitter transmitting flag
        jmp     L3939
L38FA:
        lhld    $A81A
        mov     a,h
        ora     l
        jz      L390A
        mvi     a,$FF
        sta     $A81C
        jmp     L3939
L390A:
        lda     $AC39                   ; Serial transmitter transmitting flag
        ora     a
        jnz     L392A
        di                              ; Disable Interrupts
        mvi     a,$04
        sta     $E002                   ; FSK UART Command Register
        mvi     a,$FF
        sta     $AC39                   ; Serial transmitter transmitting flag
        mvi     a,$01
        sta     $E00E                   ; FSK option hardware
        mvi     a,$FF
        sta     $E003                   ; FSK UART Rx/Tx Holding Register
        ei                              ; Enable interrupts
        jmp     L3939
L392A:
        lhld    $A7A6                   ; Harris protocol transmit buffer pointer
        mov     a,m
        sta     $E003                   ; FSK UART Rx/Tx Holding Register
        inx     h
        shld    $A7A6                   ; Harris protocol transmit buffer pointer
        lxi     h,$A7A5                 ; Harris protocol # chars left to transmit
        dcr     m
L3939:
        ret
L393A:                          ; Harris Protocol - Character transmitted
        lda     $A7A5                   ; Harris protocol # chars left to transmit
        ora     a
        jnz     L394C
        mvi     a,$08
        out     $B2                     ; UART CRA - Disable transmitter
        xra     a
        sta     $AC39                   ; clear Serial transmitter transmitting flag
        jmp     L3987
L394C:
        lhld    $A81A
        mov     a,h
        ora     l
        jz      L395C                   ; if A81A and A81B are zero keep transmitting
        mvi     a,$FF
        sta     $A81C                   ; else make $A81C = $FF and exit
        jmp     L3987
L395C:
        lda     $AC39                   ; Serial transmitter transmitting flag
        ora     a
        jnz     L3979                   ; don't bother turning on transmitter if it is already on
        di                              ; Disable Interrupts
        mvi     a,$04
        out     $B2                     ; UART CRA - Enable transmitter
        mvi     a,$FF
        sta     $AC39                   ; Serial transmitter transmitting flag
        mvi     a,$01
        out     $BE                     ; UART Set Output Port Bits Command, turn on transmit driver
        mvi     a,$FF
        out     $B3                     ; UART Transmit Holding Register A - Send $FF char
        ei                              ; Enable interrupts
        jmp     L3987
L3979:
        lhld    $A7A6                   ; Harris protocol transmit buffer pointer
        mov     a,m
        out     $B3                     ; UART Transmit Holding Register A
        inx     h
        shld    $A7A6                   ; Harris protocol transmit buffer pointer
        lxi     h,$A7A5                 ; decrement Harris protocol # chars left to transmit
        dcr     m
L3987:
        ret
L3988:                          ; ASCII Protocol - character transmitted
        lda     $AA4A                   ; # chars left to transmit
        ora     a
        jnz     L39A0                   ; jump if more chars to send
        mvi     a,$08
        out     $B2                     ; UART CRA - Disable transmitter
        xra     a
        sta     $AC39                   ; clear Serial transmitter transmitting flag
        lxi     h,$A949                 ; Serial comm transmit buffer
        shld    $AA48                   ; Re-init serial comm transmit buffer pointer
        jmp     L39CA
L39A0:                                  ; still more chars to transmit
        lda     $AC39                   ; Serial transmitter transmitting flag
        ora     a
        jnz     L39B9                   ; don't bother turning on transmitter if it is already on
        di                              ; Disable Interrupts
        mvi     a,$04
        out     $B2                     ; UART CRA - Enable transmitter
        mvi     a,$FF
        sta     $AC39                   ; set Serial transmitter transmitting flag
        mvi     a,$01
        out     $BE                     ; UART Set Output Port Bits Command, turn on transmit driver
        ei                              ; Enable interrupts
        jmp     L39CA
L39B9:
        lhld    $AA48                   ; Serial comm transmit buffer pointer
        mov     a,m
        out     $B3                     ; UART Transmit Holding Register A
        inx     h
        shld    $AA48                   ; increment serial comm transmit buffer pointer
        lda     $AA4A                   ; decrement # chars left to transmit
        dcr     a
        sta     $AA4A
L39CA:
        ret
;--------------------------------------------------------------------------------------------------
;       FSK/UART initialization code
L39CB:
        rim
        ani     $07
        ori     $09
        sim
        lda     $AC3A                   ; FSK UART present flag
        ora     a
        jz      L3A1F
        lda     $AC39                   ; Serial transmitter transmitting flag
        ora     a
        jz      L39E7
L39DF:
        lda     $E001                   ; FSK UART Command/Status Register
        ani     $08
        jz      L39DF
L39E7:
        mvi     a,$0A
        sta     $E002                   ; FSK UART Command Register
        mvi     a,$BB
        sta     $E001                   ; FSK UART Command/Status Register
        mvi     a,$80
        sta     $E000                   ; FSK UART
        mvi     a,$06
        sta     $E002                   ; FSK UART Command Register
        mvi     a,$55
        sta     $E003                   ; FSK UART Rx/Tx Holding Register
        lxi     h,$FFFF
L3A03:
        dcx     h
        mov     a,l
        ora     h
        jz      L3A70
        lda     $E001                   ; FSK UART Command/Status Register
        ani     $08
        jz      L3A03
        lda     $E001                   ; FSK UART Command/Status Register
        ani     $01
        jz      L3A03
        lda     $E003                   ; FSK UART Rx/Tx Holding Register
        jmp     L3A5A
L3A1F:
        lda     $AC39                   ; Serial transmitter transmitting flag
        ora     a
        jz      L3A2D
L3A26:
        in      $B1                     ; UART Status Register A
        ani     $08
        jz      L3A26
L3A2D:
        mvi     a,$0A
        out     $B2                     ; UART Command Register A
        mvi     a,$BB
        out     $B1                     ; UART Clock Select Register A
        mvi     a,$80
        out     $B0                     ; UART Mode A Register
        mvi     a,$06
        out     $B2                     ; UART Command Register A
        mvi     a,$55
        out     $B3                     ; UART Transmit Holding Register A
        lxi     h,$FFFF
L3A44:
        dcx     h
        mov     a,l
        ora     h
        jz      L3A70
        in      $B1                     ; UART Status Register A
        ani     $08
        jz      L3A44
        in      $B1                     ; UART Status Register A
        ani     $01
        jz      L3A44
        in      $B3                     ; UART Rx Holding Register A
L3A5A:
        mvi     a,$00
L3A5C:
        ora     a
        push    psw
        call    L36F1                   ; Initialize FSK hardware, init UART if no FSK installed
        call    L462C                   ; Reset Harris protocol state machine
        di                              ; Disable Interrupts
        rim
        cma
        ori     $F1
        cma
        ori     $08
        sim
        pop     psw
        ei                              ; Enable interrupts
        ret
L3A70:
        mvi     a,$FF
        jmp     L3A5C
;--------------------------------------------------------------------------------------------------
;       FSK option code
L3A75:
        lda     $AC3A                   ; FSK UART present flag
        ora     a
        jz      L3A96
        mvi     b,$04
        call    L3A9B                   ; UART/FSK UART output port reset bits B
        lda     $E00D                   ; FSK option hardware
        ani     $40
        jz      L3A99
        mvi     b,$04
        call    L3AC4                   ; UART/FSK UART output port set bits B
        lda     $E00D                   ; FSK option hardware
        ani     $40
        jnz     L3A99
L3A96:
        stc
        cmc
        ret
L3A99:
        stc
        ret
;--------------------------------------------------------------------------------------------------
;       UART/FSK UART output port reset bits B
L3A9B:
        push    psw
        rim
        push    psw
        di                              ; Disable Interrupts
        lda     $A80C                   ; Mirrors UART port bits
        ora     b
        sta     $A80C                   ; Mirrors UART port bits
        lda     $AC3A                   ; FSK UART present flag
        ora     a
        jz      L3AB6
        mov     a,b
        ani     $FC
        sta     $E00F                   ; FSK option hardware
        jmp     L3ABB
L3AB6:
        mov     a,b
        ani     $FC
        out     $BF                     ; UART Reset Output Port Bits Command
L3ABB:
        pop     psw
        ani     $08
        jz      L3AC2
        ei                              ; Enable interrupts
L3AC2:
        pop     psw
        ret
;--------------------------------------------------------------------------------------------------
;       UART/FSK UART output port set bits B
L3AC4:
        push    psw
        rim
        push    psw
        di                              ; Disable Interrupts
        mov     a,b
        cma
        mov     b,a
        lda     $A80C                   ; Mirrors UART port bits
        ana     b
        sta     $A80C                   ; Mirrors UART port bits
        lda     $AC3A                   ; FSK UART present flag
        ora     a
        jz      L3AE3
        mov     a,b
        cma
        ani     $FC
        sta     $E00E                   ; FSK option hardware
        jmp     L3AE9
L3AE3:
        mov     a,b
        cma
        ani     $FC
        out     $BE                     ; UART Set Output Port Bits Command
L3AE9:
        pop     psw
        ani     $08
        jz      L3AF0
        ei                              ; Enable interrupts
L3AF0:
        pop     psw
        ret
;--------------------------------------------------------------------------------------------------
; Get BAUD rate select switch data into low nybble of A
L3AF2:
        lda     $AC3A                   ; FSK UART present flag
        ora     a
        jz      L3AFF
        lda     $D000                   ; FSK option memory space
        ani     $0F
        ret
L3AFF:
        in      $BD                     ; UART Input Port
        ani     $0F                     ; Baud select switch data
        ret
;--------------------------------------------------------------------------------------------------
; Put Radio ID from DIP switch into $AC3B
L3B04:
        lda     $AC3A                   ; FSK UART present flag
        ora     a
        jz      L3B11                   ; If memory, $AC3B = $E800 and return
        lda     $E800                   ; FSK option memory space
        jmp     L3B31
L3B11:
        mvi     a,$40
        out     $BE                     ; UART Set Output Port Bits $40
        mvi     a,$80
        out     $BF                     ; UART Reset Output Port Bits $80
        out     $BE                     ; UART Set Output Port Bits $80
        out     $BF                     ; UART Reset Output Port Bits $80
        mvi     d,$08
L3B1F:
        rim                             ; read a radio ID bit into Acc bit 7
        ral
        mov     a,e
        rar
        mov     e,a
        mvi     a,$40
        out     $BF                     ; UART Reset Output Port Bits $40
        nop
        nop
        out     $BE                     ; UART Set Output Port Bits $40
        dcr     d
        jnz     L3B1F
        mov     a,e                     ; if no memory, $AC3B = Radio ID
L3B31:
        sta     $AC3B                   ;
        ret
;--------------------------------------------------------------------------------------------------
; Sets A843=0 for Harris Protocol, $FF for ASCII
L3B35:
        lda     $AC3A                   ; FSK UART present flag
        ora     a
        jz      L3B41                   ; if $AC3A not 0, $A843=0 and return
        mvi     a,$00
        jmp     L3B64
L3B41:
        mvi     a,$40
        out     $BE                     ; UART Set Output Port Bits $40
        mvi     a,$80
        out     $BF                     ; UART Reset Output Port Bits $80
        out     $BE                     ; UART Set Output Port Bits $80
        out     $BF                     ; UART Reset Output Port Bits $80
        mvi     d,$08
L3B4F:
        mvi     a,$40
        out     $BF                     ; UART Reset Output Port Bits $40
        nop
        nop
        out     $BE                     ; UART Set Output Port Bits $40
        dcr     d
        jnz     L3B4F                   ; do 8 times
        rim                             ; read a radio ID bit into Acc bit 7 (J20: 0=ASCII, 1=Harris protocol)
        ral                             ; move it into carry
        mvi     a,$00                   ; clr A
        jc      L3B64                   ; if bit was 1, $A843=0, else $A843=$FF (0=Harris Protocol, $FF=ASCII)
        mvi     a,$FF
L3B64:
        sta     $A843
        ret

;--------------------------------------------------------------------------------------------------
;
;       SUMMARY OF DIDS BY VALUE
;
;       HEX             DID                                 
;
;       30/31           USBLIN  USB Line Audio Level
;       32/33           LSBLIN  LSB Line Audio Level
;       34/35           FCFLOW  FSK Center Freq Low
;       36/37           FCFHI   FSK Center Freq High
;       38/39           FSHIFT  FSK Shift & Shift Polarity
;       3A/3B           OPTION  Options
;       3C/3D           SSTHRH  Stop Scan Threshold
;       50/51           USBOUT  USB AGC Level
;       52/53           LSBOUT  LSB AGC Level
;       81              SPARE1  Spare 1
;       83              SPARE2  Spare 2
;       86/87           WHORU   Who Are You
;       88/89           BWCONF  Bandwidth Configuration
;       91              REPCHA  Report Channel Data
;       93              CHANNL  Channel
;       95              PROCHA  Program Channel Data
;       97              GROUP   Group Program
;       99              UNGRUP  Group Unprogram
;       9B              REPGRP  Report Group
;       A9              RXCMST  Receiver Command/Status
;       A1              FAULT   Fault
;       B1              BANDWT  Bandwidth
;       B3              BFOHI   BFO High
;       B5              BFOLOW  BFO Low
;       B7              TUNAGC  Tuning method/AGC speed
;       BB              RFGAIN  RF Gain
;       C1              FREQ3   10/1 MHz Frequency   
;       C3              FREQ2   100/10 KHz Frequency   
;       C5              FREQ1   1000/100 Hz Frequency   
;       C7              FREQ0   10/1 Hz Frequency   
;       C9              MODE    Mode
;       CF              STATE   State
;       D0              REPCOM  Report Complete Status   
;       D2/D3           SELTST  Self-test (BITE)   
;       DC              INCCHA  Increment Channel   
;       DE              DECCHA  Decrement Channel
;       E1              SCASTA  Scan Start Bound   
;       E3              SCAEND  Scan End Bound   
;       E5              DWELL   Dwell
;       E6/E7           RESCAN  Resume Scan   
;       E8/E9           SUSCAN  Suspend Scan   
;       EA/EB           LCKOUT  Lockout Channel   
;       EC/ED           UNLOCK  Un-lock channel 



;
L3B68:  .DW     L42E1           ; 30/31   USB Line Audio Level
        .DW     L42E8           ; 32/33   LSB Line Audio Level
        .DW     L42EF           ; 34/35   FSK Center Freq Low
        .DW     L4311           ; 36/37   FSK Center Freq High
        .DW     L4337           ; 38/39   FSK Shift & Shift Polarity
        .DW     L4355           ; 3A/3B   Options
        .DW     L415C           ; 3C/3D   Stop Scan Threshold
        .DW     L4075           ; 3E/3F   nop
        .DW     L4075           ; 40/41   nop
        .DW     L4075           ; 42/43   nop
        .DW     L4075           ; 44/45   nop
        .DW     L4075           ; 46/47   nop
        .DW     L4075           ; 48/49   nop
        .DW     L4075           ; 4A/4B   nop
        .DW     L4075           ; 4C/4D   nop
        .DW     L4075           ; 4E/4F   nop
        .DW     L42D3           ; 50/51   USB AGC Level
        .DW     L42DA           ; 52/53   LSB AGC Level
        .DW     L4075           ; 54/55   nop
        .DW     L4075           ; 56/57   nop
        .DW     L4075           ; 58/59   nop
        .DW     L4075           ; 5A/5B   nop
        .DW     L4075           ; 5C/5D   nop
        .DW     L4075           ; 5E/5F   nop
        .DW     L4075           ; 60/61   nop
        .DW     L4075           ; 62/63   nop
        .DW     L4075           ; 64/65   nop
        .DW     L4075           ; 66/67   nop
        .DW     L4075           ; 68/69   nop
        .DW     L4075           ; 6A/6B   nop
        .DW     L4075           ; 6C/6D   nop
        .DW     L4075           ; 6E/6F   nop
        .DW     L4075           ; 70/71   nop
        .DW     L4075           ; 72/73   nop
        .DW     L4075           ; 74/75   nop
        .DW     L4075           ; 76/77   nop
        .DW     L4075           ; 78/79   nop
        .DW     L4075           ; 7A/7B   nop
        .DW     L4075           ; 7C/7D   nop
        .DW     L4075           ; 7E/7F   nop
        .DW     L4076           ; 80/81   Spare 1
        .DW     L4076           ; 82/83   Spare 2
        .DW     L4075           ; 84/85   nop
        .DW     L4085           ; 86/87   Who Are You
        .DW     L4372           ; 88/89   Bandwidth Configuration
        .DW     L4075           ; 8A/8B   nop
        .DW     L4075           ; 8C/8D   nop
        .DW     L4075           ; 8E/8F   nop
        .DW     L4387           ; 90/91   Report Channel Data
        .DW     L43BF           ; 92/93   Channel
        .DW     L4091           ; 94/95   Program Channel Data
        .DW     L40C7           ; 96/97   Group Program
        .DW     L40C7           ; 98/99   Group Unprogram
        .DW     L410D           ; 9A/9B   Report Group
        .DW     L4075           ; 9C/9D   nop
        .DW     L4075           ; 9E/9F   nop
        .DW     L4075           ; A0/A1   nop
        .DW     L4075           ; A2/A3   nop
        .DW     L4075           ; A4/A5   nop
        .DW     L4075           ; A6/A7   nop
        .DW     L4134           ; A8/A9   Receiver Command/Status
        .DW     L4075           ; AA/AB   nop
        .DW     L4075           ; AC/AD   nop
        .DW     L4075           ; AE/AF   nop
        .DW     L43F5           ; B0/B1   Bandwidth
        .DW     L416B           ; B2/B3   BFO High
        .DW     L4193           ; B4/B5   BFO Low
        .DW     L41AE           ; B6/B7   Tuning method/AGC speed
        .DW     L4075           ; B8/B9   nop
        .DW     L4150           ; BA/BB   RF Gain
        .DW     L4075           ; BC/BD   nop
        .DW     L4075           ; BE/BF   nop
        .DW     L41F6           ; C0/C1   10/1 MHz Frequency
        .DW     L4207           ; C2/C3   100/10 KHz Frequency
        .DW     L420C           ; C4/C5   1000/100 Hz Frequency
        .DW     L4211           ; C6/C7   10/1 Hz Frequency
        .DW     L422C           ; C8/C9   Mode
        .DW     L4075           ; CA/CB   nop
        .DW     L4075           ; CC/CD   nop
        .DW     L4459           ; CE/CF   State
        .DW     L44B4           ; D0/D1   Report Complete Status
        .DW     L427F           ; D2/D3   Self-test (BITE)
        .DW     L4075           ; D4/D5   nop
        .DW     L4075           ; D6/D7   nop
        .DW     L4075           ; D8/D9   nop
        .DW     L4075           ; DA/DB   nop
        .DW     L44BF           ; DC/DD   Increment Channel
        .DW     L4501           ; DE/DF   Decrement Channel
        .DW     L4551           ; E0/E1   Scan Start Bound
        .DW     L4557           ; E2/E3   Scan End Bound
        .DW     L42A4           ; E4/E5   Dwell
        .DW     L456A           ; E6/E7   Resume Scan
        .DW     L45D8           ; E8/E9   Suspend Scan
        .DW     L45F4           ; EA/EB   Lockout Channel
        .DW     L45F4           ; EC/ED   Un-lock channel

;--------------------------------------------------------------------------------------------------
;       Harris protocol, add bandwidth DID to response
L3C26:
        push    b
        push    h
        mov     a,m                     ; HL is mode/filter address
        rrc
        rrc
        rrc
        rrc
        ani     $0F
        mov     c,a
        mvi     b,$00
        lxi     h,$ABF8                 ; IF filter data
        dad     b
        mov     c,m
        mvi     b,$B1                   ; DID - bandwidth
        call    L3C43                   ; Harris protocol code; add non-urgent DID B data C to response
        pop     h
        pop     b
        ret
;--------------------------------------------------------------------------------------------------
;       Harris protocol code; add non-urgent DID B data C to response
L3C3F:
        ora     a
        jmp     L3C44
L3C43:
        stc
L3C44:
        push    h
        push    d
        push    psw
        lda     $A6B1                   ; Harris protocol non-urgent message byte count
        mov     d,a
        cpi     $4F
        jnc     L3C58
        lxi     h,$A6B2                 ; Harris protocol non-urgent message buffer
        pop     psw
        push    psw
        call    L3C71                   ; P/O Harris protocol code; add DID B, data C to response
L3C58:
        pop     psw
        pop     d
        pop     h
        ret
;--------------------------------------------------------------------------------------------------
;       Harris protocol code; add Urgent DID B data C to response
L3C5C:
        push    h
        push    d
        lda     $A6A4                   ; Harris protocol byte count for urgent message
        mov     d,a
        cpi     $0B
        jnc     L3C6E
        lxi     h,$A6A5                 ; Harris protocol urgent message buffer
        ora     a
        call    L3C71                   ; P/O Harris protocol code; add DID B, data C to response
L3C6E:
        pop     d
        pop     h
        ret
;--------------------------------------------------------------------------------------------------
;       P/O Harris protocol code; add DID B, data C to response
L3C71:
        push    h
        jc      L3C82
        call    L3C93                   ; Search for B at D locs from HL
        pop     d
        jc      L3C87
        mov     a,b
        rrc
        rnc
        inx     h
        mov     m,c
        ret
L3C82:
        mov     e,d
        mvi     d,$00
        dad     d
        pop     d
L3C87:
        mov     m,b
        xchg
        dcx     h
        inr     m
        mov     a,b
        rrc
        rnc
        inr     m
        xchg
        inx     h
        mov     m,c
        ret
;--------------------------------------------------------------------------------------------------
;       Search for B at D locs from HL
L3C93:
        mov     a,d
        ora     a
        jz      L3C9B
        jp      L3C9D
L3C9B:
        stc
        ret
L3C9D:
        mov     a,m
        cmp     b
        rz
        rrc
        jnc     L3CA6
        inx     h
        dcr     d
L3CA6:
        inx     h
        dcr     d
        jmp     L3C93
;--------------------------------------------------------------------------------------------------
;       Harris protocol, if (HL)<>(BC) for A locs, send DID (DE) data (HL) for each nomatch
L3CAB:
        push    psw
        ldax    b
        cmp     m
        jz      L3CBB
        mov     m,a
        push    b
        mov     c,a
        xchg
        mov     b,m
        call    L3C43                   ; Harris protocol code; add non-urgent DID B data C to response
        xchg
        pop     b
L3CBB:
        inx     b
        inx     d
        inx     h
        pop     psw
        dcr     a
        jnz     L3CAB
        ret
;--------------------------------------------------------------------------------------------------
;       Harris protocol, report differences in parameters since last subroutine run
L3CC4:
        lxi     h,$A696
        lxi     d,L3E35
        lxi     b,$A54B                 ; new commanded receiver params block beginning
        mvi     a,$06
        call    L3CAB                   ; Harris protocol, if (HL)<>(BC) for A locs, send DID (DE) data (HL) for each nomatch
        push    b
        pop     d
        ldax    d
        cmp     m
        jz      L3CF0
        mov     m,a
        ani     $0F
        mov     c,a
        lda     $A818                   ; 4ISB option flag, zero for no 4ISB
        ora     a
        jz      L3CE8
        mov     a,c
        ori     $80
        mov     c,a
L3CE8:
        mvi     b,$C9                   ; DID - mode
        call    L3C43                   ; Harris protocol code; add non-urgent DID B data C to response
        call    L3C26                   ; Harris protocol, add bandwidth DID to response
L3CF0:
        inx     h
        inx     d
        ldax    d
        cmp     m
        jz      L3D09
        mov     m,a
        add     a
        add     a
        add     a
        add     a
        cpi     $40
        jnz     L3D03
        mvi     a,$70
L3D03:
        mov     c,a
        mvi     b,$B7                   ; DID - Tuning method/AGC speed
        call    L3C43                   ; Harris protocol code; add non-urgent DID B data C to response
L3D09:
        inx     h
        inx     d
        ldax    d
        cmp     m
        jz      L3D17
        mov     m,a
        mov     c,a
        mvi     b,$81                   ; DID - Spare 1
        call    L3C43                   ; Harris protocol code; add non-urgent DID B data C to response
L3D17:
        lda     $A825                   ; FSK option installed flag. Zero if not installed
        ora     a
        jz      L3D2C
        lxi     h,$A69F
        lxi     b,$A554                 ; FSK center freq
        lxi     d,L3E3B
        mvi     a,$03
        call    L3CAB                   ; Harris protocol, if (HL)<>(BC) for A locs, send DID (DE) data (HL) for each nomatch
L3D2C:
        lxi     h,$A6A3
        lda     $A558                   ; Channel number displayed on front panel (=A0 if none)
        cmp     m
        rz
        mov     m,a
        cpi     $A0
        rnc
        mov     c,a
        mvi     b,$93                   ; DID - Channel
        lda     $A575                   ; Actively scanning flag ($FF means actively scanning)
        ora     a
        jz      L3D4F
        lda     $AB92                   ; Flag, scan stopped for received signal (=FF)
        ora     a
        jnz     L3D4F
        call    L3C5C                   ; Harris protocol code; add Urgent DID B data C to response
        jmp     L3D52
L3D4F:
        call    L3C43                   ; Harris protocol code; add non-urgent DID B data C to response
L3D52:
        ret
;--------------------------------------------------------------------------------------------------
;       Set flags to reacquire AGC and audio levels
L3D53:
        mvi     a,$FF
        sta     $A83D                   ; Flag, if FF then remeasure USB AGC Level
        sta     $A83E                   ; Flag, if FF then remeasure LSB AGC Level
        sta     $A83F                   ; Flag, if FF then remeasure USB Line Audio Level
        sta     $A840                   ; Flag, if FF then remeasure LSB Line Audio Level
        ret
;--------------------------------------------------------------------------------------------------
;       Reacquire AGC and audio levels based on flags
L3D62:
        lda     $A83D                   ; Flag, if FF then remeasure USB AGC Level
        ora     a
        jz      L3D76
        mvi     b,$51                   ; DID - USB AGC level
        lda     $A839                   ; 2nd IF AGC reading
        mov     c,a
        call    L3C3F                   ; Harris protocol code; add non-urgent DID B data C to response
        xra     a
        sta     $A83D                   ; Flag, if FF then remeasure USB AGC Level
L3D76:
        lda     $A83E                   ; Flag, if FF then remeasure LSB AGC Level              
        ora     a
        jz      L3D8A
        mvi     b,$53                   ; DID - LSB AGC level
        lda     $A83A                   ; AGC reading
        mov     c,a
        call    L3C3F                   ; Harris protocol code; add non-urgent DID B data C to response
        xra     a
        sta     $A83E                   ; Flag, if FF then remeasure LSB AGC Level
L3D8A:
        lda     $A83F                   ; Flag, if FF then remeasure USB Line Audio Level
        ora     a
        jz      L3D9E
        mvi     b,$31                   ; DID - USB line audio level
        lda     $A83B                   ; Line Audio reading
        mov     c,a
        call    L3C3F                   ; Harris protocol code; add non-urgent DID B data C to response
        xra     a
        sta     $A83F                   ; Flag, if FF then remeasure USB Line Audio Level
L3D9E:
        lda     $A840                   ; Flag, if FF then remeasure LSB Line Audio Level
        ora     a
        jz      L3DB2
        mvi     b,$33                   ; DID - LSB line audio level
        lda     $A83C                   ; ISB Audio reading
        mov     c,a
        call    L3C3F                   ; Harris protocol code; add non-urgent DID B data C to response
        xra     a
        sta     $A840                   ; Flag, if FF then remeasure LSB Line Audio Level
L3DB2:
        ret
;--------------------------------------------------------------------------------------------------
;       P/O Harris protocol code
L3DB3:
        mvi     b,$CF
        lxi     h,$A6A4                 ; Harris protocol byte count for urgent message
        mov     d,m
        inx     h
        call    L3C93                   ; Search for B at D locs from HL
        jc      L3DC5
        inx     h
        lda     $A67A                   ; Radio state bits
        mov     m,a
L3DC5:
        mvi     a,$05
        lxi     b,$A679                 ; Status bits
        lxi     h,$A691
        lxi     d,L3DD4
        call    L3CAB                   ; Harris protocol, if (HL)<>(BC) for A locs, send DID (DE) data (HL) for each nomatch
        ret

;
L3DD4:  .db     $CB, $CF, $BB, $A9, $3D ; DIDs cmd/stat, state, RF gain, cmd/stat, stop scan threshold

;--------------------------------------------------------------------------------------------------
;       Harris protocol, add DIDs for channel data to response
L3DD9:
        push    h
        pop     b
        lxi     d,L3E35
        mvi     a,$06
        push    d
        pop     h
        call    L3CAB                   ; Harris protocol, if (HL)<>(BC) for A locs, send DID (DE) data (HL) for each nomatch
        push    b
        pop     h
        mov     a,m
        ani     $0F
        mov     c,a
        lda     $A818                   ; 4ISB option flag, zero for no 4ISB
        ora     a
        jz      L3DF6
        mov     a,c
        ori     $80
        mov     c,a
L3DF6:
        mvi     b,$C9                   ; DID - Mode
        call    L3C43                   ; Harris protocol code; add non-urgent DID B data C to response
        call    L3C26                   ; Harris protocol, add bandwidth DID to response
        inx     h
        mov     a,m
        add     a
        add     a
        add     a
        add     a
        cpi     $40
        jnz     L3E0B
        mvi     a,$70
L3E0B:
        mov     c,a
        mvi     b,$B7                   ; DID - Tuning method/AGC speed
        call    L3C43                   ; Harris protocol code; add non-urgent DID B data C to response
        inx     h
        mov     c,m
        mvi     b,$81                   ; DID - Spare 1
        call    L3C43                   ; Harris protocol code; add non-urgent DID B data C to response
        lda     $A825                   ; FSK option installed flag. Zero if not installed
        ora     a
        jz      L3E34
        inx     h
        mov     c,m
        mvi     b,$35                   ; DID - FSK center freq low
        call    L3C43                   ; Harris protocol code; add non-urgent DID B data C to response
        inx     h
        mov     c,m
        mvi     b,$37                   ; DID - FSK center freq high
        call    L3C43                   ; Harris protocol code; add non-urgent DID B data C to response
        inx     h
        mov     c,m
        mvi     b,$39                   ; DID - FSK shift & shift polarity
        call    L3C43                   ; Harris protocol code; add non-urgent DID B data C to response
L3E34:
        ret


L3E35:  .db     $C7, $C5, $C3, $C1, $B5, $B3    ; DIDs freq low to high, BFO low to high
L3E3B:  .db     $35, $37, $39                   ; DIDs FSK low to high

;--------------------------------------------------------------------------------------------------
;       Harris protocol, report status
L3E3E:
        lxi     h,$A687                 ; Harris protocol action bits 
        mvi     a,$FB
        ana     m
        mov     m,a                     ; clear bit $04 (request status report bit)
        xra     a
        sta     $A6B1                   ; Harris protocol non-urgent message byte count
        lda     $A67A                   ; Radio state bits
        cpi     $04
        jz      L3EAB
        cpi     $01
        jz      L3E91
        lda     $A575                   ; Actively scanning flag ($FF means actively scanning)
        ora     a
        jz      L3E6A
        lda     $AB92                   ; Flag, scan stopped for received signal (=FF)
        ora     a
        jnz     L3E6A
        call    L3EB2                   ; Harris protocol - send urgent DID sequence for resuming scan
        jmp     L3E6D
L3E6A:
        call    L3EF1                   ; Harris protocol - send out state or suspend scan DID as urgent
L3E6D:
        lda     $A581                   ; Scan dwell (FF means external)
        cpi     $FF
        jz      L3E79
        mov     c,a
        call    L27DC                   ; Converts C to tens & ones BCD (99=>10011001 and 255=>01010101) in A (B has hundreds)
L3E79:
        mov     c,a
        mvi     b,$E5                   ; DID - Dwell
        call    L3C43                   ; Harris protocol code; add non-urgent DID B data C to response
        mvi     b,$E1                   ; DID - Scan start bound
        lda     $A57C                   ; Channel scanning lower bound
        mov     c,a
        call    L3C43                   ; Harris protocol code; add non-urgent DID B data C to response
        mvi     b,$E3                   ; DID - Scan end bound
        lda     $A57D                   ; Channel scanning upper bound
        mov     c,a
        call    L3C43                   ; Harris protocol code; add non-urgent DID B data C to response
L3E91:
        mvi     c,$13
        lxi     h,$A691
L3E96:
        mov     a,m
        cma
        mov     m,a
        inx     h
        dcr     c
        jnz     L3E96
        call    L3CC4                   ; Harris protocol, report differences in parameters since last subroutine run
        call    L3DB3                   ; P/O Harris protocol code
        call    L3D53                   ; Set flags to reacquire AGC and audio levels
        call    L3D62                   ; Reacquire AGC and audio levels based on flags
        ret
L3EAB:
        lxi     b,$CF04
        call    L3C5C                   ; Harris protocol code; add Urgent DID B data C to response
        ret
;--------------------------------------------------------------------------------------------------
;       Harris protocol - send urgent DID sequence for resuming scan
L3EB2:
        push    psw
        lda     $A57E
        cpi     $FF
        jnz     L3EC0
        call    L3EF1                   ; Harris protocol - send out state or suspend scan DID as urgent
        pop     psw
        ret
L3EC0:
        lda     $A57B                   ; Channel or group scan.  43=channel, 47=group
        mvi     c,$02
        cpi     $43
        jz      L3ECC
        mvi     c,$03
L3ECC:
        lxi     h,$A692
        mov     a,m
        cmp     c
        jz      L3EDE
        mov     m,c
        mov     a,c
        sta     $A67A                   ; Radio state bits
        mvi     b,$CF                   ; DID - State
        call    L3C5C                   ; Harris protocol code; add Urgent DID B data C to response
L3EDE:
        mvi     b,$E6                   ; DID - Resume scan
        call    L3C5C                   ; Harris protocol code; add Urgent DID B data C to response
        mvi     b,$93                   ; DID - Channel
        lda     $A558                   ; Channel number displayed on front panel (=A0 if none)
        sta     $A80D                   ; Harris protocol channel
        mov     c,a
        call    L3C5C                   ; Harris protocol code; add Urgent DID B data C to response
        pop     psw
        ret
;--------------------------------------------------------------------------------------------------
;       Harris protocol - send out state or suspend scan DID as urgent
L3EF1:
        push    psw
        lda     $A67A                   ; Radio state bits
        mov     c,a
        ani     $02
        jz      L3F08
        mvi     b,$E9                   ; DID - Suspend scan
        lda     $A558                   ; Channel number displayed on front panel (=A0 if none)
        mov     c,a
        cpi     $A0
        jc      L3F0A
        pop     psw
        ret
L3F08:
        mvi     b,$CF                   ; DID - State
L3F0A:
        call    L3C5C                   ; Harris protocol code; add Urgent DID B data C to response
        pop     psw
        ret
;--------------------------------------------------------------------------------------------------
;       Harris protocol, Error DIDs
L3F0F:
        mvi     c,$01                   ; Error DID 01, Invalid channel number
        jmp     L3F43
L3F14:
        mvi     c,$02                   ; Error DID 02, Invalid frequency
        jmp     L3F43
L3F19:
        mvi     c,$03                   ; Error DID 03, Invalid mode
        jmp     L3F43
L3F1E:
        mvi     c,$04                   ; Error DID 04, Invalid tuning method/AGC speed
        jmp     L3F43
L3F23:
        mvi     c,$05                   ; Error DID 05, Local control, cannot comply
        jmp     L3F43
L3F28:
        mvi     c,$06                   ; Error DID 06, Scanning, cannot program channel
        jmp     L3F43
L3F2D:
        mvi     c,$08                   ; Error DID 08, Invalid bandwidth
        jmp     L3F43
L3F32:
        mvi     c,$09                   ; Error DID 09, Invalid dwell time
        jmp     L3F43
L3F37:
        mvi     c,$0A                   ; Error DID 0A, Invalid group operation
        jmp     L3F43
L3F3C:
        mvi     c,$0C                   ; Error DID 0C, State error
        jmp     L3F43
L3F41:
        mvi     c,$0B                   ; Error DID 0B, Invalid data format
L3F43:
        mvi     b,$A3                   ; DID - Error
        jmp     L3C5C                   ; Harris protocol code; add Urgent DID B data C to response

;
L3F48:
        pop     h
        pop     h
        pop     h
        jmp     L3F43
;--------------------------------------------------------------------------------------------------
;       HL = $A809 + C
;
L3F4E:
        push    b
        mvi     b,$00                   ; B=0
        lhld    $A809                   ; HL=$A809
        dad     b                       ; HL = $A809 + BC
        pop     b
        ret
;--------------------------------------------------------------------------------------------------
;       Remote programming channel code
L3F57:
        lda     $A680                   ; Remote 'programming channel' flag
        ora     a
        jz      L3F83
        call    L3F86                   ; checksum
        rz
        lxi     h,$A54A                 ; remotely generated channel number going to commanded
        lda     $A68C
        cmp     m
        rnz                             ; exit if $A68C not equal to $A54A
        mvi     b,$A0
        mov     m,b                     ; $A54A=$A0
        lxi     h,$A558                 ; Channel number displayed on front panel (=A0 if none)
        cmp     m
        jnz     L3F75                   ; jump if $A68C not equal to $A558
        mov     m,b
L3F75:
        lxi     h,$A566                 ; Channel
        cmp     m
        rnz
        mov     m,b
        lxi     h,$ABEC                 ; Display update control see L06FD
        mvi     a,$80                   ; chan
        ora     m
        mov     m,a
        ret
L3F83:
        mvi     m,$FF
        ret
;--------------------------------------------------------------------------------------------------
;       checksum
L3F86:
        lhld    $A809
        call    L1D65                   ; A = sum of 13 bytes from HL
        cmp     m
        mov     m,a
        ret
;--------------------------------------------------------------------------------------------------
;       Jump to location DE
L3F8F:
        push    h
        xchg
        mov     e,m
        inx     h
        mov     d,m
        pop     h
        push    d
        ret
;--------------------------------------------------------------------------------------------------
;       Harris protocol, generates Error DID 06, Scanning, cannot program channel, if scanning
L3F97:
        lda     $A575                   ; Actively scanning flag ($FF means actively scanning)
        mvi     e,$FF
        cmp     e
        rnz
        lda     $A57E
        cmp     e
        rz
        pop     h
        jmp     L3F28                   ; Error DID 06, Scanning, cannot program channel
;--------------------------------------------------------------------------------------------------
;       Clear remote 'programming channel' flag
;
L3FA7:
        xra     a
        sta     $A680                   ; Remote 'programming channel' flag
        ret
;--------------------------------------------------------------------------------------------------
;       Interpret Harris protocol commands and jump via table
L3FAC:
        lxi     h,$A687                 ; Harris protocol action bits
        mvi     a,$F9
        ana     m
        mov     m,a                     ; clear bits $06 (request status report bit), (data message/interpret message & respond)
        lxi     h,$A757                 ; send byte count/data/flag
        mov     c,m
        push    b
        inx     h
        inx     h
        lxi     d,$A702
        push    d
        call    L27D3                   ; Move C bytes @HL to @DE
        pop     d
        pop     b
        xra     a
        sta     $A808
        sta     $A80B
        call    L3FA7                   ; Clear remote 'programming channel' flag
        lxi     h,$A559                 ; present receiver param block beginning
        shld    $A809
        xchg
        mov     e,c
L3FD5:
        mov     a,e
        ora     a
        jz      L406C
        mov     d,m
        dcr     e
        inx     h
        push    d
        push    h
        lda     $A80B
        ora     a
        jnz     L4001
        mov     a,d
        cpi     $80
        jnc     L4016
        cpi     $40
        jz      L3FF6
        cpi     $42
        jnz     L400E
L3FF6:
        sui     $3E
        rrc
        ani     $7F
        sta     $A80B
        jmp     L404E
L4001:
        mov     a,d
        cpi     $44
        jnz     L404E
        xra     a
        sta     $A80B
        jmp     L404E
L400E:
        cpi     $60
        jc      L4035
        jmp     L404E
L4016:
        mvi     a,$ED
        cmp     d
        jc      L404E
        lda     $A67A                   ; Radio state bits
        cpi     $04
        jnz     L4035
        mov     a,d
        cpi     $CF
        jz      L4035
        cpi     $D2
        jz      L4035
        call    L3F3C                   ; Error DID 0C, State error
        pop     h
        pop     d
        ret
L4035:
        mov     a,d                     ; offset is in D
        ani     $FE                     ; clear low bit
        sui     $30                     ; subtract $30
        mvi     b,$00
        mov     c,a
        lxi     h,L3B68                 ; use $3B68 table
        dad     b
        xchg
        lda     $A679                   ; Status bits
        ani     $80                     ; bit 80 true indicates local control
        mov     a,h
        rar
        pop     h
        push    h
        call    L3F8F                   ; Jump to location DE
L404E:
        lda     $A680                   ; Remote 'programming channel' flag
        ora     a
        jnz     L405B
        lxi     h,$A559                 ; present receiver param block beginning
        shld    $A809
L405B:
        pop     h
        pop     d
        mov     a,e
        ora     a
        jz      L406C
        mov     a,d
        rar
        jnc     L3FD5
        inx     h
        dcr     e
        jmp     L3FD5
L406C:
        lda     $A679                   ; Status bits
        ani     $80                     ; bit 80 true indicates local control
        cz      L1E05                   ; Set radio where present <> new commanded params
        ret
;--------------------------------------------------------------------------------------------------
;
;  Harris protocol NOP
;
L4075:
        ret
;--------------------------------------------------------------------------------------------------
;
; Harris protocol Spare 1,2
;
L4076:
        rnc
        jnz     L3F23                   ; Error DID 05, Local control, cannot comply
        mov     a,m
        mvi     c,$08
        call    L3F4E                   ; HL = $A809 + C ($A811)
        mov     m,a
        call    L3F86                   ; checksum
        ret
;--------------------------------------------------------------------------------------------------
;
; Harris protocol Who Are You
;
L4085:
        rc
        call    L3FA7                   ; Clear remote 'programming channel' flag
        lxi     h,$A687                 ; Harris protocol action bits
        mvi     a,$40
        ora     m
        mov     m,a                     ; set bit $40 (Who Are You request)
        ret
;--------------------------------------------------------------------------------------------------
;
; Harris protocol Program Channel Data
;
L4091:
        jnc     L40BD
        jnz     L40C2
        lda     $A575                   ; Actively scanning flag ($FF means actively scanning)
        ora     a
        jnz     L40B8
        mov     a,m
        call    L281C                   ; Test A: C=1 if A>$99 or low 4 bits >9
        jc      L40BD
        mov     b,a
        sta     $A68C
        call    L1CBF                   ; Get channel memory RAM addr in HL given BCD channel # in B
        xra     a
        sta     $A808
        shld    $A809
        cma
        sta     $A680                   ; set remote 'programming channel' flag
        ret
L40B8:
        mvi     c,$06
        jmp     L3F48
L40BD:
        mvi     c,$01
        jmp     L3F48
L40C2:
        mvi     c,$05
        jmp     L3F48
;--------------------------------------------------------------------------------------------------
;
; Harris protocol Group Program/Unprogram
;
L40C7:
        rnc
        jnz     L3F23                   ; Error DID 05, Local control, cannot comply
        call    L3FA7                   ; Clear remote 'programming channel' flag
        lda     $A579                   ; Holds group number
        cmp     m
        jnz     L40E6
        lda     $A67A                   ; Radio state bits
        cpi     $03
        jnz     L40E6
        mvi     c,$06
        lda     $A575                   ; Actively scanning flag ($FF means actively scanning)
        ora     a
        jnz     L4102
L40E6:
        mov     a,m
        cpi     $0A
        mvi     c,$0A
        jnc     L4102
        sta     $ABC4                   ; Channel storage for use in group programming
        dcx     h
        mov     a,m
        cpi     $97
        jnz     L40FD
        mvi     a,$47
        jmp     L4104
L40FD:
        mvi     a,$55
        jmp     L4104
L4102:
        mvi     a,$45
L4104:
        sta     $A808
        cpi     $45
        jz      L3F43
        ret
;--------------------------------------------------------------------------------------------------
;
; Harris protocol Report Group
;
L410D:
        rnc
        call    L3FA7                   ; Clear remote 'programming channel' flag
        mov     a,m
        cpi     $0A
        jnc     L3F37                   ; Error DID 0A, Invalid group operation
        mvi     b,$9B                   ; DID - Report group
        mov     c,a
        call    L3C43                   ; Harris protocol code; add non-urgent DID B data C to response
        mvi     d,$14
        call    L20E9                   ; Calc address of beginning of group C memory area (returned in HL)
        mvi     b,$93
L4124:
        mov     a,m
        cpi     $9A
        jnc     L412E
        mov     c,a
        call    L3C43                   ; Harris protocol code; add non-urgent DID B data C to response
L412E:
        inx     h
        dcr     d
        jnz     L4124
        ret
;--------------------------------------------------------------------------------------------------
;
; Harris protocol Receiver Command/Status
;
L4134:
        rnc
        jnz     L3F23                   ; Error DID 05, Local control, cannot comply
        call    L3FA7                   ; Clear remote 'programming channel' flag
        mov     a,m
        rrc
        push    psw
        call    L3234                   ; Disconnect ant and mute audio if called with carry set
        pop     psw
        rrc
        rrc
        rrc
        push    psw
        call    L1944                   ; Noise Blanker = not(carry)
        pop     psw
        ani     $01
        sta     $A68E
        ret
;--------------------------------------------------------------------------------------------------
;
; Harris protocol RF Gain
;
L4150:
        rnc
        jnz     L3F23                   ; Error DID 05, Local control, cannot comply
        call    L3FA7                   ; Clear remote 'programming channel' flag
        mov     a,m
        sta     $A67B                   ; RF atten
        ret
;--------------------------------------------------------------------------------------------------
;
; Harris protocol Stop Scan Threshold
;
L415C:
        rnc
        jnz     L3F23                   ; Error DID 05, Local control, cannot comply
        call    L3FA7                   ; Clear remote 'programming channel' flag
        mov     a,m
        sta     $AB91                   ; Auto Stop Scan Threshold (FF=off)
        sta     $A67D
        ret
;--------------------------------------------------------------------------------------------------
;
; Harris protocol BFO High
;
L416B:
        rnc
        jnz     L3F23                   ; Error DID 05, Local control, cannot comply
        call    L3F97                   ; Harris protocol, generates Error DID 06, Scanning, cannot program channel, if scanning
        mov     b,m
        mov     a,b
        ani     $F0
        jz      L417E
        cpi     $F0
        jnz     L3F41                   ; Error DID 0B, Invalid data format
L417E:
        mov     a,b
        ani     $0F
        cpi     $0A
        jnc     L3F41                   ; Error DID 0B, Invalid data format
        mvi     c,$05
        call    L3F4E                   ; HL = $A809 + C ($A80E)
        mov     m,b
        lxi     h,$ABF1
        call    L3F57                   ; Remote programming channel code
        ret
;--------------------------------------------------------------------------------------------------
;
; Harris protocol BFO Low
;
L4193:
        rnc
        jnz     L3F23                   ; Error DID 05, Local control, cannot comply
        call    L3F97                   ; Harris protocol, generates Error DID 06, Scanning, cannot program channel, if scanning
        mov     a,m
        call    L281C                   ; Test A: C=1 if A>$99 or low 4 bits >9
        jc      L3F41                   ; Error DID 0B, Invalid data format
        mvi     c,$04
        call    L3F4E                   ; HL = $A809 + C ($A80D)  (Harris protocol channel)
        mov     m,a
        lxi     h,$ABF1
        call    L3F57                   ; Remote programming channel code
        ret
;--------------------------------------------------------------------------------------------------
;
; Harris protocol Tuning method/AGC speed
;
L41AE:
        rnc
        jnz     L3F23                   ; Error DID 05, Local control, cannot comply
        call    L3F97                   ; Harris protocol, generates Error DID 06, Scanning, cannot program channel, if scanning
        mov     a,m
        rrc
        rrc
        rrc
        rrc
        ani     $0F
        mov     b,a
        mvi     c,$06
        call    L3F4E                   ; HL = $A809 + C  ($A80F)
        mov     a,m
        ani     $0F
        cpi     $09
        jnz     L41D3
        mov     a,b
        cpi     $06
        jz      L41E5
        jmp     L3F1E                   ; Error DID 04, Invalid tuning method/AGC speed
L41D3:
        mov     a,b
        cpi     $04
        jc      L41E5
        cpi     $05
        jz      L41E5
        cpi     $07
        jnz     L3F1E                   ; Error DID 04, Invalid tuning method/AGC speed
        mvi     b,$04
L41E5:
        mvi     c,$07
        call    L3F4E                   ; HL = $A809 + C ($A810)
        mov     a,m
        ani     $F0
        ora     b
        mov     m,a
        lxi     h,$ABF3
        call    L3F57                   ; Remote programming channel code
        ret
;--------------------------------------------------------------------------------------------------
;
; Harris protocol 10/1 MHz Frequency
;
L41F6:
        push    psw
        mov     a,m
        cpi     $2A
        jc      L4201
        pop     psw
        jmp     L3F14                   ; Error DID 02, Invalid frequency
L4201:
        pop     psw
        mvi     c,$03
        jmp     L4213
;
; Harris protocol 100/10 KHz Frequency
;
L4207:
        mvi     c,$02
        jmp     L4213
;
; Harris protocol 1000/100 Hz Frequency
;
L420C:
        mvi     c,$01
        jmp     L4213
;
; Harris protocol 10/1 Hz Frequency
;
L4211:
        mvi     c,$00
L4213:
        rnc
        jnz     L3F23                   ; Error DID 05, Local control, cannot comply
        call    L3F97                   ; Harris protocol, generates Error DID 06, Scanning, cannot program channel, if scanning
        mov     a,m
        call    L281C                   ; Test A: C=1 if A>$99 or low 4 bits >9
        jc      L3F41                   ; Error DID 0B, Invalid data format
        call    L3F4E                   ; HL = $A809 + C
        mov     m,a
        lxi     h,$ABF2
        call    L3F57                   ; Remote programming channel code
        ret
;--------------------------------------------------------------------------------------------------
;
; Harris protocol Mode
;
L422C:
        rnc
        jnz     L3F23                   ; Error DID 05, Local control, cannot comply
        call    L3F97                   ; Harris protocol, generates Error DID 06, Scanning, cannot program channel, if scanning
        mvi     a,$0F
        ana     m
        cpi     $0A
        jnc     L3F19                   ; Error DID 03, Invalid mode
        mov     b,a
        mvi     c,$07
        call    L1A34                   ; Find next filter supporting mode, mode B, current filter C, returns with B
        mov     a,b
        ani     $F0
        cpi     $F0
        jz      L3F19                   ; Error DID 03, Invalid mode
        mvi     c,$06
        call    L3F4E                   ; HL = $A809 + C ($A80F)
        mov     a,b
        ani     $0F
        cpi     $09
        jnz     L4269
        mvi     a,$0F
        ana     m
        cpi     $09
        jz      L4277
        inx     h
        mov     a,m
        sta     $A842
        mvi     m,$06
        dcx     h
        jmp     L4277
L4269:
        mvi     a,$0F
        ana     m
        cpi     $09
        jnz     L4277
        inx     h
        lda     $A842
        mov     m,a
        dcx     h
L4277:
        mov     m,b
        lxi     h,$ABF3
        call    L3F57                   ; Remote programming channel code
        ret
;--------------------------------------------------------------------------------------------------
;
; Harris protocol Self-test (BITE)
;
L427F:
        jnz     L3F23                   ; Error DID 05, Local control, cannot comply
        mvi     a,$04
        sta     $A67A                   ; Radio state bits
        xra     a
        sta     $A575                           ; Actively scanning flag ($FF means actively scanning)
        sta     $AB92                   ; Flag, scan stopped for received signal (=FF)
        cma
        sta     $ABEB                   ; in BITE mode if FF
        call    L3FA7                   ; Clear remote 'programming channel' flag
        lda     $A682                   ; Status bits
        lxi     h,$07D0
        shld    $ABD4
        ori     $01
        sta     $A682                   ; Status bits
        ret
;--------------------------------------------------------------------------------------------------
;
; Harris protocol Dwell
;
L42A4:
        rnc
        jnz     L3F23                   ; Error DID 05, Local control, cannot comply
        xra     a
        sta     $A680                   ; clear remote 'programming channel' flag
        mov     b,m
        mvi     c,$0B
        lxi     d,$42D2
L42B2:
        ldax    d
        cmp     b
        jz      L42BF
        dcr     c
        dcx     d
        jp      L42B2
        jmp     L3F32                   ; Error DID 09, Invalid dwell time
L42BF:
        mov     a,c
        sta     $A580                   ; Scan Dwell pointer; $0B means external.
        call    L22E2                   ; Scan dwell setting code
        ret

;
L42C7:  .DB     $01, $02, $04, $05, $08, $10
        .DB     $20, $40, $50, $80, $99, $FF

;--------------------------------------------------------------------------------------------------
; Harris protocol reacquire USB AGC Level
;
L42D3:
        rc
        mvi     a,$FF
        sta     $A83D                   ; Flag, if FF then remeasure USB AGC Level
        ret
;--------------------------------------------------------------------------------------------------
; Harris protocol reacquire LSB AGC Level
;
L42DA:
        rc
        mvi     a,$FF
        sta     $A83E                   ; Flag, if FF then remeasure LSB AGC Level
        ret
;--------------------------------------------------------------------------------------------------
; Harris protocol reacquire USB Line Audio Level
;
L42E1:
        rc
        mvi     a,$FF
        sta     $A83F                   ; Flag, if FF then remeasure USB Line Audio Level
        ret
;--------------------------------------------------------------------------------------------------
; Harris protocol reacquire LSB Line Audio Level
;
L42E8:
        rc
        mvi     a,$FF
        sta     $A840                   ; Flag, if FF then remeasure LSB Line Audio Level
        ret
;--------------------------------------------------------------------------------------------------
;
; Harris protocol FSK Center Freq Low
;
L42EF: 
        rnc
        jnz     L3F23                   ; Error DID 05, Local control, cannot comply
        call    L3F97                   ; Harris protocol, generates Error DID 06, Scanning, cannot program channel, if scanning
        lda     $A825                   ; FSK option installed flag. Zero if not installed
        ora     a
        jz      L3F19                   ; Error DID 03, Invalid mode
        mov     a,m
        call    L281C                   ; Test A: C=1 if A>$99 or low 4 bits >9
        jc      L3F41                   ; Error DID 0B, Invalid data format
        mvi     c,$09
        call    L3F4E                   ; HL = $A809 + C ($A812)
        mov     m,a
        lxi     h,$ABF1
        call    L3F57                   ; Remote programming channel code
        ret
;--------------------------------------------------------------------------------------------------
;
; Harris protocol FSK Center Freq High
;
L4311:
        rnc
        jnz     L3F23                   ; Error DID 05, Local control, cannot comply
        call    L3F97                   ; Harris protocol, generates Error DID 06, Scanning, cannot program channel, if scanning
        lda     $A825                   ; FSK option installed flag. Zero if not installed
        ora     a
        jz      L3F19                   ; Error DID 03, Invalid mode
        mov     a,m
        ani     $0F
        cpi     $0A
        jnc     L3F41                   ; Error DID 0B, Invalid data format
        mov     a,m
        ani     $BF
        mvi     c,$0A
        call    L3F4E                   ; HL = $A809 + C ($A813)
        mov     m,a
        lxi     h,$ABF1
        call    L3F57                   ; Remote programming channel code
        ret
;--------------------------------------------------------------------------------------------------
;
; Harris protocol FSK Shift & Shift Polarity
;
L4337:
        rnc
        jnz     L3F23                   ; Error DID 05, Local control, cannot comply
        call    L3F97                   ; Harris protocol, generates Error DID 06, Scanning, cannot program channel, if scanning
        lda     $A825                   ; FSK option installed flag. Zero if not installed
        ora     a
        jz      L3F19                   ; Error DID 03, Invalid mode
        mov     a,m
        ani     $83
        mvi     c,$0B
        call    L3F4E                   ; HL = $A809 + C ($A814)
        mov     m,a
        lxi     h,$ABF3
        call    L3F57                   ; Remote programming channel code
        ret
;--------------------------------------------------------------------------------------------------
;
; Harris protocol Options
;
L4355:
        jc      L435E
        call    L54CD
        jmp     L4371
L435E:
        jnz     L3F23                   ; Error DID 05, Local control, cannot comply
        mov     a,m
        rrc
        rrc
        rrc
        ani     $1F
        mov     c,a
        mov     a,m
        ani     $07
        call    L547E
        jc      L3F41                   ; Error DID 0B, Invalid data format
L4371:
        ret
;--------------------------------------------------------------------------------------------------
;
; Harris protocol Bandwidth Configuration
;
L4372:
        rc
        call    L3FA7                   ; Clear remote 'programming channel' flag
        mvi     b,$89                   ; DID - Bandwidth configuration
        lxi     h,$ABF8
        mvi     e,$08
L437D:
        mov     c,m
        call    L3C43                   ; Harris protocol code; add non-urgent DID B data C to response
        inx     h
        dcr     e
        jnz     L437D
        ret
;--------------------------------------------------------------------------------------------------
;
; Harris protocol Report Channel Data
;
L4387:
        rnc
        call    L3FA7                   ; Clear remote 'programming channel' flag
        mov     a,m
        call    L281C                   ; Test A: C=1 if A>$99 or low 4 bits >9
        jc      L3F0F                   ; Error DID 01, Invalid channel number
        mvi     b,$91                   ; DID - Report channel data
        mov     c,a
        xra     a
        sta     $A6B1                   ; Harris protocol non-urgent message byte count
        call    L3C43                   ; Harris protocol code; add non-urgent DID B data C to response
        mov     b,m
        call    L1CBF                   ; Get channel memory RAM addr in HL given BCD channel # in B
        shld    $A809
        push    h
        lxi     b,$0007
        dad     b
        mov     a,m
        ani     $80
        mvi     b,$EC                   ; DID - Unlock channel
        jz      L43B2
        mvi     b,$EA                   ; DID - Lockout channel
L43B2:
        call    L3C43                   ; Harris protocol code; add non-urgent DID B data C to response
        pop     h
        call    L3DD9                   ; Harris protocol, add DIDs for channel data to response
        mvi     a,$FF
        sta     $A68D
        ret
;--------------------------------------------------------------------------------------------------
;
; Harris protocol Channel
;
L43BF:
        rnc
        jnz     L3F23                   ; Error DID 05, Local control, cannot comply
        call    L3FA7                   ; Clear remote 'programming channel' flag
        mov     a,m
        call    L281C                   ; Test A: C=1 if A>$99 or low 4 bits >9
        jc      L3F0F                   ; Error DID 01, Invalid channel number
        mov     b,a
        lda     $ABC4                   ; Channel storage for use in group programming
        mov     c,a
        lda     $A808
        ora     a
        jnz     L43DD
        call    L1D0F                   ; Set radio to BCD chan # in B
        ret
L43DD:
        cpi     $47
        jnz     L43EA
        mov     a,b
        call    L21AE                   ; Put channel A into spot with $EE in group C
        rnc
        jmp     L3F37                   ; Error DID 0A, Invalid group operation
L43EA:
        cpi     $55
        rnz
        mov     a,b
        call    L21B7                   ; Replace channel A in group C with $EE
        rnc
        jmp     L3F37                   ; Error DID 0A, Invalid group operation
;--------------------------------------------------------------------------------------------------
;
; Harris protocol Bandwidth
;
L43F5:
        rnc
        jnz     L3F23                   ; Error DID 05, Local control, cannot comply
        mov     a,m
        lxi     h,$ABFF
        mvi     c,$07
L43FF:
        cmp     m
        jz      L440B
        dcx     h
        dcr     c
        jp      L43FF
        jmp     L3F2D                   ; Error DID 08, Invalid bandwidth
L440B:
        push    b
        mvi     c,$06
        call    L3F4E                   ; HL = $A809 + C ($A80F)
        mvi     a,$0F
        ana     m
        mov     e,a
        pop     b
        mov     a,c
        cpi     $02
        jnc     L4429
        mov     a,e
        cpi     $04
        jc      L4429
        cpi     $07
        jnc     L4429
        mvi     c,$00
L4429:
        push    h
        mvi     d,$00
        lxi     h,L444F
        dad     d
        mov     a,m
        lxi     h,$AC01
        mvi     b,$00
        dad     b
        mov     b,m
        pop     h
        ana     b
        jz      L3F2D                   ; Error DID 08, Invalid bandwidth
        mov     a,c
        rlc
        rlc
        rlc
        rlc
        mov     c,a
        mvi     a,$0F
        ana     m
        ora     c
        mov     m,a
        lxi     h,$ABF3
        call    L3F57                   ; Remote programming channel code
        ret

;
L444F:  .DB     $02, $00, $04, $01, $01, $01
        .DB     $01, $00, $08, $10

;--------------------------------------------------------------------------------------------------
;
; Harris protocol State
;
L4459:
        rnc
        jnz     L3F23                   ; Error DID 05, Local control, cannot comply
        mov     a,m
        ora     a
        jz      L3F41                   ; Error DID 0B, Invalid data format
        cpi     $04
        jnc     L3F41                   ; Error DID 0B, Invalid data format
        lda     $A682                   ; Status bits
        ani     $02
        jnz     L3F3C                   ; Error DID 0C, State error
        sta     $A808
        sta     $ABEB                   ; in BITE mode if FF
        sta     $ABB5                   ; Front panel LEDs
        mov     a,m
        sta     $A67A                   ; Radio state bits
        call    L3FA7                   ; Clear remote 'programming channel' flag
        lda     $A682                   ; Status bits
        ani     $FE
        sta     $A682                   ; Status bits
        mvi     a,$0E
        sta     $ABCB
        mov     a,m
        cpi     $01
        jnz     L4496
        call    L16A2                   ; Start receive mode
        ret
L4496:
        mvi     c,$28
        cpi     $03
        mvi     a,$47
        jz      L44A1
        mvi     a,$43
L44A1:
        sta     $A57B                   ; Channel or group scan.  43=channel, 47=group
        lxi     h,$ABB4                 ; Front panel LEDs
        mov     a,m
        ani     $01
        ora     c
        mov     m,a
        lxi     h,$ABEC                 ; Display update control see L06FD
        mvi     a,$01                   ; update now
        ora     m
        mov     m,a
        ret
;--------------------------------------------------------------------------------------------------
;
; Harris protocol Report Complete Status
;
L44B4:
        call    L3FA7                   ; Clear remote 'programming channel' flag
        lxi     h,$A687                 ; Harris protocol action bits
        mvi     a,$04
        ora     m
        mov     m,a                     ; set action bit $04 (request status report bit)
        ret
;--------------------------------------------------------------------------------------------------
;
; Harris protocol Increment Channel
;
L44BF:
        rc
        jnz     L3F23                   ; Error DID 05, Local control, cannot comply
        call    L3FA7                   ; Clear remote 'programming channel' flag
        xra     a
        sta     $A56C                   ; Decimal movement of tuning wheel
        lda     $A67A                   ; Radio state bits
        cpi     $03
        jnz     L44DB
        call    L213D                   ; Group (and maybe scan) logic
        jnc     L44FE
        jmp     L3F37                   ; Error DID 0A, Invalid group operation
L44DB:
        cpi     $02
        jnz     L44E9
        lda     $A558                   ; Channel number displayed on front panel (=A0 if none)
        lhld    $A57C                   ; Channel scanning lower bound
        jmp     L44F7
L44E9:
        cpi     $01
        rnz
        lxi     h,$9900
        lda     $A558                   ; Channel number displayed on front panel (=A0 if none)
        cpi     $A0
        jz      L3F0F                   ; Error DID 01, Invalid channel number
L44F7:
        mov     b,a
        mvi     a,$01
        ora     a
        call    L28A3                   ; Increment/decrement channel logic.  Carry=1 means dec, B=present chan, HL=valid range of chans
L44FE:
        jmp     L453D
;--------------------------------------------------------------------------------------------------
;
; Harris protocol Decrement Channel
;
L4501:
        rc
        jnz     L3F23                   ; Error DID 05, Local control, cannot comply
        call    L3FA7                   ; Clear remote 'programming channel' flag
        lda     $A67A                   ; Radio state bits
        cpi     $03
        jnz     L451A
        stc
        call    L213D                   ; Group (and maybe scan) logic
        jnc     L453D
        jmp     L3F37                   ; Error DID 0A, Invalid group operation
L451A:
        cpi     $02
        jnz     L4528
        lda     $A558                   ; Channel number displayed on front panel (=A0 if none)
        lhld    $A57C                   ; Channel scanning lower bound
        jmp     L4536
L4528:
        cpi     $01
        rnz
        lxi     h,$9900
        lda     $A558                   ; Channel number displayed on front panel (=A0 if none)
        cpi     $A0
        jz      L3F0F                   ; Error DID 01, Invalid channel number
L4536:
        mov     b,a
        mvi     a,$01
        stc
        call    L28A3                   ; Increment/decrement channel logic.  Carry=1 means dec, B=present chan, HL=valid range of chans
L453D:
        mov     b,a
        call    L1D0F                   ; Set radio to BCD chan # in B
        lda     $A575                           ; Actively scanning flag ($FF means actively scanning)
        ora     a
        rz
        lda     $A57F
        sta     $A57E
        mov     a,b
        sta     $A582                   ; Scan channel
        ret
;--------------------------------------------------------------------------------------------------
;
; Harris protocol Scan Start Bound
;
L4551:
        lxi     d,$A57C                   ; Channel scanning lower bound
        jmp     L455A
;
; Harris protocol Scan End Bound
;
L4557:
        lxi     d,$A57D                   ; Channel scanning upper bound
L455A:
        jnz     L3F23                   ; Error DID 05, Local control, cannot comply
        rnc
        call    L3FA7                   ; Clear remote 'programming channel' flag
        mov     a,m
        call    L281C                   ; Test A: C=1 if A>$99 or low 4 bits >9
        jc      L3F0F                   ; Error DID 01, Invalid channel number
L4568:
        stax    d
        ret
;--------------------------------------------------------------------------------------------------
;
; Harris protocol Resume Scan
;
L456A:
        jnz     L3F23                   ; Error DID 05, Local control, cannot comply
        call    L3FA7                   ; Clear remote 'programming channel' flag
        lda     $A67A                   ; Radio state bits
        cpi     $01
        jz      L3F3C                   ; Error DID 0C, State error
        mov     c,a
        dcx     h
        mov     a,m
        inx     h
        rar
        jnc     L4599
        mvi     a,$02
        cmp     c
        jz      L45B7
        mov     c,m
        mvi     a,$09
        cmp     c
        jc      L3F37                   ; Error DID 0A, Invalid group operation
        call    L2109                   ; Utility setup code for group (called with group # in C)
        jc      L3F37                   ; Error DID 0A, Invalid group operation
        lhld    $A667                   ; Pointer for member of group
        jmp     L45B7
L4599:
        call    L22B1                   ; High level scan code
        mvi     a,$02
        cmp     c
        lxi     h,$A582                 ; Scan channel
        jz      L45B7
        lhld    $A665                   ; Pointer for member of group
        push    h
        lda     $A579                   ; Holds group number
        mov     c,a
        call    L2109                   ; Utility setup code for group (called with group # in C)
        pop     h
        jc      L3F37                   ; Error DID 0A, Invalid group operation
        shld    $A665                   ; Pointer for member of group
L45B7:
        mov     a,m
        call    L281C                   ; Test A: C=1 if A>$99 or low 4 bits >9
        jnc     L45C2
        inx     h
        jmp     L45B7
L45C2:
        mov     b,m
        call    L1D0F                   ; Set radio to BCD chan # in B
        jc      L3F0F                   ; Error DID 01, Invalid channel number
        mov     a,b
        sta     $A582                   ; Scan channel
        call    L23DA                   ; Init & start scan
        lxi     h,$ABEC                 ; Display update control see L06FD
        mvi     a,$02                   ; dwell
        ora     m
        mov     m,a
        ret
;--------------------------------------------------------------------------------------------------
;
; Harris protocol Suspend Scan
;
L45D8:
        rc
        jnz     L3F23                   ; Error DID 05, Local control, cannot comply
        call    L3FA7                   ; Clear remote 'programming channel' flag
        lda     $A67A                   ; Radio state bits
        cpi     $01
        jz      L3F3C                   ; Error DID 0C, State error
        call    L23B6                   ; Stopping scan, not due to received signal
        mvi     b,$E9                   ; DID - Suspend scan
        lda     $A558                   ; Channel number displayed on front panel (=A0 if none)
        mov     c,a
        call    L3C5C                   ; Harris protocol code; add Urgent DID B data C to response
        ret
;--------------------------------------------------------------------------------------------------
;
; Harris protocol Lock/Unlock channel
;
L45F4:
        rnc
        jnz     L3F23                   ; Error DID 05, Local control, cannot comply
        call    L3FA7                   ; Clear remote 'programming channel' flag
        mov     a,m
        call    L281C                   ; Test A: C=1 if A>$99 or low 4 bits >9
        jc      L3F0F                   ; Error DID 01, Invalid channel number
        mov     b,a
        dcx     h
        mov     c,m
        lhld    $A809
        xchg
        call    L1CBF                   ; Get channel memory RAM addr in HL given BCD channel # in B
        shld    $A809
        mov     b,c
        mvi     c,$07
        call    L3F4E                   ; HL = $A809 + C ($A810)
        mvi     a,$EB
        cmp     b
        mov     a,m
        jnz     L4621
        ori     $80
        jmp     L4623
L4621:
        ani     $7F
L4623:
        mov     m,a
        call    L3F86                   ; checksum
        xchg
        shld    $A809
        ret
;--------------------------------------------------------------------------------------------------
;       Reset Harris protocol state machine
L462C:
        lxi     h,L466C                 ; Detect Harris protocol header preamble FF F5, call L463A if so.
        shld    $A689                   ; Jump to L466C on next char received
        lxi     h,$A687                 ; Harris protocol action bits
        mvi     a,$F7
        ana     m
        mov     m,a                     ; Clear bit $08 (report equipment type)
        ret
;--------------------------------------------------------------------------------------------------
;       Harris protocol, keep track of incoming 4 byte messages
L463A:
        lxi     h,L468E                 ; Harris protocol, receive next byte
        shld    $A689                   ; Jump to L468E on next char received
        mvi     a,$04
        sta     $A752                   ; Harris protocol incoming message data and checksum total byte count = 4
        lxi     h,$A755
        shld    $A753                   ; Harris protocol pointer, received characters
        lxi     h,$A687                 ; Harris protocol action bits
        mvi     a,$F7
        ana     m
        mov     m,a                     ; clear bit $08 (report equipment type)
        ret
;--------------------------------------------------------------------------------------------------
;       Harris protocol - place first char in buffer and set count to 1
L4653:
        mov     a,b
        cpi     $FF
        rz                              ; return if B = $FF
        cpi     $F5
        jz      L463A                   ; Harris protocol, keep track of incoming 4 byte messages
        lxi     h,$A757                 ; send byte count/data/flag
        mvi     m,$01
        inx     h
        inx     h
        mov     m,b
        lxi     h,$A687                 ; Harris protocol action bits
        mvi     a,$02
        ora     m
        mov     m,a                     ; set bit $02 (data message/interpret message & respond)
        ret
;--------------------------------------------------------------------------------------------------
;       Detect Harris protocol header preamble FF F5, call L463A if so.
;       If B=$FF set $A687 bit $01; else if $A687 bit $01 set, (if B=$F5 call L463A) clear $A687 bit $01
L466C:
        mvi     a,$FF
        cmp     b
        jnz     L467A
        lxi     h,$A687                 ; Harris protocol action bits
        mvi     a,$01
        ora     m
        mov     m,a                     ; set bit $01 ($FF received, waiting for $F5)
        ret
L467A:
        lda     $A687                   ; Harris protocol action bits
        ani     $01
        rz
        mvi     a,$F5
        cmp     b
        cz      L463A                   ; Harris protocol, keep track of incoming 4 byte messages
        lxi     h,$A687                 ; Harris protocol action bits
        mvi     a,$FE
        ana     m
        mov     m,a                     ; clear bit $01 ($FF received, waiting for $F5)
        ret
;--------------------------------------------------------------------------------------------------
;       Harris protocol, receive next byte
L468E:
        lhld    $A753                   ; Harris protocol pointer, received characters
        mov     m,b
        inx     h
        shld    $A753                   ; Harris protocol pointer, received characters
        lxi     h,$A752                 ; Harris protocol incoming message data and checksum total byte count
        dcr     m
        jz      L46D2                   ; Harris protocol message received, process it
        jm      L462C                   ; Reset Harris protocol state machine
        mov     a,m
        cpi     $03
        rnz
        mov     a,b
        cpi     $01
        jc      L46AD
        cpi     $07
        rc
L46AD:
        lxi     h,L466C                 ; Detect Harris protocol header preamble FF F5, call L463A if so.
        shld    $A689                   ; Jump to L466C on next char received
        cpi     $FF
        rnz
        lxi     h,$A687                 ; Harris protocol action bits
        mvi     a,$01
        ora     m
        mov     m,a                     ; set bit $01 ($FF received, waiting for $F5)
        ret
;--------------------------------------------------------------------------------------------------
;       Harris protocol process HRRCP data messages
L46BE:
        lhld    $A753                   ; Harris protocol pointer, received characters
        mov     m,b
        inx     h
        shld    $A753                   ; Harris protocol pointer, received characters
        lxi     h,$A752                 ; Harris protocol incoming message data and checksum total byte count
        dcr     m
        rnz
        call    L47A5                   ; Harris protocol, check radio ID and message CRC
        call    L462C                   ; Reset Harris protocol state machine
        ret
;--------------------------------------------------------------------------------------------------
;       Harris protocol message received, process it
L46D2:
        lxi     h,$A755
        call    L47E3                   ; Returns checksum byte in A for $A755, $A756, $A757
        cmp     m                       ; compare to checksum byte received
        jnz     L462C                   ; Reset Harris protocol state machine if checksum bad
        lxi     h,$A755
        mov     a,m
        cpi     $01                     ; is message type 01: HRRCP data messages ?
        jnz     L46FD                   ; jump if not type 01
        lda     $A757                   ; get byte count
        ora     a
        jm      L462C                   ; Reset Harris protocol state machine if byte count >$7F
        cpi     $31
        jnc     L462C                   ; Reset Harris protocol state machine if byte count >$30
        adi     $02
        sta     $A752                   ; add 2 to total byte count to include CRC
        lxi     h,L46BE
        shld    $A689                   ; Jump to L46BE on next char received
        ret
L46FD:
        cpi     $06                     ; message type 06: ESCAPE
        jnz     L471E                   ; jump if not
        lda     $AC3B                   ; Radio ID
        inx     h
        cmp     m                       ; radio ID match?
        jnz     L462C                   ; Reset Harris protocol state machine if not
        mvi     a,$03
        sta     $A68B                   ; $A68B=$03
        lda     $A687                   ; Harris protocol action bits
        ori     $08
        sta     $A687                   ; set bit $08 (report equipment type)
        lxi     h,L4653
        shld    $A689                   ; Jump to L4653 on next char received
        ret
L471E:                                  ; if radio ID matches, decode message type then reset state machine
        inx     h
        lda     $AC3B                   ; Radio ID
        cmp     m
        cz      L4729                   ; Harris protocol - decode message type
        jmp     L462C                   ; Reset Harris protocol state machine
;--------------------------------------------------------------------------------------------------
; Harris protocol - decode message type
;
; MESSAGE TYPE SUMMARY 
;
; 01: HRRCP data messages
; 02: HRRCP short data messages
; 03: ACK
; 04: NAK
; 05: POLL
; 06: ESCAPE
; 07: Special Products protocol data messages
; 08: Special Products protocol short data messages
; 09: HARCP data messages
; 0A: HARCP short data messages
; 0B: HESP data messages
; 0C: HESP short data messages
; 0D: AT protocol data messages
; 0E: -- reserved
; 0F: MFR protocol data messages
; 10: -- reserved
; 11: IMC or HMRCP data messages
; 12: HMRCP short data messages
; 13: HTSCP data messages
; 14: HTSCP short data messages
; 15: HAARCP data messages
; 16: HAARCP short data messages
;

L4729:
        dcx     h
        mov     a,m
        cpi     $02                     ; message type 02: HRRCP short data messages
        jnz     L474B
        lda     $A757                   ; send byte count/data/flag
        sta     $A759                   ; $A759 = $A757
        mvi     m,$01                   ; replace message type with 01
        mvi     a,$01
        sta     $A757                   ; $A757=$01
        mvi     a,$03
        sta     $A68B                   ; $A68B=$03
        lda     $A687                   ; Harris protocol action bits
        ori     $02
        sta     $A687                   ; set bit $02 (data message/interpret message & respond)
        ret
L474B:
        cpi     $04                     ; message type 04: NAK
        jnz     L4756
        mvi     a,$10
        sta     $A68B                   ; $A68B=$10
        ret
L4756:
        cpi     $05                     ; message type 05: POLL
        jnz     L478D
        mvi     a,$05
        sta     $A68B                   ; $A68B=$05
        inx     h
        inx     h
        mov     a,m                     ; get flag byte
        ani     $04                     ; 'report status' bit set?
        jnz     L4770                   ; jump if so
        lda     $A688
        ani     $01
        jz      L4780                   ; if $A688 bit $01 set, act like 'report status' bit set
L4770:
        lda     $A688
        ani     $FE
        sta     $A688                   ; clear $A688 bit $01
        lda     $A687                   ; Harris protocol action bits
        ori     $04
        sta     $A687                   ; set bit $04  (request status report bit)
L4780:
        mov     a,m
        ani     $08                     ; 'report equipment type' bit set?
        rz                              ; return if not
        lda     $A687                   ; Harris protocol action bits
        ori     $40
        sta     $A687                   ; set bit $40 (Who Are You request)
        ret
L478D:
        cpi     $03                     ; message type 03: ACK
        rnz
        xra     a
        sta     $A68B                   ; $A68B=0
        lda     $A688
        ani     $FE
        sta     $A688                   ; clear $A688 bit $01
        lda     $A687                   ; Harris protocol action bits
        ori     $10
        sta     $A687                   ; set bit $10 (ACK message)
        ret
;--------------------------------------------------------------------------------------------------
;       Harris protocol, check radio ID and message CRC
L47A5:
        lxi     h,$A756
        mov     a,m
        ora     a
        jnz     L47C1
        xra     a
        sta     $A68B
        dcx     h
        call    L47ED                   ; Harris protocol CRC generation.  HL points to header, CRC returned in DE
        mov     a,e
        ora     d
        rnz
        lda     $A687                   ; Harris protocol action bits
        ori     $02
        sta     $A687                   ; set bit $02 (data message/interpret message & respond)
        ret
L47C1:
        lda     $AC3B                   ; Radio ID
        cmp     m
        rnz
        dcx     h
        call    L47ED                   ; Harris protocol CRC generation.  HL points to header, CRC returned in DE
        mov     a,e
        ora     d
        jnz     L47DD
        lda     $A687                   ; Harris protocol action bits
        ori     $02
        sta     $A687                   ; set bit $02 (data message/interpret message & respond)
        mvi     a,$03
        sta     $A68B
        ret
L47DD:
        mvi     a,$04
        sta     $A68B
        ret
;--------------------------------------------------------------------------------------------------
;       Returns checksum byte in A for HL, HL+1, HL+2
L47E3:
        mvi     c,$03
        xra     a
L47E6:
        xra     m
        inx     h
        dcr     c
        jnz     L47E6
        ret
;--------------------------------------------------------------------------------------------------
;       Harris protocol CRC generation.  HL points to header, CRC returned in DE
L47ED:
        inx     h
        inx     h
        mov     c,m
        inr     c
        inr     c
        inx     h
        inx     h
L47F4:
        lxi     d,$0000
L47F7:
        mov     a,m
        xra     d                       ; scratch2 = Character(i) XOR Crc_high
        mov     b,a
        rrc
        rrc
        rrc
        rrc
        ani     $0F                     ; scratch3 = scratch2 divided by 16
        xra     b                       ; scratch2 = scratch2 XOR scratch3
        mov     b,a
        add     a
        add     a
        add     a
        add     a                       ; scratch1 = scratch2 multiplied by 16
        xra     e                       ; scratch1 = scratch1 XOR Crc_low
        mov     d,a
        mov     a,b
        rrc
        rrc
        rrc
        ani     $1F                     ; scratch3 = scratch2 divided by 8
        xra     d
        mov     d,a                     ; Crc_high = scratch3 XOR scratch1
        mov     a,b
        rrc
        rrc
        rrc
        ani     $E0                     ; scratch3 = scratch2 multiplied by 32
        xra     b
        mov     e,a                     ; Crc_low = scratch3 XOR scratch2
        inx     h
        dcr     c
        jnz     L47F7
        ret

;--------------------------------------------------------------------------------------------------
;
;
; The following is an example pseudo-code section for CRC calculation of a message.  It assumes the message has been stored 
; in an array called Character with the number of bytes in a variable called Charactercount.  The results are stored in 
; Crchigh and Crclow, which should be initialized to zero before starting the calculation.  
;
; /* CRC check */
;
;        DO i = 0 TO (Character_count - 1)
;                scratch2 = Character(i) XOR Crc_high
;                scratch3 = scratch2 divided by 16
;                scratch2 = scratch2 XOR scratch3
;                scratch1 = scratch2 multiplied by 16
;                scratch1 = scratch1 XOR Crc_low
;                scratch3 = scratch2 divided by 8
;                Crc_high = scratch3 XOR scratch1
;                scratch3 = scratch2 multiplied by 32
;                Crc_low = scratch3 XOR scratch2
;        END
;
; CRC Examples
;
; The following strings of hexadecimal bytes have had CRC values calculated, and may be used for testing of CRC algorithms.  
; The CRC bytes are shown in the order that they would be appended to the data packet.
;
; 4 bytes:        CB      88      C1      27                                      CRC = 4E A0 
; 6 bytes:        AD      16      A7      01      AF      00                      CRC = E7 9F
; 8 bytes:        C1      29      C9      03      CD      03      AB      00      CRC = 03 4E
;
;

;--------------------------------------------------------------------------------------------------
;       Harris protocol, set up outgoing message
L481E:
        lxi     h,$A7A8                 ; Harris protocol transmit buffer
        mvi     m,$FF                   ; make first byte $FF
        inx     h
        mvi     m,$F5                   ; make second byte $F5
        lda     $A68B
        cpi     $03
        jz      L4833                   ; call L4882 if $A68B = $03 or $04  (ACK or NAK)
        cpi     $04
        jnz     L4839
L4833:
        call    L4882                   ; Harris protocol - make flag byte (ACK and NAK responses here)
        jmp     L4866
L4839:
        cpi     $10
        jnz     L4860
        lda     $A7AA
        cpi     $01                     ; type 01?
        jnz     L4858
        lda     $A688
        ani     $01
        jnz     L4852
        sta     $A68B
        ret
L4852:
        call    L48A7                   ; Set # chars to xmt at $A7AC + 8 for Harris protocol
        jmp     L4866
L4858:
        mvi     a,$06
        sta     $A7A5                   ; set to 6, Harris protocol # chars left to transmit
        jmp     L4866
L4860:
        cpi     $05
        rnz
        call    L48B0                   ; Harris protocol - process WRU rqst, xfer data to xmt buffer and append CRC
L4866:
        xra     a
        sta     $A68B                   ; $A68B=0
        lda     $AC3B                   ; Radio ID
        sta     $A7AB
        lxi     h,$A7A8                 ; Harris protocol transmit buffer
        shld    $A7A6                   ; set Harris protocol transmit buffer pointer to beginning of buffer
        inx     h
        inx     h
        call    L47E3                   ; Returns checksum byte in A for HL, HL+1, HL+2
        mov     m,a                     ; add checksum to outgoing message
        di                              ; Disable Interrupts
        call    L38E0
        ei                              ; Enable interrupts
        ret
;--------------------------------------------------------------------------------------------------
;       Harris protocol - make flag byte
L4882:
        sta     $A7AA                   ; set type to A
        mvi     b,$00
        lda     $A6A4                   ; Harris protocol byte count for urgent message
        ora     a
        jz      L4892                   ; jump if A6A4=0
        mov     a,b
        ori     $01
        mov     b,a
L4892:
        lda     $A6B1                   ; Harris protocol non-urgent message byte count
        ora     a
        jz      L489D
        mov     a,b
        ori     $02
        mov     b,a
L489D:
        mov     a,b
        sta     $A7AC                   ; flag byte
        mvi     a,$06
        sta     $A7A5                   ; Harris protocol # chars left to transmit
        ret
;--------------------------------------------------------------------------------------------------
;       Set # chars to xmt at $A7AC + 8 for Harris protocol
L48A7:
        lda     $A7AC                   ; byte count
        adi     $08
        sta     $A7A5                   ; Harris protocol # chars left to transmit
        ret
;--------------------------------------------------------------------------------------------------
;       Harris protocol - process WRU rqst, xfer data to xmt buffer and append CRC
L48B0:
        lxi     h,$A687                 ; Harris protocol action bits
        mov     a,m
        ani     $40                     ; bit $40 (Who Are You request)
        jz      L48D6                   ; jump if not requesting WRO
        mov     a,m
        ani     $BF                     ; clear bit $40
        mov     m,a
        lxi     b,$8710
        lda     $ABC5                   ; 2ISB option installed flag (0=not installed, FF=installed)
        ora     a
        jz      L48C8
        inx     b                       ; BC=BC+1 if 2ISB installed
L48C8:
        lda     $A825                   ; FSK option installed flag. Zero if not installed
        ora     a
        jz      L48D3
        mov     a,c
        ori     $80                     ; set bit $80 of C (BC) if FSK option installed
        mov     c,a
L48D3:
        call    L3C43                   ; Harris protocol code; add non-urgent DID B data C to response
L48D6:
        call    L4925                   ; Harris protocol - transfer long data to send buffer
        lda     $A7A5                   ; Harris protocol # chars left to transmit
        ora     a
        jnz     L48E6
        mvi     a,$03
        call    L4882                   ; Harris protocol - make flag byte 
        ret
L48E6:
        cpi     $01
        jnz     L4901
        mvi     a,$02
        sta     $A7AA
        lda     $A7AE
        sta     $A7AC                   ; flag byte/byte count
        mvi     a,$01
        sta     $A688
        mvi     a,$06
        sta     $A7A5                   ; Harris protocol # chars left to transmit
        ret
L4901:
        lxi     h,$A7AA
        mvi     m,$01
        lda     $A7A5                   ; Harris protocol # chars left to transmit
        sta     $A7AC                   ; flag byte/byte count
        adi     $08
        sta     $A7A5                   ; Harris protocol # chars left to transmit
        call    L491D                   ; Harris protocol CRC generation (alternate entry).  HL points to header, CRC returned in DE
        mov     m,d
        inx     h
        mov     m,e
        mvi     a,$01
        sta     $A688
        ret
;--------------------------------------------------------------------------------------------------
;       Harris protocol CRC generation (alternate entry).  HL points to header, CRC returned in DE
L491D:
        inx     h
        inx     h
        mov     c,m
        inx     h
        inx     h
        jmp     L47F4
;--------------------------------------------------------------------------------------------------
;       Harris protocol - transfer long data to send buffer
L4925:
        xra     a
        mov     b,a
        lxi     d,$A7AE
        lda     $A757                   ; send byte count/data/flag
        rrc
        jnc     L494E
        lda     $A6A4                   ; Harris protocol byte count for urgent message
        ora     a
        jz      L494A
        lxi     h,$A6A5                 ; Harris protocol urgent message buffer
        lda     $A6A4                   ; Harris protocol byte count for urgent message
        mov     c,a
        mov     b,a
        sta     $A7A5                   ; Harris protocol # chars left to transmit
        call    L27D3                   ; Move C bytes @HL to @DE
        xra     a
        sta     $A6A4                   ; Harris protocol byte count for urgent message
L494A:
        lda     $A757                   ; send byte count/data/flag
        rrc
L494E:
        rrc
        rnc
        lda     $A6B1                   ; Harris protocol non-urgent message byte count
        ora     a
        rz
        lxi     h,$A6B2                 ; Harris protocol non-urgent message buffer
        lda     $A6B1                   ; Harris protocol non-urgent message byte count
        mov     c,a
        add     b
        sta     $A7A5                   ; Harris protocol # chars left to transmit
        call    L27D3                   ; Move C bytes @HL to @DE
        xra     a
        sta     $A6B1                   ; Harris protocol non-urgent message byte count
        ret


;--------------------------------------------------------------------------------------------------
;
;       BITE routine
;
L4968:
        lda     $A82A                   ; FSK variable
        ani     $EF
        sta     $C200                   ; FSK option memory space
        sta     $A82A                   ; FSK variable
        in      $40                     ; 8255 Port A
        ori     $04
        out     $40                     ; Set bit 2PA2 (Not used)
        lda     $A67C                   ; NB/mute status
        push    psw
        in      $40                     ; 8255 Port A
        ori     $10
        out     $40                     ; Set bit 2PA4 (4ISB Enable)
        in      $40                     ; 8255 Port A
        ani     $7F
        out     $40                     ; Clear bit 2PA7 (Noise Blank)
        stc
        call    L3234                   ; Disconnect ant and mute audio
        lda     $A574                   ; D/A value for RF gain
        sta     $ABCE
        mvi     a,$04
        sta     $A552
        call    L2E1A                   ; Set AGC control lines
        in      $40                     ; 8255 Port A
        ori     $08
        out     $40                     ; Set bit 2PA3 (A1 relay control)
        call    L4AFA                   ; Reset Front Panel Display
        call    L4B09                   ; ROM test routine (Test 1)
        mvi     b,$14                   ; set module to A14
        jc      L4A46                   ; Report ERROR if carry set
        call    L4B3E                   ; RAM test routine (Test 2)
        mvi     b,$14                   ; set module to A14
        jc      L4A46                   ; Report ERROR if carry set
        call    L4B89                   ; Test 8155 and 8255 Ports (Tests 3.1 and 3.2)
        mvi     b,$14                   ; set module to A14
        jc      L4A46                   ; Report ERROR if carry set
        call    L4BFE                   ; Serial Buffer tests (Tests 4.1, 4.2, 4.3)
        jc      L4A46                   ; Report ERROR if carry set
        call    L4C7E                   ; Ref gen test (Tests 5.1, 5.2, 5.3)
        mvi     b,$12                   ; set module to A12 
        jc      L4A46                   ; Report ERROR if carry set
        call    L4CAA                   ; PLL test (Tests 6.1 and 6.2)
        jc      L4A46                   ; Report ERROR if carry set
        call    L4D87                   ; A/D test.  Error if Carry set. (Tests 7.1, 7.2, 7.3)
        mvi     b,$14                   ; set module to A14
        jc      L4A46                   ; Report ERROR if carry set
        call    L52BB                   ; sends $00 to D/A and $A574
        call    L4DB0                   ; Input filter test (Tests 8.1, 8.2, 8.3)
        mvi     b,$01                   ; set module to A01 
        jc      L4A46                   ; Report ERROR if carry set
        call    L4E17                   ; Test first and second converters
        jc      L4A46                   ; Report ERROR if carry set
        call    L4E3B                   ; IF Filter test (Tests 11.1 through 11.8)
        mvi     b,$04                   ; set module to A04
        jc      L4A46                   ; Report ERROR if carry set
        call    L4F31                   ; IF Audio test (Tests 12.1 through 12.7)
        mvi     b,$05                   ; set module to A05
        jc      L4A46                   ; Report ERROR if carry set
        lda     $ABC5                   ; 2ISB option installed flag (0=not installed, FF=installed)
        ora     a
        jz      L4A17                   ; skip ISB tests if ISB not installed
        call    L5105                   ; ISB test (Tests 13.1, 13.2, 13.3)
        mvi     b,$18                   ; set module to A18 
        jc      L4A46                   ; Report ERROR if carry set
        lda     $A818                   ; 4ISB option flag, zero for no 4ISB
        ora     a
        jz      L4A17                   ; if 4ISB not installed, skip A22 test
        call    L4D29                   ; 4ISB test
        mvi     b,$22                   ; set module to A22
        jc      L4A46                   ; Report ERROR if carry set
L4A17:
        lda     $A825                   ; FSK option installed flag. Zero if not installed
        ora     a
        jz      L4A26                   ; if $A825=0, skip A26 test
        call    L51DA                   ; FSK test
        mvi     b,$26                   ; set module to A26
        jc      L4A46                   ; Report ERROR if carry set
L4A26:
        lda     $A67E                   ; Comm port has been initialized flag
        ora     a
        jz      L4A44                   ; if not initialized, skip next test
        call    L36BC                   ; FSK option code, set A67F and A681 flags
        push    psw
        lda     $AC3A                   ; FSK UART present flag
        cpi     $FF
        jz      L4A3E
        mvi     b,$14                   ; set module to A14
        jmp     L4A40
L4A3E:
        mvi     b,$17
L4A40:
        pop     psw
        jc      L4A46                   ; Report ERROR
L4A44:
        xra     a
        mov     b,a
L4A46:                                  ; Report error location, module B, fault num A
        mov     h,b
        mov     l,a
        shld    $ABC9                   ; BITE fault code
        push    b
        lxi     h,L4AF0                 ; dashes
        lxi     b,$0A09
        call    L0666                   ; Display B chars from [HL] to disp loc C
        jnc     L4A5E
        lxi     h,L4AC8                 ; BITE fault message
        jmp     L4A61
L4A5E:
        lxi     h,L4ADC                 ; BITE passed message
L4A61:
        lxi     b,$141D
        call    L0645                   ; Display text message
        pop     b
        jnc     L4A76
        mvi     c,$0C
        call    L06EB                   ; Place BCD number in A in display positions C-1 and C
        mov     a,b
        mvi     c,$18
        call    L06EB                   ; Place BCD number in A in display positions C-1 and C
L4A76:
        lda     $A679                   ; Status bits
        ani     $80
        cpi     $80
        mvi     b,$00
        jz      L4A84
        mvi     b,$08
L4A84:
        mvi     a,$10
        ora     b
        sta     $ABB4                   ; Front panel LEDs
        xra     a                       ; freq, chan, BFO, tune, NB off
        sta     $ABB5                   ; Front panel LEDs
        call    L09E0                   ; If not in BITE, make NB LED display NB status
        in      $40                     ; 8255 Port A
        ani     $F5
        out     $40                     ; 8255 Port A
        pop     psw
        sta     $A67C                   ; NB/mute status
        rar
        call    L3234                   ; Disconnect ant and mute audio if called with carry set
        rar
        rar
        rar
        in      $40                     ; 8255 Port A
        jc      L4AAC
        ani     $7F
        jmp     L4AAE
L4AAC:
        ori     $80
L4AAE:
        out     $40                     ; 8255 Port A
        lda     $ABCE
        call    L52BD                   ; sends A to D/A and $A574
        cma
        sta     $A67B                   ; RF atten
        xra     a
        sta     $ABED                   ; Radio setting control, see L2D5B
        sta     $ABEC                   ; Display update control see L06FD
        in      $40                     ; 8255 Port A
        ani     $FB
        out     $40                     ; 8255 Port A
        ret

L4AC8:  .DB     "ASSY      FAULT "
        .DB     $22
        .DB     "  "
        .DB     $22
L4ADC:  .DB     "--- TEST  PASSED ---"          

L4AF0:  .db     "----------"

;--------------------------------------------------------------------------
;
;       Reset Front Panel Display
;
L4AFA:
        mvi     a,$FD
        di                                      ; Disable Interrupts
        call    L322C                           ; Send A to Serial Bus
        out     $66                             ; Set Serial Data strobe to frnt pnl Display Strobe
        call    L322C                           ; Send A to Serial Bus
        out     $66                             ; Set Serial Data strobe to frnt pnl Display Strobe
        ei                                      ; Enable interrupts
        ret
;--------------------------------------------------------------------------
;       ROM test routine
;
L4B09:
        mvi     a,$40           ;
        sim                     ;
        mvi     a,$C0           ;
        sim                     ;
        lxi     h,$0000         ; HL=0
        push    h
        mvi     d,$08                   ; D=8
        xra     a                       ; A=0
L4B16:
        mov     c,a
        call    L28D8                   ; XORs memory from HL to H=D, result in A,E & flags set
        pop     h
        mov     h,d
        push    h
        xra     c
        push    psw                     ; save flags from recent block XOR
        mvi     a,$40           ;
        sim                     ;
        mvi     a,$C0           ;
        sim                     ;
        mov     a,d                     ; D has block tested
        cpi     $80                     ; is it the top of ROM?
        jz      L4B32                   ; quit testing if yes
        adi     $08                     ; go do another block
        mov     d,a
        pop     psw
        jmp     L4B16
L4B32:
        pop     psw                     ; recall stored flags
        pop     h
        jnz     L4B3A
        stc                             ; zero, carry clear
        cmc
        ret
L4B3A:
        stc
        mvi     a,$01                   ; not zero, error code 1 and carry set
        ret

;----------------------------------------------------------------------------------
;       RAM test routine
;         Tests $100 bytes starting from $AB95
;         Tests $800 bytes starting from $A000
;         carry set indicates error
;
L4B3E:
        lxi     d,$0100
        lxi     h,$AB95
        call    L4B57
        jc      L4B83                           ; Set A=2 and return if error in AB95 area
        lxi     d,$0800
        lxi     h,$A000
        call    L4B57
        jc      L4B86                           ; Set A=3 and return if error in A000 area
        ret
;
; Called only from L4B3E
L4B57:
        mvi     b,$00
L4B59:
        di                                      ; Disable Interrupts
        mov     a,m
        cma
        mov     m,a                             ; get mem, complement and return it
        cmp     m                               ; check if it reads back OK
        jnz     L4B80                           ; return with carry set if not
        cma
        mov     m,a                             ; restore original memory value
        cmp     m                               ; check if it reads back OK
        jnz     L4B80                           ; return with carry set if not
        ei                                      ; Enable interrupts
        inr     b
        jnz     L4B72
        mvi     a,$40
        sim
        mvi     a,$C0
        sim
L4B72:
        inx     h                               ; incr to next mem location
        dcx     d                               ; decr DE
        xra     a                               ; clear A
        cmp     d
        jnz     L4B59                           ; do more mem locs until DE=0
        cmp     e
        jnz     L4B59
        stc                                     ; got through test OK
        cmc
        ret                                     ; Return with carry cleared
L4B80:
        ei                                      ; Enable interrupts
        stc
        ret                                     ; Return with carry set
;
; Used in L4B3E
L4B83:
        mvi     a,$02
        ret
;
; Used in L4B3E
L4B86:
        mvi     a,$03
        ret
;----------------------------------------------------------------------------------
;
; Test 8155 and 8255 Ports
;
L4B89:
        in      $82                             ; 8155 Port B
        mov     b,a
        cma
        out     $82                             ; 8155 Port B
        mov     c,a
        mvi     d,$01
        call    L52CA                           ; 10 msec delay
        in      $82                             ; 8155 Port B
        cmp     c
        jnz     L4BFA                           ; jump if readback incorrect on complement
        mov     a,b
        out     $82                             ; Restore 8155 Port B to original state
        mvi     d,$01
        call    L52CA                           ; 10 msec delay
        in      $82                             ; 8155 Port B
        cmp     b
        jnz     L4BFA                           ; jump if readback incorrect on original value
        in      $83                             ; 8155 Port C
        ani     $3F
        mov     b,a
        cma
        ani     $3F
        out     $83                             ; 8155 Port C
        mov     c,a
        mvi     d,$01
        call    L52CA                           ; 10 msec delay
        in      $83                             ; 8155 Port C
        ani     $3F
        cmp     c
        jnz     L4BFA
        mov     a,b
        out     $83                             ; 8155 Port C
        mvi     d,$01
        call    L52CA                           ; 10 msec delay
        in      $83                             ; 8155 Port C
        ani     $3F
        cmp     b
        jnz     L4BFA
        in      $40                             ; 8255 Port A
        mov     b,a
        cma
        ori     $30
        out     $40                             ; 8255 Port A
        mov     c,a
        mvi     d,$01
        call    L52CA                           ; 10 msec delay
        in      $40                             ; 8255 Port A
        cmp     c
        jnz     L4BF6
        mov     a,b
        out     $40                             ; 8255 Port A
        mvi     d,$01
        call    L52CA                           ; 10 msec delay
        in      $40                             ; 8255 Port A
        cmp     b
        jnz     L4BF6
        stc
        cmc
        ret
L4BF6:
        stc                                     ; 8255 port error, code $06
        mvi     a,$06
        ret
L4BFA:
        stc                                     ; 8155 port error, code $05
        mvi     a,$05
        ret
;----------------------------------------------------------------------------------
;       Serial Data test
;
L4BFE:
        mvi     b,$00
        mov     c,b
        mov     d,b                             ; clear B, C, D
        di                                      ; Disable Interrupts
        call    L3144                           ; Send rotated B, C, D to serial bus
        out     $68                             ; Set Serial Data strobe to BFO
        xra     a
        call    L322C                           ; Send 0 to Serial Bus
        call    L322C                           ; Send 0 to Serial Bus
        call    L322C                           ; Send 0 to Serial Bus
        call    L322C                           ; Send 0 to Serial Bus
        call    L322C                           ; Send 0 to Serial Bus
        call    L322C                           ; Send 0 to Serial Bus
        out     $60                             ; Set Serial Data strobe to Synthesizer
        ei                                      ; Enable interrupts
        call    L4C73                           ; Returns bits 1PA7, 1PA5, 1PA3, 2PC2 in A
        mov     e,a                             ; save these bits in E
        mvi     b,$08
        di                                      ; Disable Interrupts
        call    L3144                           ; Send rotated B, C, D to serial bus
        out     $68                             ; Set Serial Data strobe to BFO
        mvi     a,$FF
        call    L322C                           ; Send $FF to Serial Bus
        call    L322C                           ; Send $FF to Serial Bus
        call    L322C                           ; Send $FF to Serial Bus
        call    L322C                           ; Send $FF to Serial Bus
        call    L322C                           ; Send $FF to Serial Bus
        call    L322C                           ; Send $FF to Serial Bus
        out     $60                             ; Set Serial Data strobe to Synthesizer
        ei                                      ; Enable interrupts
        call    L4C73                           ; Returns bits 1PA7, 1PA5, 1PA3, 2PC2 in A
        xra     e                               ; Compare to previous state of bits to see which ones changed
        ani     $A0                             ; look only at bits 7 and 5
        xri     $A0                             ; Did they both change?
        rz                                      ; return if so, test OK
        xri     $A0
        jnz     L4C55
        stc
        mvi     a,$04
        mvi     b,$14
        ret                                     ; A14 fault 4, cannot send to BFO or Synthesizer
L4C55:
        xri     $A0
        mov     b,a
        mov     a,b
        ani     $80
        jz      L4C64
        stc
        mvi     a,$01
        mvi     b,$11
        ret                                     ; A11 fault 1, BFO serial data failure
L4C64:
        mov     a,b
        ani     $20
        jz      L4C70
        mvi     a,$01
        mvi     b,$10
        stc
        ret                                     ; A10 fault 1, Synthesizer serial data failure
L4C70:
        stc
        cmc
        ret
;--------------------------------------------------------------------------------------------------
;       Returns bits 1PA7, 1PA5, 1PA3, 2PC2 in A
;
L4C73:
        in      $81                             ; 8155 Port A
        ani     $A8
        mov     b,a
        in      $42                             ; 8255 Port C
        ani     $40
        ora     b
        ret
;--------------------------------------------------------------------------------------------------
;       Reference generator test
;
L4C7E:
        in      $41                             ; 8255 Port B
        mov     b,a
        ani     $10
        jnz     L4C9D                           ; 1 = unlocked
        mov     a,b
        ani     $40
        jnz     L4C95                           ; 1 = fault
        mov     a,b
        ani     $20
        jnz     L4C99                           ; 1 = fault
        stc
        cmc
        ret                                     ; test OK
L4C95:
        stc
        mvi     a,$01
        ret                                     ; Fault 1, 1 MHz reference 
L4C99:
        stc
        mvi     a,$02
        ret                                     ; Fault 2, 800 KHz reference
L4C9D:
        call    L4CA3                           ; Set carry and PLL unlocked flag
        mvi     a,$03
        ret                                     ; Fault 3, 40 MHz PLL lock
;--------------------------------------------------------------------------------------------------
;       Set carry and PLL unlocked flag
;         means a PLL is out of lock ($ABEF is the PLL unlocked error flag)
L4CA3:
        mvi     a,$FF
        sta     $ABEF                   ; PLL unlocked error flag
        stc
        ret
;--------------------------------------------------------------------------------------------------
;       PLL test
;
L4CAA:
        lxi     h,$0000                 ;
        shld    $A54B                           ; $A54B = $00, $A54C = $00
        lxi     h,$2999                 ;
        shld    $A54D                           ; $A54D = $29, $A54E = $99
        lxi     h,$F999                 ;               
        shld    $A54F                   ; BFO LSB   ; $A54F = $F9, $A550 = $99                   ; BFO MSB & sign
        call    L4CF8           ;
        mvi     d,$19                           ;
        call    L52CA                           ; 250 msec delay
        mvi     a,$03                           ;
        sta     $A551                           ; $A551 = $03   (mode & IF filter, new commanded rcv params)
        call    L2EBD                   ; Set audio path and mode
        lxi     h,$0000                 ;
        shld    $A54B                           ; $A54B = $00, $A54C = $00
        lxi     h,$0000                 ;
        shld    $A54D                           ; $A54D = $00, $A54E = $00
        lxi     h,$0999                 ;
        shld    $A54F                           ; $A54F = $09, $A550 = $99                   ; BFO LSB
        call    L4CF8           ;
        rc
        lxi     h,$0000                 ;
        shld    $A54B                           ; $A54B = $00, $A54C = $00
        lxi     h,$2999                 ;
        shld    $A54D                           ; $A54D = $29, $A54E = $99
        lxi     h,$F999                 ;
        shld    $A54F                           ; $A54F = $F9, $A550 = $99                   ; BFO LSB
        call    L4CF8           ;
        ret
;--------------------------------------------------------------------------------------------------
;       BFO test
L4CF8:
        call    L2FA9                   ; Set BFO
        call    L3098                   ; Set Synth; recv freq in $A54B-E, $AC3D determines offset (USB, AM, or LSB)
        mvi     d,$05
        call    L52CA                           ; 50 msec delay
        in      $81                             ; 8155 Port A
        ani     $10
        jnz     L4D12                           ; jump if 1PA4 is true
        call    L4CA3                           ; Set carry and PLL unlocked flag
        mvi     a,$02
        mvi     b,$10
        ret                                     ; A10 fault 2 (Synthesizer out of lock)
L4D12:
        in      $81                             ; 8155 Port A
        ani     $40
        jz      L4D21                           ; jump if 1PA6 is false
        call    L4CA3                           ; Set carry and PLL unlocked flag
        mvi     a,$02
        mvi     b,$11
        ret                                     ; A11 fault 2 (BFO PLL out of lock)
L4D21:
        mvi     a,$00
        sta     $ABEF                           ; clear PLL unlock flag
        stc
        cmc
        ret                                     ; test OK
;--------------------------------------------------------------------------------------------------
;       4ISB test
;
L4D29:
        mvi     b,$00
        in      $40                             ; 8255 Port A
        ani     $EF                             ; 
        out     $40                             ; 8255 Port A, turn off 4ISB enable
        call    L4D69                           ; P/O BITE routine
        cpi     $80
        jnc     L4D3B
        mvi     b,$01
L4D3B:
        call    L4D69                           ; P/O BITE routine
        cpi     $80
        jnc     L4D53
        mov     a,b
        cpi     $01
        jnz     L4D4E
        mvi     b,$03
        jmp     L4D59                           ; error 03
L4D4E:
        mvi     b,$02
        jmp     L4D59                           ; error 02
L4D53:
        mov     a,b
        cpi     $01
        jnz     L4D5D
L4D59:
        stc
        jmp     L4D5F
L4D5D:
        stc
        cmc
L4D5F:
        push    psw
        in      $40                             ; 8255 Port A
        ori     $10
        out     $40                             ; 8255 Port A, turn on 4ISB enable
        pop     psw
        mov     a,b
        ret
;--------------------------------------------------------------------------------------------------
;       P/O BITE routine
L4D69:
        push    b
        in      $40                             ; 8255 Port A
        ani     $DF
        out     $40                             ; 8255 Clear 2PA0, activate A1 relay test
        mvi     d,$0A
        call    L52CA                           ; 100 msec delay
        in      $40                             ; 8255 Port A
        ori     $20
        out     $40                             ; 8255  Clear 2PA0, deactivate A1 relay test
        mvi     d,$28
        call    L52CA                           ; 400 msec delay
        mvi     h,$5C                           ; 2nd IF AGC
        call    L2BBE                           ; A/D read routine.  Channel H, A has data, carry if error.
        pop     b
        ret
;--------------------------------------------------------------------------------------------------
;
;       A/D Test.  returns with carry clear if OK, else A= 7, 8, or 9 indicating type of error.
;
L4D87:
        mvi     h,$54                           ; +5V Reference check
        call    L2BBE                           ; A/D read routine.  Channel H, A has data, carry if error.
        jc      L4DA4
        cpi     $FA
        jc      L4DA8                           ; +5V ref must be > $FA
        mvi     h,$51                           ; AGND reference check
        call    L2BBE                           ; A/D read routine.  Channel H, A has data, carry if error.
        jc      L4DA4
        cpi     $05
        jnc     L4DAC
        stc
        cmc
        ret
L4DA4:
        mvi     a,$07
        stc
        ret                                     ; No A/D EOC, code $07
L4DA8:
        mvi     a,$08
        stc
        ret                                     ; +5V returns code < $FA
L4DAC:
        mvi     a,$09
        stc
        ret                                     ; AGND returns code > $05
;--------------------------------------------------------------------------------------------------
;       Input filter test (Tests 8.1, 8.2, 8.3)
L4DB0:
        in      $41                             ; 8255 Port B
        ani     $01
        jz      L4DBB
        mvi     a,$01
        stc
        ret
L4DBB:
        in      $40                             ; 8255 Port A
        ani     $F6
        out     $40                             ; 8255 Port A
        call    L52C8                           ; 500 msec delay
        mvi     h,$56                           ; Test Monitor, A1 BITE det out
        call    L2BBE                           ; A/D read routine.  Channel H, A has data, carry if error.
        cpi     $5D
        push    psw
        in      $40                             ; 8255 Port A
        ori     $08
        out     $40                             ; 8255 Port A
        call    L52C8                           ; 500 msec delay
        mvi     h,$56                           ; Test Monitor, A1 BITE det out 
        call    L2BBE                           ; A/D read routine.  Channel H, A has data, carry if error.
        cpi     $10
        jnc     L4E03
        in      $40                             ; 8255 Port A
        ori     $03
        out     $40                             ; 8255 Port A
        call    L52C8                           ; 500 msec delay
        mvi     h,$56                           ; Test Monitor, A1 BITE det out
        call    L2BBE                           ; A/D read routine.  Channel H, A has data, carry if error.
        cpi     $39
        jnc     L4DFA
        pop     psw
        push    psw
        jc      L4E08
        jmp     L4E12
L4DFA:
        pop     psw
        push    psw
        jc      L4E0D
        pop     psw
        stc
        cmc
        ret
L4E03:
        pop     psw
        stc
        mvi     a,$02
        ret
L4E08:
        pop     psw
        stc
        mvi     a,$04
        ret
L4E0D:
        pop     psw
        stc
        mvi     a,$05
        ret
L4E12:
        pop     psw
        stc
        mvi     a,$03
        ret
;--------------------------------------------------------------------------------------------------
;       Test first and second converters
L4E17:
        call    L52A2                   ; Set Receiver to 100 KHz
        mvi     d,$03
        call    L52CA                   ; 30 msec delay
        mvi     h,$57                   ; Test Monitor, A2 Detect
        call    L2BBE                   ; A/D read routine.  Channel H, A has data, carry if error.
        cpi     $10
        jnc     L4E2E
        mvi     b,$02                   ; A2 module fault
        mvi     a,$01
        ret
L4E2E:
        mvi     h,$53                   ; IF Input Detect
        call    L2BBE                   ; A/D read routine.  Channel H, A has data, carry if error.
        cpi     $43
        rnc
        mvi     b,$03                   ; A3 module fault
        mvi     a,$01
        ret
;--------------------------------------------------------------------------------------------------
;       IF filter test
;
; code  filter
;  0            FL2 - LSB, USB, AM
;  1            FL1, FL2 - ISB
;  2            FL1
;  3            FL3 - CW
;  4            FL4 - CW
;  5            FL5 - optional
;  6            FL6 - AM
;  7            FL7 - optional  
;  8            FL8 - wideband
;  9            FL1 - LSB
L4E3B:
        mvi     a,$08
        out     $83                             ; 8155 Port C (select FL8)
        call    L4F26                           ; Read IF input level
        cpi     $4D
        push    psw
        mvi     a,$79
        out     $82                             ; 8155 Port B
        in      $40                             ; 8255 Port A
        ani     $FD
        out     $40                             ; 8255 Port A (Shut off A1 BITE oscillator)
        mvi     b,$04                           ;
        mvi     c,$04                           ;
        mvi     d,$54                           ;
        mvi     e,$00                           ;
        mvi     h,$00                           ; 40.454 MHz
        call    L3160                           ; Set 1st LO from B, C, D, E, H
        ei                                      ; Enable interrupts
        mvi     a,$00                           ;
        out     $83                             ; 8155 Port C (select FL2)
        call    L4F26                           ; Read IF input level
        cpi     $32                             ;
        jnc     L4E75                           ; error if < $32 (jump if no error)
        pop     psw
        jc      L4E71                           ; jump if wideband filter had no output
        stc                                     ;
        mvi     a,$03                           ;
        ret                                     ; Error 3, USB filter
L4E71:
        stc                                     ;
        mvi     a,$09                           ;
        ret                                     ; Error 9, A5 input peak det or A4 IF amp and output circuitry
L4E75:
        pop     psw
        jnc     L4E7C
        mvi     a,$01                           ;
        ret                                     ; Error 1, Bypass Signal Path fault
L4E7C:
        lda     $ABC5                   ; 2ISB option installed flag (0=not installed, FF=installed)
        ora     a
        jz      L4EA1                           ; If $ABC5=0 do not test FL1
        mvi     a,$02                           ;
        out     $83                             ; 8155 Port C (select FL1)
        lxi     h,$1000
        shld    $A54B                   ; new commanded receiver params block beginning
        lxi     h,$0000
        shld    $A54D
        call    L3098                   ; Set Synth; recv freq in $A54B-E, $AC3D determines offset (USB, AM, or LSB)
        call    L4F26                           ; Read IF input level
        cpi     $1C
        jnc     L4EA1
        mvi     a,$02                           ;
        ret                                     ; Error 2, LSB filter
L4EA1:
        lxi     h,$0000
        shld    $A54B                           ; $A54B=0, $A54C=0
        lxi     h,$0000
        shld    $A54D                           ; $A54C=0, $A54E=0
        call    L3098                   ; Set Synth; recv freq in $A54B-E, $AC3D determines offset (USB, AM, or LSB)
        lda     $ABFA
        ora     a
        jz      L4EC6
        mvi     a,$03                           ;
        out     $83                             ; 8155 Port C (select FL3)
        call    L4F26                           ; Read IF input level
        cpi     $32
        jnc     L4EC6
        mvi     a,$04                           ;
        ret                                     ; Error 4, CW filter
L4EC6:
        lda     $ABFB
        ora     a
        jz      L4EDC
        mvi     a,$04                           ;
        out     $83                             ; 8155 Port C (select FL4)
        call    L4F26                           ; Read IF input level
        cpi     $32
        jnc     L4EDC
        mvi     a,$05                           ;
        ret                                     ; Error 5, CW filter
L4EDC:
        lda     $ABFC
        ora     a
        jz      L4EF9
        lda     $AC00
        ora     a
        jz      L4EF9
        mvi     a,$05
        out     $83                             ; 8155 Port C (select FL5)
        call    L4F26                           ; Read IF input level
        cpi     $32
        jnc     L4EF9
        mvi     a,$06                           ;
        ret                                     ; Error 6, Special Filter slot 5
L4EF9:
        lda     $ABFD
        ora     a
        jz      L4F0F
        mvi     a,$06
        out     $83                             ; 8155 Port C (select FL6)
        call    L4F26                           ; Read IF input level
        cpi     $32
        jnc     L4F0F
        mvi     a,$07                           ;
        ret                                     ; Error 7, Special Filter slot 6
L4F0F:
        lda     $ABFE
        ora     a
        jz      L4F23
        mvi     a,$07
        out     $83                             ; 8155 Port C (select FL7)
        call    L4F26                           ; Read IF input level
        cpi     $32
        rnc
        mvi     a,$08                           ;
        ret                                     ; Error 8, Special Filter slot 7
L4F23:
        stc
        cmc
        ret
;--------------------------------------------------------------------------------------------------
;       Read IF input level
;
L4F26:
        mvi     d,$04
        call    L52CA                           ; 40 msec delay
        mvi     h,$5D                           ; IF Input Detect
        call    L2BBE                           ; A/D read routine.  Channel H, A has data, carry if error.
        ret
;--------------------------------------------------------------------------------------------------
;       IF audio test
;
L4F31:
        mvi     a,$02
        sta     $A552
        mvi     a,$73
        sta     $A551                   ; mode & IF filter, new commanded rcv params
        call    L2E1A                   ; Set AGC control lines
        call    L2EBD                   ; Set audio path and mode
        call    L2E6A                   ; Set IF filter
        lxi     h,$0000
        shld    $A54F                   ; BFO LSB
        call    L2FA9                   ; Set BFO
        in      $40                             ; 8255 Port A
        ori     $02
        out     $40                             ; 8255 Port A
        lxi     h,$1040
        shld    $A54C
        call    L3098                   ; Set Synth; recv freq in $A54B-E, $AC3D determines offset (USB, AM, or LSB)
        mvi     d,$08
        call    L52CA                           ; 80 msec delay
        mvi     h,$5C                           ; 2nd IF AGC
        call    L2BBE                           ; A/D read routine.  Channel H, A has data, carry if error.
        cpi     $39
        jnc     L4F6E
        mvi     a,$01
        ret
L4F6E:
        in      $40                             ; 8255 Port A
        ani     $FD
        out     $40                             ; 8255 Port A
        mvi     a,$66
        call    L52BD                           ; sends A to D/A and $A574
        mvi     a,$04
        sta     $A552
        call    L2E1A                   ; Set AGC control lines
        stc
        cmc
        call    L3234                   ; Disconnect ant and mute audio if called with carry set
        call    L52C8                           ; 500 msec delay
        mvi     c,$5E
        call    L50D7
        stc
        call    L3234                   ; Disconnect ant and mute audio if called with carry set
        cpi     $05
        jnc     L4FB9
        xra     a
        sta     $A54D
        call    L3098                   ; Set Synth; recv freq in $A54B-E, $AC3D determines offset (USB, AM, or LSB)
        mvi     a,$33
        call    L52BD                           ; sends A to D/A and $A574
        stc
        cmc
        call    L3234                   ; Disconnect ant and mute audio if called with carry set
        call    L52C8                           ; 500 msec delay
        mvi     c,$5E
        call    L50D7
        stc
        call    L3234                   ; Disconnect ant and mute audio if called with carry set
        cpi     $0E
        jnc     L4FBE
L4FB9:
        mvi     a,$FF
        jmp     L4FBF
L4FBE:
        xra     a
L4FBF:
        sta     $ABD6
        call    L52A2                   ; Set Receiver to 100 KHz
        mvi     a,$72
        sta     $A551                   ; mode & IF filter, new commanded rcv params
        call    L2EBD                   ; Set audio path and mode
        call    L2E6A                   ; Set IF filter
        mvi     a,$66
        call    L52BD                           ; sends A to D/A and $A574
        stc
        cmc
        call    L3234                   ; Disconnect ant and mute audio if called with carry set
        mvi     d,$64
        call    L52CA                           ; 1000 msec delay
        mvi     h,$5E                           ; Line Audio Det Out
        call    L2BBE                           ; A/D read routine.  Channel H, A has data, carry if error.
        stc
        call    L3234                   ; Disconnect ant and mute audio if called with carry set
        cpi     $05
        jnc     L5045
        lxi     h,$0040
        shld    $A54C
        call    L3098                   ; Set Synth; recv freq in $A54B-E, $AC3D determines offset (USB, AM, or LSB)
        mvi     a,$33
        call    L52BD                           ; sends A to D/A and $A574
        mvi     d,$02
        call    L52CA                           ; 20 msec delay
        stc
        cmc
        call    L3234                   ; Disconnect ant and mute audio if called with carry set
        mvi     d,$05
        mvi     b,$0A
L5009:
        push    b
        push    d
        call    L52CA                           ; 10 * D msec delay
        call    L52A2                   ; Set Receiver to 100 KHz
        pop     d
        push    d
        call    L52CA                           ; 10 * D msec delay
        lxi     h,$0040
        shld    $A54C
        call    L3098                   ; Set Synth; recv freq in $A54B-E, $AC3D determines offset (USB, AM, or LSB)
        pop     d
        pop     b
        dcr     b
        jnz     L5009
        mvi     a,$03
        mvi     d,$01
        call    L52CC                           ; 3 msec delay
        mvi     h,$5E                           ; Line Audio Det Out
        call    L2BBE                           ; A/D read routine.  Channel H, A has data, carry if error.
        stc
        call    L3234                   ; Disconnect ant and mute audio if called with carry set
        cpi     $0A
        jc      L5045
        lda     $ABD6
        ora     a
        jz      L5054
        stc
        mvi     a,$04
        ret
L5045:
        lda     $ABD6
        ora     a
        jnz     L5050
        mvi     a,$02
        stc
        ret
L5050:
        mvi     a,$03
        stc
        ret
L5054:
        mvi     a,$78
        sta     $A551                   ; mode & IF filter, new commanded rcv params
        call    L2EBD                   ; Set audio path and mode
        call    L2E6A                   ; Set IF filter
        xra     a
        sta     $A54C
        call    L3098                   ; Set Synth; recv freq in $A54B-E, $AC3D determines offset (USB, AM, or LSB)
        mvi     a,$66
        call    L52BD                           ; sends A to D/A and $A574
        stc
        cmc
        call    L3234                   ; Disconnect ant and mute audio if called with carry set
        call    L52C8                           ; 500 msec delay
        mvi     h,$5E                           ; Line Audio Det Out
        call    L2BBE                           ; A/D read routine.  Channel H, A has data, carry if error.
        stc
        call    L3234                   ; Disconnect ant and mute audio if called with carry set
        cpi     $05
        jnc     L50D3
        mvi     a,$50
        sta     $A54C
        call    L3098                   ; Set Synth; recv freq in $A54B-E, $AC3D determines offset (USB, AM, or LSB)
        mvi     a,$33
        call    L52BD                           ; sends A to D/A and $A574
        mvi     d,$03
        call    L52CA                           ; 30 msec delay
        stc
        cmc
        call    L3234                   ; Disconnect ant and mute audio if called with carry set
        call    L52C8                           ; 500 msec delay
        mvi     d,$05
        mvi     b,$0A
L509F:
        push    b
        push    d
        call    L52CA                           ; 10 * D msec delay
        mvi     b,$04
        mvi     c,$04
        mvi     d,$50
        mvi     e,$00
        mvi     h,$00                   ; 40.45000 MHz
        call    L3160                   ; Set 1st LO from B, C, D, E, H
        ei                                      ; Enable interrupts
        pop     d
        push    d
        call    L52CA                           ; 10 * D msec delay
        call    L3098                   ; Set Synth; recv freq in $A54B-E, $AC3D determines offset (USB, AM, or LSB)
        pop     d
        pop     b
        dcr     b
        jnz     L509F
        mvi     a,$03
        mvi     d,$01
        call    L52CC                           ; 3 msec delay
        mvi     h,$5E                           ; Line Audio Det Out
        call    L2BBE                           ; A/D read routine.  Channel H, A has data, carry if error.
        stc
        call    L3234                   ; Disconnect ant and mute audio if called with carry set
        cpi     $03
        rnc
L50D3:
        stc
        mvi     a,$05
        ret

;
L50D7:
        lxi     h,$0000
        mvi     b,$20
L50DC:
        shld    $ABC7
        push    b
        mov     h,c
        call    L2BBE                           ;A/D read routine.  Channel H, A has data, carry if error.
        mvi     d,$00
        mov     e,a
        lhld    $ABC7
        dad     d
        mvi     d,$01
        mvi     a,$01
        call    L52CC                           ; 1 msec delay
        pop     b
        dcr     b
        jnz     L50DC
        mvi     c,$05
L50F9:
        mov     a,h
        rrc
        mov     h,a
        mov     a,l
        rar
        mov     l,a
        dcr     c
        jnz     L50F9
        mov     a,l
        ret

;
L5105:
        call    L52BB                           ; sends $00 to D/A and $A574
        mvi     a,$05
        sta     $A551                   ; mode & IF filter, new commanded rcv params
        call    L2EBD                   ; Set audio path and mode
        call    L2E6A                   ; Set IF filter
        in      $40                             ; 8255 Port A
        ori     $02
        out     $40                             ; 8255 Port A
        lxi     h,$0950
        shld    $A54C
        call    L52C8                           ; 500 msec delay
L5122:
        call    L3098                   ; Set Synth; recv freq in $A54B-E, $AC3D determines offset (USB, AM, or LSB)
        mvi     d,$02
        call    L52CA                           ; 20 msec delay
        mvi     h,$55                           ; Test Monitor, A2 Detect
        call    L2BBE                           ; A/D read routine.  Channel H, A has data, carry if error.
        cpi     $21
        jnc     L5151
        lhld    $A54C
        mov     a,h
        cpi     $11
        jnz     L5143
        mov     a,l
        cpi     $50
        jnc     L516E
L5143:
        lxi     h,$A54C
        lxi     d,L51D8
        mvi     c,$02
        call    L2873                           ; (HL)=daa[(HL)+(DE)] for C locations
        jmp     L5122
L5151:
        lxi     h,$A54C
        lxi     d,L51D6
        mvi     c,$02
        call    L2873                           ; (HL)=daa[(HL)+(DE)] for C locations
        call    L3098                   ; Set Synth; recv freq in $A54B-E, $AC3D determines offset (USB, AM, or LSB)
        mvi     d,$03
        call    L52CA                           ; 30 msec delay
        mvi     h,$55                           ; Test Monitor, A2 Detect
        call    L2BBE                           ; A/D read routine.  Channel H, A has data, carry if error.
        cpi     $32
        jnc     L5172
L516E:
        stc
        mvi     a,$01
        ret
L5172:
        mvi     a,$02
        sta     $A552
        call    L2E1A                   ; Set AGC control lines
        call    L52C8                           ; 500 msec delay
        mvi     h,$5A                           ; AGC
        call    L2BBE                           ; A/D read routine.  Channel H, A has data, carry if error.
        cpi     $39
        jnc     L518A
        mvi     a,$02
        ret
L518A:
        in      $40                             ; 8255 Port A
        ani     $FD
        out     $40                             ; 8255 Port A
        mvi     a,$66
        call    L52BD                           ; sends A to D/A and $A574
        mvi     a,$04
        sta     $A552
        call    L2E1A                   ; Set AGC control lines
        stc
        cmc
        call    L3234                   ; Disconnect ant and mute audio if called with carry set
        call    L52C8                           ; 500 msec delay
        mvi     c,$5F
        call    L50D7
        stc
        call    L3234                   ; Disconnect ant and mute audio if called with carry set
        cpi     $05
        jnc     L51D2
        in      $40                             ; 8255 Port A
        ori     $02
        out     $40                             ; 8255 Port A
        mvi     a,$33
        call    L52BD                           ; sends A to D/A and $A574
        stc
        cmc
        call    L3234                   ; Disconnect ant and mute audio if called with carry set
        call    L52C8                           ; 500 msec delay
        mvi     c,$5F
        call    L50D7
        stc
        call    L3234                   ; Disconnect ant and mute audio if called with carry set
        cpi     $0E
        rnc
L51D2:
        stc
        mvi     a,$03
        ret

L51D6:  .DB     $15, $00
L51D8:  .db     $02, $00
;--------------------------------------------------------------------------------------------------
;       FSK test routine
;
L51DA:
        mvi     a,$2A
        sta     $F800                   ; FSK option memory space
        mvi     a,$00
        sta     $C800                   ; FSK option memory space
        mvi     a,$55
        sta     $F800                   ; FSK option memory space
        mvi     a,$00
        sta     $D800                   ; FSK option memory space
        mvi     a,$E6
        sta     $F800                   ; $F800=$2A $C800=$00 $F800=$55 $D800=$00 $F800=$E6
        lda     $C800                   ; FSK option memory space
        mov     c,a
        lda     $D800                   ; FSK option memory space
        mov     b,a
        push    b
        call    L04C6                   ; loads 2 values to $F800 to see what happens
        pop     b
        mov     a,c
        mvi     c,$01
        ani     $3F
        cpi     $2A
        jnz     L5283
        mov     a,b
        ani     $3F
        cpi     $15
        jnz     L5283
        ora     a
        call    L3234                   ; Disconnect ant and mute audio if called with carry set
        mvi     a,$79
        sta     $A551                   ; mode & IF filter, new commanded rcv params
        xra     a
        sta     $A554                   ; FSK center freq
        mvi     a,$20
        sta     $A555                   ; FSK center freq
        mvi     a,$03
        sta     $A556                   ; FSK shift & pol
        call    L2D83                   ; Set FSK parameters
        mvi     a,$01
        sta     $A552
        call    L2E1A                   ; Set AGC control lines
        in      $40                             ; 8255 Port A
        ani     $FD
        out     $40                             ; 8255 Port A, turn off BITE osc
        lxi     h,$2425
        shld    $A54B                   ; new commanded receiver params block beginning
        lxi     h,$0000
        shld    $A54D
        call    L2E6A                   ; Set IF filter
        call    L2EBD                   ; Set audio path and mode
        call    L2FA9                   ; Set BFO
        call    L3098                   ; Set Synth; recv freq in $A54B-E, $AC3D determines offset (USB, AM, or LSB)
        mvi     c,$02
        mvi     d,$05
        call    L52CA                           ; 50 msec delay
        lda     $C400                   ; FSK option memory space
        ani     $01
        jz      L5283
        lxi     h,$1575
        shld    $A54B                   ; new commanded receiver params block beginning
        lxi     h,$0000
        shld    $A54D
        call    L3098                   ; Set Synth; recv freq in $A54B-E, $AC3D determines offset (USB, AM, or LSB)
        mvi     c,$02
        mvi     d,$05
        call    L52CA                           ; 50 msec delay
        lda     $C400                   ; FSK option memory space
        ani     $01
        jnz     L5283
        xra     a
        jmp     L5285
L5283:
        mov     a,c
        stc
L5285:
        push    psw
        mvi     a,$73
        sta     $A551                   ; mode & IF filter, new commanded rcv params
        lxi     h,$0000
        shld    $A54F                   ; BFO setting
        shld    $A54B                   ; new commanded receiver params block beginning
        shld    $A54D
        call    L2EBD                   ; Set audio path and mode
        call    L2FA9                   ; Set BFO
        call    L3098                   ; Set Synth; recv freq in $A54B-E, $AC3D determines offset (USB, AM, or LSB)
        pop     psw
        ret
;--------------------------------------------------------------------------------------------------
;       Set Receiver to 100 KHz
L52A2:
        lxi     h,$0000
        shld    $A54B                   ; new commanded receiver params block beginning
        lxi     h,$0010
        shld    $A54D
        call    L3098                   ; Set Synth; recv freq in $A54B-E, $AC3D determines offset (USB, AM, or LSB)
        ret

;--------------------------------------------------------------------------------------------------
;       Send 4 serial data strobes
L52B2:
        out     $63                     ; Set Serial Data strobe to PLL II
        out     $62                     ; Set Serial Data strobe to PLL III
        out     $60                     ; Set Serial Data strobe to Synthesizer
        out     $68                     ; Set Serial Data strobe to BFO
        ret
;--------------------------------------------------------------------------------------------------
;
;       L52BB sends $00 to D/A and $A574, L52BD sends A to D/A and $A574
;
L52BB:
        mvi     a,$00
L52BD:
        sta     $A574                   ; D/A value for RF gain
        di                                      ; Disable Interrupts
        call    L322C                           ; Send A to Serial Bus
        out     $61                             ; Set Serial Data strobe to D/A
        ei                                      ; Enable interrupts
        ret
;--------------------------------------------------------------------------------------------------
;       Time delay subroutine
L52C8:                                          ;               500 msec delay
        mvi     d,$32                           ; D=$32
L52CA:                                          ;               10 * D msec delay
        mvi     a,$0A                           ; A=$0A
L52CC:                                          ;               A msec delay
        sta     $ABD3                           ; $ABD3 = $0A
        dcr     d
L52D0:
        lda     $ABD3                           ; get A from $ABD3
        cpi     $00
        jnz     L52D0                           ; loop until A=0
        cmp     d
        jnz     L52CA                           ; loop until D=0
        ret
;--------------------------------------------------------------------------------------------------
;       FSK option code
L52DD:
        lda     $ABCB
        cpi     $0B
        jz      L52F6
        lda     $A836
        ora     a
        rz
        call    L537C                   ; FSK option code
        call    L53EF                   ; Display FSK shift, more
        mvi     a,$0B
        sta     $ABCB
        ret
L52F6:
        lda     $ABBB                   ; Location of pressed key code
        cpi     $FF
        jnz     L5304
        mvi     a,$00
        sta     $ABBC
        ret
L5304:
        lda     $ABBB                   ; Location of pressed key code
        rlc
        jnc     L5310
        lxi     h,$ABBF
        dcr     m
        rnz
L5310:
        mvi     a,$0C
        sta     $ABBF
        lda     $ABBB                   ; Location of pressed key code
        sta     $ABBC
        call    L542C                   ; FSK option code, command steering
        ret
;--------------------------------------------------------------------------------------------------
;
;       Returns sum of mem locs $A82B, C, D, E, F in Acc (FSK option values)
;
L531F:
        push    b
        lxi     h,$A82B                 ; FSK option values
        mvi     b,$05                           ; B=5
        xra     a                               ; A=0
L5326:
        adc     m                               ; A=$A82B+$A82C+$A82D+$A82E+$A82F
        inx     h
        dcr     b
        jnz     L5326
        pop     b
        ret
;--------------------------------------------------------------------------------------------------
;       Check FSK option data with checksum.  A=0 means was OK, A=FF means was reinitialized
L532E:
        call    L531F                           ; Returns sum of mem locs $A82B, C, D, E, F in Acc
        cmp     m
        rz
        call    L533A
        mvi     a,$FF
        ora     a
        ret
;--------------------------------------------------------------------------------------------------
;       FSK option code
L533A:
        lxi     h,L55BA
        lxi     d,$0006
        lxi     b,$A82B                 ; FSK option values
        mvi     a,$05
L5345:
        push    psw
        mov     a,m
        dad     d
        stax    b
        inx     b
        pop     psw
        dcr     a
        jnz     L5345
        call    L531F                           ; Returns sum of mem locs $A82B, C, D, E, F in Acc
        mov     m,a
        ret

;
L5354:
        lxi     h,$A831                 ; FSK option flag
        mvi     b,$05
        mvi     a,$00
L535B:
        mov     m,a
        inx     h
        dcr     b
        jnz     L535B
        sta     $A836
        ret

;
L5365:
        push    psw
        push    b
        push    h
        mov     c,a
        mvi     b,$00
        lxi     h,$A831                 ; FSK option flag
        dad     b
        mvi     m,$FF
        lda     $A836
        inr     a
        sta     $A836
        pop     h
        pop     b
        pop     psw
        ret
;--------------------------------------------------------------------------------------------------
;       FSK option code
L537C:
        mvi     a,$00
        sta     $A837                   ; FSK shift code (0-3)
        call    L2725                   ; Disable Tuning wheel
        lda     $ABB5
        ani     $0F                     ; freq, chan, BFO, tune off
        sta     $ABB5                   ; Front panel LEDs
        mvi     a,$00
        sta     $ABBD                   ; clear Numerical keypad applicability
        lda     $ABEC
        ori     $01                     ; update now
        sta     $ABEC                   ; Display update control see L06FD
        call    L54F4
        mvi     a,$0B
        sta     $ABCB
        ret
;--------------------------------------------------------------------------------------------------
;       FSK option code, called from 542C
;
L53A2:
        lda     $A837                   ; FSK shift code (0-3)
        inr     a
        cpi     $05
        jc      L53AD
        mvi     a,$00
L53AD:
        sta     $A837                   ; FSK shift code (0-3)
        mov     e,a
        mvi     d,$00
        lxi     h,$A831                 ; FSK option flag
        dad     d
        mov     a,m
        ora     a
        jz      L53A2
        lda     $A837                   ; FSK shift code (0-3)
        mov     e,a
        mvi     d,$00
        lxi     h,$A82B                 ; FSK option values
        dad     d
        mov     a,m
        sta     $A838                   ; Active FSK option value
        call    L53EF                   ; Display FSK shift, more
        ret
;--------------------------------------------------------------------------------------------------
;       FSK option code, called from 542C
;
L53CE:
        lda     $A837                   ; FSK shift code (0-3)
        mov     l,a
        mvi     h,$00
        dad     h
        push    h
        dad     h
        pop     d
        dad     d
        lxi     d,L55B5
        dad     d
        mov     c,m
        lda     $A838                   ; Active FSK option value
        inr     a
        cmp     c
        jc      L53E8
        mvi     a,$00
L53E8:
        sta     $A838                   ; Active FSK option value
        call    L53EF                   ; Display FSK shift, more
        ret
;--------------------------------------------------------------------------------------------------
;       Display FSK shift, more
L53EF:
        lda     $A837                   ; FSK shift code (0-3)
        add     a
        mov     c,a
        add     a
        add     a
        add     c
        mov     c,a                     ; C = 10 * $A837
        mvi     b,$00
        lxi     h,L552E                 ; FSK shift messages
        dad     b
        mvi     c,$1D
        mvi     b,$0A
        call    L0645                   ; Display text message
        lda     $A837                   ; FSK shift code (0-3)
        mov     l,a
        mvi     h,$00
        dad     h
        push    h
        dad     h
        pop     d
        dad     d
        lxi     d,L55B6
        dad     d
        mov     e,m
        inx     h
        mov     d,m
        xchg
        lda     $A838                   ; Active FSK option value
        add     a
        mov     c,a
        add     a
        add     a
        add     c
        mov     c,a
        mvi     b,$00
        dad     b
        mvi     c,$13
        mvi     b,$0A
        call    L0645                    ; Display text message
        ret
;--------------------------------------------------------------------------------------------------
;       FSK option code, command steering
L542C:
        lda     $ABBB                           ; Location of pressed key code
        ani     $7F
        sui     $0C
        rc                                      ; return if col <4
        add     a
        mov     e,a
        mvi     d,$00
        lxi     h,L5441
        dad     d
        mov     e,m
        inx     h
        mov     d,m
        xchg
        pchl                    ; index jump
;
L5441:  .DW     L546A   ; Prog
        .DW     L546A   ; Receive
        .DW     L546A   ; Scan
        .DW     L546A   ; Test
        .DW     L546A   ; Remote
        .DW     L5469   ; Enter
        .DW     L5473   ; Load
        .DW     L54F4   ; Recall 
        .DW     L5469   ; Channel
        .DW     L5469   ; Frequency
        .DW     L5469   ; BFO
        .DW     L53CE   ; Group
        .DW     L5469   ; BW
        .DW     L5469   ; Mode
        .DW     L53A2   ; AGC Speed
        .DW     L5469   ; AGC On/Off
        .DW     L5469   ; Noise Blanker
        .DW     L5469   ; Tune Rate
        .DW     L5469   ; Tune Enable
        .DW     L5469   ; Dwell

;--------------------------------------------------------------------------------------------------
;       FSK option code, called from 542C
L5469:
        ret
;--------------------------------------------------------------------------------------------------
;       FSK option code, called from 542C
L546A:
        mvi     a,$00
        sta     $ABCB
        call    L0D38                   ; process pressed key
        ret
;--------------------------------------------------------------------------------------------------
;       FSK option code, called from 542C
L5473:
        lda     $A837                   ; FSK shift code (0-3)
        mov     c,a
        lda     $A838                   ; Active FSK option value
        call    L547E
        ret
;--------------------------------------------------------------------------------------------------
;       FSK option code
L547E:
        mov     b,a
        mov     a,c
        cpi     $05
        jnc     L54CB
        mov     e,c
        mvi     d,$00
        lxi     h,$A831                 ; FSK option flag
        dad     d
        mov     a,m
        ora     a
        jz      L54CB
        xchg
        dad     h
        push    h
        dad     h
        pop     d
        dad     d
        lxi     d,L55B5
        dad     d
        mov     a,b
        cmp     m
        jnc     L54CB
        push    h
        mov     e,c
        mvi     d,$00
        lxi     h,$A82B                 ; FSK option values
        dad     d
        mov     m,b
        call    L531F                   ; Returns sum of mem locs $A82B, C, D, E, F in Acc
        mov     m,a
        mov     a,c
        rlc
        rlc
        rlc
        ani     $F8
        ora     b
        mvi     b,$3B                   ; DID - Options
        mov     c,a
        call    L3C43                   ; Harris protocol code; add non-urgent DID B data C to response
        pop     h
        inx     h
        inx     h
        inx     h
        mov     e,m
        inx     h
        mov     d,m
        xchg
        lxi     d,L54C7                 ; *****
        push    d
        pchl                    ;INFO: index jump
L54C7:
        ora     a
        jmp     L54CC
L54CB:
        stc
L54CC:
        ret
;--------------------------------------------------------------------------------------------------
;       FSK option code
L54CD:
        lxi     d,$0000
L54D0:
        lxi     h,$A831                 ; FSK option flag
        dad     d
        mov     a,m
        ora     a
        jz      L54EC
        mov     a,e
        rlc
        rlc
        rlc
        ani     $F8
        lxi     h,$A82B                 ; FSK option values
        dad     d
        ora     m
        mvi     b,$3B                   ; DID - Options
        mov     c,a
        push    d
        call    L3C43                   ; Harris protocol code; add non-urgent DID B data C to response
        pop     d
L54EC:
        inr     e
        mov     a,e
        cpi     $05
        jnz     L54D0
        ret
;--------------------------------------------------------------------------------------------------
;       FSK option code
L54F4:
        lda     $A837                   ; FSK shift code (0-3)
        mov     e,a
        mvi     d,$00
        lxi     h,$A82B                 ; FSK option values
        dad     d
        mov     a,m
        sta     $A838                   ; Active FSK option value
        call    L53EF                   ; Display FSK shift, more
        ret
;--------------------------------------------------------------------------------------------------
;       Get into A from $55B0 lookup table the byte offset by val of $A82F
;
L5506:
        push    h
        push    d
         lda     $A82F                 ; FSK option values
         mov     e,a
         mvi     d,$00
         lxi     h,L55B0
         dad     d
         mov     a,m
        pop     d
        pop     h
        ret
;--------------------------------------------------------------------------------------------------
;       Set AGC control lines if FSK mode
L5516:
        lda     $A551                   ; mode & IF filter, new commanded rcv params
        ani     $0F
        cpi     $09                     ; FSK?
        jnz     L5523                   ; jump if not
        call    L2E1A                   ; Set AGC control lines
L5523:
        ret
;--------------------------------------------------------------------------------------------------
;
L5524:  .DB     "----------"
L552E:  .DB     " VN SHIFT "
L5538:  .DB     "  N SHIFT "
L5542:  .DB     "  M SHIFT "
L554C:  .DB     "  W SHIFT "
L5556:  .DB     " FSK AGC  "
L5560:  .DB     " BAUD 50  "
L556A:  .DB     " BAUD 100 "
L5574:  .DB     " BAUD 200 "
L557E:  .DB     "    SLOW  "
L5588:  .DB     "    FAST  "
L5592:  .DB     "   MEDIUM "
L559C:  .DB     "    OFF   "
L55A6:  .DB     "    DATA  "

;--------------------------------------------------------------------------------------------------
;
L55B0:  .DB     $00, $01, $02, $04, $05
L55B5:  .DB     $03
L55B6:  .DB     $60
L55B7:  .DB     $55
L55B8:  .DB     $83
L55B9:  .DB     $2D
L55BA:  .DB     $00
L55BB:  .DB     $03
L55BC:  .DB     $60
L55BD:  .DB     $55
L55BE:  .DB     $83
L55BF:  .DB     $2D
L55C0:  .DB     $00
L55C1:  .DB     $03
L55C2:  .DB     $60
L55C3:  .DB     $55
L55C4:  .DB     $83
L55C5:  .DB     $2D
L55C6:  .DB     $01
L55C7:  .DB     $03
L55C8:  .DB     $60
L55C9:  .DB     $55
L55CA:  .DB     $83
L55CB:  .DB     $2D
L55CC:  .DB     $02
L55CD:  .DB     $05
L55CE:  .DB     $7E
L55CF:  .DB     $55
L55D0:  .DB     $16
L55D1:  .DB     $55
L55D2:  .DB     $01
;--------------------------------------------------------------------------------------------------
;       Process ASCII commands from serial port
L55D3:
        lda     $AC39                   ; Serial transmitter transmitting flag
        ora     a
        rnz                             ; do not respond if currently sending serial data out
        lda     $AA4B                   ; Number of CR's in input buffer
        ora     a
        rz
        call    L6252                   ; Move incoming ASCII into second buffer
        call    L56C2                   ; Enable/disable radio response based on Radio ID and incoming address
        lda     $A845                   ; Radio addressed, respond to commands (FF=respond)
        ora     a
        jz      L55D3
        call    L55F5                   ; ASCII command processing
        lda     $AB8E                   ; set to FF to request BITE
        ora     a
        cnz     L5C6E                   ; start BITE if $AB8E = $FF
        ret

;--------------------------------------------------------------------------------------------------
;       ASCII command processing
L55F5:
        xra     a
        sta     $A808
        sta     $AB84
        sta     $AB67
        sta     $AB6E
        call    L3FA7                   ; Clear remote 'programming channel' flag
        lxi     h,$A559                 ; present receiver param block beginning
        shld    $A809
L560B:
        lda     $A680                   ; Remote 'programming channel' flag
        ora     a
        jnz     L5618
        lxi     h,$A559                 ; present receiver param block beginning
        shld    $A809
L5618:
        lxi     d,L5672                 ; *****
        lhld    $AB4B                   ; command parsing pointer
        mov     a,m
        cpi     $5A
        jnz     L5629
        lxi     d,L56BE
        inx     h
        mov     a,m
L5629:
        inx     h
        shld    $AB4B                   ; command parsing pointer
        cpi     $0D
        jnz     L5651
        lda     $AB84
        ora     a
        jnz     L5F80                   ; Remote code dealing with BW filters
        lda     $A679                   ; Status bits
        ani     $80
        cnz     L5649                   ; call if local control mode
        lda     $A67A                   ; Radio state bits
        cpi     $04
        cnz     L1E05                   ; Set radio where present <> new commanded params
L5649:
        lda     $AB67
        ora     a
        cnz     L63F6                   ; Send status report and Carriage return
        ret
L5651:
        mov     c,a
L5652:
        ldax    d
        cpi     $FF
        jnz     L565E
        call    L6247                   ; Adv parsing ptr to next cmd and set 'Syntax Error' flag
        jmp     L560B
L565E:
        inx     d
        cmp     c
        jz      L5668
        inx     d
        inx     d
        jmp     L5652
L5668:
        lxi     h,L560B
        push    h
        xchg
        mov     e,m
        inx     h
        mov     d,m
        xchg
        pchl                    ;INFO: index jump

;
L5672:                                  ; ***** all the following:
        .db      'A'
        .DW      L5D50                  ; RF attenuation command (A) processing 

        .db      'B'
        .DW      L61D7                  ; BFO command (B) processing

        .db      'C'
        .DW      L5E2F                  ; Goto Channel command (C) processing

        .db      'D'
        .DW      L5F05                  ; Mode command (D) processing

        .db      'E'
        .DW      L5819                  ; Auto stop scan threshold command (E) processing

        .db      'F'
        .DW      L60C7                  ; Frequency command (F) processing

        .db      'G'
        .DW      L5CA7                  ; Report complete status command (G) processing

        .db      'H'
        .DW      L5E7C                  ; Report Channel (H) command processing

        .db      'I'
        .DW      L5F62                  ; IF filter bandwidth (I) command processing

        .db      'J'
        .DW      L5A5A                  ; Program channel (J) command processing

        .db      'K'
        .DW      L5D96                  ; Start Scan at chan or grp command (K) processing        

        .db      'L'
        .DW      L5956                  ; Lock out chan(s) command (L) processing        

        .db      'M'
        .DW      L5E8C                  ; AGC command (M) processing        

        .db      'N'
        .DW      L57DF                  ; Noise Blanker command (N) processing         

        .db      'O'
        .DW      L589B                  ; Program options command (O) processing         

        .db      'P'
        .DW      L57A5                  ; Open/close Path (mute) command (P) processing         

        .db      'Q'
        .DW      L59A7                  ; Unlock channel(s) command (Q) processing        

        .db      'R'
        .DW      L6110                  ; FSK Center freq command (R) processing

        .db      'S'
        .DW      L5A90                  ; S command processing

        .db      'T'
        .DW      L5CCE                  ; Request specific status command (T) processing

        .db      'U'
        .DW      L585F                  ; Channel scanning bounds (U) command processing

        .db      'V'
        .DW      L58F4                  ; Program group (V) command processing

        .db      'W'
        .DW      L59F8                  ; Unprogram group (W) command processing

        .db      'X'
        .DW      L5841                  ; Report group command (X) processing

        .db      'Y'
        .DW      L6184                  ; FSK shift and polarity command (Y) processing

        .db      $FF
L56BE:  .db      'D'
        .DW      L571C                  ; Scan Dwell command (zD) processing

        .db     $FF

;--------------------------------------------------------------------------------------------------
;       Enable/disable radio response based on Radio ID and incoming address
L56C2:
        lhld    $AB4B                   ; command parsing pointer
        mov     a,m                     ; get next char addressed by pointer
        cpi     $24                     ; '$'
        rnz                             ; this subroutine only acts on addressing commands
        mvi     a,$00
        sta     $A845                   ; Radio addressed, respond to commands (FF=respond)
        sta     $A846                   ; Radio addressed uniquely, return status reports (FF=report)
        mvi     b,$00
        mvi     c,$00
L56D5:
        inx     h
        call    L6317                   ; Convert nbr string to # in DE, A=# digits, HL points to next
        ora     a
        jz      L56F6                   ; jump if zero digits
        mov     a,d
        ora     a
        jnz     L5718
        lda     $AC3B                   ; Radio ID
        cmp     e
        jnz     L56EE
        mvi     c,$FF
        jmp     L56F0
L56EE:
        mvi     b,$FF
L56F0:
        mov     a,m
        cpi     $2C
        jz      L56D5                   ; if a comma, multiple radios addressed
L56F6:
        shld    $AB4B                   ; command parsing pointer
        mov     a,b
        ora     c
        jz      L5718                   ; jump if bad addressing command
        mov     a,c
        ora     a
        jz      L571B                   ; address does not match
        mvi     a,$FF
        sta     $A845                   ; Radio addressed, respond to commands (FF=respond)
        sta     $A846                   ; Radio addressed uniquely, return status reports (FF=report)
        mov     a,b
        ora     a
        jz      L571B
        mvi     a,$00
        sta     $A846                   ; Radio not addressed uniquely, do not return status reports
        jmp     L571B
L5718:
        call    L6247                   ; Adv parsing ptr to next cmd and set 'Syntax Error' flag
L571B:
        ret
;--------------------------------------------------------------------------------------------------
;       Scan Dwell command (zD) processing
;
L571C:
        lda     $A679                   ; Status bits
        ani     $80                     ; skip ASCII command if in local control mode
        jnz     L623C                   ; Adv parsing ptr to next cmd and set 'Unable or Invalid Command' flag
        call    L3FA7                   ; Clear remote 'programming channel' flag
        lxi     h,$A559                 ; present receiver param block beginning
        shld    $A809
        lda     $A67A                   ; Radio state bits
        cpi     $04
        jz      L623C                   ; Adv parsing ptr to next cmd and set 'Unable or Invalid Command' flag
        lhld    $AB4B                   ; command parsing pointer
        mov     a,m
        cpi     $2D
        jnz     L574E
        call    L63DB                   ; Advance $AB4B pointer to next valid cmd or EOL (CR)
        mvi     a,$0B
        sta     $A580                   ; Scan Dwell pointer; $0B means external.
        mvi     b,$FF
        call    L22E2                   ; Scan dwell setting code
        jmp     L5799
L574E:
        lxi     d,$AB51                 ; $AB51-8 BCD radio frequency
        mvi     b,$02
        mvi     c,$01
        call    L6340                   ; ASCII verify number B digits before dec pt, C digits after.  A=0 if OK, $FF if bad
L5758:
        ora     a
        jnz     L6247                   ; Adv parsing ptr to next cmd and set 'Syntax Error' flag
        lxi     h,$AB51                 ; $AB51-8 BCD radio frequency
        mov     a,m
        cpi     $30
        jz      L5772
        mvi     a,$0A
        sta     $A580                   ; Scan Dwell pointer; $0B means external.
        mvi     b,$99
        call    L22E2                   ; Scan dwell setting code
        jmp     L5799
L5772:
        inx     h
        mov     b,m
        inx     h
        mov     c,m
        call    L630C                   ; A gets low nybble of B as top 4 bits, low nybble of C as low 4 bits
        mvi     c,$00
        lxi     h,L579A
L577E:
        cmp     m
        jz      L5791
        jc      L5791
        inx     h
        inr     c
        mov     b,a
        mov     a,c
        cpi     $0B
        mov     a,b
        jnz     L577E
        dcx     h
        dcr     c
L5791:
        mov     a,c
        sta     $A580                   ; Scan Dwell pointer; $0B means external.
        mov     b,m
        call    L22E2                   ; Scan dwell setting code
L5799:
        ret

;
L579A:  .db     $01, $02, $04, $05, $08, $10
        .db     $20, $40, $50, $80, $99

;--------------------------------------------------------------------------------------------------
;       Open/close Path (mute) command (P) processing
;
L57A5:
        lda     $A679                   ; Status bits
        ani     $80                     ; skip ASCII command if in local control mode
        jnz     L623C                   ; Adv parsing ptr to next cmd and set 'Unable or Invalid Command' flag
        call    L3FA7                   ; Clear remote 'programming channel' flag
        lxi     h,$A559                 ; present receiver param block beginning
        shld    $A809
        lda     $A67A                   ; Radio state bits
        cpi     $04
        jz      L623C                   ; Adv parsing ptr to next cmd and set 'Unable or Invalid Command' flag
        lhld    $AB4B                   ; command parsing pointer
        call    L6317                   ; Convert nbr string to # in DE, A=# digits, HL points to next
        shld    $AB4B                   ; command parsing pointer
        ora     a
        jz      L6247                   ; Adv parsing ptr to next cmd and set 'Syntax Error' flag
        mov     a,d
        ora     a
        jnz     L623C                   ; Adv parsing ptr to next cmd and set 'Unable or Invalid Command' flag
        mov     a,e
        cpi     $02
        jnc     L623C                   ; Adv parsing ptr to next cmd and set 'Unable or Invalid Command' flag
        ora     a
        jz      L57DB
        stc
L57DB:
        call    L3234                   ; Disconnect ant and mute audio if called with carry set
        ret
;--------------------------------------------------------------------------------------------------
;       Noise Blanker command (N) processing
;
L57DF:
        lda     $A679                   ; Status bits
        ani     $80                     ; skip ASCII command if in local control mode
        jnz     L623C                   ; Adv parsing ptr to next cmd and set 'Unable or Invalid Command' flag
        call    L3FA7                   ; Clear remote 'programming channel' flag
        lxi     h,$A559                 ; present receiver param block beginning
        shld    $A809
        lda     $A67A                   ; Radio state bits
        cpi     $04
        jz      L623C                   ; Adv parsing ptr to next cmd and set 'Unable or Invalid Command' flag
        lhld    $AB4B                   ; command parsing pointer
        call    L6317                   ; Convert nbr string to # in DE, A=# digits, HL points to next
        shld    $AB4B                   ; command parsing pointer
        ora     a
        jz      L6247                   ; Adv parsing ptr to next cmd and set 'Syntax Error' flag
        mov     a,d
        ora     a
        jnz     L623C                   ; Adv parsing ptr to next cmd and set 'Unable or Invalid Command' flag
        mov     a,e
        cpi     $02
        jnc     L623C                   ; Adv parsing ptr to next cmd and set 'Unable or Invalid Command' flag
        ora     a
        jz      L5815
        stc
L5815:
        call    L1944                   ; Noise Blanker = not(carry)
        ret
;--------------------------------------------------------------------------------------------------
;       Auto stop scan threshold command (E) processing
;
L5819:
        lda     $A679                   ; Status bits
        ani     $80                     ; skip ASCII command if in local control mode
        jnz     L623C                   ; Adv parsing ptr to next cmd and set 'Unable or Invalid Command' flag
        call    L3FA7                   ; Clear remote 'programming channel' flag
        lxi     h,$A559                 ; present receiver param block beginning
        shld    $A809
        lhld    $AB4B                   ; command parsing pointer
        call    L6317                   ; Convert nbr string to # in DE, A=# digits, HL points to next
        shld    $AB4B                   ; command parsing pointer
        ora     a
        jz      L6247                   ; Adv parsing ptr to next cmd and set 'Syntax Error' flag
        mov     a,d
        ora     a
        jnz     L623C                   ; Adv parsing ptr to next cmd and set 'Unable or Invalid Command' flag
        mov     a,e
        sta     $AB91                   ; Auto Stop Scan Threshold (FF=off)
        ret
;--------------------------------------------------------------------------------------------------
;       Report group command (X) processing
;
L5841:
        call    L3FA7                   ; Clear remote 'programming channel' flag
        lxi     h,$A559                 ; present receiver param block beginning
        shld    $A809
        lhld    $AB4B                   ; command parsing pointer
        call    L62E1                   ; ASCII at [HL] and [HL+1] converted to BCD in A, HL incr by 2
        shld    $AB4B                   ; command parsing pointer
        jc      L6247                   ; Adv parsing ptr to next cmd and set 'Syntax Error' flag
        cpi     $0A
        jnc     L623C                   ; Adv parsing ptr to next cmd and set 'Unable or Invalid Command' flag
        call    L6475                   ; Report channels programmed into group specified in A
        ret
;--------------------------------------------------------------------------------------------------
;       Channel scanning bounds (U) command processing
;
L585F:
        lda     $A679                   ; Status bits
        ani     $80                     ; skip ASCII command if in local control mode
        jnz     L623C                   ; Adv parsing ptr to next cmd and set 'Unable or Invalid Command' flag
        call    L3FA7                   ; Clear remote 'programming channel' flag
        lxi     h,$A559                 ; present receiver param block beginning
        shld    $A809
        lda     $A67A                   ; Radio state bits
        cpi     $04
        jz      L623C                   ; Adv parsing ptr to next cmd and set 'Unable or Invalid Command' flag
        lhld    $AB4B                   ; command parsing pointer
        call    L62E1                   ; ASCII at [HL] and [HL+1] converted to BCD in A, HL incr by 2
        shld    $AB4B                   ; command parsing pointer
        jc      L6247                   ; Adv parsing ptr to next cmd and set 'Syntax Error' flag
        sta     $A57C                   ; Channel scanning lower bound
        mov     a,m
        cpi     $2C
        jnz     L6247                   ; Adv parsing ptr to next cmd and set 'Syntax Error' flag
        inx     h
        call    L62E1                   ; ASCII at [HL] and [HL+1] converted to BCD in A, HL incr by 2
        shld    $AB4B                   ; command parsing pointer
        jc      L6247                   ; Adv parsing ptr to next cmd and set 'Syntax Error' flag
        sta     $A57D                   ; Channel scanning upper bound
        ret
;--------------------------------------------------------------------------------------------------
;       Program options command (O) processing
;
L589B:
        lda     $A679                   ; Status bits
        ani     $80                     ; skip ASCII command if in local control mode
        jnz     L623C                   ; Adv parsing ptr to next cmd and set 'Unable or Invalid Command' flag
        call    L3FA7                   ; Clear remote 'programming channel' flag
        lxi     h,$A559                 ; present receiver param block beginning
        shld    $A809
        lda     $A67A                   ; Radio state bits
        cpi     $04
        jz      L623C                   ; Adv parsing ptr to next cmd and set 'Unable or Invalid Command' flag
L58B4:
        lhld    $AB4B                   ; command parsing pointer
        call    L6317                   ; Convert nbr string to # in DE, A=# digits, HL points to next
        shld    $AB4B                   ; command parsing pointer
        ora     a
        jz      L6247                   ; Adv parsing ptr to next cmd and set 'Syntax Error' flag
        mov     a,d
        ora     a
        jnz     L623C                   ; Adv parsing ptr to next cmd and set 'Unable or Invalid Command' flag
        mov     c,e
        mov     a,m
        cpi     $2C
        jnz     L6247                   ; Adv parsing ptr to next cmd and set 'Syntax Error' flag
        inx     h
        call    L6317                   ; Convert nbr string to # in DE, A=# digits, HL points to next
        shld    $AB4B                   ; command parsing pointer
        ora     a
        jz      L6247                   ; Adv parsing ptr to next cmd and set 'Syntax Error' flag
        mov     a,d
        ora     a
        jnz     L623C                   ; Adv parsing ptr to next cmd and set 'Unable or Invalid Command' flag
        mov     a,e
        push    h
        call    L547E
        pop     h
        jc      L623C                   ; Adv parsing ptr to next cmd and set 'Unable or Invalid Command' flag
        mov     a,m
        cpi     $2C
        jnz     L58F3
        inx     h
        shld    $AB4B                   ; command parsing pointer
        jmp     L58B4
L58F3:
        ret
;--------------------------------------------------------------------------------------------------
;       Program group (V) command processing
;
L58F4:
        lda     $A679                   ; Status bits
        ani     $80                     ; skip ASCII command if in local control mode
        jnz     L623C                   ; Adv parsing ptr to next cmd and set 'Unable or Invalid Command' flag
        call    L3FA7                   ; Clear remote 'programming channel' flag
        lxi     h,$A559
        shld    $A809
        lda     $A67A                   ; Radio state bits
        cpi     $04
        jz      L623C                   ; Adv parsing ptr to next cmd and set 'Unable or Invalid Command' flag
        lhld    $AB4B                   ; command parsing pointer
        call    L62E1                   ; ASCII at [HL] and [HL+1] converted to BCD in A, HL incr by 2
        shld    $AB4B                   ; command parsing pointer
        jc      L6247                   ; Adv parsing ptr to next cmd and set 'Syntax Error' flag
        cpi     $0A
        jnc     L623C                   ; Adv parsing ptr to next cmd and set 'Unable or Invalid Command' flag
        mov     c,a
        lda     $A579                   ; Holds group number
        cmp     c
        jnz     L5935
        lda     $A67A                   ; Radio state bits
        cpi     $03
        jnz     L5935
        lda     $A575                           ; Actively scanning flag ($FF means actively scanning)
        ora     a
        jnz     L623C                   ; Adv parsing ptr to next cmd and set 'Unable or Invalid Command' flag
L5935:
        mov     a,c
        sta     $ABC4                   ; Channel storage for use in group programming
L5939:
        lhld    $AB4B                   ; command parsing pointer
        mvi     a,$2C
        cmp     m
        jnz     L5955
        inx     h
        call    L62E1                   ; ASCII at [HL] and [HL+1] converted to BCD in A, HL incr by 2
        shld    $AB4B                   ; command parsing pointer
        jc      L6247                   ; Adv parsing ptr to next cmd and set 'Syntax Error' flag
        call    L21AE                   ; Put channel A into spot with $EE in group C
        jc      L623C                   ; Adv parsing ptr to next cmd and set 'Unable or Invalid Command' flag
        jmp     L5939
L5955:
        ret
;--------------------------------------------------------------------------------------------------
;       Lock out chan(s) command (L) processing
;
L5956:
        lda     $A679                   ; Status bits
        ani     $80                     ; skip ASCII command if in local control mode
        jnz     L623C                   ; Adv parsing ptr to next cmd and set 'Unable or Invalid Command' flag
        call    L3FA7                   ; Clear remote 'programming channel' flag
        lxi     h,$A559                 ; present receiver param block beginning
        shld    $A809
        lda     $A67A                   ; Radio state bits
        cpi     $04
        jz      L623C                   ; Adv parsing ptr to next cmd and set 'Unable or Invalid Command' flag
L596F:
        lhld    $AB4B                   ; command parsing pointer
        call    L62E1                   ; ASCII at [HL] and [HL+1] converted to BCD in A, HL incr by 2
        shld    $AB4B                   ; command parsing pointer
        jc      L6247                   ; Adv parsing ptr to next cmd and set 'Syntax Error' flag
        lhld    $A809
        xchg
        mov     b,a
        call    L1CBF                   ; Get channel memory RAM addr in HL given BCD channel # in B
        shld    $A809
        mvi     c,$07
        call    L3F4E                   ; HL = $A809 + C ($A810)
        mov     a,m
        ori     $80
        mov     m,a
        call    L3F86                   ; checksum
        xchg
        shld    $A809
        lhld    $AB4B                   ; command parsing pointer
        mvi     a,$2C
        cmp     m
        jnz     L59A6
        inx     h
        shld    $AB4B                   ; command parsing pointer
        jmp     L596F
L59A6:
        ret
;--------------------------------------------------------------------------------------------------
;       Unlock channel(s) command (Q) processing
;
L59A7:
        lda     $A679                   ; Status bits
        ani     $80                     ; skip ASCII command if in local control mode
        jnz     L623C                   ; Adv parsing ptr to next cmd and set 'Unable or Invalid Command' flag
        call    L3FA7                   ; Clear remote 'programming channel' flag
        lxi     h,$A559                 ; present receiver param block beginning
        shld    $A809
        lda     $A67A                   ; Radio state bits
        cpi     $04
        jz      L623C                   ; Adv parsing ptr to next cmd and set 'Unable or Invalid Command' flag
L59C0:
        lhld    $AB4B                   ; command parsing pointer
        call    L62E1                   ; ASCII at [HL] and [HL+1] converted to BCD in A, HL incr by 2
        shld    $AB4B                   ; command parsing pointer
        jc      L6247                   ; Adv parsing ptr to next cmd and set 'Syntax Error' flag
        lhld    $A809
        xchg
        mov     b,a
        call    L1CBF                   ; Get channel memory RAM addr in HL given BCD channel # in B
        shld    $A809
        mvi     c,$07
        call    L3F4E                   ; HL = $A809 + C ($A810)
        mov     a,m
        ani     $7F
        mov     m,a
        call    L3F86                   ; checksum
        xchg
        shld    $A809
        lhld    $AB4B                   ; command parsing pointer
        mvi     a,$2C
        cmp     m
        jnz     L59F7
        inx     h
        shld    $AB4B                   ; command parsing pointer
        jmp     L59C0
L59F7:
        ret
;--------------------------------------------------------------------------------------------------
;       Unprogram group (W) command processing
;
L59F8:
        lda     $A679                   ; Status bits
        ani     $80                     ; skip ASCII command if in local control mode
        jnz     L623C                   ; Adv parsing ptr to next cmd and set 'Unable or Invalid Command' flag
        call    L3FA7                   ; Clear remote 'programming channel' flag
        lxi     h,$A559                 ; present receiver param block beginning
        shld    $A809
        lda     $A67A                   ; Radio state bits
        cpi     $04
        jz      L623C                   ; Adv parsing ptr to next cmd and set 'Unable or Invalid Command' flag
        lhld    $AB4B                   ; command parsing pointer
        call    L62E1                   ; ASCII at [HL] and [HL+1] converted to BCD in A, HL incr by 2
        shld    $AB4B                   ; command parsing pointer
        jc      L6247                   ; Adv parsing ptr to next cmd and set 'Syntax Error' flag
        cpi     $0A
        jnc     L623C                   ; Adv parsing ptr to next cmd and set 'Unable or Invalid Command' flag
        mov     c,a
        lda     $A579                   ; Holds group number
        cmp     c
        jnz     L5A39
        lda     $A67A                   ; Radio state bits
        cpi     $03
        jnz     L5A39
        lda     $A575                           ; Actively scanning flag ($FF means actively scanning)
        ora     a
        jnz     L623C                   ; Adv parsing ptr to next cmd and set 'Unable or Invalid Command' flag
L5A39:
        mov     a,c
        sta     $ABC4                   ; Channel storage for use in group programming
L5A3D:
        lhld    $AB4B                   ; command parsing pointer
        mvi     a,$2C
        cmp     m
        jnz     L5A59
        inx     h
        call    L62E1                   ; ASCII at [HL] and [HL+1] converted to BCD in A, HL incr by 2
        shld    $AB4B                   ; command parsing pointer
        jc      L6247                   ; Adv parsing ptr to next cmd and set 'Syntax Error' flag
        call    L21B7                   ; Replace channel A in group C with $EE
        jc      L623C                   ; Adv parsing ptr to next cmd and set 'Unable or Invalid Command' flag
        jmp     L5A3D
L5A59:
        ret
;--------------------------------------------------------------------------------------------------
;       Program channel (J) command processing
;
L5A5A:
        lda     $A679                   ; Status bits
        ani     $80                     ; skip ASCII command if in local control mode
        jnz     L623C                   ; Adv parsing ptr to next cmd and set 'Unable or Invalid Command' flag
        lda     $A575                   ; Actively scanning flag ($FF means actively scanning)
        ora     a
        jnz     L623C                   ; Adv parsing ptr to next cmd and set 'Unable or Invalid Command' flag
        lda     $A67A                   ; Radio state bits
        cpi     $04
        jz      L623C                   ; Adv parsing ptr to next cmd and set 'Unable or Invalid Command' flag
        lhld    $AB4B                   ; command parsing pointer
        call    L62E1                   ; ASCII at [HL] and [HL+1] converted to BCD in A, HL incr by 2
        shld    $AB4B                   ; command parsing pointer
        jc      L6247                   ; Adv parsing ptr to next cmd and set 'Syntax Error' flag
        mov     b,a
        sta     $A68C
        call    L1CBF                   ; Get channel memory RAM addr in HL given BCD channel # in B
        xra     a
        sta     $A808
        shld    $A809
        cma
        sta     $A680                   ; Set remote 'programming channel' flag
        ret
;--------------------------------------------------------------------------------------------------
;       S command processing
;
L5A90:
        lxi     h,$A559                 ; present receiver param block beginning
        shld    $A809
        call    L3FA7                   ; Clear remote 'programming channel' flag
        lhld    $AB4B                   ; command parsing pointer
        call    L6317                   ; Convert nbr string to # in DE, A=# digits, HL points to next
        shld    $AB4B                   ; command parsing pointer
        ora     a
        jz      L6247                   ; if no S #, Adv parsing ptr to next cmd and set 'Syntax Error' flag
        mov     a,d
        ora     a
        jnz     L623C                   ; Adv parsing ptr to next cmd and set 'Unable or Invalid Command' flag
        xchg
        mov     a,h
        ora     a
        jnz     L623C                   ; Adv parsing ptr to next cmd and set 'Unable or Invalid Command' flag
        dcr     l                       ; convert S1 to zero based offset
        jc      L623C                   ; Adv parsing ptr to next cmd and set 'Unable or Invalid Command' flag
        mov     a,l
        cpi     $13
        jnc     L623C                   ; if > S19, Adv parsing ptr to next cmd and set 'Unable or Invalid Command' flag
        dad     h
        lxi     d,L5AC5                 ; *****
        dad     d
        mov     e,m
        inx     h
        mov     d,m
        push    d
        ret

;                                       ; ***** the following:
L5AC5:  .DW     L5AEB   ; S1      nop
        .DW     L5AEB   ; S2      nop
        .DW     L5C60   ; S3      Begin BITE command
        .DW     L5BA9   ; S4      Goto Normal State command
        .DW     L66E7   ; S5      Report IF Filter Config command
        .DW     L668A   ; S6      Report BITE Results command
        .DW     L5AEB   ; S7      nop
        .DW     L5AEB   ; S8      nop
        .DW     L5AEB   ; S9      nop
        .DW     L5BD6   ; S10     Prepare For Channel Scan command
        .DW     L5C1B   ; S11     Prepare for Group Scan command
        .DW     L5AEC   ; S12     Halt Scan command
        .DW     L5D9B   ; S13     Resume Scan command
        .DW     L5B0E   ; S14     Increment Channel command
        .DW     L5B5D   ; S15     Decrement Channel command
        .DW     L66BD   ; S16     Report Who You Are command
        .DW     L6584   ; S17     Report Radio State command
        .DW     L65F3   ; S18     Report Programmable Options command
        .DW     L6633   ; S19     Report AGC and Audio Levels command

;--------------------------------------------------------------------------------------------------
;       S command NOP processing
;
L5AEB:
        ret
;--------------------------------------------------------------------------------------------------
;       S12 Halt Scan command
;
L5AEC:
        lda     $A679                   ; Status bits
        ani     $80                     ; skip ASCII command if in local control mode
        jnz     L623C                   ; Adv parsing ptr to next cmd and set 'Unable or Invalid Command' flag
        call    L3FA7                   ; Clear remote 'programming channel' flag
        lxi     h,$A559                 ; present receiver param block beginning
        shld    $A809
        lda     $A67A                   ; Radio state bits
        cpi     $01
        jz      L623C                   ; Adv parsing ptr to next cmd and set 'Unable or Invalid Command' flag
        cpi     $04
        jz      L623C                   ; Adv parsing ptr to next cmd and set 'Unable or Invalid Command' flag
        call    L23B6                   ; Stopping scan, not due to received signal
        ret
;--------------------------------------------------------------------------------------------------
;       S14 Increment Channel command
;
L5B0E:
        lda     $A679                   ; Status bits
        ani     $80                     ; skip ASCII command if in local control mode
        jnz     L623C                   ; Adv parsing ptr to next cmd and set 'Unable or Invalid Command' flag
        call    L3FA7                   ; Clear remote 'programming channel' flag
        lda     $A67A                   ; Radio state bits
        cpi     $04
        jz      L623C                   ; Adv parsing ptr to next cmd and set 'Unable or Invalid Command' flag
        xra     a
        sta     $A56C                   ; Decimal movement of tuning wheel
        lda     $A67A                   ; Radio state bits
        cpi     $03
        jnz     L5B36
        call    L213D                   ; Group (and maybe scan) logic
        jnc     L5B59
        jmp     L623C                   ; Adv parsing ptr to next cmd and set 'Unable or Invalid Command' flag
L5B36:
        cpi     $02
        jnz     L5B44
        lda     $A558                   ; Channel number displayed on front panel (=A0 if none)
        lhld    $A57C                   ; Channel scanning lower bound
        jmp     L5B52
L5B44:
        cpi     $01
        rnz
        lxi     h,$9900
        lda     $A558                   ; Channel number displayed on front panel (=A0 if none)
        cpi     $A0
        jz      L623C                   ; Adv parsing ptr to next cmd and set 'Unable or Invalid Command' flag
L5B52:
        mov     b,a
        mvi     a,$01
        ora     a
        call    L28A3                   ; Increment/decrement channel logic.  Carry=1 means dec, B=present chan, HL=valid range of chans
L5B59:
        call    L453D
        ret
;--------------------------------------------------------------------------------------------------
;       S15 Decrement Channel command
;
L5B5D:
        lda     $A679                   ; Status bits
        ani     $80                     ; skip ASCII command if in local control mode
        jnz     L623C                   ; Adv parsing ptr to next cmd and set 'Unable or Invalid Command' flag
        call    L3FA7                   ; Clear remote 'programming channel' flag
        lda     $A67A                   ; Radio state bits
        cpi     $04
        jz      L623C                   ; Adv parsing ptr to next cmd and set 'Unable or Invalid Command' flag
        lda     $A67A                   ; Radio state bits
        cpi     $03
        jnz     L5B82
        stc
        call    L213D                   ; Group (and maybe scan) logic
        jnc     L5BA5
        jmp     L623C                   ; Adv parsing ptr to next cmd and set 'Unable or Invalid Command' flag
L5B82:
        cpi     $02
        jnz     L5B90
        lda     $A558                   ; Channel number displayed on front panel (=A0 if none)
        lhld    $A57C                   ; Channel scanning lower bound
        jmp     L5B9E
L5B90:
        cpi     $01
        rnz
        lxi     h,$9900
        lda     $A558                   ; Channel number displayed on front panel (=A0 if none)
        cpi     $A0
        jz      L623C                   ; Adv parsing ptr to next cmd and set 'Unable or Invalid Command' flag
L5B9E:
        mov     b,a
        mvi     a,$01
        stc
        call    L28A3                   ; Increment/decrement channel logic.  Carry=1 means dec, B=present chan, HL=valid range of chans
L5BA5:
        call    L453D
        ret
;--------------------------------------------------------------------------------------------------
;       S4 Goto Normal State command
;
L5BA9:
        lda     $A679                   ; Status bits
        ani     $80                     ; skip ASCII command if in local control mode
        jnz     L623C                   ; Adv parsing ptr to next cmd and set 'Unable or Invalid Command' flag
        lda     $A682                   ; Status bits
        ani     $02
        jnz     L623C                   ; Adv parsing ptr to next cmd and set 'Unable or Invalid Command' flag
        sta     $A808
        sta     $ABEB                   ; in BITE mode if FF
        sta     $ABB5                   ; Front panel LEDs
        mvi     a,$01
        sta     $A67A                   ; Radio state bits
        call    L3FA7                   ; Clear remote 'programming channel' flag
        lda     $A682                   ; Status bits
        ani     $FE
        sta     $A682                   ; Status bits
        call    L16A2                   ; Start receive mode
        ret
;--------------------------------------------------------------------------------------------------
;       S10 Prepare For Channel Scan command
;
L5BD6:
        lda     $A679                   ; Status bits
        ani     $80                     ; skip ASCII command if in local control mode
        jnz     L623C                   ; Adv parsing ptr to next cmd and set 'Unable or Invalid Command' flag
        lda     $A682                   ; Status bits
        ani     $02
        jnz     L623C                   ; Adv parsing ptr to next cmd and set 'Unable or Invalid Command' flag
        sta     $A808
        sta     $ABEB                   ; in BITE mode if FF
        sta     $ABB5                   ; Front panel LEDs
        mvi     a,$02
        sta     $A67A                   ; Radio state bits
        call    L3FA7                   ; Clear remote 'programming channel' flag
        lda     $A682                   ; Status bits
        ani     $FE
        sta     $A682                   ; Status bits
        mvi     a,$0E
        sta     $ABCB
        mvi     a,$43
        sta     $A57B                   ; Channel or group scan.  43=channel, 47=group
        lda     $ABB4
        ani     $01
        ori     $28
        sta     $ABB4                   ; Front panel LEDs
        lxi     h,$ABEC                 ; Display update control see L06FD
        mvi     a,$01                   ; update now
        ora     m
        mov     m,a
        ret
;--------------------------------------------------------------------------------------------------
;       S11 Prepare for Group Scan command
;
L5C1B:
        lda     $A679                   ; Status bits
        ani     $80                     ; skip ASCII command if in local control mode
        jnz     L623C                   ; Adv parsing ptr to next cmd and set 'Unable or Invalid Command' flag
        lda     $A682                   ; Status bits
        ani     $02
        jnz     L623C                   ; Adv parsing ptr to next cmd and set 'Unable or Invalid Command' flag
        sta     $A808
        sta     $ABEB                   ; in BITE mode if FF
        sta     $ABB5                   ; Front panel LEDs
        mvi     a,$03
        sta     $A67A                   ; Radio state bits
        call    L3FA7                   ; Clear remote 'programming channel' flag
        lda     $A682                   ; Status bits
        ani     $FE
        sta     $A682                   ; Status bits
        mvi     a,$0E
        sta     $ABCB
        mvi     a,$47
        sta     $A57B                   ; Channel or group scan.  43=channel, 47=group
        lda     $ABB4
        ani     $01
        ori     $28
        sta     $ABB4                   ; Front panel LEDs
        lxi     h,$ABEC                 ; Display update control see L06FD
        mvi     a,$01                   ; update now
        ora     m
        mov     m,a
        ret
;--------------------------------------------------------------------------------------------------
; S3 Begin BITE command
;
L5C60:
        lda     $A679                   ; Status bits
        ani     $80                     ; skip ASCII command if in local control mode
        jnz     L623C                   ; Adv parsing ptr to next cmd and set 'Unable or Invalid Command' flag
        mvi     a,$FF
        sta     $AB8E                   ; set to FF to request BITE
        ret
;--------------------------------------------------------------------------------------------------
;       Start BITE
L5C6E:
        mvi     a,$04
        sta     $A67A                   ; Radio state bits
        xra     a
        sta     $A575                   ; Actively scanning flag ($FF means actively scanning)
        sta     $AB92                   ; Flag, scan stopped for received signal (=FF)
        cma
        sta     $ABEB                   ; in BITE mode if FF
        call    L3FA7                   ; Clear remote 'programming channel' flag
        lxi     h,$A559                 ; present receiver param block beginning
        shld    $A809
        mvi     a,$02
        sta     $A682                   ; Status bits
        mvi     b,$04
        call    L3AC4                   ; UART/FSK UART output port set bits B
        xra     a
        sta     $AB8E                   ; clear request to start BITE
        xra     a
        sta     $A67F
        call    L4968
        lda     $A682                   ; Status bits
        ori     $04
        ani     $FC
        sta     $A682                   ; Status bits
        ret
;--------------------------------------------------------------------------------------------------
;       Report complete status command (G) processing
;
L5CA7:
        call    L3FA7                   ; Clear remote 'programming channel' flag
        lxi     h,$A559                 ; present receiver param block beginning
        shld    $A809
        mvi     a,$FF
        sta     $AB67
        call    L656E
        call    L64C5                   ; Channel status report
        call    L6808                   ; RF Atten status report
        call    L686E                   ; Noise Blanker Status Report
        call    L684E                   ; Mute Status Report
        call    L64ED                   ; Scan Dwell report
        call    L64A4                   ; Channel scanning bounds report
        call    L682A                   ; Auto Stop Scan Threshold report
        ret
;--------------------------------------------------------------------------------------------------
;       Request specific status command (T) processing
;
L5CCE:
        call    L3FA7                   ; Clear remote 'programming channel' flag
        lxi     h,$A559                 ; present receiver param block beginning
        shld    $A809
        lhld    $AB4B                   ; command parsing pointer
        mov     c,m
        mvi     a,$5A
        cmp     c
        jnz     L5CEC
        inx     h
        mov     c,m
        shld    $AB4B                   ; command parsing pointer
        lxi     d,L5D36
        jmp     L5CEF
L5CEC:
        lxi     d,L5D0E
L5CEF:
        ldax    d
        inx     d
        ora     a
        jz      L5D0D
        cmp     c
        jnz     L5D08
        ldax    d
        mov     c,a
        inx     d
        ldax    d
        mov     b,a
        inx     h
        shld    $AB4B                   ; command parsing pointer
        lxi     h,L5CCE                 ; Request specific status routine
        push    h
        push    b
        ret
L5D08:
        inx     d
        inx     d
        jmp     L5CEF
L5D0D:
        ret

;                                       ; ***** the following:
L5D0E:  .db     'A'
        .DW     L6808           ; RF Atten report

        .db     'B'
        .DW     L6945           ; BFO report

        .db     'C'
        .DW     L64C5           ; Channel report

        .db     'D'
        .DW     L68D2           ; Mode report

        .db     'E'
        .DW     L682A           ; Auto Stop Scan Threshold report

        .db     'F'
        .DW     L68FE           ; Frequency report

        .db     'I'
        .DW     L6760           ; IF Filter Bandwidth report

        .db     'M'
        .DW     L688E           ; AGC report

        .db     'N'
        .DW     L686E           ; Noise Blanker report

        .db     'P'
        .DW     L684E           ; Mute (path) status

        .db     'R'
        .DW     L5D3A           ; FSK Center freq report

        .db     'U' 
        .DW     L64A4           ; Channel Scanning Bounds report

        .db     'Y' 
        .DW     L5D45           ; FSK shift report

        .db     $00
L5D36:  .db     'D'
        .DW     L64ED           ; Scan Dwell report

        .db     $00
;--------------------------------------------------------------------------------------------------
;       FSK Center freq report
;
L5D3A:
        lda     $A825                   ; FSK option installed flag. Zero if not installed
        ora     a
        jz      L623C                   ; Adv parsing ptr to next cmd and set 'Unable or Invalid Command' flag
        call    L698E                   ; FSK Center freq report
        ret
;--------------------------------------------------------------------------------------------------
;       FSK shift report
;
L5D45:
        lda     $A825                   ; FSK option installed flag. Zero if not installed
        ora     a
        jz      L623C                   ; Adv parsing ptr to next cmd and set 'Unable or Invalid Command' flag
        call    L69E1                   ; FSK Shift and Polarity report
        ret
;--------------------------------------------------------------------------------------------------
;       RF attenuation command (A) processing 
;
L5D50:
        lda     $A679                   ; Status bits
        ani     $80                     ; skip ASCII command if in local control mode
        jnz     L623C                   ; Adv parsing ptr to next cmd and set 'Unable or Invalid Command' flag
        call    L3FA7                   ; Clear remote 'programming channel' flag
        lxi     h,$A559                 ; present receiver param block beginning
        shld    $A809
        lda     $A67A                   ; Radio state bits
        cpi     $04
        jz      L623C                   ; Adv parsing ptr to next cmd and set 'Unable or Invalid Command' flag
        lhld    $AB4B                   ; command parsing pointer
        call    L6317                   ; Convert nbr string to # in DE, A=# digits, HL points to next
        shld    $AB4B                   ; command parsing pointer
        ora     a
        jz      L6247                   ; Adv parsing ptr to next cmd and set 'Syntax Error' flag
        mov     a,d
        ora     a
        jnz     L623C                   ; Adv parsing ptr to next cmd and set 'Unable or Invalid Command' flag
        mov     a,e
        cpi     $97
        jc      L5D83
        mvi     a,$96
L5D83:
        mvi     b,$00
        cpi     $2E
        jc      L5D90
        sui     $2D
        add     a
        mov     b,a
        mvi     a,$2D
L5D90:
        add     b
        cma
        sta     $A67B                   ; RF atten
        ret

;--------------------------------------------------------------------------------------------------
;       Start Scan at chan or grp command (K) processing
;                                
L5D96:
        mvi     d,$00
        jmp     L5D9D
;
;        S13 Resume Scan command
;
L5D9B:
        mvi     d,$FF
L5D9D:
        lda     $A679                   ; Status bits
        ani     $80                     ; skip ASCII command if in local control mode
        jnz     L623C                   ; Adv parsing ptr to next cmd and set 'Unable or Invalid Command' flag
        call    L3FA7                   ; Clear remote 'programming channel' flag
        lxi     h,$A559                 ; present receiver param block beginning
        shld    $A809
        lda     $A67A                   ; Radio state bits
        mov     c,a
        cpi     $01
        jz      L623C                   ; Adv parsing ptr to next cmd and set 'Unable or Invalid Command' flag
        cpi     $04
        jz      L623C                   ; Adv parsing ptr to next cmd and set 'Unable or Invalid Command' flag
        mov     a,d
        ora     a
        jnz     L5DF0
        lhld    $AB4B                   ; command parsing pointer
        call    L62E1                   ; ASCII at [HL] and [HL+1] converted to BCD in A, HL incr by 2
        shld    $AB4B                   ; command parsing pointer
        jc      L5DF0
        lxi     h,$AB51                 ; $AB51-8 BCD radio frequency
        mov     m,a
        mvi     a,$02
        cmp     c
        jz      L5E0E
        mvi     a,$03
        cmp     c
        jnz     L623C                   ; Adv parsing ptr to next cmd and set 'Unable or Invalid Command' flag
        mov     c,m
        mvi     a,$09
        cmp     c
        jc      L623C                   ; Adv parsing ptr to next cmd and set 'Unable or Invalid Command' flag
        call    L2109                   ; Utility setup code for group (called with group # in C)
        jc      L623C                   ; Adv parsing ptr to next cmd and set 'Unable or Invalid Command' flag
        lhld    $A667                   ; Pointer for member of group
        jmp     L5E0E
L5DF0:
        call    L22B1                   ; High level scan code
        mvi     a,$02
        cmp     c
        lxi     h,$A582                 ; Scan channel
        jz      L5E0E
        lhld    $A665                   ; Pointer for member of group
        push    h
        lda     $A579                   ; Holds group number
        mov     c,a
        call    L2109                   ; Utility setup code for group (called with group # in C)
        pop     h
        jc      L623C                   ; Adv parsing ptr to next cmd and set 'Unable or Invalid Command' flag
        shld    $A665                   ; Pointer for member of group
L5E0E:
        mov     a,m
        call    L281C                   ; Test A: C=1 if A>$99 or low 4 bits >9
        jnc     L5E19
        inx     h
        jmp     L5E0E
L5E19:
        mov     b,m
        call    L1D0F                   ; Set radio to BCD chan # in B
        jc      L623C                   ; Adv parsing ptr to next cmd and set 'Unable or Invalid Command' flag
        mov     a,b
        sta     $A582                   ; Scan channel
        call    L23DA                   ; Init & start scan
        lxi     h,$ABEC                 ; Display update control see L06FD
        mvi     a,$02                   ; dwell
        ora     m
        mov     m,a
        ret
;--------------------------------------------------------------------------------------------------
;       Goto Channel command (C) processing
;
L5E2F:
        lda     $A679                   ; Status bits
        ani     $80                     ; skip ASCII command if in local control mode
        jnz     L623C                   ; Adv parsing ptr to next cmd and set 'Unable or Invalid Command' flag
        call    L3FA7                   ; Clear remote 'programming channel' flag
        lxi     h,$A559                 ; present receiver param block beginning
        shld    $A809
        lda     $A67A                   ; Radio state bits
        cpi     $04
        jz      L623C                   ; Adv parsing ptr to next cmd and set 'Unable or Invalid Command' flag
        lhld    $AB4B                   ; command parsing pointer
        call    L62E1                   ; ASCII at [HL] and [HL+1] converted to BCD in A, HL incr by 2
        shld    $AB4B                   ; command parsing pointer
        jc      L6247                   ; Adv parsing ptr to next cmd and set 'Syntax Error' flag
        mov     b,a
        lda     $ABC4                   ; Channel storage for use in group programming
        mov     c,a
        lda     $A808
        ora     a
        jnz     L5E64
        call    L1D0F                   ; Set radio to BCD chan # in B
        ret
L5E64:
        cpi     $47
        jnz     L5E71
        mov     a,b
        call    L21AE                   ; Put channel A into spot with $EE in group C
        rnc
        jmp     L623C                   ; Adv parsing ptr to next cmd and set 'Unable or Invalid Command' flag
L5E71:
        cpi     $55
        rnz
        mov     a,b
        call    L21B7                   ; Replace channel A in group C with $EE
        rnc
        jmp     L623C                   ; Adv parsing ptr to next cmd and set 'Unable or Invalid Command' flag
;--------------------------------------------------------------------------------------------------
;       Report Channel (H) command processing
;
L5E7C:
        lhld    $AB4B                   ; command parsing pointer
        call    L62E1                   ; ASCII at [HL] and [HL+1] converted to BCD in A, HL incr by 2
        shld    $AB4B                   ; command parsing pointer
        jc      L6247                   ; Adv parsing ptr to next cmd and set 'Syntax Error' flag
        call    L655A
        ret
;--------------------------------------------------------------------------------------------------
;       AGC command (M) processing
;
L5E8C:
        lda     $A679
        ani     $80                     ; skip ASCII command if in local control mode
        jnz     L623C                   ; Adv parsing ptr to next cmd and set 'Unable or Invalid Command' flag
        call    L6293                   ; If actively scanning, if $A57E <> E, return with carry set
        jc      L623C                   ; Adv parsing ptr to next cmd and set 'Unable or Invalid Command' flag
        lda     $A67A                   ; Radio state bits
        cpi     $04
        jz      L623C                   ; Adv parsing ptr to next cmd and set 'Unable or Invalid Command' flag
        lhld    $AB4B                   ; command parsing pointer
        call    L6317                   ; Convert nbr string to # in DE, A=# digits, HL points to next
        shld    $AB4B                   ; command parsing pointer
        ora     a
        jz      L6247                   ; Adv parsing ptr to next cmd and set 'Syntax Error' flag
        mov     a,d
        ora     a
        jnz     L623C                   ; Adv parsing ptr to next cmd and set 'Unable or Invalid Command' flag
        dcr     e
        jc      L623C                   ; Adv parsing ptr to next cmd and set 'Unable or Invalid Command' flag
        mov     a,e
        cpi     $06
        jnc     L623C                   ; Adv parsing ptr to next cmd and set 'Unable or Invalid Command' flag
        mov     b,a
        mvi     c,$06
        call    L3F4E                   ; HL = $A809 + C ($A80F)
        mov     a,m
        ani     $0F
        cpi     $09
        jnz     L5EE5
        mov     a,b
        cpi     $05
        jnc     L623C                   ; Adv parsing ptr to next cmd and set 'Unable or Invalid Command' flag
        mov     l,a
        mvi     h,$00
        lxi     d,L5F00                 
        dad     d
        mov     a,m
        mvi     c,$04
        call    L547E
        jc      L623C                   ; Adv parsing ptr to next cmd and set 'Unable or Invalid Command' flag
        jmp     L5EF9
L5EE5:
        mov     l,b
        mvi     h,$00
        lxi     d,L5EFA
        dad     d
        mov     a,m
        mvi     c,$07
        call    L3F4E                   ; HL = $A809 + C ($A810)
        mov     m,a
        lxi     h,$ABF3
        call    L3F57                   ; Remote programming channel code
L5EF9:
        ret

;  AGC speed mappings, reported to radio
;
L5EFA:  .db      $01, $02, $00, $04       
        .db      $05, $03
L5F00:  .DB      $01, $02
        .db      $00, $03, $04

;--------------------------------------------------------------------------------------------------
;       Mode command (D) processing
;
L5F05:
        lda     $A679                   ; Status bits
        ani     $80                     ; skip ASCII command if in local control mode
        jnz     L623C                   ; Adv parsing ptr to next cmd and set 'Unable or Invalid Command' flag
        call    L6293                   ; If actively scanning, if $A57E <> E, return with carry set
        jc      L623C                   ; Adv parsing ptr to next cmd and set 'Unable or Invalid Command' flag
        lda     $A67A                   ; Radio state bits
        cpi     $04
        jz      L623C                   ; Adv parsing ptr to next cmd and set 'Unable or Invalid Command' flag
        lhld    $AB4B                   ; command parsing pointer
        call    L6317                   ; Convert nbr string to # in DE, A=# digits, HL points to next
        shld    $AB4B                   ; command parsing pointer
        ora     a
        jz      L6247                   ; Adv parsing ptr to next cmd and set 'Syntax Error' flag if arg missing
        mov     a,d
        ora     a
        jnz     L623C                   ; Adv parsing ptr to next cmd and set 'Unable or Invalid Command' flag if mode 0
        dcr     e
        jc      L623C                   ; Adv parsing ptr to next cmd and set 'Unable or Invalid Command' flag
        mov     a,e
        cpi     $09                     ; should be 0-8 here
        jnc     L623C                   ; Adv parsing ptr to next cmd and set 'Unable or Invalid Command' flag
        mov     l,a
        mvi     h,$00
        lxi     d,L5F59
        dad     d
        mov     b,m                     ; internal radio mode B from map
        mvi     c,$07
        call    L1A34                   ; Find next filter supporting mode, mode B, current filter C, returns with B
        mov     a,b
        ani     $F0
        cpi     $F0
        jz      L623C                   ; Adv parsing ptr to next cmd and set 'Unable or Invalid Command' flag (no filter)
        mvi     c,$06
        call    L3F4E                   ; HL = $A809 + C ($A80F)
        mov     m,b
        lxi     h,$ABF3
        call    L3F57                   ; Remote programming channel code
        ret

; mode mapping data
;
L5F59:  .db      $02, $08, $00, $00      ; AM, FM, CW, -
        .db      $05, $04, $03, $09      ; 2ISB, LSB, USB, FSK
        .db      $06                     ; 4ISB

;--------------------------------------------------------------------------------------------------
;       IF filter bandwidth (I) command processing
;
L5F62:
        mvi     b,$02
        mvi     c,$02
        lxi     d,$AB51                 ; $AB51-8 BCD radio frequency
        call    L6340                   ; ASCII verify number B digits before dec pt, C digits after.  A=0 if OK, $FF if bad
        ora     a
        jnz     L6247                   ; Adv parsing ptr to next cmd and set 'Syntax Error' flag
        lxi     h,$AB51                 ; $AB51-8 BCD radio frequency
        call    L6317                   ; Convert nbr string to # in DE, A=# digits, HL points to next
        xchg
        shld    $AB82
        mvi     a,$FF
        sta     $AB84
        ret
;--------------------------------------------------------------------------------------------------
;       Remote code dealing with BW filters
L5F80:
        lda     $A679                   ; Status bits
        ani     $80                     ; skip ASCII command if in local control mode
        jnz     L623C                   ; Adv parsing ptr to next cmd and set 'Unable or Invalid Command' flag
        call    L6293                   ; If actively scanning, if $A57E <> E, return with carry set
        jc      L623C                   ; Adv parsing ptr to next cmd and set 'Unable or Invalid Command' flag
        lda     $A67A                   ; Radio state bits
        cpi     $04
        jz      L623C                   ; Adv parsing ptr to next cmd and set 'Unable or Invalid Command' flag
        lxi     h,$AB72
        mvi     b,$10
        mvi     a,$00
L5F9D:
        mov     m,a
        inx     h
        dcr     b
        jnz     L5F9D                   ; clear 16 locations from $AB72
        mvi     c,$06
        call    L3F4E                   ; HL = $A809 + C ($A80F)
        mov     a,m
        ani     $0F
        mov     e,a
        mvi     d,$00
        lxi     h,L2A2F                 ; 02 00 04 00 00 00 00 00 08 10
        dad     d
        mov     c,m
        mvi     b,$00
        mvi     a,$01
L5FB7:
        push    psw
        mov     e,a
        mvi     d,$00
        lxi     h,$AC01                 ; installed filter modes info
        dad     d
        mov     a,m
        ana     c
        jz      L5FD8
        xchg
        dad     h
        xchg
        lxi     h,$AB72
        dad     d
        push    h
        lxi     h,$AC29
        dad     d
        pop     d
        mov     a,m
        stax    d
        inx     h
        inx     d
        mov     a,m
        stax    d
        inr     b
L5FD8:
        pop     psw
        inr     a
        cpi     $08
        jnz     L5FB7
        mov     a,b
        cpi     $02
        rc
        lhld    $AB82
        xchg
        lxi     b,$AB74
        mvi     a,$01
        sta     $AB8B
L5FEF:
        ldax    b
        mov     l,a
        inx     b
        ldax    b
        mov     h,a
        inx     b
        ora     l
        jnz     L6003
        lda     $AB8B
        inr     a
        sta     $AB8B
        jmp     L5FEF
L6003:
        lda     $AB8B
        sta     $AB89
        call    L60A4                   ; HL=f(HL,DE) and set A to 0, 1, or 2
        jz      L6043
        shld    $AB85
        sta     $AB8C
L6015:
        lda     $AB8B
        inr     a
        sta     $AB8B
        cpi     $08
        jz      L6049
        ldax    b
        mov     l,a
        inx     b
        ldax    b
        mov     h,a
        inx     b
        ora     l
        jz      L6015
        call    L60A4                   ; HL=f(HL,DE) and set A to 0, 1, or 2
        jz      L6043
        shld    $AB87
        sta     $AB8D
        lda     $AB8B
        sta     $AB8A
        call    L6062                   ; Compare AB85,AB86,AB89,AB8C to AB87,AB88,AB8A,AB8D and make 1st set=2nd set sometimes
        jmp     L6015
L6043:
        lda     $AB8B
        sta     $AB89
L6049:
        mvi     c,$06
        call    L3F4E                   ; HL = $A809 + C ($A80F)
        lda     $AB89
        rlc
        rlc
        rlc
        rlc
        mov     c,a
        mvi     a,$0F
        ana     m
        ora     c
        mov     m,a
        lxi     h,$ABF3
        call    L3F57                   ; Remote programming channel code
        ret
;--------------------------------------------------------------------------------------------------
;       Compare AB85,AB86,AB89,AB8C to AB87,AB88,AB8A,AB8D and make 1st set=2nd set sometimes
L6062:
        push    psw
        push    b
        push    h
        lda     $AB8D
        mov     c,a
        lda     $AB8C
        cmp     c
        jz      L6078
        cpi     $01
        jz      L60A0
        jmp     L608E
L6078:
        lda     $AB88
        mov     c,a
        lda     $AB86
        cmp     c
        jnz     L608B
        lda     $AB87
        mov     c,a
        lda     $AB85
        cmp     c
L608B:
        jc      L60A0
L608E:
        lhld    $AB87
        shld    $AB85
        lda     $AB8A
        sta     $AB89
        lda     $AB8D
        sta     $AB8C
L60A0:
        pop     h
        pop     b
        pop     psw
        ret
;--------------------------------------------------------------------------------------------------
;       HL=f(HL,DE) and set A to 0, 1, or 2
L60A4:
        mov     a,l
        cma
        mov     l,a
        mov     a,h
        cma
        mov     h,a
        inx     h
        dad     d
        mov     a,h
        ora     l
        jnz     L60B3
        xra     a
        ret
L60B3:
        mov     a,h
        ral
        jc      L60BC
        mvi     a,$02
        ora     a
        ret
L60BC:
        mov     a,h
        cma
        mov     h,a
        mov     a,l
        cma
        mov     l,a
        inx     h
        mvi     a,$01
        ora     a
        ret
;--------------------------------------------------------------------------------------------------
;       Frequency command (F) processing
;
L60C7:
        mvi     b,$02
        mvi     c,$06
        lxi     d,$AB51                 ; $AB51-8 BCD radio frequency
        call    L6340                   ; ASCII verify number B digits before dec pt, C digits after.  A=0 if OK, $FF if bad
        ora     a
        jnz     L6247                   ; Adv parsing ptr to next cmd and set 'Syntax Error' flag
        lda     $A679                   ; Status bits
        ani     $80                     ; skip ASCII command if in local control mode
        jnz     L623C                   ; Adv parsing ptr to next cmd and set 'Unable or Invalid Command' flag
        call    L6293                   ; If actively scanning, if $A57E <> E, return with carry set
        jc      L623C                   ; Adv parsing ptr to next cmd and set 'Unable or Invalid Command' flag
        lda     $A67A                   ; Radio state bits
        cpi     $04
        jz      L623C                   ; Adv parsing ptr to next cmd and set 'Unable or Invalid Command' flag
        lxi     h,$AB51                 ; $AB51-8 BCD radio frequency
        mov     a,m
        cpi     $33
        jnc     L623C                   ; Adv parsing ptr to next cmd and set 'Unable or Invalid Command' flag
        mvi     c,$03
L60F6:
        push    h
        push    b
        call    L62E1                   ; ASCII at [HL] and [HL+1] converted to BCD in A, HL incr by 2
        pop     b
        call    L3F4E                   ; HL = $A809 + C
        mov     m,a
        push    b
        lxi     h,$ABF2
        call    L3F57                   ; Remote programming channel code
        pop     b
        pop     h
        inx     h
        inx     h
        dcr     c
        jp      L60F6
        ret
;--------------------------------------------------------------------------------------------------
;       FSK Center freq command (R) processing
;
L6110:
        lda     $A679                   ; Status bits
        ani     $80                     ; skip ASCII command if in local control mode
        jnz     L623C                   ; Adv parsing ptr to next cmd and set 'Unable or Invalid Command' flag
        call    L6293                   ; If actively scanning, if $A57E <> E, return with carry set
        jc      L623C                   ; Adv parsing ptr to next cmd and set 'Unable or Invalid Command' flag
        lda     $A67A                   ; Radio state bits
        cpi     $04
        jz      L623C                   ; Adv parsing ptr to next cmd and set 'Unable or Invalid Command' flag
        lhld    $AB4B                   ; command parsing pointer
        mvi     c,$00
        mov     a,m
        cpi     $2B
        jz      L6138
        cpi     $2D
        jnz     L6139
        mvi     c,$80
L6138:
        inx     h
L6139:
        shld    $AB4B                   ; command parsing pointer
        push    b
        mvi     b,$01
        mvi     c,$03
        lxi     d,$AB51                 ; $AB51-8 BCD radio frequency
        call    L6340                   ; ASCII verify number B digits before dec pt, C digits after.  A=0 if OK, $FF if bad
        pop     b
        ora     a
        jnz     L6247                   ; Adv parsing ptr to next cmd and set 'Syntax Error' flag
        lda     $A825                   ; FSK option installed flag. Zero if not installed
        ora     a
        jz      L623C                   ; Adv parsing ptr to next cmd and set 'Unable or Invalid Command' flag
        lxi     h,$AB51                 ; $AB51-8 BCD radio frequency
        mov     a,m
        cpi     $34
        jnc     L623C                   ; Adv parsing ptr to next cmd and set 'Unable or Invalid Command' flag
        push    b
        mvi     c,$0A
        call    L3F4E                   ; HL = $A809 + C ($A813)
        lda     $AB51                   ; $AB51-8 BCD radio frequency
        mov     b,a
        lda     $AB52
        mov     c,a
        call    L630C                   ; A gets low nybble of B as top 4 bits, low nybble of C as low 4 bits
        pop     b
        ora     c
        mov     m,a
        dcx     h
        lda     $AB53
        mov     b,a
        lda     $AB54
        mov     c,a
        call    L630C                   ; A gets low nybble of B as top 4 bits, low nybble of C as low 4 bits
        mov     m,a
        lxi     h,$ABF1
        call    L3F57                   ; Remote programming channel code
        ret
;--------------------------------------------------------------------------------------------------
;       FSK shift and polarity command (Y) processing
;
L6184:
        lda     $A679                   ; Status bits
        ani     $80                     ; skip ASCII command if in local control mode
        jnz     L623C                   ; Adv parsing ptr to next cmd and set 'Unable or Invalid Command' flag
        call    L6293                   ; If actively scanning, if $A57E <> E, return with carry set
        jc      L623C                   ; Adv parsing ptr to next cmd and set 'Unable or Invalid Command' flag
        lda     $A67A                   ; Radio state bits
        cpi     $04
        jz      L623C                   ; Adv parsing ptr to next cmd and set 'Unable or Invalid Command' flag
        lhld    $AB4B                   ; command parsing pointer
        mvi     c,$00
        mov     a,m
        cpi     $2B
        jz      L61AC
        cpi     $2D
        jnz     L61AD
        mvi     c,$80
L61AC:
        inx     h
L61AD:
        call    L6317                   ; Convert nbr string to # in DE, A=# digits, HL points to next
        shld    $AB4B                   ; command parsing pointer
        ora     a
        jz      L6247                   ; Adv parsing ptr to next cmd and set 'Syntax Error' flag
        lda     $A825                   ; FSK option installed flag. Zero if not installed
        ora     a
        jz      L623C                   ; Adv parsing ptr to next cmd and set 'Unable or Invalid Command' flag
        mov     a,d
        ora     a
        jnz     L623C                   ; Adv parsing ptr to next cmd and set 'Unable or Invalid Command' flag
        mov     a,e
        cpi     $04
        jnc     L623C                   ; Adv parsing ptr to next cmd and set 'Unable or Invalid Command' flag
        ora     c
        mvi     c,$0B
        call    L3F4E                   ; HL = $A809 + C ($A814)
        mov     m,a
        lxi     h,$ABF3
        call    L3F57                   ; Remote programming channel code
        ret
;--------------------------------------------------------------------------------------------------
;       BFO command (B) processing
;
L61D7:
        lhld    $AB4B                   ; command parsing pointer
        mov     a,m
        mvi     c,$00
        cpi     $2B
        jz      L61E9
        cpi     $2D
        jnz     L61EA
        mvi     c,$F0
L61E9:
        inx     h
L61EA:
        shld    $AB4B                   ; command parsing pointer
        push    b
        mvi     b,$01
        mvi     c,$02
        lxi     d,$AB51                 ; $AB51-8 BCD radio frequency
        call    L6340                   ; ASCII verify number B digits before dec pt, C digits after.  A=0 if OK, $FF if bad
        pop     b
        ora     a
        jnz     L6247                   ; Adv parsing ptr to next cmd and set 'Syntax Error' flag
        lda     $A679                   ; Status bits
        ani     $80                     ; skip ASCII command if in local control mode
        jnz     L623C                   ; Adv parsing ptr to next cmd and set 'Unable or Invalid Command' flag
        call    L6293                   ; If actively scanning, if $A57E <> E, return with carry set
        jc      L623C                   ; Adv parsing ptr to next cmd and set 'Unable or Invalid Command' flag
        lda     $A67A                   ; Radio state bits
        cpi     $04
        jz      L623C                   ; Adv parsing ptr to next cmd and set 'Unable or Invalid Command' flag
        lxi     h,$AB51                 ; $AB51-8 BCD radio frequency
        mov     a,m
        inx     h
        push    h
        sui     $30
        ora     c
        mvi     c,$05
        call    L3F4E                   ; HL = $A809 + C ($A80E)
        mov     m,a
        lxi     h,$ABF1
        call    L3F57                   ; Remote programming channel code
        pop     h
        mov     b,m
        inx     h
        mov     c,m
        call    L630C                   ; A gets low nybble of B as top 4 bits, low nybble of C as low 4 bits
        mvi     c,$04
        call    L3F4E                   ; HL = $A809 + C ($A80D)  (Harris protocol channel)
        mov     m,a 
        lxi     h,$ABF1
        call    L3F57                   ; Remote programming channel code
        ret
;--------------------------------------------------------------------------------------------------
;       Adv parsing ptr to next cmd and set 'Unable or Invalid Command' flag
;
L623C:
        push    psw                     ;
        mvi     a,$FF
        sta     $AB4F                   ; command parsing flag - (Invalid command or unable to comply flag)
        call    L63DB                   ; Advance $AB4B pointer to next valid cmd or EOL (CR)
        pop     psw                     ;
        ret                             ;
;--------------------------------------------------------------------------------------------------
;       Adv parsing ptr to next cmd and set 'Syntax Error' flag
;
L6247:
        push    psw
        mvi     a,$FF
        sta     $AB50                   ; command parsing flag - (Syntax error flag)
        call    L63DB                   ; Advance $AB4B pointer to next valid cmd or EOL (CR)
        pop     psw
        ret
;--------------------------------------------------------------------------------------------------
;       Move incoming ASCII into second buffer
;
L6252:
        lda     $AA4B                   ; Number of CR's in input buffer
        ora     a
        rz                              ; return if no complete command strings in buffer
        lxi     b,$AA4C                 ; Secondary receive buffer area start
        lxi     d,$A847
L625D:
        lda     $A947
        mov     l,a
        mvi     h,$00
        inr     a
        cpi     $FF
        jnz     L626B
        mvi     a,$00
L626B:
        sta     $A947
        dad     d
        di                              ; Disable Interrupts
        lda     $A948                   ; Receive unread counter.  Hitting FF means overflow
        dcr     a
        sta     $A948                   ; Receive unread counter.  Hitting FF means overflow
        ei                              ; Enable interrupts
        mov     a,m
        call    L62A9                   ; Convert ASCII char A into upper case
        stax    b
        inx     b
        cpi     $0D
        jnz     L625D
        di                              ; Disable Interrupts
        lda     $AA4B                   ; Number of CR's in input buffer
        dcr     a
        sta     $AA4B
        ei                              ; Enable interrupts
        lxi     h,$AA4C                 ; Secondary receive buffer area start
        shld    $AB4B                   ; move command parsing pointer to secondary buffer area
        ret
;--------------------------------------------------------------------------------------------------
;       If actively scanning, if $A57E <> E, return with carry set
L6293:
        push    psw
        lda     $A575                   ; Actively scanning flag ($FF means actively scanning)
        cpi     $FF
        jnz     L62A6                   ; jump if not actively scanning
        lda     $A57E
        cmp     e
        jz      L62A6
        pop     psw
        stc
        ret
L62A6:
        pop     psw
        ora     a
        ret
;--------------------------------------------------------------------------------------------------
;       Convert ASCII char A into upper case
L62A9:
        cpi     $61
        jc      L62B5                   ; return if A < 61
        cpi     $7B
        jnc     L62B5                   ; return if A > 7A
        sui     $20
L62B5:
        ret
;--------------------------------------------------------------------------------------------------
;       Returns with carry clear if A is ASCII number char
;
L62B6:
        cpi     $30
        jc      L62C4
        cpi     $3A
        jnc     L62C4
        stc
        jmp     L62C6
L62C4:
        stc
        cmc
L62C6:
        ret

;--------------------------------------------------------------------------------------------------
; ASCII char in A, returns with cy set for letter; converts A to UC.
;
L62C7:
        cpi     $41
        jc      L62DF           ; jump if A less than $41
        cpi     $5B
        jc      L62DD           ; jump if A less than $5B
        cpi     $61
        jc      L62DF           ; jump if A less than $61
        cpi     $7B
        jnc     L62DF           ; jump if A greater than or equal to $7B
        ani     $DF
L62DD:
        stc
        ret
L62DF:
        ora     a
        ret
;--------------------------------------------------------------------------------------------------
; ASCII at [HL] and [HL+1] converted to BCD in A, HL incr by 2
;
L62E1:
        push    b
        mov     a,m
        cpi     $30
        jc      L6309
        cpi     $3A
        jnc     L6309
        mov     b,a             ; B gets validated ASCII number from [HL]
        inx     h
        mov     a,m
        cpi     $30
        jc      L62FF
        cpi     $3A
        jnc     L62FF
        inx     h
        mov     c,a             ; C gets validated ASCII number from [HL+1]
        jmp     L6302
L62FF:
        mov     c,b
        mvi     b,$30           ; if [HL+1] not valid, C gets B and B becomes '0'
L6302:
        call    L630C           ; A gets low nybble of B as top 4 bits, low nybble of C as low 4 bits
        ora     a
        jmp     L630A
L6309:
        stc
L630A:
        pop     b
        ret
;--------------------------------------------------------------------------------------------------
; A gets low nybble of B as top 4 bits, low nybble of C as low 4 bits
L630C:
        mov     a,b
        add     a
        add     a
        add     a
        add     a
        mov     b,a
        mov     a,c
        ani     $0F
        ora     b
        ret
;--------------------------------------------------------------------------------------------------
;       Convert nbr string to # in DE, A=# digits, HL points to next
;
L6317:
        push    b                       ;
        lxi     d,$0000
        mvi     b,$00
L631D:
        mov     a,m                     ; get next command string char
        sui     $30
        jc      L633D                   ; if <30 then set A=0 and exit
        cpi     $0A
        jnc     L633D                   ; if >3A then set A=0 and exit
        inr     b
        push    b       ;
        push    h       ;
         xchg                    ; HL <=> DE
          dad     h
          push    h
          dad     h
          dad     h
          pop     d
          dad     d
          mov     c,a
          mvi     b,$00
          dad     b
         xchg                    ; HL <=> DE
        pop     h       ;
        pop     b       ;
        inx     h       
        jmp     L631D
L633D:
        mov     a,b
        pop     b                       ;
        ret                             ;
;--------------------------------------------------------------------------------------------------
;       ASCII verify number B digits before dec pt, C digits after.  A=0 if OK, $FF if bad
L6340:
        mov     a,b
        add     c
        push    d
        pop     h
L6344:
        mvi     m,$30
        inx     h
        dcr     a
        jnz     L6344
        mvi     m,$0D
        lhld    $AB4B                   ; command parsing pointer
        call    L63C9                   ; returns with A=# of ASCII # chars from HL on and HL pointing to first non-#
        cmp     b
        jz      L635D
        jc      L635D
        jmp     L63C6
L635D:
        ora     a
        jnz     L637A
        mov     a,m
        cpi     $2E
        jnz     L63C6
        inx     h
        shld    $AB4B                   ; command parsing pointer
        mov     a,m
        call    L62B6                   ; Returns with carry clear if A is ASCII number char
        jnc     L63C6
        mov     l,b
        mvi     h,$00
        dad     d
        xchg
        jmp     L63A0
L637A:
        push    b
        mov     c,a
        mov     a,b
        sub     c
        mov     l,a
        mvi     h,$00
        dad     d
        pop     b
        xchg
        lhld    $AB4B                   ; command parsing pointer
L6387:
        mov     a,m
        call    L62B6                   ; Returns with carry clear if A is ASCII number char
        jnc     L6397
        stax    d
        inx     d
        inx     h
        shld    $AB4B                   ; command parsing pointer
        jmp     L6387
L6397:
        cpi     $2E
        jnz     L63C3
        inx     h
        shld    $AB4B                   ; command parsing pointer
L63A0:
        lhld    $AB4B                   ; command parsing pointer
        call    L63C9                   ; returns with A=# of ASCII # chars from HL on and HL pointing to first non-#
        lhld    $AB4B                   ; command parsing pointer
        cmp     c
        jz      L63B3
        jc      L63B3
        jmp     L63C6
L63B3:
        mov     a,m
        call    L62B6                   ; Returns with carry clear if A is ASCII number char
        jnc     L63C3
        stax    d
        inx     d
        inx     h
        shld    $AB4B                   ; command parsing pointer
        jmp     L63B3
L63C3:
        mvi     a,$00
        ret
L63C6:
        mvi     a,$FF
        ret
;--------------------------------------------------------------------------------------------------
;       returns with A=# of ASCII # chars from HL on and HL pointing to first non-#
;
L63C9:
        push    b
        mvi     b,$00
L63CC:
        mov     a,m
        call    L62B6                   ; Returns with carry clear if A is ASCII number char
        jnc     L63D8
        inr     b
        inx     h
        jmp     L63CC
L63D8:
        mov     a,b
        pop     b
        ret
;--------------------------------------------------------------------------------------------------
;       Advance $AB4B pointer to next valid cmd or EOL (CR)
;
L63DB:
        push    psw                     ;
        push    h                       ;
        lhld    $AB4B                   ; command parsing pointer
L63E0:
        mov     a,m                     
        cpi     $0D                     ; does $AB4B point to a $0D (ASCII return)?
        jz      L63F3                   ; exit if so
        call    L62C7                   ; ASCII char in A, returns with cy set for letter; converts A to UC.
        jc      L63F3                   ; exit if char was valid letter
        inx     h
        shld    $AB4B                   ; inc pointer at $AB4B & C.  Only exit on return or letter.
        jmp     L63E0
L63F3:
        pop     h                       ;
        pop     psw                     ;
        ret                             ;
;--------------------------------------------------------------------------------------------------
; Send status report and Carriage return
L63F6:
        mvi     a,$00
        sta     $AB67
        lda     $A846                   ; Radio addressed uniquely, return status reports (FF=report)
        ora     a
        rz                              ; exit without action if radio not addressed
        call    L6412                   ; CURRENT STATUS report - Appended to the end of all outgoing messages
        mvi     a,$0D                   ; CR
        call    L6A16                   ; Put ASCII char A in serial comm output queue
        lxi     h,$A949                 ; Serial comm transmit buffer
        shld    $AA48                   ; Serial comm transmit buffer pointer
        call    L3988
        ret
;--------------------------------------------------------------------------------------------------
; CURRENT STATUS report - Appended to the end of all outgoing messages
;
L6412:
        mvi     c,$00
        mvi     a,$53                   ; 'S'
        call    L6A16                   ; Put ASCII char A in serial comm output queue
        lda     $A679                   ; Status bits
        ani     $80
        jnz     L6425
        mvi     a,$01                   ; Bit 0 = Remote Control Mode (1 = remote, 0 = local)
        ora     c
        mov     c,a
L6425:
        lda     $AB4F                   ; command parsing flag - (Invalid command or unable to comply flag)
        ora     a
        jz      L6435
        mvi     a,$40                   ; Bit 6 = Invalid command or unable to comply
        ora     c
        mov     c,a
        mvi     a,$00
        sta     $AB4F                   ; command parsing flag - (Invalid command or unable to comply flag)
L6435:
        lda     $AB50                   ; command parsing flag - (Syntax error flag)
        ora     a
        jz      L6445
        mvi     a,$10                   ; Bit 4 = Syntax error
        ora     c
        mov     c,a
        mvi     a,$00
        sta     $AB50                   ; command parsing flag - (Syntax error flag)
L6445:
        lda     $AB4D                   ; Comm error flag (parity, etc)
        ora     a
        jz      L6455
        mvi     a,$08                   ; Bit 3 - Comm error (parity, etc)
        ora     c
        mov     c,a
        mvi     a,$00
        sta     $AB4D                   ; Comm error flag (parity, etc)
L6455:
        lda     $AB4E                   ; FF = receive buffer overflow
        ora     a
        jz      L6465
        mvi     a,$20                   ; Bit 5 - Serial buffer overflow
        ora     c
        mov     c,a
        mvi     a,$00                   ; reset receive buffer overflow flag
        sta     $AB4E                   ; FF = receive buffer overflow
L6465:
        lda     $ABEF                   ; PLL unlocked error flag
        ora     a
        jz      L6470
        mvi     a,$02                   ; Bit 1 - PLL unlock error
        ora     c
        mov     c,a
L6470:
        mov     a,c
        call    L6A34                   ; Send value of A out as ASCII '000' to '255'
        ret
;--------------------------------------------------------------------------------------------------
;       Report channels programmed into group specified in A
L6475:
        mov     c,a
        lda     $A846                   ; Radio addressed uniquely, return status reports (FF=report)
        ora     a
        rz                              ; exit without action if radio not addressed
        mvi     a,$FF
        sta     $AB67
        mvi     a,$58                   ; 'X'  (Report Scan Group)
        call    L6A16                   ; Put ASCII char 'X' in serial comm output queue
        mov     a,c
        call    L6A61                   ; Convert H/L bytes of A into ASCII and send out serial port
        call    L20E9                   ; Calc address of beginning of group C memory area (returned in HL)
        mvi     d,$14
L648E:
        mov     a,m                     ; get chans from memory and output
        cpi     $9A
        jnc     L649E
        push    psw
        mvi     a,$2C                   ; ','
        call    L6A16                   ; Put ASCII char ',' in serial comm output queue
        pop     psw
        call    L6A61                   ; Convert H/L bytes of A into ASCII and send out serial port
L649E:
        inx     h
        dcr     d
        jnz     L648E
        ret
;--------------------------------------------------------------------------------------------------
;       Channel scanning bounds report
;
L64A4:
        lda     $A846                   ; Radio addressed uniquely, return status reports (FF=report)
        ora     a
        rz                              ; exit without action if radio not addressed
        mvi     a,$FF
        sta     $AB67
        mvi     a,$55                   ; 'U'  (Channel Scanning Bounds)
        call    L6A16                   ; Put ASCII char 'U' in serial comm output queue
        lda     $A57C                   ; Channel scanning lower bound
        call    L6A61                   ; Convert H/L bytes of A into ASCII and send out serial port
        mvi     a,$2C                   ; ','
        call    L6A16                   ; Put ASCII char ',' in serial comm output queue
        lda     $A57D                   ; Channel scanning upper bound
        call    L6A61                   ; Convert H/L bytes of A into ASCII and send out serial port
        ret
;--------------------------------------------------------------------------------------------------
;       Channel status report (which channel displayed on front panel)
;
L64C5:
        lda     $A846                   ; Radio addressed uniquely, return status reports (FF=report)
        ora     a
        rz                              ; exit without action if radio not addressed
        mvi     a,$FF
        sta     $AB67
        mvi     a,$43                   ; 'C'  (Channel)
        call    L6A16                   ; Put ASCII char 'C' in serial comm output queue
        lda     $A558                   ; Channel number displayed on front panel (=A0 if none)
        cpi     $A0
        jc      L64E9
        mvi     a,$2D                   ; '-'
        call    L6A16                   ; Put ASCII char '-' in serial comm output queue
        mvi     a,$31                   ; '1'
        call    L6A16                   ; Put ASCII char '1' in serial comm output queue ('C-1' if no channel displayed)
        jmp     L64EC
L64E9:
        call    L6A61                   ; Convert H/L bytes of A into ASCII and send out serial port
L64EC:
        ret
;--------------------------------------------------------------------------------------------------
;       Scan Dwell report
;
L64ED:
        lda     $A846                   ; Radio addressed uniquely, return status reports (FF=report)
        ora     a
        rz                              ; exit without action if radio not addressed
        mvi     a,$FF
        sta     $AB67
        mvi     a,$5A                   ; 'Z'
        call    L6A16                   ; Put ASCII char 'Z' in serial comm output queue
        mvi     a,$44                   ; 'D'  (ZD Scan Dwell)
        call    L6A16                   ; Put ASCII char 'D' in serial comm output queue
        lda     $A580                   ; Scan Dwell pointer; $0B means external.
        cpi     $0B
        jnz     L6516
        mvi     a,$2D                   ; '-'
        call    L6A16                   ; Put ASCII char A in serial comm output queue
        mvi     a,$31                   ; '1'
        call    L6A16                   ; Put ASCII char A in serial comm output queue
        jmp     L6538
L6516:
        mov     l,a
        mvi     h,$00
        push    h
        dad     h
        pop     d
        dad     d
        lxi     d,L6539
        dad     d
        lxi     d,$AB51                 ; $AB51-8 BCD radio frequency
        mvi     b,$03
L6526:
        mov     a,m
        stax    d
        inx     h
        inx     d
        dcr     b
        jnz     L6526
        mvi     b,$02
        mvi     c,$01
        lxi     h,$AB51                 ; $AB51-8 BCD radio frequency
        call    L6AC2                   ; Place ASCII # digits from HL into output queue, B before DP, C after DP.
L6538:
        ret

;
L6539:  .db      "001"
        .db      "002"
        .db      "004"
        .db      "005"
        .db      "008"
        .db      "010"
        .db      "020"
        .db      "040"
        .db      "050"
        .db      "080"
        .db      "100"

;--------------------------------------------------------------------------------------------------
;       Report channel (H) processing
L655A:
        mov     b,a
        mvi     a,$48           ; 'H'  (Report Channel)
        call    L6A16           ; Put ASCII char 'H' in serial comm output queue
        mov     a,b
        call    L6A61           ; Convert H/L bytes of A into ASCII and send out serial port (channel #)
        call    L1CBF           ; Get channel memory RAM addr in HL given BCD channel # in B
        shld    $A809           ; set RAM pointer for channel
        call    L656E
        ret
;--------------------------------------------------------------------------------------------------
;       reports for 655A
L656E:
        call    L68FE   ; Frequency report for RAM channel data $A809 pointer
        call    L68D2   ; Mode report for RAM channel data $A809 pointer
        call    L688E   ; AGC report for RAM channel data $A809 pointer
        call    L6760   ; IF Filter Bandwidth report for RAM channel data $A809 pointer
        call    L6945   ; BFO report for RAM channel data $A809 pointer
        call    L698E   ; FSK Center freq report for RAM channel data $A809 pointer
        call    L69E1   ; FSK Shift and Polarity report for RAM channel data $A809 pointer
        ret
;--------------------------------------------------------------------------------------------------
;       S17 Report Radio State command
;
L6584:
        lda     $A846                   ; Radio addressed uniquely, return status reports (FF=report)
        ora     a
        rz                              ; exit without action if radio not addressed
        mvi     a,$11
        call    L6743                   ; Send ASCII '#17['
        lda     $A679                   ; Status bits
        xri     $80
        ani     $80
        mov     c,a                     ; bit 7: 1=remote control, 0=local control
        lda     $A67A                   ; Radio state bits
        cpi     $04
        jz      L65DB
        lda     $A558                   ; Channel number displayed on front panel (=A0 if none)
        cpi     $A0
        jnc     L65AA
        mvi     a,$01
        ora     c
        mov     c,a
L65AA:
        lda     $A67A                   ; Radio state bits
        cpi     $01
        jz      L65EB
        mvi     a,$10
        ora     c
        mov     c,a
        lda     $A575                   ; Actively scanning flag ($FF means actively scanning)
        ora     a
        jz      L65C8
        lda     $AB92                   ; Flag, scan stopped for received signal (=FF)
        ora     a
        jz      L65CC
        mvi     a,$08
        ora     c
        mov     c,a
L65C8:
        mvi     a,$04
        ora     c
        mov     c,a
L65CC:
        lda     $A67A                   ; Radio state bits
        cpi     $02
        jz      L65EB
        mvi     a,$02
        ora     c
        mov     c,a
        jmp     L65EB
L65DB:
        mvi     a,$20
        ora     c
        mov     c,a
        lda     $A682                   ; Status bits
        ani     $02
        jnz     L65EB
        mvi     a,$01
        ora     c
        mov     c,a
L65EB:
        mov     a,c
        call    L6A34                   ; Send value of A out as ASCII '000' to '255'
        call    L6758                   ; Send ASCII ']'
        ret
;--------------------------------------------------------------------------------------------------
;       S18 Report Programmable Options command (for FSK only)
;
L65F3:
        lda     $A846                   ; Radio addressed uniquely, return status reports (FF=report)
        ora     a
        rz                              ; exit without action if radio not addressed
        mvi     a,$12
        call    L6743                   ; Send ASCII '#18['
        lxi     d,$0000
        mvi     c,$00
L6602:
        lxi     h,$A831                 ; FSK option flag
        dad     d
        mov     a,m                     ; get A from first mem loc
        ora     a
        jz      L6628                   ; try next if 0
        mov     a,c
        ora     a
        jz      L6615                   ; don't send comma if first data out
        mvi     a,$2C                   ; ','
        call    L6A16                   ; send ',' 
L6615:
        mvi     c,$FF
        mov     a,e
        call    L6A34                   ; Send option number out
        mvi     a,$2C                   ; ','
        call    L6A16                   ; send ',' 
        lxi     h,$A82B                 ; FSK option values
        dad     d
        mov     a,m
        call    L6A34                   ; Send option value out
L6628:
        inr     e
        mov     a,e
        cpi     $05
        jnz     L6602
        call    L6758                   ; Send ASCII ']'
        ret
;--------------------------------------------------------------------------------------------------
;       S19 Report AGC and Audio Levels command
;
L6633:
        lda     $A846                   ; Radio addressed uniquely, return status reports (FF=report)
        ora     a
        rz                              ; exit without action if radio not addressed
        mvi     a,$13
        call    L6743                   ; Send ASCII '#a[' where a is A
        mvi     c,$00
        lda     $A551                   ; mode & IF filter, new commanded rcv params
        ani     $0F
        cpi     $05
        jnz     L664E
        mvi     c,$FF
        jmp     L665A
L664E:
        cpi     $04
        jnz     L665A
        lda     $ABC5                   ; 2ISB option installed flag (0=not installed, FF=installed)
        ora     a
        jnz     L6675
L665A:
        lda     $A839                   ; 2nd IF AGC reading
        call    L6A34                   ; Send value of A out as ASCII '000' to '255'
        mvi     a,$2C                   ; ','
        call    L6A16                   ; Put ASCII char A in serial comm output queue
        lda     $A83B                   ; Line Audio reading
        call    L6A34                   ; Send value of A out as ASCII '000' to '255'
        mov     a,c
        ora     a
        jz      L6686
        mvi     a,$2C                   ; ','
        call    L6A16                   ; Put ASCII char A in serial comm output queue
L6675:
        lda     $A83A                   ; AGC reading
        call    L6A34                   ; Send value of A out as ASCII '000' to '255'
        mvi     a,$2C                   ; ','
        call    L6A16                   ; Put ASCII char A in serial comm output queue
        lda     $A83C                   ; ISB Audio reading
        call    L6A34                   ; Send value of A out as ASCII '000' to '255'
L6686:
        call    L6758                   ; Send ASCII ']'
        ret
;--------------------------------------------------------------------------------------------------
;       S6 Report BITE Results command
;
L668A:
        lda     $A846                   ; Radio addressed uniquely, return status reports (FF=report)
        ora     a
        rz                              ; exit without action if radio not addressed
        mvi     a,$06
        call    L6743                   ; Send ASCII '#6['
        lhld    $ABC9                   ; BITE fault code
        mov     a,h
        ora     l
        mvi     a,$00
        jz      L66A0
        mvi     a,$01
L66A0:
        call    L6A34                   ; Send value of A out as ASCII '000' to '255'
        mvi     a,$2C                   ; ','
        call    L6A16                   ; Put ASCII char ',' in serial comm output queue
        lda     $ABCA                   ; BITE fault subassembly
        call    L6A61                   ; Convert H/L bytes of A into ASCII and send out serial port
        mvi     a,$2C                   ; ','
        call    L6A16                   ; Put ASCII char ',' in serial comm output queue
        lda     $ABC9                   ; BITE fault code
        call    L6A61                   ; Convert H/L bytes of A into ASCII and send out serial port
        call    L6758                   ; Send ASCII ']'
        ret
;--------------------------------------------------------------------------------------------------
;       S16 Report Who You Are command
;
L66BD:
        lda     $A846                   ; Radio addressed uniquely, return status reports (FF=report)
        ora     a
        rz                              ; exit without action if radio not addressed
        mvi     a,$10
        call    L6743                   ; Send ASCII '#a[' where a is A
        mvi     c,$10
        lda     $ABC5                   ; 2ISB option installed flag (0=not installed, FF=installed)
        ora     a
        jz      L66D4
        mvi     a,$01
        ora     c
        mov     c,a
L66D4:
        lda     $A825                   ; FSK option installed flag. Zero if not installed
        ora     a
        jz      L66DF
        mvi     a,$80
        ora     c
        mov     c,a
L66DF:
        mov     a,c
        call    L6A34                   ; Send value of A out as ASCII '000' to '255'
        call    L6758                   ; Send ASCII ']'
        ret
;--------------------------------------------------------------------------------------------------
;       S5 Report IF Filter Config command
;
L66E7:
        lda     $A846                   ; Radio addressed uniquely, return status reports (FF=report)
        ora     a
        rz                              ; exit without action if radio not addressed
        mvi     a,$05
        call    L6743                   ; Send ASCII '#5['
        mvi     a,$00
        call    L6781                   ; Filter number, low 4 bits of A, BW ASCII out serial port
        mvi     a,$2C                   ; ','
        call    L6A16                   ; Put ASCII char ',' in serial comm output queue
        mvi     a,$36                   ; '6'
        call    L6A16                   ; Put ASCII char '6' in serial comm output queue
        mvi     a,$01
L6702:
        push    psw
        mvi     a,$2F                   ; '/'
        call    L6A16                   ; Put ASCII char '/' in serial comm output queue
        pop     psw
        push    psw
        call    L6781                   ; Filter number, low 4 bits of A, BW ASCII out serial port
        jz      L6733                   ; try next filter if this one not installed
        pop     psw
        push    psw
        mov     c,a
        mvi     b,$00
        lxi     h,$AC01
        dad     b
        mov     c,m                     ; C has 3rd filter description byte
        lxi     d,L673E
        mvi     b,$05
L671F:
        mov     a,c
        rrc
        mov     c,a
        jnc     L672E
        mvi     a,$2C                   ; ','
        call    L6A16                   ; Put ASCII char A in serial comm output queue
        ldax    d
        call    L6A16                   ; Put ASCII char A in serial comm output queue
L672E:
        inx     d
        dcr     b
        jnz     L671F
L6733:
        pop     psw
        inr     a                       ; next filter
        cpi     $08
        jnz     L6702                   ; loop if all 8 not done yet
        call    L6758                   ; Send ASCII ']'
        ret


L673E:  .db      "73128"

;--------------------------------------------------------------------------------------------------
; Send ASCII '#a[' where a is A
L6743:
        push    psw                     ; save A
        mvi     a,$FF
        sta     $AB67
        mvi     a,$23                   ; '#'
        call    L6A16                   ; Put ASCII char '#' in serial comm output queue
        pop     psw                     ; recall A
        call    L6A34                   ; Send value of A out as ASCII '000' to '255'
        mvi     a,$5B                   ; '['
        call    L6A16                   ; Put ASCII char '[' in serial comm output queue
        ret
;--------------------------------------------------------------------------------------------------
; Send ASCII ']'
L6758:
        push    psw
        mvi     a,$5D                   ; ']'
        call    L6A16                   ; Put ASCII char A in serial comm output queue
        pop     psw
        ret
;--------------------------------------------------------------------------------------------------
;       IF Filter Bandwidth report
L6760:
        lda     $A846                   ; Radio addressed uniquely, return status reports (FF=report)
        ora     a
        rz                              ; exit without action if radio not addressed
        mvi     a,$FF
        sta     $AB67
        mvi     a,$49                   ; 'I'  (IF Filter Bandwidth)
        call    L6A16                   ; Put ASCII char 'I' in serial comm output queue
        lhld    $A809
        lxi     d,$0006
        dad     d
        mov     a,m
        rar
        rar
        rar
        rar
        ani     $0F
        call    L6781                   ; Filter number, low 4 bits of A, BW ASCII out serial port
        ret
;--------------------------------------------------------------------------------------------------
;       Filter number, low 4 bits of A, BW ASCII out serial port
L6781:
        mov     c,a
        lda     $A846                   ; Radio addressed uniquely, return status reports (FF=report)
        ora     a
        rz                              ; exit without action if radio not addressed
        mvi     a,$FF
        sta     $AB67
        mov     l,c             
        mvi     h,$00           ; HL gets filter code nybble
        dad     h               ; mult by 2
        lxi     d,$AC29
        dad     d               ; add to 'AC29', gets loc of 1st and 2nd filter param bytes (hex bw in 10's)
        mov     e,m
        inx     h
        mov     d,m             ; DE has filt bw
        xchg                    ; now in HL
        mov     a,l
        ora     h
        jz      L6807           ; exit if zero
        mvi     a,$30
        sta     $AB51           ; $AB51 used for 10 kHz digit, put '0' there
        lxi     d,$FC18
L67A5:
        push    h
        pop     b               ; BC has filt bw
        dad     d               ; add 'FC18' to filt bw
        mov     a,h
        ani     $80             ; 10 or greater kHz bw = 0
        jnz     L67B8
        lda     $AB51
        inr     a
        sta     $AB51           ; increment 10 kHz digit, count up until 10's kHz digit correct
        jmp     L67A5           ;   by subtracting 1000 until bw is under 1000 (remember, count by 10's)
L67B8:
        push    b
        pop     h               ; HL has filt bw
        mvi     a,$30
        sta     $AB52           ; 1 kHz digit
        lxi     d,$FF9C
L67C2:
        push    h
        pop     b
        dad     d
        mov     a,h
        ani     $80
        jnz     L67D5
        lda     $AB52
        inr     a
        sta     $AB52           ; generate 1's kHz digit in a sililar way
        jmp     L67C2
L67D5:
        push    b
        pop     h
        mvi     a,$30
        sta     $AB53
        lxi     d,$FFF6
L67DF:
        push    h
        pop     b
        dad     d
        mov     a,h
        ani     $80
        jnz     L67F2
        lda     $AB53
        inr     a
        sta     $AB53           ; generate 100's digit in a sililar way
        jmp     L67DF
L67F2:
        push    b
        pop     h
        mov     a,l
        adi     $30
        sta     $AB54           ; 10's digit is always a zero
        lxi     h,$AB51         ; $AB51-4 BCD BFO frequency
        mvi     b,$02
        mvi     c,$02
        call    L6AC2           ; Place ASCII # digits from HL into output queue, B before DP, C after DP.
        mvi     a,$FF
        ora     a
L6807:
        ret
;--------------------------------------------------------------------------------------------------
;       RF Atten status report
L6808:
        lda     $A846                   ; Radio addressed uniquely, return status reports (FF=report)
        ora     a
        rz                              ; exit without action if radio not addressed
        mvi     a,$FF
        sta     $AB67
        mvi     a,$41                   ; 'A'  (RF Attenuation)
        call    L6A16                   ; Put ASCII char 'A' in serial comm output queue
        lda     $A67B                   ; RF atten
        cma
        cpi     $2E
        jc      L6826
        sui     $2D
        ora     a
        rar
        adi     $2D
L6826:
        call    L6A34                   ; Send value of A out as ASCII '000' to '255'
        ret
;--------------------------------------------------------------------------------------------------
;       Auto Stop Scan Threshold report
L682A:
        lda     $A846                   ; Radio addressed uniquely, return status reports (FF=report)
        ora     a
        rz                              ; exit without action if radio not addressed
        mvi     a,$FF
        sta     $AB67
        mvi     a,$45                   ; 'E'  (Auto Stop Scan Threshold)
        call    L6A16                   ; Put ASCII char A in serial comm output queue
        lda     $A679                   ; Status bits
        ani     $80
        jnz     L6847
        lda     $AB91                   ; Auto Stop Scan Threshold (FF=off)
        jmp     L684A
L6847:
        lda     $AB90                   ; Auto Stop Scan Threshold (FF=off)
L684A:
        call    L6A34                   ; Send value of A out as ASCII '000' to '255'
        ret
;--------------------------------------------------------------------------------------------------
;       Mute Status Report
L684E:
        lda     $A846                   ; Radio addressed uniquely, return status reports (FF=report)
        ora     a
        rz                              ; exit without action if radio not addressed
        mvi     a,$FF
        sta     $AB67
        mvi     a,$50                   ; 'P'  (Input path mute Status)
        call    L6A16                   ; Put ASCII char A in serial comm output queue
        mvi     c,$00
        lda     $A67C                   ; NB/mute status
        ani     $01
        jz      L6869
        mvi     c,$01
L6869:
        mov     a,c
        call    L6A34                   ; Send value of A out as ASCII '000' to '255'
        ret
;--------------------------------------------------------------------------------------------------
;       Noise Blanker Status Report
L686E:
        lda     $A846                   ; Radio addressed uniquely, return status reports (FF=report)
        ora     a
        rz                              ; exit without action if radio not addressed
        mvi     a,$FF
        sta     $AB67
        mvi     a,$4E                   ; 'N'  (Noise Blanker)
        call    L6A16                   ; Put ASCII char 'N' in serial comm output queue
        mvi     c,$00
        lda     $A67C                   ; NB/mute status
        ani     $08
        jz      L6889
        mvi     c,$01
L6889:
        mov     a,c
        call    L6A34                   ; Send value of A out as ASCII '000' to '255'
        ret
;--------------------------------------------------------------------------------------------------
;       AGC report
;
L688E:
        lda     $A846                   ; Radio addressed uniquely, return status reports (FF=report)
        ora     a
        rz                              ; exit without action if radio not addressed
        mvi     a,$FF
        sta     $AB67
        mvi     a,$4D                   ; 'M'  (AGC)
        call    L6A16                   ; Put ASCII char 'M' in serial comm output queue
        mvi     c,$06
        call    L3F4E                   ; HL = $A809 + C ($A80F)
        mov     a,m
        ani     $0F
        cpi     $09
        jnz     L68B0                   ; jump if mode not FSK
        call    L5506                   ; Get into A from $55B0 lookup table the byte offset by val of $A82F
        jmp     L68B8
L68B0:
        lhld    $A809
        lxi     d,$0007
        dad     d
        mov     a,m
L68B8:
        cpi     $07
        jnz     L68BF
        mvi     a,$04                   ; if AGC speed is 7, make it 4
L68BF:
        mvi     b,$01
        lxi     h,L5EFA
L68C4:
        cmp     m
        jz      L68CD
        inx     h
        inr     b
        jmp     L68C4
L68CD:
        mov     a,b
        call    L6A34                   ; Send value of A out as ASCII '000' to '255'
        ret
;--------------------------------------------------------------------------------------------------
;       Mode report
;
L68D2:
        lda     $A846                   ; Radio addressed uniquely, return status reports (FF=report)
        ora     a
        rz                              ; exit without action if radio not addressed
        mvi     a,$FF
        sta     $AB67
        mvi     a,$44                   ; 'D'  (Mode)
        call    L6A16                   ; Put ASCII char 'D' in serial comm output queue
        lhld    $A809
        lxi     d,$0006
        dad     d
        mov     a,m
        ani     $0F                     ; mode is now in A
        mvi     b,$01
        lxi     h,L5F59
L68F0:
        cmp     m                       ; lookup radio internal mode number and convert using lookup table at $5F59
        jz      L68F9                   ; to find reportable mode number.  See description at RAM map.
        inx     h
        inr     b
        jmp     L68F0
L68F9:
        mov     a,b
        call    L6A34                   ; Send value of A out as ASCII '000' to '255'
        ret
;--------------------------------------------------------------------------------------------------
;       Frequency report, sends out freq of RAM channel data pointed to by $A809
;
L68FE:
        lda     $A846                   ; Radio addressed uniquely, return status reports (FF=report)
        ora     a
        rz                              ; exit without action if radio not addressed
        mvi     a,$FF
        sta     $AB67
        mvi     a,$46                   ; 'F'  (Frequency)
        call    L6A16                   ; Put ASCII char 'F' in serial comm output queue
        lhld    $A809
        lxi     d,$0003
        dad     d
        xchg
        lxi     h,$AB51                 ; where to store BCD radio frequency
        ldax    d
        call    L6A84                   ; Convert H/L nybbles of A to ASCII # chars in B/C
        mov     m,b
        inx     h
        mov     m,c
        inx     h
        dcx     d
        ldax    d
        call    L6A84                   ; Convert H/L nybbles of A to ASCII # chars in B/C
        mov     m,b
        inx     h
        mov     m,c
        inx     h
        dcx     d
        ldax    d
        call    L6A84                   ; Convert H/L nybbles of A to ASCII # chars in B/C
        mov     m,b
        inx     h
        mov     m,c
        inx     h
        dcx     d
        ldax    d
        call    L6A84                   ; Convert H/L nybbles of A to ASCII # chars in B/C
        mov     m,b
        inx     h
        mov     m,c
        lxi     h,$AB51                 ; $AB51-8 now has BCD radio frequency
        mvi     b,$02
        mvi     c,$06
        call    L6AC2                   ; Place ASCII # digits from HL into output queue, B before DP, C after DP.
        ret
;--------------------------------------------------------------------------------------------------
;       BFO report
;
L6945:
        lda     $A846                   ; Radio addressed uniquely, return status reports (FF=report)
        ora     a
        rz                              ; exit without action if radio not addressed
        mvi     a,$FF
        sta     $AB67
        mvi     a,$42                   ; 'B'  (BFO)
        call    L6A16                   ; Put ASCII char 'B' in serial comm output queue
L6954:
        lhld    $A809
        lxi     d,$0005
        dad     d
        push    h
        mov     a,m
        mov     c,a                     ; A and C have the BFO freq
        ani     $F0
        jnz     L6968                   ; send a '-' if any of the top 4 bits are set, else send a '+'
        mvi     a,$2B                   ; '+'
        jmp     L696A
L6968:
        mvi     a,$2D                   ; '-'
L696A:
        call    L6A16                   ; Put ASCII char A in serial comm output queue
        mov     a,c
        ani     $0F
        adi     $30
        sta     $AB51                   ; $AB51 gets BFO kHz digit
        pop     h
        dcx     h
        mov     a,m
        call    L6A84                   ; Convert H/L nybbles of A to ASCII # chars in B/C
        mov     a,b
        sta     $AB52                   ; $AB52 gets BFO 100 Hz digit
        mov     a,c
        sta     $AB53                   ; $AB53 gets BFO 10 Hz digit
        lxi     h,$AB51
        mvi     b,$01
        mvi     c,$02
        call    L6AC2                   ; Place ASCII # digits from HL into output queue, B before DP, C after DP.
        ret
;--------------------------------------------------------------------------------------------------
;       FSK Center freq report
;
L698E:
        lda     $A825                   ; FSK option installed flag. Zero if not installed
        ora     a
        rz                              ; exit without action if $A825 is zero
        lda     $A846                   ; Radio addressed uniquely, return status reports (FF=report)
        ora     a
        rz                              ; exit without action if radio not addressed
        mvi     a,$FF
        sta     $AB67
        mvi     a,$52                   ; 'R'  (FSK Center Frequency)
        call    L6A16                   ; Put ASCII char 'R' in serial comm output queue
        lhld    $A809
        lxi     d,$0009
        dad     d
        mov     e,m
        inx     h
        mov     d,m
        mov     a,d
        ani     $80
        jnz     L69B7
        mvi     a,$2B                   ; '+'
        jmp     L69B9
L69B7:
        mvi     a,$2D                   ; '-'
L69B9:
        call    L6A16                   ; Put ASCII char A in serial comm output queue
        mov     a,d
        ani     $3F
        call    L6A84                   ; Convert H/L nybbles of A to ASCII # chars in B/C
        mov     a,b
        sta     $AB51                   ; $AB51 FSK 1 kHz digit
        mov     a,c
        sta     $AB52                   ; $AB52 FSK 100 Hz digit
        mov     a,e
        call    L6A84                   ; Convert H/L nybbles of A to ASCII # chars in B/C
        mov     a,b
        sta     $AB53                   ; $AB53 FSK 10 Hz digit
        mov     a,c
        sta     $AB54                   ; $AB54 FSK 1 Hz digit
        lxi     h,$AB51
        mvi     b,$01
        mvi     c,$03
        call    L6AC2                   ; Place ASCII # digits from HL into output queue, B before DP, C after DP.
        ret
;--------------------------------------------------------------------------------------------------
;       FSK Shift and Polarity report
;
L69E1:
        lda     $A825                   ; FSK option installed flag. Zero if not installed
        ora     a
        rz                              ; exit without action if $A825 is zero
        lda     $A846                   ; Radio addressed uniquely, return status reports (FF=report)
        ora     a
        rz                              ; exit without action if radio not addressed
        mvi     a,$FF
        sta     $AB67
        mvi     a,$59                   ; 'Y'  (FSK Shift and Polarity)
        call    L6A16                   ; Put ASCII char 'Y' in serial comm output queue
        lhld    $A809
        lxi     d,$000B
        dad     d
        mov     c,m
        mov     a,c
        ani     $80
        jnz     L6A08
        mvi     a,$2B                   ; '+'
        jmp     L6A0A
L6A08:
        mvi     a,$2D                   ; '-'
L6A0A:
        call    L6A16                   ; Put ASCII char A in serial comm output queue
        mov     a,c
        ani     $03
        adi     $30                     ; '0' to '3'
        call    L6A16                   ; Put ASCII char A in serial comm output queue
        ret
;--------------------------------------------------------------------------------------------------
;       Put ASCII char A in serial comm output queue
L6A16:
        push    h                       ;
        push    psw                     ;
        lhld    $AA48                   ; Serial comm transmit buffer pointer
        mov     m,a                     ; put A there
        lda     $AA4A                   ; # chars left to transmit
        cpi     $FF
        jz      L6A31                   ; exit if FF
        inr     a
        sta     $AA4A                   ; increment # chars left to transmit
        cpi     $FF
        jz      L6A31                   ; exit if FF
        inx     h
        shld    $AA48                   ; increment Serial comm transmit buffer pointer
L6A31:
        pop     psw                     ;
        pop     h                       ;
        ret
;--------------------------------------------------------------------------------------------------
;       Send value of A out as ASCII '000' to '255'
;
L6A34:
        push    psw
        push    b
        push    h
        mov     c,a
        call    L27DC                   ; Converts C to tens & ones BCD (99=>10011001 and 255=>01010101) in A (B has hundreds)
        mov     c,a
        lxi     h,$AB62
        mov     a,b
        adi     $30
        mov     m,a
        inx     h
        mov     a,c
        rar
        rar
        rar
        rar
        ani     $0F
        adi     $30
        mov     m,a
        inx     h
        mov     a,c
        ani     $0F
        adi     $30
        mov     m,a
        lxi     h,$AB62
        mvi     c,$03
        call    L6A97                   ; Place C ASCII #'s from $AB62 into output queue.  Suppress leading zeroes.
        pop     h
        pop     b
        pop     psw
        ret
;--------------------------------------------------------------------------------------------------
;       Convert H/L bytes of A into ASCII and send out serial port
;
L6A61:
        push    psw
        push    b
        push    h
        push    psw
        rrc
        rrc
        rrc
        rrc
        ani     $0F
        adi     $30
        sta     $AB65
        pop     psw
        ani     $0F
        adi     $30
        sta     $AB66
        lxi     h,$AB65
        mvi     c,$02
        call    L6A97                  ; Place C ASCII #'s from $AB65 into output queue.  Suppress leading zeroes.
        pop     h
        pop     b
        pop     psw
        ret
;--------------------------------------------------------------------------------------------------
;       Convert H/L nybbles of A to ASCII # chars in B/C
;
L6A84:
        push    psw
        push    psw
        rrc
        rrc
        rrc
        rrc
        ani     $0F
        adi     $30
        mov     b,a
        pop     psw
        ani     $0F
        adi     $30
        mov     c,a
        pop     psw
        ret
;--------------------------------------------------------------------------------------------------
;       Place C ASCII #'s from HL into output queue.  Suppress leading zeroes.
;
L6A97:
        push    psw
        push    b
        push    h
L6A9A:
        mov     a,c                            ; C= # digits
        cpi     $01
        jnz     L6AA7                          ; jump if not one digit
        mov     a,m
        call    L6A16                          ; Put ASCII char A in serial comm output queue
        jmp     L6ABE                          ; and exit (only single digit)
L6AA7:
        mov     a,m                            ; get ASCII char
        inx     h
        cpi     $30
        jnz     L6AB8                          ; jump if char is not zero
        dcr     c
        jmp     L6A9A
L6AB2:
        dcr     c
        jz      L6ABE
        mov     a,m
        inx     h
L6AB8:
        call    L6A16                           ; Put ASCII char A in serial comm output queue
        jmp     L6AB2
L6ABE:
        pop     h
        pop     b
        pop     psw
        ret
;--------------------------------------------------------------------------------------------------
;       Place ASCII # digits from HL into output queue, B before DP, C after DP.
;
L6AC2:
        push    b
        push    h
        mov     d,b
        mvi     e,$00
L6AC7:
        mov     a,b
        ora     a
        jz      L6AD8
        dcr     b
        mov     a,m
        cpi     $30
        jnz     L6AD8
        inx     h
        inr     e
        jmp     L6AC7
L6AD8:
        mov     a,d
        sub     e
        sta     $AB5C
        shld    $AB5A
        pop     h
        pop     b
        push    b
        push    h
        mov     a,b
        add     c
        mov     e,a
        mvi     d,$00
        dcx     d
        dad     d
        mvi     e,$00
L6AED:
        mov     a,c
        ora     a
        jz      L6AFE
        dcr     c
        mov     a,m
        dcx     h
        cpi     $30
        jnz     L6AFE
        inr     e
        jmp     L6AED
L6AFE:
        pop     h
        pop     b
        mov     a,c
        sub     e
        mov     c,a
        mov     a,c
        sta     $AB5D
        lda     $AB5C
        ora     c
        jnz     L6B16
        mvi     a,$30                   ; '0'
        call    L6A16                   ; Put ASCII char A in serial comm output queue
        jmp     L6B46
L6B16:
        lhld    $AB5A
        lda     $AB5C
        mov     b,a
L6B1D:
        mov     a,b
        ora     a
        jz      L6B2B
        dcr     b
        mov     a,m
        call    L6A16                   ; Put ASCII char A in serial comm output queue
        inx     h
        jmp     L6B1D
L6B2B:
        lda     $AB5D
        mov     b,a
        ora     a
        jz      L6B46
        mvi     a,$2E                   ; '.'
        call    L6A16                   ; Put ASCII char A in serial comm output queue
L6B38:
        mov     a,b
        ora     a
        jz      L6B46
        dcr     b
        mov     a,m
        call    L6A16                   ; Put ASCII char A in serial comm output queue
        inx     h
        jmp     L6B38
L6B46:
        ret
;--------------------------------------------------------------------------------------------------

        .fill $6FFF-$
                                
        .org    $6FFF

        .db     $2C                     ; to make checksum work out

        .fill $7FFF-$

        .END



